/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import com.adobe.mobile.AnalyticsTrackLifetimeValueIncrease;
import com.adobe.mobile.Lifecycle;
import com.adobe.mobile.MessageAlert;
import com.adobe.mobile.Messages;
import com.adobe.mobile.MobileConfig;
import com.adobe.mobile.MobileIdentities;
import com.adobe.mobile.MobilePrivacyStatus;
import com.adobe.mobile.StaticMethods;
import com.adobe.mobile.WearableFunctionBridge;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public final class Config {
    public static final String ADB_MESSAGE_DEEPLINK_KEY = "adb_deeplink";

    public static void setContext(Context context) {
        Config.setContext(context, ApplicationType.APPLICATION_TYPE_HANDHELD);
    }

    public static void setContext(Context context, ApplicationType appType) {
        StaticMethods.setSharedContext(context);
        Config.setApplicationType(appType);
        if (appType == ApplicationType.APPLICATION_TYPE_WEARABLE) {
            StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    WearableFunctionBridge.syncConfigFromHandheld();
                }
            });
        }
    }

    public static String getVersion() {
        return "4.18.0-AN";
    }

    public static MobilePrivacyStatus getPrivacyStatus() {
        FutureTask<MobilePrivacyStatus> f = new FutureTask<MobilePrivacyStatus>(new Callable<MobilePrivacyStatus>(){

            @Override
            public MobilePrivacyStatus call() throws Exception {
                return MobileConfig.getInstance().getPrivacyStatus();
            }
        });
        StaticMethods.getSharedExecutor().execute(f);
        try {
            return f.get();
        }
        catch (Exception e) {
            StaticMethods.logErrorFormat("Analytics - Unable to get PrivacyStatus (%s)", e.getMessage());
            return null;
        }
    }

    public static void setPrivacyStatus(final MobilePrivacyStatus status) {
        StaticMethods.getSharedExecutor().execute(new Runnable(){

            @Override
            public void run() {
                MobileConfig.getInstance().setPrivacyStatus(status);
            }
        });
    }

    public static String getUserIdentifier() {
        FutureTask<String> f = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return StaticMethods.getVisitorID();
            }
        });
        StaticMethods.getAnalyticsExecutor().execute(f);
        try {
            return f.get();
        }
        catch (Exception e) {
            StaticMethods.logErrorFormat("Analytics - Unable to get UserIdentifier (%s)", e.getMessage());
            return null;
        }
    }

    public static void setUserIdentifier(final String identifier) {
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (MobileConfig.getInstance().getPrivacyStatus() == MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_OUT) {
                    return;
                }
                StaticMethods.setVisitorID(identifier);
            }
        });
    }

    public static void setPushIdentifier(final String registrationId) {
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (MobileConfig.getInstance().getPrivacyStatus() == MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_OUT) {
                    return;
                }
                StaticMethods.setPushIdentifier(registrationId);
            }
        });
    }

    public static void submitAdvertisingIdentifierTask(final Callable<String> task) {
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (MobileConfig.getInstance().getPrivacyStatus() == MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_OUT) {
                        return;
                    }
                    if (task == null) {
                        return;
                    }
                    StaticMethods.setAdvertisingIdentifier((String)task.call());
                }
                catch (Exception ex) {
                    StaticMethods.logErrorFormat("Config - Error running the task to get Advertising Identifier (%s).", ex.getLocalizedMessage());
                }
            }
        });
    }

    public static ApplicationType getApplicationType() {
        return StaticMethods.getApplicationType();
    }

    public static void setApplicationType(ApplicationType appType) {
        StaticMethods.setApplicationType(appType);
    }

    public static Boolean getDebugLogging() {
        return StaticMethods.getDebugLogging();
    }

    public static void setDebugLogging(Boolean debugLogging) {
        StaticMethods.setDebugLogging(debugLogging);
    }

    public static BigDecimal getLifetimeValue() {
        FutureTask<BigDecimal> f = new FutureTask<BigDecimal>(new Callable<BigDecimal>(){

            @Override
            public BigDecimal call() throws Exception {
                return AnalyticsTrackLifetimeValueIncrease.getLifetimeValue();
            }
        });
        StaticMethods.getAnalyticsExecutor().execute(f);
        try {
            return f.get();
        }
        catch (Exception e) {
            StaticMethods.logErrorFormat("Analytics - Unable to get lifetime value (%s)", e.getMessage());
            return null;
        }
    }

    public static void collectLifecycleData() {
        if (StaticMethods.isWearableApp()) {
            StaticMethods.logWarningFormat("Analytics - Method collectLifecycleData is not available for Wearable", new Object[0]);
            return;
        }
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                Lifecycle.start(null, null);
            }
        });
    }

    public static void collectLifecycleData(final Activity activity) {
        if (StaticMethods.isWearableApp()) {
            StaticMethods.logWarningFormat("Analytics - Method collectLifecycleData is not available for Wearable", new Object[0]);
            return;
        }
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                Lifecycle.start(activity, null);
            }
        });
    }

    public static void collectLifecycleData(final Activity activity, final Map<String, Object> contextData) {
        if (StaticMethods.isWearableApp()) {
            StaticMethods.logWarningFormat("Analytics - Method collectLifecycleData is not available for Wearable", new Object[0]);
            return;
        }
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                Lifecycle.start(activity, contextData);
            }
        });
    }

    public static void pauseCollectingLifecycleData() {
        if (StaticMethods.isWearableApp()) {
            StaticMethods.logWarningFormat("Analytics - Method pauseCollectingLifecycleData is not available for Wearable", new Object[0]);
            return;
        }
        MessageAlert.clearCurrentDialog();
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                Lifecycle.stop();
            }
        });
    }

    public static void collectPII(Map<String, Object> data) {
        Messages.checkForPIIRequests(data);
    }

    public static void trackAdobeDeepLink(final Uri uri) {
        if (StaticMethods.isWearableApp()) {
            StaticMethods.logWarningFormat("Analytics - Method trackAdobeDeepLink is not available for Wearable", new Object[0]);
            return;
        }
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                Lifecycle.processAdobeDeepLink(uri);
            }
        });
    }

    public static void setSmallIconResourceId(final int resourceId) {
        if (StaticMethods.isWearableApp()) {
            StaticMethods.logWarningFormat("Analytics - Method setSmallIconResourceId is not available for Wearable", new Object[0]);
            return;
        }
        StaticMethods.getMessagesExecutor().execute(new Runnable(){

            @Override
            public void run() {
                Messages.setSmallIconResourceId(resourceId);
            }
        });
    }

    public static void setLargeIconResourceId(final int resourceId) {
        if (StaticMethods.isWearableApp()) {
            StaticMethods.logWarningFormat("Analytics - Method setLargeIconResourceId is not available for Wearable", new Object[0]);
            return;
        }
        StaticMethods.getMessagesExecutor().execute(new Runnable(){

            @Override
            public void run() {
                Messages.setLargeIconResourceId(resourceId);
            }
        });
    }

    public static void overrideConfigStream(InputStream stream) {
        MobileConfig.setUserDefinedConfigPath(stream);
    }

    public static void registerAdobeDataCallback(final AdobeDataCallback callback) {
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                MobileConfig.getInstance().setAdobeDataCallback(callback);
            }
        });
    }

    public static void getAllIdentifiersAsync(final ConfigCallback<String> callback) {
        if (callback == null) {
            return;
        }
        StaticMethods.getSharedExecutor().execute(new Runnable(){

            @Override
            public void run() {
                callback.call(MobileIdentities.getAllIdentifiers());
            }
        });
    }

    public static interface AdobeDataCallback {
        public void call(MobileDataEvent var1, Map<String, Object> var2);
    }

    public static interface ConfigCallback<T> {
        public void call(T var1);
    }

    public static enum MobileDataEvent {
        MOBILE_EVENT_LIFECYCLE(0),
        MOBILE_EVENT_ACQUISITION_INSTALL(1),
        MOBILE_EVENT_ACQUISITION_LAUNCH(2);

        private final int value;

        private MobileDataEvent(int value) {
            this.value = value;
        }

        protected int getValue() {
            return this.value;
        }
    }

    public static enum ApplicationType {
        APPLICATION_TYPE_HANDHELD(0),
        APPLICATION_TYPE_WEARABLE(1);

        private final int value;

        private ApplicationType(int value) {
            this.value = value;
        }

        protected int getValue() {
            return this.value;
        }
    }
}

