/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.upstream.cache;

import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.akamai.amp.exoplayer2.upstream.cache.CacheSpan;
import com.akamai.amp.exoplayer2.upstream.cache.ContentMetadata;
import com.akamai.amp.exoplayer2.upstream.cache.ContentMetadataMutations;
import java.io.File;
import java.io.IOException;
import java.util.NavigableSet;
import java.util.Set;

public interface Cache {
    public static final long UID_UNSET = -1L;

    public long getUid();

    @WorkerThread
    public void release();

    public NavigableSet<CacheSpan> addListener(String var1, Listener var2);

    public void removeListener(String var1, Listener var2);

    public NavigableSet<CacheSpan> getCachedSpans(String var1);

    public Set<String> getKeys();

    public long getCacheSpace();

    @WorkerThread
    public CacheSpan startReadWrite(String var1, long var2, long var4) throws InterruptedException, CacheException;

    @WorkerThread
    @Nullable
    public CacheSpan startReadWriteNonBlocking(String var1, long var2, long var4) throws CacheException;

    @WorkerThread
    public File startFile(String var1, long var2, long var4) throws CacheException;

    @WorkerThread
    public void commitFile(File var1, long var2) throws CacheException;

    public void releaseHoleSpan(CacheSpan var1);

    @WorkerThread
    public void removeResource(String var1);

    @WorkerThread
    public void removeSpan(CacheSpan var1);

    public boolean isCached(String var1, long var2, long var4);

    public long getCachedLength(String var1, long var2, long var4);

    public long getCachedBytes(String var1, long var2, long var4);

    @WorkerThread
    public void applyContentMetadataMutations(String var1, ContentMetadataMutations var2) throws CacheException;

    public ContentMetadata getContentMetadata(String var1);

    public static class CacheException
    extends IOException {
        public CacheException(String message) {
            super(message);
        }

        public CacheException(Throwable cause) {
            super(cause);
        }

        public CacheException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface Listener {
        public void onSpanAdded(Cache var1, CacheSpan var2);

        public void onSpanRemoved(Cache var1, CacheSpan var2);

        public void onSpanTouched(Cache var1, CacheSpan var2, CacheSpan var3);
    }
}

