/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.trackselection;

import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.source.TrackGroup;
import com.akamai.amp.exoplayer2.source.chunk.MediaChunk;
import com.akamai.amp.exoplayer2.source.chunk.MediaChunkIterator;
import com.akamai.amp.exoplayer2.trackselection.BaseTrackSelection;
import com.akamai.amp.exoplayer2.trackselection.FixedTrackSelection;
import com.akamai.amp.exoplayer2.trackselection.TrackSelection;
import com.akamai.amp.exoplayer2.upstream.BandwidthMeter;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Clock;
import com.akamai.amp.exoplayer2.util.Util;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableType;

public class AdaptiveTrackSelection
extends BaseTrackSelection {
    public static final int DEFAULT_MIN_DURATION_FOR_QUALITY_INCREASE_MS = 10000;
    public static final int DEFAULT_MAX_DURATION_FOR_QUALITY_DECREASE_MS = 25000;
    public static final int DEFAULT_MIN_DURATION_TO_RETAIN_AFTER_DISCARD_MS = 25000;
    public static final float DEFAULT_BANDWIDTH_FRACTION = 0.7f;
    public static final float DEFAULT_BUFFERED_FRACTION_TO_LIVE_EDGE_FOR_QUALITY_INCREASE = 0.75f;
    private static final long MIN_TIME_BETWEEN_BUFFER_REEVALUTATION_MS = 1000L;
    private final BandwidthProvider bandwidthProvider;
    private final long minDurationForQualityIncreaseUs;
    private final long maxDurationForQualityDecreaseUs;
    private final long minDurationToRetainAfterDiscardUs;
    private final float bufferedFractionToLiveEdgeForQualityIncrease;
    private final Clock clock;
    private float playbackSpeed;
    private int selectedIndex;
    private int reason;
    private long lastBufferEvaluationMs;
    @Nullable
    private MediaChunk lastBufferEvaluationMediaChunk;

    public AdaptiveTrackSelection(TrackGroup group, int[] tracks, BandwidthMeter bandwidthMeter) {
        this(group, tracks, bandwidthMeter, 0L, 10000L, 25000L, 25000L, 0.7f, 0.75f, Clock.DEFAULT);
    }

    public AdaptiveTrackSelection(TrackGroup group, int[] tracks, BandwidthMeter bandwidthMeter, long reservedBandwidth, long minDurationForQualityIncreaseMs, long maxDurationForQualityDecreaseMs, long minDurationToRetainAfterDiscardMs, float bandwidthFraction, float bufferedFractionToLiveEdgeForQualityIncrease, Clock clock) {
        this(group, tracks, new DefaultBandwidthProvider(bandwidthMeter, bandwidthFraction, reservedBandwidth), minDurationForQualityIncreaseMs, maxDurationForQualityDecreaseMs, minDurationToRetainAfterDiscardMs, bufferedFractionToLiveEdgeForQualityIncrease, clock);
    }

    private AdaptiveTrackSelection(TrackGroup group, int[] tracks, BandwidthProvider bandwidthProvider, long minDurationForQualityIncreaseMs, long maxDurationForQualityDecreaseMs, long minDurationToRetainAfterDiscardMs, float bufferedFractionToLiveEdgeForQualityIncrease, Clock clock) {
        super(group, tracks);
        this.bandwidthProvider = bandwidthProvider;
        this.minDurationForQualityIncreaseUs = minDurationForQualityIncreaseMs * 1000L;
        this.maxDurationForQualityDecreaseUs = maxDurationForQualityDecreaseMs * 1000L;
        this.minDurationToRetainAfterDiscardUs = minDurationToRetainAfterDiscardMs * 1000L;
        this.bufferedFractionToLiveEdgeForQualityIncrease = bufferedFractionToLiveEdgeForQualityIncrease;
        this.clock = clock;
        this.playbackSpeed = 1.0f;
        this.reason = 0;
        this.lastBufferEvaluationMs = -9223372036854775807L;
    }

    public void experimentalSetBandwidthAllocationCheckpoints(long[][] allocationCheckpoints) {
        ((DefaultBandwidthProvider)this.bandwidthProvider).experimentalSetBandwidthAllocationCheckpoints(allocationCheckpoints);
    }

    @Override
    @CallSuper
    public void enable() {
        this.lastBufferEvaluationMs = -9223372036854775807L;
        this.lastBufferEvaluationMediaChunk = null;
    }

    @Override
    @CallSuper
    public void disable() {
        this.lastBufferEvaluationMediaChunk = null;
    }

    @Override
    public void onPlaybackSpeed(float playbackSpeed) {
        this.playbackSpeed = playbackSpeed;
    }

    @Override
    public void updateSelectedTrack(long playbackPositionUs, long bufferedDurationUs, long availableDurationUs, List<? extends MediaChunk> queue, MediaChunkIterator[] mediaChunkIterators) {
        int formatIndexOfPreviousChunk;
        long nowMs = this.clock.elapsedRealtime();
        if (this.reason == 0) {
            this.reason = 1;
            this.selectedIndex = this.determineIdealSelectedIndex(nowMs);
            return;
        }
        int previousSelectedIndex = this.selectedIndex;
        int previousReason = this.reason;
        int n = formatIndexOfPreviousChunk = queue.isEmpty() ? -1 : this.indexOf(((MediaChunk)Iterables.getLast(queue)).trackFormat);
        if (formatIndexOfPreviousChunk != -1) {
            previousSelectedIndex = formatIndexOfPreviousChunk;
            previousReason = ((MediaChunk)Iterables.getLast(queue)).trackSelectionReason;
        }
        int newSelectedIndex = this.determineIdealSelectedIndex(nowMs);
        if (!this.isBlacklisted(previousSelectedIndex, nowMs)) {
            Format currentFormat = this.getFormat(previousSelectedIndex);
            Format selectedFormat = this.getFormat(newSelectedIndex);
            if (selectedFormat.bitrate > currentFormat.bitrate && bufferedDurationUs < this.minDurationForQualityIncreaseUs(availableDurationUs)) {
                newSelectedIndex = previousSelectedIndex;
            } else if (selectedFormat.bitrate < currentFormat.bitrate && bufferedDurationUs >= this.maxDurationForQualityDecreaseUs) {
                newSelectedIndex = previousSelectedIndex;
            }
        }
        this.reason = newSelectedIndex == previousSelectedIndex ? previousReason : 3;
        this.selectedIndex = newSelectedIndex;
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    public int getSelectionReason() {
        return this.reason;
    }

    @Override
    @Nullable
    public Object getSelectionData() {
        return null;
    }

    @Override
    public int evaluateQueueSize(long playbackPositionUs, List<? extends MediaChunk> queue) {
        long minDurationToRetainAfterDiscardUs;
        long nowMs = this.clock.elapsedRealtime();
        if (!this.shouldEvaluateQueueSize(nowMs, queue)) {
            return queue.size();
        }
        this.lastBufferEvaluationMs = nowMs;
        MediaChunk mediaChunk = this.lastBufferEvaluationMediaChunk = queue.isEmpty() ? null : (MediaChunk)Iterables.getLast(queue);
        if (queue.isEmpty()) {
            return 0;
        }
        int queueSize = queue.size();
        MediaChunk lastChunk = queue.get(queueSize - 1);
        long playoutBufferedDurationBeforeLastChunkUs = Util.getPlayoutDurationForMediaDuration(lastChunk.startTimeUs - playbackPositionUs, this.playbackSpeed);
        if (playoutBufferedDurationBeforeLastChunkUs < (minDurationToRetainAfterDiscardUs = this.getMinDurationToRetainAfterDiscardUs())) {
            return queueSize;
        }
        int idealSelectedIndex = this.determineIdealSelectedIndex(nowMs);
        Format idealFormat = this.getFormat(idealSelectedIndex);
        for (int i = 0; i < queueSize; ++i) {
            MediaChunk chunk = queue.get(i);
            Format format = chunk.trackFormat;
            long mediaDurationBeforeThisChunkUs = chunk.startTimeUs - playbackPositionUs;
            long playoutDurationBeforeThisChunkUs = Util.getPlayoutDurationForMediaDuration(mediaDurationBeforeThisChunkUs, this.playbackSpeed);
            if (playoutDurationBeforeThisChunkUs < minDurationToRetainAfterDiscardUs || format.bitrate >= idealFormat.bitrate || format.height == -1 || format.height >= 720 || format.width == -1 || format.width >= 1280 || format.height >= idealFormat.height) continue;
            return i;
        }
        return queueSize;
    }

    protected boolean canSelectFormat(Format format, int trackBitrate, float playbackSpeed, long effectiveBitrate) {
        return (long)Math.round((float)trackBitrate * playbackSpeed) <= effectiveBitrate;
    }

    protected boolean shouldEvaluateQueueSize(long nowMs, List<? extends MediaChunk> queue) {
        return this.lastBufferEvaluationMs == -9223372036854775807L || nowMs - this.lastBufferEvaluationMs >= 1000L || !queue.isEmpty() && !((MediaChunk)Iterables.getLast(queue)).equals(this.lastBufferEvaluationMediaChunk);
    }

    protected long getMinDurationToRetainAfterDiscardUs() {
        return this.minDurationToRetainAfterDiscardUs;
    }

    private int determineIdealSelectedIndex(long nowMs) {
        long effectiveBitrate = this.bandwidthProvider.getAllocatedBandwidth();
        int lowestBitrateAllowedIndex = 0;
        for (int i = 0; i < this.length; ++i) {
            if (nowMs != Long.MIN_VALUE && this.isBlacklisted(i, nowMs)) continue;
            Format format = this.getFormat(i);
            if (this.canSelectFormat(format, format.bitrate, this.playbackSpeed, effectiveBitrate)) {
                return i;
            }
            lowestBitrateAllowedIndex = i;
        }
        return lowestBitrateAllowedIndex;
    }

    private long minDurationForQualityIncreaseUs(long availableDurationUs) {
        boolean isAvailableDurationTooShort = availableDurationUs != -9223372036854775807L && availableDurationUs <= this.minDurationForQualityIncreaseUs;
        return isAvailableDurationTooShort ? (long)((float)availableDurationUs * this.bufferedFractionToLiveEdgeForQualityIncrease) : this.minDurationForQualityIncreaseUs;
    }

    private static long[][][] getAllocationCheckpoints(long[][] trackBitrates) {
        double[][] logBitrates = AdaptiveTrackSelection.getLogArrayValues(trackBitrates);
        double[][] switchPoints = AdaptiveTrackSelection.getSwitchPoints(logBitrates);
        int checkpointCount = AdaptiveTrackSelection.countArrayElements(switchPoints) + 3;
        long[][][] checkpoints = new long[logBitrates.length][checkpointCount][2];
        int[] currentSelection = new int[logBitrates.length];
        AdaptiveTrackSelection.setCheckpointValues(checkpoints, 1, trackBitrates, currentSelection);
        for (int checkpointIndex = 2; checkpointIndex < checkpointCount - 1; ++checkpointIndex) {
            int nextUpdateIndex = 0;
            double nextUpdateSwitchPoint = Double.MAX_VALUE;
            for (int i = 0; i < logBitrates.length; ++i) {
                double switchPoint;
                if (currentSelection[i] + 1 == logBitrates[i].length || !((switchPoint = switchPoints[i][currentSelection[i]]) < nextUpdateSwitchPoint)) continue;
                nextUpdateSwitchPoint = switchPoint;
                nextUpdateIndex = i;
            }
            int n = nextUpdateIndex;
            currentSelection[n] = currentSelection[n] + 1;
            AdaptiveTrackSelection.setCheckpointValues(checkpoints, checkpointIndex, trackBitrates, currentSelection);
        }
        for (long[][] points : checkpoints) {
            points[checkpointCount - 1][0] = 2L * points[checkpointCount - 2][0];
            points[checkpointCount - 1][1] = 2L * points[checkpointCount - 2][1];
        }
        return checkpoints;
    }

    private static double[][] getLogArrayValues(long[][] values) {
        double[][] logValues = new double[values.length][];
        for (int i = 0; i < values.length; ++i) {
            logValues[i] = new double[values[i].length];
            for (int j = 0; j < values[i].length; ++j) {
                logValues[i][j] = values[i][j] == -1L ? 0.0 : Math.log(values[i][j]);
            }
        }
        return logValues;
    }

    private static double[][] getSwitchPoints(double[][] logBitrates) {
        double[][] switchPoints = new double[logBitrates.length][];
        for (int i = 0; i < logBitrates.length; ++i) {
            switchPoints[i] = new double[logBitrates[i].length - 1];
            if (switchPoints[i].length == 0) continue;
            double totalBitrateDiff = logBitrates[i][logBitrates[i].length - 1] - logBitrates[i][0];
            for (int j = 0; j < logBitrates[i].length - 1; ++j) {
                double switchBitrate = 0.5 * (logBitrates[i][j] + logBitrates[i][j + 1]);
                switchPoints[i][j] = totalBitrateDiff == 0.0 ? 1.0 : (switchBitrate - logBitrates[i][0]) / totalBitrateDiff;
            }
        }
        return switchPoints;
    }

    private static int countArrayElements(double[][] array) {
        int count = 0;
        for (double[] subArray : array) {
            count += subArray.length;
        }
        return count;
    }

    private static void setCheckpointValues(long[][][] checkpoints, int checkpointIndex, long[][] trackBitrates, int[] selectedTracks) {
        long totalBitrate = 0L;
        for (int i = 0; i < checkpoints.length; ++i) {
            checkpoints[i][checkpointIndex][1] = trackBitrates[i][selectedTracks[i]];
            totalBitrate += checkpoints[i][checkpointIndex][1];
        }
        for (long[][] points : checkpoints) {
            points[checkpointIndex][0] = totalBitrate;
        }
    }

    private static final class DefaultBandwidthProvider
    implements BandwidthProvider {
        private final BandwidthMeter bandwidthMeter;
        private final float bandwidthFraction;
        private final long reservedBandwidth;
        @Nullable
        private long[][] allocationCheckpoints;

        DefaultBandwidthProvider(BandwidthMeter bandwidthMeter, float bandwidthFraction, long reservedBandwidth) {
            this.bandwidthMeter = bandwidthMeter;
            this.bandwidthFraction = bandwidthFraction;
            this.reservedBandwidth = reservedBandwidth;
        }

        @Override
        public long getAllocatedBandwidth() {
            int nextIndex;
            long totalBandwidth = (long)((float)this.bandwidthMeter.getBitrateEstimate() * this.bandwidthFraction);
            long allocatableBandwidth = Math.max(0L, totalBandwidth - this.reservedBandwidth);
            if (this.allocationCheckpoints == null) {
                return allocatableBandwidth;
            }
            for (nextIndex = 1; nextIndex < this.allocationCheckpoints.length - 1 && this.allocationCheckpoints[nextIndex][0] < allocatableBandwidth; ++nextIndex) {
            }
            long[] previous = this.allocationCheckpoints[nextIndex - 1];
            long[] next = this.allocationCheckpoints[nextIndex];
            float fractionBetweenCheckpoints = (float)(allocatableBandwidth - previous[0]) / (float)(next[0] - previous[0]);
            return previous[1] + (long)(fractionBetweenCheckpoints * (float)(next[1] - previous[1]));
        }

        void experimentalSetBandwidthAllocationCheckpoints(long[][] allocationCheckpoints) {
            Assertions.checkArgument(allocationCheckpoints.length >= 2);
            this.allocationCheckpoints = allocationCheckpoints;
        }
    }

    private static interface BandwidthProvider {
        public long getAllocatedBandwidth();
    }

    public static class Factory
    implements TrackSelection.Factory {
        private final int minDurationForQualityIncreaseMs;
        private final int maxDurationForQualityDecreaseMs;
        private final int minDurationToRetainAfterDiscardMs;
        private final float bandwidthFraction;
        private final float bufferedFractionToLiveEdgeForQualityIncrease;
        private final Clock clock;

        public Factory() {
            this(10000, 25000, 25000, 0.7f, 0.75f, Clock.DEFAULT);
        }

        public Factory(int minDurationForQualityIncreaseMs, int maxDurationForQualityDecreaseMs, int minDurationToRetainAfterDiscardMs, float bandwidthFraction) {
            this(minDurationForQualityIncreaseMs, maxDurationForQualityDecreaseMs, minDurationToRetainAfterDiscardMs, bandwidthFraction, 0.75f, Clock.DEFAULT);
        }

        public Factory(int minDurationForQualityIncreaseMs, int maxDurationForQualityDecreaseMs, int minDurationToRetainAfterDiscardMs, float bandwidthFraction, float bufferedFractionToLiveEdgeForQualityIncrease, Clock clock) {
            this.minDurationForQualityIncreaseMs = minDurationForQualityIncreaseMs;
            this.maxDurationForQualityDecreaseMs = maxDurationForQualityDecreaseMs;
            this.minDurationToRetainAfterDiscardMs = minDurationToRetainAfterDiscardMs;
            this.bandwidthFraction = bandwidthFraction;
            this.bufferedFractionToLiveEdgeForQualityIncrease = bufferedFractionToLiveEdgeForQualityIncrease;
            this.clock = clock;
        }

        @Override
        public final @NullableType TrackSelection[] createTrackSelections(@NullableType TrackSelection.Definition[] definitions, BandwidthMeter bandwidthMeter) {
            AdaptiveTrackSelection adaptiveSelection;
            TrackSelection[] selections = new TrackSelection[definitions.length];
            int totalFixedBandwidth = 0;
            for (int i = 0; i < definitions.length; ++i) {
                TrackSelection.Definition definition = definitions[i];
                if (definition == null || definition.tracks.length != 1) continue;
                selections[i] = new FixedTrackSelection(definition.group, definition.tracks[0], definition.reason, definition.data);
                int trackBitrate = definition.group.getFormat((int)definition.tracks[0]).bitrate;
                if (trackBitrate == -1) continue;
                totalFixedBandwidth += trackBitrate;
            }
            ArrayList<AdaptiveTrackSelection> adaptiveSelections = new ArrayList<AdaptiveTrackSelection>();
            for (int i = 0; i < definitions.length; ++i) {
                TrackSelection.Definition definition = definitions[i];
                if (definition == null || definition.tracks.length <= 1) continue;
                adaptiveSelection = this.createAdaptiveTrackSelection(definition.group, bandwidthMeter, definition.tracks, totalFixedBandwidth);
                adaptiveSelections.add(adaptiveSelection);
                selections[i] = adaptiveSelection;
            }
            if (adaptiveSelections.size() > 1) {
                long[][] adaptiveTrackBitrates = new long[adaptiveSelections.size()][];
                for (int i = 0; i < adaptiveSelections.size(); ++i) {
                    adaptiveSelection = (AdaptiveTrackSelection)adaptiveSelections.get(i);
                    adaptiveTrackBitrates[i] = new long[adaptiveSelection.length()];
                    for (int j = 0; j < adaptiveSelection.length(); ++j) {
                        adaptiveTrackBitrates[i][j] = adaptiveSelection.getFormat((int)(adaptiveSelection.length() - j - 1)).bitrate;
                    }
                }
                long[][][] bandwidthCheckpoints = AdaptiveTrackSelection.getAllocationCheckpoints(adaptiveTrackBitrates);
                for (int i = 0; i < adaptiveSelections.size(); ++i) {
                    ((AdaptiveTrackSelection)adaptiveSelections.get(i)).experimentalSetBandwidthAllocationCheckpoints(bandwidthCheckpoints[i]);
                }
            }
            return selections;
        }

        protected AdaptiveTrackSelection createAdaptiveTrackSelection(TrackGroup group, BandwidthMeter bandwidthMeter, int[] tracks, int totalFixedTrackBandwidth) {
            return new AdaptiveTrackSelection(group, tracks, new DefaultBandwidthProvider(bandwidthMeter, this.bandwidthFraction, totalFixedTrackBandwidth), (long)this.minDurationForQualityIncreaseMs, (long)this.maxDurationForQualityDecreaseMs, (long)this.minDurationToRetainAfterDiscardMs, this.bufferedFractionToLiveEdgeForQualityIncrease, this.clock);
        }
    }
}

