/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.content.Context;
import com.adobe.mobile.MobileConfig;
import com.adobe.mobile.StaticMethods;
import java.lang.reflect.Method;

final class WearableFunctionBridge {
    private static Class<?> wearableFunctionClassLoader;
    private static Class<?> configSynchronizerClassLoader;

    WearableFunctionBridge() {
    }

    private static Class<?> getWearableFunctionClass() {
        if (wearableFunctionClassLoader != null) {
            return wearableFunctionClassLoader;
        }
        try {
            ClassLoader classLoader = WearableFunctionBridge.class.getClassLoader();
            wearableFunctionClassLoader = classLoader.loadClass("com.adobe.mobile.WearableFunction");
        }
        catch (Exception e) {
            StaticMethods.logDebugFormat("Wearable - Failed to load class com.adobe.mobile.WearableFunction", e.getLocalizedMessage());
        }
        return wearableFunctionClassLoader;
    }

    private static Class<?> getConfigSynchronizerClass() {
        if (configSynchronizerClassLoader != null) {
            return configSynchronizerClassLoader;
        }
        try {
            ClassLoader classLoader = WearableFunctionBridge.class.getClassLoader();
            configSynchronizerClassLoader = classLoader.loadClass("com.adobe.mobile.ConfigSynchronizer");
        }
        catch (Exception e) {
            StaticMethods.logDebugFormat("Wearable - Failed to load class com.adobe.mobile.ConfigSynchronizer", e.getLocalizedMessage());
        }
        return configSynchronizerClassLoader;
    }

    protected static boolean isGooglePlayServicesEnabled() {
        ClassLoader classLoader;
        try {
            classLoader = WearableFunctionBridge.class.getClassLoader();
            Class<?> GoogleApiAvailabilityClass = classLoader.loadClass("com.google.android.gms.common.GoogleApiAvailability");
            Method getInstanceMethod = GoogleApiAvailabilityClass.getDeclaredMethod("getInstance", new Class[0]);
            Object instance = getInstanceMethod.invoke(null, new Object[0]);
            Method isGooglePlayServicesAvailableMethod = GoogleApiAvailabilityClass.getDeclaredMethod("isGooglePlayServicesAvailable", Context.class);
            Object result = isGooglePlayServicesAvailableMethod.invoke(instance, StaticMethods.getSharedContext());
            if (result instanceof Integer) {
                return (Integer)result == 0;
            }
        }
        catch (IllegalStateException e) {
            StaticMethods.logDebugFormat("Wearable - Google Play Services is not enabled in your app's AndroidManifest.xml", e.getLocalizedMessage());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            classLoader = WearableFunctionBridge.class.getClassLoader();
            Class<?> GooglePlayServicesUtilClass = classLoader.loadClass("com.google.android.gms.common.GooglePlayServicesUtil");
            Method isGooglePlayServicesAvailableMethod = GooglePlayServicesUtilClass.getDeclaredMethod("isGooglePlayServicesAvailable", Context.class);
            Object result = isGooglePlayServicesAvailableMethod.invoke(null, StaticMethods.getSharedContext());
            if (result instanceof Integer) {
                return (Integer)result == 0;
            }
        }
        catch (IllegalStateException e) {
            StaticMethods.logDebugFormat("Wearable - Google Play Services is not enabled in your app's AndroidManifest.xml", e.getLocalizedMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected static boolean shouldSendHit() {
        if (!StaticMethods.isWearableApp()) {
            return true;
        }
        try {
            Method shouldSendHitMethod = WearableFunctionBridge.getWearableFunctionClass().getDeclaredMethod("shouldSendHit", new Class[0]);
            Object result = shouldSendHitMethod.invoke(null, new Object[0]);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
        }
        catch (Exception e) {
            StaticMethods.logDebugFormat("Wearable - Error checking status of handheld app (%s)", e.getLocalizedMessage());
        }
        return true;
    }

    protected static void sendGenericRequest(String url, int timeout, String source) {
        try {
            Method sendGenericRequestMethod = WearableFunctionBridge.getWearableFunctionClass().getDeclaredMethod("sendGenericRequest", String.class, Integer.TYPE);
            sendGenericRequestMethod.invoke(null, url, timeout);
            StaticMethods.logDebugFormat("%s - Request Sent(%s)", source, url);
        }
        catch (Exception e) {
            StaticMethods.logDebugFormat("Wearable - Error sending request (%s)", e.getLocalizedMessage());
        }
    }

    protected static byte[] retrieveData(String url, int readTimeout) {
        try {
            Method retrieveDataMethod = WearableFunctionBridge.getWearableFunctionClass().getDeclaredMethod("retrieveData", String.class, Integer.TYPE);
            Object result = retrieveDataMethod.invoke(null, url, readTimeout);
            if (result instanceof byte[]) {
                return (byte[])result;
            }
        }
        catch (Exception e) {
            StaticMethods.logDebugFormat("Wearable - Error sending request (%s)", e.getLocalizedMessage());
        }
        return null;
    }

    protected static byte[] retrieveAnalyticsRequestData(String url, String postBody, int timeout, String logPrefix) {
        try {
            Method retrieveDataMethod = WearableFunctionBridge.getWearableFunctionClass().getDeclaredMethod("retrieveAnalyticsRequestData", String.class, String.class, Integer.TYPE);
            Object result = retrieveDataMethod.invoke(null, url, postBody, timeout);
            if (result instanceof byte[]) {
                return (byte[])result;
            }
        }
        catch (Exception e) {
            StaticMethods.logDebugFormat("Wearable - Error sending request (%s)", e.getLocalizedMessage());
        }
        return null;
    }

    protected static boolean sendThirdPartyRequest(String url, String postBody, int timeout, String postType, String logPrefix) {
        try {
            Method sendThirdPartyRequestMethod = WearableFunctionBridge.getWearableFunctionClass().getDeclaredMethod("sendThirdPartyRequest", String.class, String.class, Integer.TYPE, String.class);
            Object result = sendThirdPartyRequestMethod.invoke(null, url, postBody, timeout, postType);
            if (result instanceof Boolean) {
                if (((Boolean)result).booleanValue()) {
                    StaticMethods.logDebugFormat("%s - Successfully forwarded hit (url:%s body:%s contentType:%s)", logPrefix, url, postBody, postType);
                } else {
                    StaticMethods.logDebugFormat("%s - Failed to forwarded hit (url:%s body:%s contentType:%s)", logPrefix, url, postBody, postType);
                }
                return (Boolean)result;
            }
        }
        catch (Exception e) {
            StaticMethods.logDebugFormat("Wearable - Error sending request (%s)", e.getLocalizedMessage());
        }
        return false;
    }

    protected static void syncVisitorIDToWearable(String vid) {
        if (StaticMethods.isWearableApp() || !MobileConfig.getInstance().mobileUsingGooglePlayServices()) {
            return;
        }
        try {
            Method syncVisitorIDMethod = WearableFunctionBridge.getConfigSynchronizerClass().getDeclaredMethod("syncVisitorID", String.class);
            syncVisitorIDMethod.invoke(null, vid);
        }
        catch (Exception e) {
            StaticMethods.logDebugFormat("Wearable - Unable to sync visitor id (%s)", e.getLocalizedMessage());
        }
    }

    protected static void syncAdvertisingIdentifierToWearable(String adid) {
        if (StaticMethods.isWearableApp() || !MobileConfig.getInstance().mobileUsingGooglePlayServices()) {
            return;
        }
        try {
            Method syncAdidMethod = WearableFunctionBridge.getConfigSynchronizerClass().getDeclaredMethod("syncAdvertisingIdentifier", String.class);
            syncAdidMethod.invoke(null, adid);
        }
        catch (Exception e) {
            StaticMethods.logDebugFormat("Wearable - Unable to sync advertisingIdentifier id (%s)", e.getLocalizedMessage());
        }
    }

    protected static void syncPushEnabledToWearable(boolean enabled) {
        if (StaticMethods.isWearableApp() || !MobileConfig.getInstance().mobileUsingGooglePlayServices()) {
            return;
        }
        try {
            Method syncPushStatusMethod = WearableFunctionBridge.getConfigSynchronizerClass().getDeclaredMethod("syncPushEnabled", Boolean.TYPE);
            syncPushStatusMethod.invoke(null, enabled);
        }
        catch (Exception e) {
            StaticMethods.logDebugFormat("Wearable - Unable to sync push enabled status (%s)", e.getLocalizedMessage());
        }
    }

    protected static void syncVidServiceToWearable(String mid, String hint, String blob, long ssl, long lastSync, String customerIDs) {
        if (StaticMethods.isWearableApp() || !MobileConfig.getInstance().mobileUsingGooglePlayServices()) {
            return;
        }
        try {
            Method syncVidServiceMethod = WearableFunctionBridge.getConfigSynchronizerClass().getDeclaredMethod("syncVidService", String.class, String.class, String.class, Long.TYPE, Long.TYPE, String.class);
            syncVidServiceMethod.invoke(null, mid, hint, blob, ssl, lastSync, customerIDs);
        }
        catch (Exception e) {
            StaticMethods.logDebugFormat("Wearable - Unable to sync visitor id service (%s)", e.getLocalizedMessage());
        }
    }

    protected static void syncPrivacyStatusToWearable(int privacyStatus) {
        if (StaticMethods.isWearableApp() || !MobileConfig.getInstance().mobileUsingGooglePlayServices()) {
            return;
        }
        try {
            Method syncPrivacyStatusMethod = WearableFunctionBridge.getConfigSynchronizerClass().getDeclaredMethod("syncPrivacyStatus", Integer.TYPE);
            syncPrivacyStatusMethod.invoke(null, privacyStatus);
        }
        catch (Exception e) {
            StaticMethods.logDebugFormat("Wearable - Unable to sync privacy status (%s)", e.getLocalizedMessage());
        }
    }

    protected static void syncConfigFromHandheld() {
        if (!StaticMethods.isWearableApp()) {
            return;
        }
        try {
            Method syncConfigFromHandheldMethod = WearableFunctionBridge.getConfigSynchronizerClass().getDeclaredMethod("syncConfigFromHandheld", new Class[0]);
            syncConfigFromHandheldMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            StaticMethods.logDebugFormat("Wearable - Unable to sync config (%s)", e.getLocalizedMessage());
        }
    }
}

