/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.content.SharedPreferences;
import com.adobe.mobile.Analytics;
import com.adobe.mobile.Config;
import com.adobe.mobile.MobileConfig;
import com.adobe.mobile.MobilePrivacyStatus;
import com.adobe.mobile.RequestHandler;
import com.adobe.mobile.StaticMethods;
import com.adobe.mobile.VisitorID;
import com.adobe.mobile.WearableFunctionBridge;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class VisitorIDService {
    static String DEFAULT_SERVER = "dpm.demdex.net";
    static final String CID_DELIMITER = "%01";
    static final int TIMEOUT = 5000;
    static final String RESPONSE_KEY_MID = "d_mid";
    static final String RESPONSE_KEY_BLOB = "d_blob";
    static final String RESPONSE_KEY_HINT = "dcs_region";
    static final String RESPONSE_KEY_TTL = "id_sync_ttl";
    static final String RESPONSE_KEY_ERROR = "error_msg";
    static final String RESPONSE_KEY_OPT_OUT = "d_optout";
    static final String ANALYTICS_PARAMETER_KEY_MID = "mid";
    static final String ANALYTICS_PARAMETER_KEY_LOCATION_HINT = "aamlh";
    static final String ANALYTICS_PARAMETER_KEY_BLOB = "aamb";
    static final String ANALYTICS_PARAMETER_KEY_ORG = "mcorgid";
    static final String TARGET_PARAMETER_KEY_HINT = "dcsLocationHint";
    static final String TARGET_PARAMETER_KEY_BLOB = "blob";
    static final String VISITOR_ID_PARAMETER_KEY_CUSTOMER = "d_cid_ic";
    static final String ADBVisitorPayloadKey = "adobe_mc";
    static final String ADBVisitorPayloadTimestampKey = "TS";
    static final String ADBVisitorPayloadMarketingCloudOrgId = "MCORGID";
    static final String ADBVisitorPayloadMarketingCloudIDKey = "MCMID";
    static final String ADBVisitorPayloadAnalyticsIDKey = "MCAID";
    static final String ADBAnalyticsPayloadKey = "adobe_aa_vid";
    static final String ADBVisitorCoopUnsafe = "&d_coop_unsafe=1";
    private long _ttl;
    private long _lastSync;
    private String _marketingCloudServer;
    private String _marketingCloudID;
    private String _locationHint;
    private String _blob;
    private String _analyticsIdString;
    private String _aamIdString;
    private List<VisitorID> _customerIds;
    private final ExecutorService _visitorIDExecutor = Executors.newSingleThreadExecutor();
    private static VisitorIDService _instance = null;
    private static final Object _instanceMutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VisitorIDService sharedInstance() {
        Object object = _instanceMutex;
        synchronized (object) {
            if (_instance == null) {
                _instance = new VisitorIDService();
            }
            return _instance;
        }
    }

    protected VisitorIDService() {
        this._marketingCloudServer = this.loadMarketingCloudServerFromConfig();
        this.resetVariablesFromSharedPreferences();
        this.idSync(null);
    }

    protected String getMarketingCloudServer() {
        return this._marketingCloudServer;
    }

    protected void resetVariablesFromSharedPreferences() {
        FutureTask<Void> f = new FutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    VisitorIDService.this.updateCustomerIds(VisitorIDService.this._parseIdString(StaticMethods.getSharedPreferences().getString("ADBMOBILE_VISITORID_IDS", null)));
                    VisitorIDService.this._marketingCloudID = StaticMethods.getSharedPreferences().getString("ADBMOBILE_PERSISTED_MID", null);
                    VisitorIDService.this._locationHint = StaticMethods.getSharedPreferences().getString("ADBMOBILE_PERSISTED_MID_HINT", null);
                    VisitorIDService.this._blob = StaticMethods.getSharedPreferences().getString("ADBMOBILE_PERSISTED_MID_BLOB", null);
                    VisitorIDService.this._ttl = StaticMethods.getSharedPreferences().getLong("ADBMOBILE_VISITORID_TTL", 0L);
                    VisitorIDService.this._lastSync = StaticMethods.getSharedPreferences().getLong("ADBMOBILE_VISITORID_SYNC", 0L);
                }
                catch (StaticMethods.NullContextException ex) {
                    VisitorIDService.this._marketingCloudID = null;
                    VisitorIDService.this._locationHint = null;
                    VisitorIDService.this._blob = null;
                    StaticMethods.logErrorFormat("Visitor - Unable to check for stored visitor ID due to context error (%s)", ex.getMessage());
                }
                return null;
            }
        });
        this._visitorIDExecutor.execute(f);
        try {
            f.get();
        }
        catch (Exception ex) {
            StaticMethods.logErrorFormat("ID Service - Unable to initialize visitor ID variables(%s)", ex.getLocalizedMessage());
        }
    }

    private void updateCustomerIds(List<VisitorID> customerIds) {
        this._customerIds = customerIds;
        this._analyticsIdString = this._generateAnalyticsCustomerIdString(this._customerIds);
        this._aamIdString = this._generateCustomerIdString(this._customerIds);
    }

    protected void idSync(Map<String, String> identifiers, VisitorID.VisitorIDAuthenticationState authenticationState) {
        this.idSync(identifiers, null, authenticationState, false);
    }

    protected void idSync(Map<String, String> identifiers, Map<String, String> dpids) {
        this.idSync(identifiers, dpids, VisitorID.VisitorIDAuthenticationState.VISITOR_ID_AUTHENTICATION_STATE_UNKNOWN, false);
    }

    protected void idSync(Map<String, String> identifiers) {
        this.idSync(identifiers, null, VisitorID.VisitorIDAuthenticationState.VISITOR_ID_AUTHENTICATION_STATE_UNKNOWN, false);
    }

    protected void idSync(Map<String, String> identifiers, Map<String, String> dpids, VisitorID.VisitorIDAuthenticationState authenticationState) {
        this.idSync(identifiers, dpids, authenticationState, false);
    }

    protected void idSync(Map<String, String> identifiers, Map<String, String> dpids, final VisitorID.VisitorIDAuthenticationState authenticationState, final boolean forceResync) {
        final HashMap<String, String> identifiersCopy = identifiers != null ? new HashMap<String, String>(identifiers) : null;
        final HashMap<String, String> dpidsCopy = dpids != null ? new HashMap<String, String>(dpids) : null;
        this._visitorIDExecutor.execute(new Runnable(){

            @Override
            public void run() {
                String internalIdString;
                List newCustomerIDs;
                String encodedIdString;
                boolean hasDpids;
                if (!MobileConfig.getInstance().getVisitorIdServiceEnabled()) {
                    return;
                }
                if (MobileConfig.getInstance().getPrivacyStatus() != MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_IN) {
                    StaticMethods.logDebugFormat("ID Service - Ignoring ID Sync due to privacy status not being opt in", new Object[0]);
                    return;
                }
                String orgId = MobileConfig.getInstance().getMarketingCloudOrganizationId();
                boolean needResync = StaticMethods.getTimeSince1970() - VisitorIDService.this._lastSync > VisitorIDService.this._ttl || forceResync;
                boolean hasIdentifiers = identifiersCopy != null;
                boolean bl = hasDpids = dpidsCopy != null;
                if (!(VisitorIDService.this.getMarketingCloudIDInternal() == null || hasIdentifiers || hasDpids || needResync)) {
                    return;
                }
                StringBuilder url = new StringBuilder(MobileConfig.getInstance().getSSL() ? "https" : "http");
                url.append("://");
                url.append(VisitorIDService.this._marketingCloudServer);
                url.append("/id?d_ver=2&d_rtbd=json&d_orgid=");
                url.append(orgId);
                if (VisitorIDService.this.getMarketingCloudIDInternal() != null) {
                    url.append("&");
                    url.append(VisitorIDService.RESPONSE_KEY_MID);
                    url.append("=");
                    url.append(VisitorIDService.this.getMarketingCloudIDInternal());
                }
                if (VisitorIDService.this._blob != null) {
                    url.append("&");
                    url.append(VisitorIDService.RESPONSE_KEY_BLOB);
                    url.append("=");
                    url.append(VisitorIDService.this._blob);
                }
                if (VisitorIDService.this._locationHint != null) {
                    url.append("&");
                    url.append(VisitorIDService.RESPONSE_KEY_HINT);
                    url.append("=");
                    url.append(VisitorIDService.this._locationHint);
                }
                if ((encodedIdString = VisitorIDService.this._generateCustomerIdString(newCustomerIDs = VisitorIDService.this._generateCustomerIds(identifiersCopy, authenticationState))) != null) {
                    url.append(encodedIdString);
                }
                if ((internalIdString = VisitorIDService.this._generateInternalIdString(dpidsCopy)) != null) {
                    url.append(internalIdString);
                }
                if (MobileConfig.getInstance().getMarketingCloudCoopUnsafe()) {
                    url.append(VisitorIDService.ADBVisitorCoopUnsafe);
                }
                String urlString = url.toString();
                StaticMethods.logDebugFormat("ID Service - Sending id sync call (%s)", urlString);
                byte[] response = RequestHandler.retrieveData(urlString, null, 5000, 5000, "ID Service");
                JSONObject responseObject = VisitorIDService.this.parseResponse(response);
                if (responseObject != null && responseObject.has(VisitorIDService.RESPONSE_KEY_MID) && !responseObject.has(VisitorIDService.RESPONSE_KEY_ERROR)) {
                    try {
                        JSONArray optOuts;
                        if (responseObject.has(VisitorIDService.RESPONSE_KEY_BLOB)) {
                            VisitorIDService.this._blob = responseObject.getString(VisitorIDService.RESPONSE_KEY_BLOB);
                        }
                        if (responseObject.has(VisitorIDService.RESPONSE_KEY_HINT)) {
                            VisitorIDService.this._locationHint = responseObject.getString(VisitorIDService.RESPONSE_KEY_HINT);
                        }
                        if (responseObject.has(VisitorIDService.RESPONSE_KEY_TTL)) {
                            VisitorIDService.this._ttl = responseObject.getInt(VisitorIDService.RESPONSE_KEY_TTL);
                        }
                        String optStatusDebug = "";
                        if (responseObject.has(VisitorIDService.RESPONSE_KEY_OPT_OUT) && (optOuts = responseObject.getJSONArray(VisitorIDService.RESPONSE_KEY_OPT_OUT)).length() > 0) {
                            MobileConfig.getInstance().setPrivacyStatus(MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_OUT);
                            optStatusDebug = ", global privacy status: opted out";
                        }
                        StaticMethods.logDebugFormat("ID Service - Got ID Response (mid: %s, blob: %s, hint: %s, ttl: %d%s)", VisitorIDService.this.getMarketingCloudIDInternal(), VisitorIDService.this._blob, VisitorIDService.this._locationHint, VisitorIDService.this._ttl, optStatusDebug);
                    }
                    catch (JSONException ex) {
                        StaticMethods.logDebugFormat("ID Service - Error parsing response (%s)", ex.getLocalizedMessage());
                    }
                } else if (responseObject != null && responseObject.has(VisitorIDService.RESPONSE_KEY_ERROR)) {
                    try {
                        StaticMethods.logErrorFormat("ID Service - Service returned error (%s)", responseObject.getString(VisitorIDService.RESPONSE_KEY_ERROR));
                    }
                    catch (JSONException ex) {
                        StaticMethods.logErrorFormat("ID Service - Unable to read error condition(%s)", ex.getLocalizedMessage());
                    }
                }
                VisitorIDService.this._lastSync = StaticMethods.getTimeSince1970();
                VisitorIDService.this.updateCustomerIds(VisitorIDService.this._mergeCustomerIds(newCustomerIDs));
                String idStringToStore = VisitorIDService.this._generateStoredCustomerIdString(VisitorIDService.this._customerIds);
                WearableFunctionBridge.syncVidServiceToWearable(VisitorIDService.this.getMarketingCloudIDInternal(), VisitorIDService.this._locationHint, VisitorIDService.this._blob, VisitorIDService.this._ttl, VisitorIDService.this._lastSync, idStringToStore);
                try {
                    SharedPreferences.Editor e = StaticMethods.getSharedPreferencesEditor();
                    e.putString("ADBMOBILE_VISITORID_IDS", idStringToStore);
                    e.putString("ADBMOBILE_PERSISTED_MID", VisitorIDService.this.getMarketingCloudIDInternal());
                    e.putString("ADBMOBILE_PERSISTED_MID_HINT", VisitorIDService.this._locationHint);
                    e.putString("ADBMOBILE_PERSISTED_MID_BLOB", VisitorIDService.this._blob);
                    e.putLong("ADBMOBILE_VISITORID_TTL", VisitorIDService.this._ttl);
                    e.putLong("ADBMOBILE_VISITORID_SYNC", VisitorIDService.this._lastSync);
                    e.commit();
                }
                catch (StaticMethods.NullContextException ex) {
                    StaticMethods.logErrorFormat("ID Service - Unable to persist identifiers to shared preferences(%s)", ex.getLocalizedMessage());
                }
            }
        });
    }

    protected final JSONObject parseResponse(byte[] response) {
        JSONObject responseObject;
        if (response == null) {
            return null;
        }
        try {
            responseObject = new JSONObject(new String(response, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            StaticMethods.logErrorFormat("ID Service - Unable to decode response(%s)", ex.getLocalizedMessage());
            return null;
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("ID Service - Unable to parse response(%s)", ex.getLocalizedMessage());
            return null;
        }
        return responseObject;
    }

    private final String getMarketingCloudIDInternal() {
        if (this._marketingCloudID == null && MobileConfig.getInstance().getPrivacyStatus() != MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_OUT && MobileConfig.getInstance().getVisitorIdServiceEnabled()) {
            this._marketingCloudID = this._generateMID();
            StaticMethods.logDebugFormat("ID Service - generating mid locally (mid: %s, ttl: %d)", this._marketingCloudID, this._ttl);
            try {
                SharedPreferences.Editor e = StaticMethods.getSharedPreferencesEditor();
                e.putString("ADBMOBILE_PERSISTED_MID", this._marketingCloudID);
                e.commit();
            }
            catch (StaticMethods.NullContextException ex) {
                StaticMethods.logErrorFormat("ID Service - Unable to persist identifiers to shared preferences(%s)", ex.getLocalizedMessage());
            }
        }
        return this._marketingCloudID;
    }

    protected final String getMarketingCloudID() {
        FutureTask<String> f = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return VisitorIDService.this.getMarketingCloudIDInternal();
            }
        });
        this._visitorIDExecutor.execute(f);
        try {
            return f.get();
        }
        catch (Exception ex) {
            StaticMethods.logErrorFormat("ID Service - Unable to retrieve marketing cloud id from queue(%s)", ex.getLocalizedMessage());
            return null;
        }
    }

    private String loadMarketingCloudServerFromConfig() {
        FutureTask<String> f = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return MobileConfig.getInstance().getMarketingCloudCustomServer();
            }
        });
        this._visitorIDExecutor.execute(f);
        String server = null;
        try {
            server = f.get();
        }
        catch (Exception ex) {
            StaticMethods.logDebugFormat("ID Service - Unable to retrieve marketing cloud server from configuration - using default value (%s)", ex.getLocalizedMessage());
        }
        if (server == null || server.isEmpty()) {
            return DEFAULT_SERVER;
        }
        return server;
    }

    protected final List<VisitorID> getIdentifiers() {
        FutureTask<List<VisitorID>> f = new FutureTask<List<VisitorID>>(new Callable<List<VisitorID>>(){

            @Override
            public List<VisitorID> call() throws Exception {
                return new ArrayList<VisitorID>(VisitorIDService.this._customerIds);
            }
        });
        this._visitorIDExecutor.execute(f);
        try {
            return f.get();
        }
        catch (Exception ex) {
            StaticMethods.logWarningFormat("ID Service - Unable to retrieve marketing cloud identifiers from queue(%s)", ex.getLocalizedMessage());
            return null;
        }
    }

    protected final String getAnalyticsIDRequestParameterString() {
        final StringBuilder returnValue = new StringBuilder();
        FutureTask<Void> f = new FutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (VisitorIDService.this.getMarketingCloudIDInternal() != null) {
                    returnValue.append("?");
                    returnValue.append(VisitorIDService.ANALYTICS_PARAMETER_KEY_MID);
                    returnValue.append("=");
                    returnValue.append(VisitorIDService.this.getMarketingCloudIDInternal());
                    returnValue.append("&");
                    returnValue.append(VisitorIDService.ANALYTICS_PARAMETER_KEY_ORG);
                    returnValue.append("=");
                    returnValue.append(MobileConfig.getInstance().getMarketingCloudOrganizationId());
                }
                return null;
            }
        });
        this._visitorIDExecutor.execute(f);
        try {
            f.get();
        }
        catch (Exception ex) {
            StaticMethods.logErrorFormat("ID Service - Unable to retrieve analytics id parameters from queue(%s)", ex.getLocalizedMessage());
        }
        return returnValue.toString();
    }

    protected final Map<String, String> getAnalyticsParameters() {
        final HashMap<String, String> returnValue = new HashMap<String, String>();
        FutureTask<Void> f = new FutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (VisitorIDService.this.getMarketingCloudIDInternal() == null) {
                    return null;
                }
                returnValue.put(VisitorIDService.ANALYTICS_PARAMETER_KEY_MID, VisitorIDService.this.getMarketingCloudIDInternal());
                if (VisitorIDService.this._blob != null) {
                    returnValue.put(VisitorIDService.ANALYTICS_PARAMETER_KEY_BLOB, VisitorIDService.this._blob);
                }
                if (VisitorIDService.this._locationHint != null) {
                    returnValue.put(VisitorIDService.ANALYTICS_PARAMETER_KEY_LOCATION_HINT, VisitorIDService.this._locationHint);
                }
                return null;
            }
        });
        this._visitorIDExecutor.execute(f);
        try {
            f.get();
        }
        catch (Exception ex) {
            StaticMethods.logErrorFormat("ID Service - Unable to retrieve analytics parameters from queue(%s)", ex.getLocalizedMessage());
        }
        return returnValue;
    }

    protected final String getAnalyticsIdString() {
        FutureTask<String> f = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return VisitorIDService.this._analyticsIdString != null ? VisitorIDService.this._analyticsIdString : "";
            }
        });
        this._visitorIDExecutor.execute(f);
        try {
            return f.get();
        }
        catch (Exception ex) {
            StaticMethods.logErrorFormat("ID Service - Unable to retrieve analytics id string from queue(%s)", ex.getLocalizedMessage());
            return "";
        }
    }

    protected final Map<String, Object> getAnalyticsIdVisitorParameters() {
        final HashMap<String, Object> analyticsIdVisitorParameters = new HashMap<String, Object>();
        FutureTask<Void> f = new FutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (VisitorIDService.this.getMarketingCloudIDInternal() == null) {
                    return null;
                }
                analyticsIdVisitorParameters.put(VisitorIDService.ANALYTICS_PARAMETER_KEY_MID, VisitorIDService.this.getMarketingCloudIDInternal());
                if (VisitorIDService.this._blob != null) {
                    analyticsIdVisitorParameters.put(VisitorIDService.ANALYTICS_PARAMETER_KEY_BLOB, VisitorIDService.this._blob);
                }
                if (VisitorIDService.this._locationHint != null) {
                    analyticsIdVisitorParameters.put(VisitorIDService.ANALYTICS_PARAMETER_KEY_LOCATION_HINT, VisitorIDService.this._locationHint);
                }
                return null;
            }
        });
        this._visitorIDExecutor.execute(f);
        try {
            f.get();
        }
        catch (Exception ex) {
            StaticMethods.logErrorFormat("ID Service - Unable to retrieve analytics parameters from queue(%s)", ex.getLocalizedMessage());
        }
        return analyticsIdVisitorParameters;
    }

    protected final String getAAMParameterString() {
        final StringBuilder returnValue = new StringBuilder();
        FutureTask<Void> f = new FutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (VisitorIDService.this.getMarketingCloudIDInternal() == null) {
                    return null;
                }
                returnValue.append("&");
                returnValue.append(VisitorIDService.RESPONSE_KEY_MID);
                returnValue.append("=");
                returnValue.append(VisitorIDService.this.getMarketingCloudIDInternal());
                if (VisitorIDService.this._blob != null) {
                    returnValue.append("&");
                    returnValue.append(VisitorIDService.RESPONSE_KEY_BLOB);
                    returnValue.append("=");
                    returnValue.append(VisitorIDService.this._blob);
                }
                if (VisitorIDService.this._locationHint != null) {
                    returnValue.append("&");
                    returnValue.append(VisitorIDService.RESPONSE_KEY_HINT);
                    returnValue.append("=");
                    returnValue.append(VisitorIDService.this._locationHint);
                }
                if (VisitorIDService.this._aamIdString != null) {
                    returnValue.append(VisitorIDService.this._aamIdString);
                }
                return null;
            }
        });
        this._visitorIDExecutor.execute(f);
        try {
            f.get();
        }
        catch (Exception ex) {
            StaticMethods.logErrorFormat("ID Service - Unable to retrieve audience manager parameters from queue(%s)", ex.getLocalizedMessage());
        }
        return returnValue.toString();
    }

    protected final HashMap<String, Object> getTargetParameterMap() {
        HashMap<String, Object> targetParameters = null;
        FutureTask<HashMap<String, Object>> targetParamTask = new FutureTask<HashMap<String, Object>>(new Callable<HashMap<String, Object>>(){

            @Override
            public HashMap<String, Object> call() throws Exception {
                if (VisitorIDService.this.getMarketingCloudIDInternal() == null || VisitorIDService.this.getMarketingCloudIDInternal().length() <= 0) {
                    return null;
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                if (VisitorIDService.this._blob != null && VisitorIDService.this._blob.length() > 0) {
                    params.put(VisitorIDService.TARGET_PARAMETER_KEY_BLOB, VisitorIDService.this._blob);
                }
                if (VisitorIDService.this._locationHint != null && VisitorIDService.this._locationHint.length() > 0) {
                    params.put(VisitorIDService.TARGET_PARAMETER_KEY_HINT, VisitorIDService.this._locationHint);
                }
                return params;
            }
        });
        this._visitorIDExecutor.execute(targetParamTask);
        try {
            targetParameters = targetParamTask.get();
        }
        catch (Exception ex) {
            StaticMethods.logErrorFormat("ID Service - Unable to retrieve target parameters from queue(%s)", ex.getLocalizedMessage());
        }
        return targetParameters;
    }

    String getVisitorInfoUrlString() {
        StringBuilder idStringBuilder = this._generateVisitorIDURLPayload();
        return idStringBuilder != null ? idStringBuilder.toString() : null;
    }

    protected final String appendVisitorInfoForURL(String url) {
        int anchorIndex;
        if (url == null || url.length() == 0) {
            return url;
        }
        StringBuilder idString = this._generateVisitorIDURLPayload();
        if (idString == null || idString.length() == 0) {
            return url;
        }
        StringBuilder modifiedURL = new StringBuilder(url);
        int queryIndex = modifiedURL.indexOf("?");
        if (queryIndex > 0) {
            if (queryIndex != modifiedURL.length() - 1) {
                idString.insert(0, "&");
            }
        } else {
            idString.insert(0, "?");
        }
        int insertIndex = (anchorIndex = modifiedURL.indexOf("#")) > 0 ? anchorIndex : modifiedURL.length();
        modifiedURL = modifiedURL.insert(insertIndex, idString.toString());
        return modifiedURL.toString();
    }

    private String _generateMID() {
        UUID uuid = UUID.randomUUID();
        long most = uuid.getMostSignificantBits();
        long least = uuid.getLeastSignificantBits();
        return String.format(Locale.US, "%019d%019d", most < 0L ? -most : most, least < 0L ? -least : least);
    }

    private String _timedCall(Callable<String> c, long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        if (c == null) {
            return null;
        }
        FutureTask<String> futureTask = new FutureTask<String>(c);
        Thread t = new Thread(futureTask);
        t.start();
        return futureTask.get(timeout, timeUnit);
    }

    private String _getAnalyticsID(long timeout, TimeUnit t) {
        Callable<String> c = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Analytics.getTrackingIdentifier();
            }
        };
        try {
            return this._timedCall(c, timeout, t);
        }
        catch (InterruptedException ex) {
            StaticMethods.logErrorFormat("ID Service - error retrieving AID (%s)", ex.getLocalizedMessage());
        }
        catch (ExecutionException ex) {
            StaticMethods.logErrorFormat("ID Service - error retrieving AID (%s)", ex.getLocalizedMessage());
        }
        catch (TimeoutException ex) {
            StaticMethods.logErrorFormat("ID Service - Timeout exceeded when retrieving AID (%s)", ex.getLocalizedMessage());
        }
        return null;
    }

    private String _getAnalyticsVID(long timeout, TimeUnit t) {
        Callable<String> c = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Config.getUserIdentifier();
            }
        };
        try {
            return this._timedCall(c, timeout, t);
        }
        catch (InterruptedException ex) {
            StaticMethods.logErrorFormat("ID Service - error retrieving VID (%s)", ex.getLocalizedMessage());
        }
        catch (ExecutionException ex) {
            StaticMethods.logErrorFormat("ID Service - error retrieving VID (%s)", ex.getLocalizedMessage());
        }
        catch (TimeoutException ex) {
            StaticMethods.logErrorFormat("ID Service - Timeout exceeded when retrieving VID (%s)", ex.getLocalizedMessage());
        }
        return null;
    }

    private String _getMarketingCloudID(long timeout, TimeUnit t) {
        Callable<String> c = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return VisitorIDService.this.getMarketingCloudID();
            }
        };
        try {
            return this._timedCall(c, timeout, t);
        }
        catch (InterruptedException ex) {
            StaticMethods.logErrorFormat("ID Service - error retrieving MID (%s)", ex.getLocalizedMessage());
        }
        catch (ExecutionException ex) {
            StaticMethods.logErrorFormat("ID Service - error retrieving MID (%s)", ex.getLocalizedMessage());
        }
        catch (TimeoutException ex) {
            StaticMethods.logErrorFormat("ID Service - Timeout exceeded when retrieving MID (%s)", ex.getLocalizedMessage());
        }
        return null;
    }

    private StringBuilder _generateVisitorIDURLPayload() {
        StringBuilder urlFragment = new StringBuilder();
        String aid = this._getAnalyticsID(100L, TimeUnit.MILLISECONDS);
        String vid = this._getAnalyticsVID(100L, TimeUnit.MILLISECONDS);
        String mid = this._getMarketingCloudID(100L, TimeUnit.MILLISECONDS);
        String mcOrgId = MobileConfig.getInstance().getMarketingCloudOrganizationId();
        String theIdString = this._appendKVPToVisitorIdStringNoEncode(null, ADBVisitorPayloadTimestampKey, String.valueOf(StaticMethods.getTimeSince1970()));
        theIdString = this._appendKVPToVisitorIdStringNoEncode(theIdString, ADBVisitorPayloadMarketingCloudIDKey, mid);
        theIdString = this._appendKVPToVisitorIdStringNoEncode(theIdString, ADBVisitorPayloadAnalyticsIDKey, aid);
        theIdString = this._appendKVPToVisitorIdStringNoEncode(theIdString, ADBVisitorPayloadMarketingCloudOrgId, mcOrgId);
        urlFragment.append(ADBVisitorPayloadKey);
        urlFragment.append("=");
        urlFragment.append(StaticMethods.URLEncode(theIdString));
        if (vid != null && vid.length() > 0) {
            urlFragment.append("&");
            urlFragment.append(ADBAnalyticsPayloadKey);
            urlFragment.append("=");
            urlFragment.append(StaticMethods.URLEncode(vid));
        }
        return urlFragment.length() > 0 ? urlFragment : null;
    }

    private String _appendKVPToVisitorIdStringNoEncode(String originalString, String key, String value) {
        if (key == null || key.isEmpty() || value == null || value.isEmpty()) {
            return originalString;
        }
        String newUrlVariable = String.format("%s=%s", key, value);
        if (originalString == null || originalString.isEmpty()) {
            return newUrlVariable;
        }
        return String.format("%s|%s", originalString, newUrlVariable);
    }

    private String _generateStoredCustomerIdString(List<VisitorID> visitorIDs) {
        if (visitorIDs == null) {
            return null;
        }
        StringBuilder customerIdString = new StringBuilder();
        for (VisitorID visitorID : visitorIDs) {
            customerIdString.append("&");
            customerIdString.append(VISITOR_ID_PARAMETER_KEY_CUSTOMER);
            customerIdString.append("=");
            customerIdString.append(visitorID.idType);
            customerIdString.append(CID_DELIMITER);
            if (visitorID.id != null) {
                customerIdString.append(visitorID.id);
            }
            customerIdString.append(CID_DELIMITER);
            customerIdString.append(visitorID.authenticationState.getValue());
        }
        return customerIdString.toString();
    }

    private String _generateCustomerIdString(List<VisitorID> newVisitorIDs) {
        if (newVisitorIDs == null) {
            return null;
        }
        StringBuilder customerIdString = new StringBuilder();
        for (VisitorID newVisitorID : newVisitorIDs) {
            customerIdString.append("&");
            customerIdString.append(VISITOR_ID_PARAMETER_KEY_CUSTOMER);
            customerIdString.append("=");
            customerIdString.append(StaticMethods.URLEncode(newVisitorID.idType));
            customerIdString.append(CID_DELIMITER);
            String urlEncodedID = StaticMethods.URLEncode(newVisitorID.id);
            if (urlEncodedID != null) {
                customerIdString.append(urlEncodedID);
            }
            customerIdString.append(CID_DELIMITER);
            customerIdString.append(newVisitorID.authenticationState.getValue());
        }
        return customerIdString.toString();
    }

    private String _generateInternalIdString(Map<String, String> dpids) {
        if (dpids == null) {
            return null;
        }
        HashMap<String, String> dpidsCopy = new HashMap<String, String>(dpids);
        StringBuilder internalIdString = new StringBuilder();
        for (Map.Entry<String, String> entry : dpidsCopy.entrySet()) {
            internalIdString.append("&d_cid=");
            internalIdString.append(StaticMethods.URLEncode(entry.getKey()));
            internalIdString.append(CID_DELIMITER);
            internalIdString.append(StaticMethods.URLEncode(entry.getValue()));
        }
        return internalIdString.toString();
    }

    private String _generateAnalyticsCustomerIdString(List<VisitorID> visitorIDs) {
        if (visitorIDs == null) {
            return null;
        }
        HashMap<String, Object> visitorIdMap = new HashMap<String, Object>();
        for (VisitorID visitorID : visitorIDs) {
            visitorIdMap.put(visitorID.serializeIdentifierKeyForAnalyticsID(), visitorID.id);
            visitorIdMap.put(visitorID.serializeAuthenticationKeyForAnalyticsID(), visitorID.authenticationState.getValue());
        }
        HashMap<String, Object> translatedIds = new HashMap<String, Object>();
        translatedIds.put("cid", StaticMethods.translateContextData(visitorIdMap));
        StringBuilder requestString = new StringBuilder(2048);
        StaticMethods.serializeToQueryString(translatedIds, requestString);
        return requestString.toString();
    }

    private List<VisitorID> _generateCustomerIds(Map<String, String> identifiers, VisitorID.VisitorIDAuthenticationState authenticationState) {
        if (identifiers == null) {
            return null;
        }
        HashMap<String, String> identifiersCopy = new HashMap<String, String>(identifiers);
        ArrayList<VisitorID> tempIds = new ArrayList<VisitorID>();
        for (Map.Entry<String, String> newID : identifiersCopy.entrySet()) {
            try {
                tempIds.add(new VisitorID(VISITOR_ID_PARAMETER_KEY_CUSTOMER, newID.getKey(), newID.getValue(), authenticationState));
            }
            catch (IllegalStateException ex) {
                StaticMethods.logWarningFormat("ID Service - Unable to create ID after encoding:(%s)", ex.getLocalizedMessage());
            }
        }
        return tempIds;
    }

    private List<VisitorID> _mergeCustomerIds(List<VisitorID> newCustomerIds) {
        if (newCustomerIds == null) {
            return this._customerIds;
        }
        ArrayList<VisitorID> tempIds = this._customerIds != null ? new ArrayList<VisitorID>(this._customerIds) : new ArrayList();
        block2: for (VisitorID newID : newCustomerIds) {
            for (VisitorID visitorID : tempIds) {
                if (!visitorID.isVisitorID(newID.idType)) continue;
                visitorID.authenticationState = newID.authenticationState;
                visitorID.id = newID.id;
                continue block2;
            }
            try {
                tempIds.add(newID);
            }
            catch (IllegalStateException ex) {
                StaticMethods.logWarningFormat("ID Service - Unable to create ID after encoding:(%s)", ex.getLocalizedMessage());
            }
        }
        return tempIds;
    }

    private List<VisitorID> _parseIdString(String idString) {
        if (idString == null) {
            return null;
        }
        List<String> customerIdComponentsArray = Arrays.asList(idString.split("&"));
        ArrayList<VisitorID> visitorIDs = new ArrayList<VisitorID>();
        for (String customerIdString : customerIdComponentsArray) {
            String currentCustomerIdValue;
            String currentCustomerIdOrigin;
            if (customerIdString.length() <= 0) continue;
            int firstEqualsIndex = customerIdString.indexOf("=");
            if (firstEqualsIndex == -1) {
                StaticMethods.logWarningFormat("ID Service - Unable to load Customer ID from Shared Preferences: %s", customerIdString);
                continue;
            }
            try {
                currentCustomerIdOrigin = customerIdString.substring(0, firstEqualsIndex);
                currentCustomerIdValue = customerIdString.substring(firstEqualsIndex + 1, customerIdString.length());
            }
            catch (IndexOutOfBoundsException ex) {
                StaticMethods.logWarningFormat("ID Service - Unable to load Customer ID from Shared Preferences, name or value was malformed: %s (%s)", customerIdString, ex.getLocalizedMessage());
                continue;
            }
            List<String> idInfo = Arrays.asList(currentCustomerIdValue.split(CID_DELIMITER));
            if (idInfo.size() != 3) {
                StaticMethods.logWarningFormat("ID Service - Unable to load Customer ID from Shared Preferences, value was malformed: %s", currentCustomerIdValue);
                continue;
            }
            try {
                VisitorID id = new VisitorID(currentCustomerIdOrigin, idInfo.get(0), idInfo.get(1), VisitorID.VisitorIDAuthenticationState.values()[Integer.parseInt(idInfo.get(2))]);
                visitorIDs.add(id);
            }
            catch (NumberFormatException ex) {
                StaticMethods.logWarningFormat("ID Service - Unable to parse visitor ID: (%s) exception:(%s)", customerIdString, ex.getLocalizedMessage());
            }
            catch (IllegalStateException ex) {
                StaticMethods.logWarningFormat("ID Service - Unable to create ID after encoding:(%s)", ex.getLocalizedMessage());
            }
        }
        return visitorIDs;
    }

    protected ExecutorService getVisitorIDServiceExecutor() {
        return this._visitorIDExecutor;
    }

    void purgeIdentities() {
        this._visitorIDExecutor.execute(new Runnable(){

            @Override
            public void run() {
                VisitorIDService.this._marketingCloudID = null;
                VisitorIDService.this._customerIds = null;
                VisitorIDService.this._analyticsIdString = null;
                VisitorIDService.this._aamIdString = null;
                VisitorIDService.this._locationHint = null;
                VisitorIDService.this._blob = null;
                try {
                    SharedPreferences.Editor prefsEditor = StaticMethods.getSharedPreferencesEditor();
                    prefsEditor.remove("ADBMOBILE_VISITORID_IDS");
                    prefsEditor.remove("ADBMOBILE_PERSISTED_MID");
                    prefsEditor.remove("ADBMOBILE_PERSISTED_MID_HINT");
                    prefsEditor.remove("ADBMOBILE_PERSISTED_MID_BLOB");
                    prefsEditor.apply();
                }
                catch (StaticMethods.NullContextException e) {
                    StaticMethods.logWarningFormat("ID Service - Unable to purge identities (application context is null)", new Object[0]);
                }
            }
        });
    }
}

