/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.content.SharedPreferences;
import com.adobe.mobile.AnalyticsTrackInternal;
import com.adobe.mobile.AnalyticsTrackLifetimeValueIncrease;
import com.adobe.mobile.Lifecycle;
import com.adobe.mobile.MobileConfig;
import com.adobe.mobile.MobilePrivacyStatus;
import com.adobe.mobile.NetworkObject;
import com.adobe.mobile.RequestHandler;
import com.adobe.mobile.StaticMethods;
import com.adobe.mobile.Target;
import com.adobe.mobile.TargetJsonBuilder;
import com.adobe.mobile.TargetLocationRequest;
import com.adobe.mobile.TargetPrefetchObject;
import com.adobe.mobile.TargetPreviewManager;
import com.adobe.mobile.TargetRequestObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class TargetWorker {
    protected static final String TARGET_API_A4T_ACTION_NAME = "AnalyticsForTarget";
    protected static final String TARGET_API_JSON_TNT_ID = "tntId";
    protected static final String TARGET_API_JSON_THIRD_PARTY_ID = "thirdPartyId";
    protected static final String TARGET_API_JSON_EDGE_HOST = "edgeHost";
    private static final List<String> cacheMboxAcceptedKeys = Arrays.asList("mbox", "parameters", "product", "order", "content", "eventTokens", "clientSideAnalyticsLoggingPayload", "errorType", "profileScriptToken", "clickToken");
    private static final List<String> cacheLoadedMboxAcceptedKeys = Arrays.asList("mbox", "profileScriptToken", "clickToken");
    protected static final String TARGET_API_JSON_ERROR_MESSAGE = "message";
    protected static final String TARGET_API_CONTENT_TYPE = "application/json";
    protected static final String TARGET_API_URL_PREVIEW_TOKEN_PARAM = "at_preview_token=%s";
    protected static final String TARGET_PREFETCH_API_URL_BASE = "https://%s/rest/v2/batchmbox/?client=%s&sessionId=%s";
    protected static final String TARGET_API_URL_HOST_BASE = "%s.tt.omtrdc.net";
    protected static final String COOKIE_NAME_PCID = "mboxPC";
    protected static final String COOKIE_EXPIRES_KEY_SUFFIX = "_Expires";
    protected static final String COOKIE_VALUE_KEY_SUFFIX = "_Value";
    protected static final String PROFILE_PARAMETER_PREFIX = "profile.";
    private static Map<String, JSONObject> prefetchedMboxes = new HashMap<String, JSONObject>();
    private static List<JSONObject> notifications = new ArrayList<JSONObject>();
    private static Map<String, JSONObject> loadedMboxes = new HashMap<String, JSONObject>();
    private static String _tntId = null;
    private static String _thirdPartyId = null;
    private static String _edgeHost = null;
    private static HashMap<String, Object> _persistentParameters = null;
    private static final Object _tntIdMutex = new Object();
    private static final Object _thirdPartyIdMutex = new Object();
    private static final Object _persistentParametersMutex = new Object();
    private static final Object _checkOldCookiesMutex = new Object();
    private static String _sessionId = null;
    private static long _sessionIdTimestampSeconds = 0L;
    private static final Object _sessionIdMutex = new Object();
    private static final int TARGET_API_SERVER_ERROR_RESPONSE_CODE_RANGE_MIN = 400;
    private static final int TARGET_API_SERVER_ERROR_RESPONSE_CODE_RANGE_MAX = 499;
    private static boolean _oldCookiesHaveBeenChecked = false;

    TargetWorker() {
    }

    protected static void loadRequest(TargetLocationRequest request, Target.TargetCallback<String> callback) {
        if (request == null) {
            StaticMethods.logWarningFormat("Target - \"TargetLocationRequest\" object cannot be null", new Object[0]);
            if (callback != null) {
                callback.call(null);
            }
            return;
        }
        HashMap<String, Object> mboxParameters = request.parameters;
        TargetWorker.getThirdPartyIDLegacy(mboxParameters);
        TargetWorker.loadRequest(request.name, request.defaultContent, TargetWorker.getProfileParametersLegacy(mboxParameters), TargetWorker.getOrderParametersLegacy(mboxParameters), mboxParameters, null, callback);
    }

    protected static void loadRequest(String mboxName, String defaultContent, Map<String, Object> profileParameters, Map<String, Object> orderParameters, Map<String, Object> mboxParameters, Map<String, Object> requestLocationParameters, Target.TargetCallback<String> callback) {
        if (!MobileConfig.getInstance().mobileUsingTarget() || MobileConfig.getInstance().getPrivacyStatus() != MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_IN) {
            if (callback != null) {
                callback.call(defaultContent);
            }
            return;
        }
        if (TargetWorker.isNullOrEmpty(mboxName)) {
            StaticMethods.logWarningFormat("Target - \"mboxName\" parameter is required for Target calls - returning default content", new Object[0]);
            if (callback != null) {
                callback.call(defaultContent);
            }
            return;
        }
        TargetRequestObject requestObject = new TargetRequestObject(mboxName, defaultContent, mboxParameters, orderParameters, null, callback);
        if (requestLocationParameters != null) {
            requestObject.setRequestLocationParameters(requestLocationParameters);
        }
        ArrayList<TargetRequestObject> batchRequest = new ArrayList<TargetRequestObject>();
        batchRequest.add(requestObject);
        HashMap<String, Object> profileParametersCopy = profileParameters != null ? new HashMap<String, Object>(profileParameters) : new HashMap();
        TargetBatchRunner targetBatchRunner = new TargetBatchRunner(batchRequest, profileParametersCopy);
        StaticMethods.getAnalyticsExecutor().execute(targetBatchRunner);
    }

    protected static void loadRequests(List<TargetRequestObject> requestArray, Map<String, Object> profileParameters) {
        if (TargetWorker.isNullOrEmpty(requestArray)) {
            StaticMethods.logWarningFormat("Target - request array should contain at least one mbox", new Object[0]);
            return;
        }
        ArrayList<TargetRequestObject> requestArrayCopy = new ArrayList<TargetRequestObject>(requestArray);
        if (!MobileConfig.getInstance().mobileUsingTarget() || MobileConfig.getInstance().getPrivacyStatus() != MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_IN) {
            TargetWorker.replyWithDefaultContent(requestArrayCopy);
            return;
        }
        Iterator iterator = requestArrayCopy.iterator();
        while (iterator.hasNext()) {
            TargetRequestObject request = (TargetRequestObject)iterator.next();
            if (!TargetWorker.isNullOrEmpty(request.getMboxName())) continue;
            if (request.getCallback() != null) {
                request.getCallback().call(request.getDefaultContent());
            }
            iterator.remove();
        }
        HashMap<String, Object> profileParametersCopy = profileParameters != null ? new HashMap<String, Object>(profileParameters) : new HashMap();
        TargetBatchRunner targetBatchRunner = new TargetBatchRunner(requestArrayCopy, profileParametersCopy);
        StaticMethods.getAnalyticsExecutor().execute(targetBatchRunner);
    }

    protected static void prefetchContent(List<TargetPrefetchObject> targetPrefetchArray, Map<String, Object> profileParameters, Target.TargetCallback<Boolean> callback) {
        if (!MobileConfig.getInstance().mobileUsingTarget() || MobileConfig.getInstance().getPrivacyStatus() != MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_IN) {
            StaticMethods.logWarningFormat("Target - prefetch can't be used if target is not enabled or privacy is not opted in", new Object[0]);
            if (callback != null) {
                callback.call(false);
            }
            return;
        }
        Boolean inTargetPreviewMode = !TargetWorker.isNullOrEmpty(TargetPreviewManager.getInstance().getPreviewParams());
        if (inTargetPreviewMode.booleanValue()) {
            StaticMethods.logWarningFormat("Target - Prefetch feature is not supported in preview mode", new Object[0]);
            if (callback != null) {
                callback.call(false);
            }
            return;
        }
        if (TargetWorker.isNullOrEmpty(targetPrefetchArray)) {
            StaticMethods.logWarningFormat("Target - prefetch array should contain at least one mbox", new Object[0]);
            if (callback != null) {
                callback.call(false);
            }
            return;
        }
        Iterator<TargetPrefetchObject> iterator = targetPrefetchArray.iterator();
        while (iterator.hasNext()) {
            TargetPrefetchObject request = iterator.next();
            if (!TargetWorker.isNullOrEmpty(request.getMboxName())) continue;
            iterator.remove();
        }
        if (TargetWorker.isNullOrEmpty(targetPrefetchArray)) {
            StaticMethods.logWarningFormat("Target - prefetch array should contain mboxes with valid mbox names", new Object[0]);
            if (callback != null) {
                callback.call(false);
            }
            return;
        }
        HashMap<String, Object> profileParametersCopy = profileParameters != null ? new HashMap<String, Object>(profileParameters) : new HashMap();
        TargetPrefetchRunner targetRunner = new TargetPrefetchRunner(targetPrefetchArray, profileParametersCopy, callback);
        StaticMethods.getAnalyticsExecutor().execute(targetRunner);
    }

    protected static void locationClicked(String mboxName, Map<String, Object> mboxParameters, Map<String, Object> orderParameters, Map<String, Object> productParameters, Map<String, Object> profileParameters) {
        if (TargetWorker.isNullOrEmpty(mboxName)) {
            StaticMethods.logWarningFormat("Target - click notification can't be sent if mbox name is empty/null", new Object[0]);
            return;
        }
        if (!MobileConfig.getInstance().mobileUsingTarget() || MobileConfig.getInstance().getPrivacyStatus() != MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_IN) {
            StaticMethods.logWarningFormat("Target - click notification can't be sent if target is not enabled or privacy is not opted in", new Object[0]);
            return;
        }
        HashMap<String, Object> mboxParametersCopy = mboxParameters != null ? new HashMap<String, Object>(mboxParameters) : new HashMap();
        HashMap<String, Object> orderParametersCopy = orderParameters != null ? new HashMap<String, Object>(orderParameters) : new HashMap();
        HashMap<String, Object> productParametersCopy = productParameters != null ? new HashMap<String, Object>(productParameters) : new HashMap();
        HashMap<String, Object> profileParametersCopy = profileParameters != null ? new HashMap<String, Object>(profileParameters) : new HashMap();
        TargetClickNotification targetRunner = new TargetClickNotification(mboxName, mboxParametersCopy, orderParametersCopy, productParametersCopy, profileParametersCopy);
        StaticMethods.getAnalyticsExecutor().execute(targetRunner);
    }

    protected static void clearPrefetchCache() {
        if (prefetchedMboxes != null) {
            prefetchedMboxes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getThirdPartyId() {
        Object object = _thirdPartyIdMutex;
        synchronized (object) {
            if (TargetWorker.isNullOrEmpty(_thirdPartyId)) {
                try {
                    SharedPreferences preferences = StaticMethods.getSharedPreferences();
                    _thirdPartyId = preferences.getString("ADBMOBILE_TARGET_3RD_PARTY_ID", null);
                }
                catch (StaticMethods.NullContextException ex) {
                    StaticMethods.logErrorFormat("Target - Error retrieving shared preferences - application context is null", new Object[0]);
                    return null;
                }
            }
            return _thirdPartyId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setThirdPartyId(String newThirdPartyId) {
        Object object = _thirdPartyIdMutex;
        synchronized (object) {
            if (newThirdPartyId != null && !newThirdPartyId.isEmpty() && MobileConfig.getInstance().getPrivacyStatus() == MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_OUT) {
                return;
            }
            String thirdPartyId = TargetWorker.getThirdPartyId();
            if (thirdPartyId != null && newThirdPartyId != null && thirdPartyId.equals(newThirdPartyId)) {
                return;
            }
            _thirdPartyId = newThirdPartyId;
            try {
                SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                if (TargetWorker.isNullOrEmpty(_thirdPartyId)) {
                    editor.remove("ADBMOBILE_TARGET_3RD_PARTY_ID");
                } else {
                    editor.putString("ADBMOBILE_TARGET_3RD_PARTY_ID", _thirdPartyId);
                }
                editor.commit();
            }
            catch (StaticMethods.NullContextException ex) {
                StaticMethods.logErrorFormat("Target - Error retrieving shared preferences - application context is null", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getTntId() {
        TargetWorker.setTntIdFromOldCookieValues();
        Object object = _tntIdMutex;
        synchronized (object) {
            if (TargetWorker.isNullOrEmpty(_tntId)) {
                try {
                    SharedPreferences preferences = StaticMethods.getSharedPreferences();
                    _tntId = preferences.getString("ADBMOBILE_TARGET_TNT_ID", null);
                }
                catch (StaticMethods.NullContextException ex) {
                    StaticMethods.logErrorFormat("Target - Error retrieving shared preferences - application context is null", new Object[0]);
                    return null;
                }
            }
            return _tntId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setTntId(String newTntId) {
        Object object = _tntIdMutex;
        synchronized (object) {
            if (TargetWorker.tntIdValuesAreEqual(_tntId, newTntId)) {
                return;
            }
            _tntId = newTntId;
            try {
                SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                if (TargetWorker.isNullOrEmpty(_tntId)) {
                    editor.remove("ADBMOBILE_TARGET_TNT_ID");
                } else {
                    editor.putString("ADBMOBILE_TARGET_TNT_ID", _tntId);
                }
                editor.commit();
            }
            catch (StaticMethods.NullContextException ex) {
                StaticMethods.logErrorFormat("Target - Error retrieving shared preferences - application context is null", new Object[0]);
            }
        }
    }

    protected static void resetExperience() {
        StaticMethods.logDebugFormat("Target - resetting experience for this user", new Object[0]);
        TargetWorker.setTntIdFromOldCookieValues();
        TargetWorker.setTntId(null);
        TargetWorker.setThirdPartyId(null);
        TargetWorker.setEdgeHost(null);
        TargetWorker.resetSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getEdgeHost() {
        Object object = _sessionIdMutex;
        synchronized (object) {
            if (TargetWorker.isSessionExpired()) {
                _edgeHost = null;
                try {
                    SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                    editor.remove("ADBMOBILE_TARGET_EDGE_HOST");
                    editor.commit();
                }
                catch (StaticMethods.NullContextException ex) {
                    StaticMethods.logErrorFormat("Target - Error persisting edge host in shared preferences - application context is null", new Object[0]);
                }
            } else if (TargetWorker.isNullOrEmpty(_edgeHost)) {
                try {
                    SharedPreferences preferences = StaticMethods.getSharedPreferences();
                    _edgeHost = preferences.getString("ADBMOBILE_TARGET_EDGE_HOST", null);
                }
                catch (StaticMethods.NullContextException ex) {
                    StaticMethods.logErrorFormat("Target - Error retrieving edge host from shared preferences - application context is null", new Object[0]);
                    return null;
                }
            }
            return _edgeHost;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setEdgeHost(String newEdgeHost) {
        Object object = _sessionIdMutex;
        synchronized (object) {
            if (_edgeHost == null && newEdgeHost == null || _edgeHost != null && _edgeHost.equals(newEdgeHost)) {
                return;
            }
            _edgeHost = newEdgeHost;
            try {
                SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                if (TargetWorker.isNullOrEmpty(_edgeHost)) {
                    editor.remove("ADBMOBILE_TARGET_EDGE_HOST");
                } else {
                    editor.putString("ADBMOBILE_TARGET_EDGE_HOST", _edgeHost);
                }
                editor.commit();
            }
            catch (StaticMethods.NullContextException ex) {
                StaticMethods.logErrorFormat("Target - Error persisting edge host in shared preferences - application context is null", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addPersistentParameter(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        Object object = _persistentParametersMutex;
        synchronized (object) {
            if (_persistentParameters == null) {
                _persistentParameters = new HashMap();
            }
            _persistentParameters.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removePersistentParameter(String key) {
        if (key == null) {
            return;
        }
        Object object = _persistentParametersMutex;
        synchronized (object) {
            if (_persistentParameters != null) {
                _persistentParameters.remove(key);
            }
        }
    }

    private static void processMboxResponse(TargetRequestObject request, JSONObject responseJson) {
        String errorType = null;
        String content = null;
        if (request == null) {
            return;
        }
        if (request.getCallback() == null) {
            StaticMethods.logDebugFormat("Target - No callback is provided for Target Location Request with mboxName - \"%s\"", request.getMboxName());
            return;
        }
        if (responseJson == null) {
            StaticMethods.logDebugFormat("Target - Invalid prefetched data is found for the mbox mboxName - \"%s\"", request.getMboxName());
            request.getCallback().call(request.getDefaultContent());
            return;
        }
        TargetWorker.forwardAnalyticsForTargetPayload(responseJson);
        try {
            content = responseJson.getString("content");
            if (responseJson.has("errorType")) {
                errorType = responseJson.getString("errorType");
            }
        }
        catch (JSONException exception) {
            StaticMethods.logDebugFormat("Target - JSONException while trying to get errorType&content (%s)", exception.getLocalizedMessage());
        }
        if (errorType == null && !TargetWorker.isNullOrEmpty(content)) {
            request.getCallback().call(content);
            StaticMethods.logDebugFormat("Target - Response returned for location \"%s\" - \"%s\"", request.getMboxName(), content);
            return;
        }
        StaticMethods.logDebugFormat("Target - Default content was returned for \"%s\"", request.getMboxName());
        request.getCallback().call(request.getDefaultContent());
    }

    private static void processMboxResponse(List<TargetRequestObject> batchRequest, Map<String, JSONObject> mBoxResponses) {
        if (mBoxResponses == null) {
            TargetWorker.replyWithDefaultContent(batchRequest);
            return;
        }
        for (TargetRequestObject eachRequest : batchRequest) {
            String errorType = null;
            String content = null;
            JSONObject mBoxResponse = mBoxResponses.get(eachRequest.getMboxName());
            TargetWorker.forwardAnalyticsForTargetPayload(mBoxResponse);
            if (eachRequest.getCallback() == null) {
                StaticMethods.logDebugFormat("Target - No callback is provided for Target Location Request with mboxName - \"%s\"", eachRequest.getMboxName());
                continue;
            }
            if (mBoxResponse == null) {
                eachRequest.getCallback().call(eachRequest.getDefaultContent());
                StaticMethods.logDebugFormat("Target - No response is obtain for Target Location Request with mboxName - \"%s\"", eachRequest.getMboxName());
                continue;
            }
            try {
                content = mBoxResponse.getString("content");
                if (mBoxResponse.has("errorType")) {
                    errorType = mBoxResponse.getString("errorType");
                }
            }
            catch (JSONException exception) {
                StaticMethods.logDebugFormat("Target - JSONException while trying to get errorType&content (%s)", exception.getLocalizedMessage());
            }
            if (errorType == null && !TargetWorker.isNullOrEmpty(content)) {
                eachRequest.getCallback().call(content);
                StaticMethods.logDebugFormat("Target - Response returned for location \"%s\" - \"%s\"", eachRequest.getMboxName(), content);
                continue;
            }
            StaticMethods.logDebugFormat("Target - Default content was returned for \"%s\"", eachRequest.getMboxName());
            eachRequest.getCallback().call(eachRequest.getDefaultContent());
        }
    }

    private static JSONObject extractServerJsonResponse(NetworkObject networkObject, String requestUrl) {
        if (networkObject == null) {
            StaticMethods.logErrorFormat("Target - unable to open connection (%s)", requestUrl);
            return null;
        }
        if (TargetWorker.isNullOrEmpty(networkObject.response)) {
            StaticMethods.logDebugFormat("Target - Response was empty", new Object[0]);
            if (networkObject.responseCode >= 400 && networkObject.responseCode <= 499) {
                notifications.clear();
            }
            return null;
        }
        if (networkObject.responseCode != 200) {
            StaticMethods.logDebugFormat("Target - Response code from Target server (%d) was invalid, returning default content", networkObject.responseCode);
            return null;
        }
        try {
            JSONObject responseJson = new JSONObject(networkObject.response);
            String errorMessage = TargetWorker.getErrorMessage(responseJson);
            if (!TargetWorker.isNullOrEmpty(errorMessage)) {
                StaticMethods.logDebugFormat("Target - An error was reported by the server (%s)", new Object[0]);
                return null;
            }
            return responseJson;
        }
        catch (JSONException exception) {
            StaticMethods.logErrorFormat("Target - JSONException while trying to get target response (%s)", exception.getLocalizedMessage());
            return null;
        }
    }

    private static void replyWithDefaultContent(List<TargetRequestObject> requestArray) {
        for (TargetRequestObject eachRequest : requestArray) {
            if (eachRequest.getCallback() == null) continue;
            eachRequest.getCallback().call(eachRequest.getDefaultContent());
        }
    }

    private static Map<String, JSONObject> extractPrefetchResponses(JSONObject serverResponseJson) throws JSONException {
        HashMap<String, JSONObject> prefetchResponses = new HashMap<String, JSONObject>();
        if (!serverResponseJson.has("prefetchResponses")) {
            return null;
        }
        JSONArray prefetchJsonArray = serverResponseJson.getJSONArray("prefetchResponses");
        if (prefetchJsonArray == null) {
            return null;
        }
        for (int i = 0; i < prefetchJsonArray.length(); ++i) {
            JSONObject mboxNode = TargetWorker.createCacheMboxNodeFromPrefetchResponse(prefetchJsonArray.getJSONObject(i));
            if (mboxNode == null || mboxNode.length() <= 0 || !mboxNode.has("mbox")) continue;
            prefetchResponses.put(mboxNode.getString("mbox"), mboxNode);
        }
        return prefetchResponses;
    }

    private static JSONObject createCacheMboxNodeFromPrefetchResponse(JSONObject mbox) {
        if (mbox == null || mbox.length() == 0) {
            return null;
        }
        JSONObject clearedMboxNode = null;
        try {
            clearedMboxNode = new JSONObject(mbox.toString());
            Iterator iterator = mbox.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                if (cacheMboxAcceptedKeys.contains(key)) continue;
                clearedMboxNode.remove(key);
            }
        }
        catch (JSONException exception) {
            StaticMethods.logWarningFormat("Target - failed to parse prefetch mbox response for %s", mbox.toString());
        }
        return clearedMboxNode;
    }

    private static Map<String, JSONObject> extractMBoxResponses(JSONObject serverResponseJson) throws JSONException {
        HashMap<String, JSONObject> mBoxResponses = new HashMap<String, JSONObject>();
        if (!serverResponseJson.has("mboxResponses")) {
            return null;
        }
        JSONArray mboxJSONArray = serverResponseJson.getJSONArray("mboxResponses");
        if (mboxJSONArray == null) {
            return null;
        }
        for (int i = 0; i < mboxJSONArray.length(); ++i) {
            String mboxName;
            JSONObject mboxNode = mboxJSONArray.getJSONObject(i);
            if (!mboxNode.has("mbox") || TargetWorker.isNullOrEmpty(mboxName = mboxNode.getString("mbox"))) continue;
            mBoxResponses.put(mboxName, mboxNode);
        }
        return mBoxResponses;
    }

    private static void cacheLoadedMboxResponses(Map<String, JSONObject> mBoxResponses) {
        if (mBoxResponses == null) {
            return;
        }
        for (Map.Entry<String, JSONObject> mbox : mBoxResponses.entrySet()) {
            String mboxName = mbox.getKey();
            JSONObject mboxNode = mbox.getValue();
            if (TargetWorker.isNullOrEmpty(mboxName) || prefetchedMboxes.containsKey(mboxName) || mboxNode == null) continue;
            try {
                JSONObject clearedMboxNode = new JSONObject(mboxNode.toString());
                Iterator iterator = mboxNode.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    if (cacheLoadedMboxAcceptedKeys.contains(key)) continue;
                    clearedMboxNode.remove(key);
                }
                loadedMboxes.put(mboxName, clearedMboxNode);
            }
            catch (JSONException exception) {
                StaticMethods.logDebugFormat("Target - failed to save viewed mbox responses for click notification %s, error %s", mboxNode.toString(), exception.getLocalizedMessage());
            }
        }
    }

    private static void removeDuplicatedMboxesFromCaches() {
        for (String mboxName : prefetchedMboxes.keySet()) {
            if (mboxName == null || !loadedMboxes.containsKey(mboxName)) continue;
            loadedMboxes.remove(mboxName);
        }
    }

    private static String getTargetRequestURL() {
        String targetClientCode = MobileConfig.getInstance().getClientCode();
        String edgeHost = TargetWorker.getEdgeHost();
        String requestHost = !TargetWorker.isNullOrEmpty(edgeHost) ? edgeHost : String.format(TARGET_API_URL_HOST_BASE, targetClientCode);
        return String.format(TARGET_PREFETCH_API_URL_BASE, requestHost, targetClientCode, TargetWorker.getSessionId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSessionId() {
        Object object = _sessionIdMutex;
        synchronized (object) {
            if (TargetWorker.isNullOrEmpty(_sessionId)) {
                try {
                    SharedPreferences preferences = StaticMethods.getSharedPreferences();
                    _sessionId = preferences.getString("ADBMOBILE_TARGET_SESSION_ID", null);
                }
                catch (StaticMethods.NullContextException ex) {
                    StaticMethods.logErrorFormat("Target - Error retrieving shared preferences - application context is null", new Object[0]);
                }
            }
            if (TargetWorker.isNullOrEmpty(_sessionId) || TargetWorker.isSessionExpired()) {
                _sessionId = UUID.randomUUID().toString();
                try {
                    SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                    editor.putString("ADBMOBILE_TARGET_SESSION_ID", _sessionId);
                    editor.commit();
                }
                catch (StaticMethods.NullContextException ex) {
                    StaticMethods.logErrorFormat("Target - Error storing session id in shared preferences - application context is null", new Object[0]);
                }
                TargetWorker.updateSessionIdTimestamp();
            }
            return _sessionId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isSessionExpired() {
        Object object = _sessionIdMutex;
        synchronized (object) {
            if (_sessionIdTimestampSeconds <= 0L) {
                try {
                    SharedPreferences preferences = StaticMethods.getSharedPreferences();
                    _sessionIdTimestampSeconds = preferences.getLong("ADBMOBILE_TARGET_LAST_TIMESTAMP", 0L);
                }
                catch (StaticMethods.NullContextException ex) {
                    StaticMethods.logErrorFormat("Target - Error retrieving shared preferences - application context is null", new Object[0]);
                }
            }
            long currentTimeSeconds = StaticMethods.getTimeSince1970();
            int sessionTimeout = MobileConfig.getInstance().getTargetSessionTimeout();
            return _sessionIdTimestampSeconds > 0L && currentTimeSeconds - _sessionIdTimestampSeconds > (long)sessionTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetSession() {
        Object object = _sessionIdMutex;
        synchronized (object) {
            _sessionId = null;
            _sessionIdTimestampSeconds = 0L;
            try {
                SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                editor.remove("ADBMOBILE_TARGET_SESSION_ID");
                editor.remove("ADBMOBILE_TARGET_LAST_TIMESTAMP");
                editor.commit();
            }
            catch (StaticMethods.NullContextException ex) {
                StaticMethods.logErrorFormat("Target - Error resetting session from shared preferences - application context is null", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateSessionIdTimestamp() {
        Object object = _sessionIdMutex;
        synchronized (object) {
            _sessionIdTimestampSeconds = StaticMethods.getTimeSince1970();
            try {
                SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                editor.putLong("ADBMOBILE_TARGET_LAST_TIMESTAMP", _sessionIdTimestampSeconds);
                editor.commit();
            }
            catch (StaticMethods.NullContextException e) {
                StaticMethods.logErrorFormat("Target - Error persisting session id timestamp in shared preferences - application context is null", new Object[0]);
            }
        }
    }

    private static void saveTargetResponseVariables(JSONObject response) {
        if (response == null) {
            return;
        }
        try {
            if (response.getJSONObject("id") == null) {
                TargetWorker.setTntId(null);
            } else {
                TargetWorker.setTntId(response.getJSONObject("id").getString(TARGET_API_JSON_TNT_ID));
            }
        }
        catch (JSONException ex) {
            TargetWorker.setTntId(null);
        }
        try {
            TargetWorker.setEdgeHost(response.getString(TARGET_API_JSON_EDGE_HOST));
        }
        catch (JSONException ex) {
            TargetWorker.setEdgeHost(null);
        }
    }

    private static String getErrorMessage(JSONObject jsonResponse) {
        if (jsonResponse == null) {
            return null;
        }
        try {
            return jsonResponse.getString(TARGET_API_JSON_ERROR_MESSAGE);
        }
        catch (JSONException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setTntIdFromOldCookieValues() {
        Object object = _checkOldCookiesMutex;
        synchronized (object) {
            if (_oldCookiesHaveBeenChecked) {
                return;
            }
            String oldPcid = TargetWorker.checkForOldCookieValue(COOKIE_NAME_PCID);
            if (oldPcid != null) {
                TargetWorker.setTntId(oldPcid);
            }
            _oldCookiesHaveBeenChecked = true;
        }
    }

    private static String checkForOldCookieValue(String cookieName) {
        if (cookieName == null || cookieName.length() == 0) {
            return null;
        }
        String returnCookieValue = null;
        try {
            SharedPreferences preferences = StaticMethods.getSharedPreferences();
            if (preferences.contains(cookieName + COOKIE_EXPIRES_KEY_SUFFIX)) {
                String prefsCookieValue;
                long cookieExpiryTime = preferences.getLong(cookieName + COOKIE_EXPIRES_KEY_SUFFIX, 0L);
                if (cookieExpiryTime > System.currentTimeMillis() && (prefsCookieValue = preferences.getString(cookieName + COOKIE_VALUE_KEY_SUFFIX, "")).length() > 0) {
                    returnCookieValue = prefsCookieValue;
                }
                SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                editor.remove(cookieName + COOKIE_VALUE_KEY_SUFFIX);
                editor.remove(cookieName + COOKIE_EXPIRES_KEY_SUFFIX);
                editor.commit();
            }
        }
        catch (StaticMethods.NullContextException ex) {
            StaticMethods.logErrorFormat("Target - Error retrieving shared preferences - application context is null", new Object[0]);
        }
        return returnCookieValue;
    }

    private static boolean tntIdValuesAreEqual(String oldId, String newId) {
        if (oldId == null && newId == null) {
            return true;
        }
        if (oldId == null || newId == null) {
            return false;
        }
        if (oldId.equals(newId)) {
            return true;
        }
        int dotIndexOfOldId = oldId.indexOf(46);
        String oldIdSubstring = dotIndexOfOldId == -1 ? oldId : oldId.substring(0, dotIndexOfOldId);
        int dotIndexOfNewId = newId.indexOf(46);
        String newIdSubstring = dotIndexOfNewId == -1 ? newId : newId.substring(0, dotIndexOfNewId);
        return oldIdSubstring.equals(newIdSubstring);
    }

    private static Map<String, Object> getProfileParametersLegacy(Map<String, Object> mboxParameters) {
        if (TargetWorker.isNullOrEmpty(mboxParameters)) {
            return null;
        }
        HashMap<String, Object> newProfileParams = new HashMap<String, Object>();
        HashMap<String, Object> mboxParametersCopy = new HashMap<String, Object>(mboxParameters);
        for (Map.Entry<String, Object> entry : mboxParametersCopy.entrySet()) {
            String trimmedKey;
            String cleanedKey;
            String key = entry.getKey();
            if (key == null || !(cleanedKey = (trimmedKey = key.trim()).toLowerCase()).startsWith(PROFILE_PARAMETER_PREFIX)) continue;
            int dotIndex = cleanedKey.indexOf(".");
            String newKeyName = trimmedKey.substring(dotIndex + 1);
            newProfileParams.put(newKeyName, entry.getValue());
            mboxParameters.remove(entry.getKey());
        }
        return newProfileParams;
    }

    private static Map<String, Object> getOrderParametersLegacy(Map<String, Object> mboxParameters) {
        if (TargetWorker.isNullOrEmpty(mboxParameters)) {
            return null;
        }
        HashMap<String, Object> newOrderParams = new HashMap<String, Object>();
        Object orderId = mboxParameters.get("orderId");
        Object orderTotal = mboxParameters.get("orderTotal");
        Object products = mboxParameters.get("purchasedProductIds");
        if (orderId != null && !orderId.toString().isEmpty()) {
            newOrderParams.put("id", orderId.toString());
            mboxParameters.remove("orderId");
        }
        if (orderTotal != null && !orderTotal.toString().isEmpty()) {
            newOrderParams.put("total", orderTotal);
            mboxParameters.remove("orderTotal");
        }
        if (products != null && !products.toString().isEmpty()) {
            newOrderParams.put("purchasedProductIds", products);
            mboxParameters.remove("purchasedProductIds");
        }
        return newOrderParams;
    }

    private static void getThirdPartyIDLegacy(Map<String, Object> mboxParameters) {
        if (mboxParameters != null && mboxParameters.containsKey("mbox3rdPartyId")) {
            Object newThirdPartyId = mboxParameters.get("mbox3rdPartyId");
            if (newThirdPartyId != null) {
                TargetWorker.setThirdPartyId(newThirdPartyId.toString());
            } else {
                TargetWorker.setThirdPartyId(null);
            }
            mboxParameters.remove("mbox3rdPartyId");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<String, Object> getInternalTargetParams() {
        BigDecimal ltv;
        HashMap<String, Object> internalParams = new HashMap<String, Object>();
        HashMap<String, Object> lifecycleData = Lifecycle.getContextData();
        if (!TargetWorker.isNullOrEmpty(lifecycleData)) {
            internalParams.putAll(lifecycleData);
        }
        if ((ltv = AnalyticsTrackLifetimeValueIncrease.getLifetimeValue()) != null) {
            TargetWorker.addPersistentParameter("a.ltv.amount", ltv.toString());
        }
        Object object = _persistentParametersMutex;
        synchronized (object) {
            if (!TargetWorker.isNullOrEmpty(_persistentParameters)) {
                internalParams.putAll(_persistentParameters);
            }
        }
        return internalParams;
    }

    private static void forwardAnalyticsForTargetPayload(JSONObject targetResponse) {
        if (targetResponse == null || targetResponse.length() <= 0) {
            return;
        }
        HashMap<String, Object> analyticsForTargetPayloadParametersTemp = null;
        try {
            JSONObject analyticsForTargetPayload = targetResponse.getJSONObject("clientSideAnalyticsLoggingPayload");
            analyticsForTargetPayloadParametersTemp = StaticMethods.mapFromJson(analyticsForTargetPayload);
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Target - A4T is not enabled for this location (%s)", ex.getLocalizedMessage());
        }
        if (TargetWorker.isNullOrEmpty(analyticsForTargetPayloadParametersTemp)) {
            return;
        }
        HashMap<String, Object> analyticsForTargetPayloadParameters = new HashMap<String, Object>(analyticsForTargetPayloadParametersTemp.size());
        for (Map.Entry entry : analyticsForTargetPayloadParametersTemp.entrySet()) {
            analyticsForTargetPayloadParameters.put("&&" + (String)entry.getKey(), entry.getValue());
        }
        AnalyticsTrackInternal.trackInternal(TARGET_API_A4T_ACTION_NAME, analyticsForTargetPayloadParameters);
        StaticMethods.logDebugFormat("Target - A4T is enabled, the payload was successfully forwarded to Analytics", new Object[0]);
    }

    private static boolean isNullOrEmpty(String param) {
        return param == null || param.isEmpty();
    }

    private static boolean isNullOrEmpty(Map param) {
        return param == null || param.isEmpty();
    }

    private static boolean isNullOrEmpty(List param) {
        return param == null || param.isEmpty();
    }

    private static class TargetClickNotification
    implements Runnable {
        private String mboxName;
        private Map<String, Object> mboxParameters;
        private Map<String, Object> productParameters;
        private Map<String, Object> orderParameters;
        private Map<String, Object> profileParameters;

        private TargetClickNotification(String mboxName, Map<String, Object> mboxParameters, Map<String, Object> orderParameters, Map<String, Object> productParameters, Map<String, Object> profileParameters) {
            this.mboxName = mboxName;
            this.mboxParameters = mboxParameters;
            this.orderParameters = orderParameters;
            this.productParameters = productParameters;
            this.profileParameters = profileParameters;
        }

        @Override
        public void run() {
            JSONObject requestPayload;
            String clickToken;
            JSONObject mboxJson;
            if (prefetchedMboxes.containsKey(this.mboxName)) {
                mboxJson = (JSONObject)prefetchedMboxes.get(this.mboxName);
            } else if (loadedMboxes.containsKey(this.mboxName)) {
                mboxJson = (JSONObject)loadedMboxes.get(this.mboxName);
            } else {
                StaticMethods.logWarningFormat("Target - couldn't send click notification for %s, the location should be pre-fetched/loaded before", this.mboxName);
                return;
            }
            String string = clickToken = mboxJson != null ? mboxJson.optString("clickToken") : null;
            if (TargetWorker.isNullOrEmpty(clickToken)) {
                StaticMethods.logWarningFormat("Target - couldn't send click notification for %s, the location doesn't have click metrics enabled", this.mboxName);
                return;
            }
            JSONObject clickNotificationJson = TargetJsonBuilder.getClickNotificationJsonObject(mboxJson, this.mboxParameters, this.orderParameters, this.productParameters, TargetWorker.getInternalTargetParams());
            notifications.add(clickNotificationJson);
            try {
                requestPayload = TargetJsonBuilder.getRequestPayload(null, null, this.profileParameters, notifications, TargetWorker.getInternalTargetParams());
            }
            catch (JSONException exception) {
                StaticMethods.logWarningFormat("Target - couldn't create the target click notification %s", exception.getLocalizedMessage());
                return;
            }
            String requestUrl = TargetWorker.getTargetRequestURL();
            String sessionId = TargetWorker.getSessionId();
            StaticMethods.logDebugFormat("Target - sending click notification to url \"%s\" with parameters: %s", requestUrl, requestPayload.toString());
            NetworkObject networkObject = RequestHandler.retrieveNetworkObject(requestUrl, "POST", null, requestPayload.toString(), MobileConfig.getInstance().getDefaultLocationTimeout(), TargetWorker.TARGET_API_CONTENT_TYPE, "Target", sessionId);
            JSONObject responseJson = TargetWorker.extractServerJsonResponse(networkObject, requestUrl);
            if (responseJson == null) {
                return;
            }
            TargetWorker.updateSessionIdTimestamp();
            notifications.clear();
            TargetWorker.saveTargetResponseVariables(responseJson);
            StaticMethods.logDebugFormat("Target - click notification successfully sent for mbox (%s) with url \"%s\" with parameters: %s", this.mboxName, requestUrl, requestPayload.toString());
        }
    }

    private static class TargetPrefetchRunner
    implements Runnable {
        private List<TargetPrefetchObject> targetPrefetchArray;
        private Map<String, Object> profileParameters;
        private Target.TargetCallback<Boolean> callback;

        private TargetPrefetchRunner(List<TargetPrefetchObject> targetPrefetchArray, Map<String, Object> profileParams, Target.TargetCallback<Boolean> callback) {
            this.targetPrefetchArray = targetPrefetchArray;
            this.profileParameters = profileParams;
            this.callback = callback;
        }

        @Override
        public void run() {
            JSONObject parametersJson;
            try {
                parametersJson = TargetJsonBuilder.getRequestPayload(this.targetPrefetchArray, null, this.profileParameters, notifications, TargetWorker.getInternalTargetParams());
            }
            catch (JSONException exception) {
                StaticMethods.logWarningFormat("Target - couldn't create the target prefetch request %s", exception.getLocalizedMessage());
                this.returnCallback(false);
                return;
            }
            String requestUrl = TargetWorker.getTargetRequestURL();
            String sessionId = TargetWorker.getSessionId();
            StaticMethods.logDebugFormat("Target - requesting content from url \"%s\" with session id: \"%s\" and parameters: %s", requestUrl, sessionId, parametersJson.toString());
            NetworkObject networkObject = RequestHandler.retrieveNetworkObject(requestUrl, "POST", null, parametersJson.toString(), MobileConfig.getInstance().getDefaultLocationTimeout(), TargetWorker.TARGET_API_CONTENT_TYPE, "Target", sessionId);
            JSONObject responseJson = TargetWorker.extractServerJsonResponse(networkObject, requestUrl);
            if (responseJson == null) {
                this.returnCallback(false);
                return;
            }
            try {
                StaticMethods.logDebugFormat("Target - prefetch response received %s", responseJson.toString());
                TargetWorker.updateSessionIdTimestamp();
                TargetWorker.saveTargetResponseVariables(responseJson);
                Map prefetchResponses = TargetWorker.extractPrefetchResponses(responseJson);
                if (TargetWorker.isNullOrEmpty(prefetchResponses)) {
                    this.returnCallback(false);
                    return;
                }
                notifications.clear();
                if (prefetchedMboxes != null) {
                    prefetchedMboxes.putAll(prefetchResponses);
                } else {
                    prefetchedMboxes = prefetchResponses;
                }
                TargetWorker.removeDuplicatedMboxesFromCaches();
                this.returnCallback(true);
            }
            catch (NullPointerException ex) {
                StaticMethods.logErrorFormat("Target - NullPointerException while trying to get content from the response (%s)", ex.getLocalizedMessage());
                this.returnCallback(false);
            }
            catch (JSONException ex) {
                StaticMethods.logErrorFormat("Target - JSONException while trying to get content from the response (%s)", ex.getLocalizedMessage());
                this.returnCallback(false);
            }
        }

        private void returnCallback(boolean successful) {
            if (this.callback != null) {
                this.callback.call(successful);
            }
        }
    }

    private static class TargetBatchRunner
    implements Runnable {
        private List<TargetRequestObject> batchRequests;
        private Map<String, Object> profileParameters;

        private TargetBatchRunner(List<TargetRequestObject> newBatchRequestArray, Map<String, Object> newProfileParameters) {
            this.batchRequests = newBatchRequestArray;
            this.profileParameters = newProfileParameters;
        }

        @Override
        public void run() {
            JSONObject requestPayload;
            TargetWorker.setTntIdFromOldCookieValues();
            Boolean inTargetPreviewMode = false;
            inTargetPreviewMode = !TargetWorker.isNullOrEmpty(TargetPreviewManager.getInstance().getPreviewParams());
            if (!inTargetPreviewMode.booleanValue()) {
                Iterator<TargetRequestObject> iterator = this.batchRequests.iterator();
                while (iterator.hasNext()) {
                    TargetRequestObject request = iterator.next();
                    if (prefetchedMboxes.get(request.getMboxName()) == null) continue;
                    TargetWorker.processMboxResponse(request, (JSONObject)prefetchedMboxes.get(request.getMboxName()));
                    JSONObject notification = TargetJsonBuilder.getNotificationsJsonObject((JSONObject)prefetchedMboxes.get(request.getMboxName()), request, TargetWorker.getInternalTargetParams());
                    if (notification != null) {
                        notifications.add(notification);
                    }
                    iterator.remove();
                }
            }
            if (this.batchRequests.isEmpty() && TargetWorker.isNullOrEmpty(notifications)) {
                return;
            }
            try {
                requestPayload = TargetJsonBuilder.getRequestPayload(null, this.batchRequests, this.profileParameters, notifications, TargetWorker.getInternalTargetParams());
            }
            catch (JSONException exception) {
                StaticMethods.logWarningFormat("Target - couldn't create the target load request %s", exception.getLocalizedMessage());
                TargetWorker.replyWithDefaultContent(this.batchRequests);
                return;
            }
            String requestUrl = TargetWorker.getTargetRequestURL();
            String sessionId = TargetWorker.getSessionId();
            StaticMethods.logDebugFormat("Target - requesting content from url \"%s\" with session id: \"%s\" and parameters: %s", requestUrl, sessionId, requestPayload.toString());
            NetworkObject networkObject = RequestHandler.retrieveNetworkObject(requestUrl, "POST", null, requestPayload.toString(), MobileConfig.getInstance().getDefaultLocationTimeout(), TargetWorker.TARGET_API_CONTENT_TYPE, "Target", sessionId);
            JSONObject responseJson = TargetWorker.extractServerJsonResponse(networkObject, requestUrl);
            if (responseJson == null) {
                TargetWorker.replyWithDefaultContent(this.batchRequests);
                return;
            }
            notifications.clear();
            try {
                TargetWorker.updateSessionIdTimestamp();
                TargetWorker.saveTargetResponseVariables(responseJson);
                Map mBoxResponses = TargetWorker.extractMBoxResponses(responseJson);
                TargetWorker.processMboxResponse(this.batchRequests, mBoxResponses);
                TargetWorker.cacheLoadedMboxResponses(mBoxResponses);
            }
            catch (NullPointerException ex) {
                StaticMethods.logErrorFormat("Target - NullPointerException while trying to get content (%s)", ex.getLocalizedMessage());
                TargetWorker.replyWithDefaultContent(this.batchRequests);
            }
            catch (JSONException ex) {
                StaticMethods.logErrorFormat("Target - JSONException while trying to get content from the response (%s)", ex.getLocalizedMessage());
                TargetWorker.replyWithDefaultContent(this.batchRequests);
            }
        }
    }
}

