/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import com.adobe.mobile.Analytics;
import com.adobe.mobile.AudienceManager;
import com.adobe.mobile.AudienceManagerWorker;
import com.adobe.mobile.Config;
import com.adobe.mobile.MobileConfig;
import com.adobe.mobile.StaticMethods;
import com.adobe.mobile.Target;
import com.adobe.mobile.Visitor;
import com.adobe.mobile.VisitorID;
import com.adobe.mobile.VisitorIDService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

class MobileIdentities {
    private static final String JSON_KEY_COMPANYCONTEXTS = "companyContexts";
    private static final String JSON_KEY_USERS = "users";
    private static final String JSON_KEY_USERIDS = "userIDs";
    private static final String JSON_KEY_NAMESPACE = "namespace";
    private static final String JSON_KEY_VALUE = "value";
    private static final String JSON_KEY_TYPE = "type";
    private static final String JSON_KEY_ANALYTICS_RSIDS = "rsids";
    private static final String JSON_VALUE_NAMESPACE_COMPANYCONTEXTS = "imsOrgID";
    private static final String JSON_VALUE_NAMESPACE_ANALYTICS_AID = "AVID";
    private static final String JSON_VALUE_NAMESPACE_AUDIENCE_UUID = "0";
    private static final String JSON_VALUE_NAMESPACE_MCID = "4";
    private static final String JSON_VALUE_NAMESPACE_TARGET_THIRDPARTYID = "3rdpartyid";
    private static final String JSON_VALUE_NAMESPACE_TARGET_TNTID = "tntid";
    private static final String JSON_VALUE_NAMESPACE_USERIDENTIFIER = "vid";
    private static final String JSON_VALUE_TYPE_ANALYTICS = "analytics";
    private static final String JSON_VALUE_TYPE_INTEGRATIONCODE = "integrationCode";
    private static final String JSON_VALUE_TYPE_TARGET = "target";
    private static final String JSON_VALUE_TYPE_NAMESPACEID = "namespaceId";

    private MobileIdentities() {
    }

    private static Map<String, Object> createUserIdMap(String namespace, String value, String type) {
        HashMap<String, Object> userIdMap = new HashMap<String, Object>();
        userIdMap.put(JSON_KEY_NAMESPACE, namespace);
        userIdMap.put(JSON_KEY_VALUE, value);
        userIdMap.put(JSON_KEY_TYPE, type);
        return userIdMap;
    }

    static String getAllIdentifiers() {
        HashMap<String, Object> identities = new HashMap<String, Object>();
        List<Object> companyContexts = MobileIdentities.getCompanyContexts();
        if (companyContexts != null && !companyContexts.isEmpty()) {
            identities.put(JSON_KEY_COMPANYCONTEXTS, companyContexts);
        }
        ArrayList<Object> userIds = new ArrayList<Object>();
        userIds.addAll(MobileIdentities.getOsIdentifiers());
        userIds.addAll(MobileIdentities.getAnalyticsIdentifiers());
        userIds.addAll(MobileIdentities.getTargetIdentifiers());
        userIds.addAll(MobileIdentities.getAudienceIdentifiers());
        userIds.addAll(MobileIdentities.getVisitorIdentifiers());
        if (!userIds.isEmpty()) {
            ArrayList users = new ArrayList();
            HashMap<String, ArrayList<Object>> usersMap = new HashMap<String, ArrayList<Object>>();
            usersMap.put(JSON_KEY_USERIDS, userIds);
            users.add(usersMap);
            identities.put(JSON_KEY_USERS, users);
        }
        return StaticMethods.mapToJson(identities).toString();
    }

    private static List<Object> getAudienceIdentifiers() {
        String audienceUuid;
        ArrayList<Object> audienceIds = new ArrayList<Object>();
        String audienceDpuuid = AudienceManager.getDpuuid();
        if (audienceDpuuid != null && !audienceDpuuid.isEmpty()) {
            String audienceDpid = AudienceManager.getDpid();
            audienceIds.add(MobileIdentities.createUserIdMap(audienceDpid, audienceDpuuid, JSON_VALUE_TYPE_NAMESPACEID));
        }
        if ((audienceUuid = AudienceManager.getUuid()) != null && !audienceUuid.isEmpty()) {
            audienceIds.add(MobileIdentities.createUserIdMap(JSON_VALUE_NAMESPACE_AUDIENCE_UUID, audienceUuid, JSON_VALUE_TYPE_NAMESPACEID));
        }
        return audienceIds;
    }

    private static List<Object> getTargetIdentifiers() {
        String thirdPartyId;
        ArrayList<Object> targetIds = new ArrayList<Object>();
        String tntId = Target.getPcID();
        if (tntId != null && !tntId.isEmpty()) {
            targetIds.add(MobileIdentities.createUserIdMap(JSON_VALUE_NAMESPACE_TARGET_TNTID, tntId, JSON_VALUE_TYPE_TARGET));
        }
        if ((thirdPartyId = Target.getThirdPartyID()) != null && !thirdPartyId.isEmpty()) {
            targetIds.add(MobileIdentities.createUserIdMap(JSON_VALUE_NAMESPACE_TARGET_THIRDPARTYID, thirdPartyId, JSON_VALUE_TYPE_TARGET));
        }
        return targetIds;
    }

    private static List<Object> getAnalyticsIdentifiers() {
        String aid;
        ArrayList<Object> analyticsIds = new ArrayList<Object>();
        String userIdentifier = Config.getUserIdentifier();
        if (userIdentifier != null && !userIdentifier.isEmpty()) {
            Map<String, Object> customVisitorIdMap = MobileIdentities.createUserIdMap(JSON_VALUE_NAMESPACE_USERIDENTIFIER, userIdentifier, JSON_VALUE_TYPE_ANALYTICS);
            String commaSeparatedRsids = MobileConfig.getInstance().getReportSuiteIds();
            if (commaSeparatedRsids != null && !commaSeparatedRsids.isEmpty()) {
                customVisitorIdMap.put(JSON_KEY_ANALYTICS_RSIDS, Arrays.asList(commaSeparatedRsids.split(",")));
            }
            analyticsIds.add(customVisitorIdMap);
        }
        if ((aid = Analytics.getTrackingIdentifier()) != null && !aid.isEmpty()) {
            analyticsIds.add(MobileIdentities.createUserIdMap(JSON_VALUE_NAMESPACE_ANALYTICS_AID, Analytics.getTrackingIdentifier(), JSON_VALUE_TYPE_INTEGRATIONCODE));
        }
        return analyticsIds;
    }

    private static List<Object> getOsIdentifiers() {
        FutureTask<List<Object>> osIdsTask = new FutureTask<List<Object>>(new Callable<List<Object>>(){

            @Override
            public List<Object> call() throws Exception {
                String advertisingId;
                ArrayList<Object> osIdsList = new ArrayList<Object>();
                String pushId = StaticMethods.getPushIdentifier();
                if (pushId != null && !pushId.isEmpty()) {
                    osIdsList.add(MobileIdentities.createUserIdMap("20919", pushId, MobileIdentities.JSON_VALUE_TYPE_INTEGRATIONCODE));
                }
                if ((advertisingId = StaticMethods.getAdvertisingIdentifier()) != null && !advertisingId.isEmpty()) {
                    osIdsList.add(MobileIdentities.createUserIdMap("DSID_20914", advertisingId, MobileIdentities.JSON_VALUE_TYPE_INTEGRATIONCODE));
                }
                return osIdsList;
            }
        });
        StaticMethods.getAnalyticsExecutor().execute(osIdsTask);
        try {
            return osIdsTask.get();
        }
        catch (Exception e) {
            StaticMethods.logDebugFormat("Identities - failed to get OS identifiers json (%s)", e.getMessage());
            return new ArrayList<Object>();
        }
    }

    private static List<Object> getVisitorIdentifiers() {
        List<VisitorID> customVisitorIDs;
        ArrayList<Object> visitorIds = new ArrayList<Object>();
        String marketingCloudId = Visitor.getMarketingCloudId();
        if (marketingCloudId != null && !marketingCloudId.isEmpty()) {
            visitorIds.add(MobileIdentities.createUserIdMap(JSON_VALUE_NAMESPACE_MCID, marketingCloudId, JSON_VALUE_TYPE_NAMESPACEID));
        }
        if ((customVisitorIDs = Visitor.getIdentifiers()) != null && !customVisitorIDs.isEmpty()) {
            for (VisitorID visitorID : customVisitorIDs) {
                if (visitorID.id == null || visitorID.id.isEmpty()) continue;
                visitorIds.add(MobileIdentities.createUserIdMap(visitorID.idType, visitorID.id, JSON_VALUE_TYPE_INTEGRATIONCODE));
            }
        }
        return visitorIds;
    }

    private static List<Object> getCompanyContexts() {
        String marketingCloudOrgId = MobileConfig.getInstance().getMarketingCloudOrganizationId();
        if (marketingCloudOrgId != null && !marketingCloudOrgId.isEmpty()) {
            HashMap<String, String> companyContextMap = new HashMap<String, String>();
            companyContextMap.put(JSON_KEY_NAMESPACE, JSON_VALUE_NAMESPACE_COMPANYCONTEXTS);
            companyContextMap.put(JSON_KEY_VALUE, marketingCloudOrgId);
            ArrayList<Object> companyContextsList = new ArrayList<Object>();
            companyContextsList.add(companyContextMap);
            return companyContextsList;
        }
        return null;
    }

    static void resetAllIdentifiers() {
        StaticMethods.logDebugFormat("Config - Privacy status set to opt out, purging all Adobe SDK identities from device.", new Object[0]);
        AudienceManagerWorker.handleOptOut();
        StaticMethods.getAudienceExecutor().execute(new Runnable(){

            @Override
            public void run() {
                MobileIdentities.resetAnalyticsIdentifiers();
                AudienceManagerWorker.purgeDpidAndDpuuid();
                AudienceManager.reset();
                MobileIdentities.resetOsIdentifiers();
                Target.clearCookies();
                VisitorIDService.sharedInstance().purgeIdentities();
            }
        });
    }

    private static void resetAnalyticsIdentifiers() {
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                StaticMethods.purgeAID();
                StaticMethods.purgeVisitorID();
            }
        });
    }

    private static void resetOsIdentifiers() {
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                StaticMethods.purgeAdvertisingIdentifier();
                StaticMethods.purgePushIdentifier();
            }
        });
    }
}

