/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.util.Base64;
import com.adobe.mobile.Message;
import com.adobe.mobile.StaticMethods;
import com.adobe.mobile.ThirdPartyQueue;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

class MessageTemplateCallback
extends Message {
    protected String templateUrl;
    protected String templateBody;
    protected String contentType;
    protected int timeout;
    private static final String ADB_TEMPLATE_CALLBACK_URL = "templateurl";
    private static final String ADB_TEMPLATE_CALLBACK_BODY = "templatebody";
    private static final String ADB_TEMPLATE_CALLBACK_CONTENT_TYPE = "contenttype";
    private static final String ADB_TEMPLATE_CALLBACK_TIMEOUT = "timeout";
    private static final int ADB_TEMPLATE_TIMEOUT_DEFAULT = 2;
    private static final String ADB_TEMPLATE_CALLBACK_TOKEN_ALL_URL_ENCODED = "%all_url%";
    private static final String ADB_TEMPLATE_CALLBACK_TOKEN_ALL_JSON_ENCODED = "%all_json%";
    private static final String ADB_TEMPLATE_CALLBACK_LOG_PREFIX = "Postbacks";

    MessageTemplateCallback() {
    }

    @Override
    protected boolean initWithPayloadObject(JSONObject dictionary) {
        JSONObject jsonPayload;
        if (dictionary == null || dictionary.length() <= 0) {
            return false;
        }
        if (!super.initWithPayloadObject(dictionary)) {
            return false;
        }
        String logPrefix = this.logPrefix();
        try {
            jsonPayload = dictionary.getJSONObject("payload");
            if (jsonPayload.length() <= 0) {
                StaticMethods.logDebugFormat("%s - Unable to create data callback %s, \"payload\" is empty", logPrefix, this.messageId);
                return false;
            }
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("%s - Unable to create create data callback %s, \"payload\" is required", logPrefix, this.messageId);
            return false;
        }
        try {
            this.templateUrl = jsonPayload.getString(ADB_TEMPLATE_CALLBACK_URL);
            if (this.templateUrl.length() <= 0) {
                StaticMethods.logDebugFormat("%s - Unable to create data callback %s, \"templateurl\" is empty", logPrefix, this.messageId);
                return false;
            }
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("%s - Unable to create data callback %s, \"templateurl\" is required", logPrefix, this.messageId);
            return false;
        }
        try {
            this.timeout = jsonPayload.getInt(ADB_TEMPLATE_CALLBACK_TIMEOUT);
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("%s - Tried to read \"timeout\" for data callback, but found none.  Using default value of two (2) seconds", logPrefix);
            this.timeout = 2;
        }
        try {
            String decodedBody;
            byte[] decodedBytes;
            String tempBody = jsonPayload.getString(ADB_TEMPLATE_CALLBACK_BODY);
            if (tempBody != null && tempBody.length() > 0 && (decodedBytes = Base64.decode((String)tempBody, (int)0)) != null && (decodedBody = new String(decodedBytes, "UTF-8")).length() > 0) {
                this.templateBody = decodedBody;
            }
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("%s - Tried to read \"templatebody\" for data callback, but found none.  This is not a required field", logPrefix);
        }
        catch (UnsupportedEncodingException ex) {
            StaticMethods.logDebugFormat("%s - Failed to decode \"templatebody\" for data callback (%s).  This is not a required field", logPrefix, ex.getLocalizedMessage());
        }
        catch (IllegalArgumentException ex) {
            StaticMethods.logDebugFormat("%s - Failed to decode \"templatebody\" for data callback (%s).  This is not a required field", logPrefix, ex.getLocalizedMessage());
        }
        if (this.templateBody != null && this.templateBody.length() > 0) {
            try {
                this.contentType = jsonPayload.getString(ADB_TEMPLATE_CALLBACK_CONTENT_TYPE);
            }
            catch (JSONException ex) {
                StaticMethods.logDebugFormat("%s - Tried to read \"contenttype\" for data callback, but found none.  This is not a required field", logPrefix);
            }
        }
        return true;
    }

    @Override
    protected void show() {
        String expandedUrl = this.getExpandedUrl();
        String expandedBody = this.getExpandedBody();
        String logPrefix = this.logPrefix();
        StaticMethods.logDebugFormat("%s - Request Queued (url:%s body:%s contentType:%s)", logPrefix, expandedUrl, expandedBody, this.contentType);
        ThirdPartyQueue currQueue = this.getQueue();
        currQueue.queue(expandedUrl, expandedBody, this.contentType, StaticMethods.getTimeSince1970(), this.timeout);
    }

    protected String getExpandedUrl() {
        String expandedUrl = null;
        if (this.templateUrl != null && this.templateUrl.length() > 0) {
            ArrayList<String> nonEncodedParamsList = new ArrayList<String>();
            nonEncodedParamsList.add("{%all_url%}");
            HashMap<String, String> urlExpansions = this.buildExpansionsForTokens(this.findTokensForExpansion(this.templateUrl), true);
            HashMap<String, String> nonEncodedURLExpansions = this.buildExpansionsForTokens(nonEncodedParamsList, false);
            urlExpansions.putAll(nonEncodedURLExpansions);
            expandedUrl = StaticMethods.expandTokens(this.templateUrl, urlExpansions);
        }
        return expandedUrl;
    }

    private String getExpandedBody() {
        String expandedBody = null;
        if (this.templateBody != null && this.templateBody.length() > 0) {
            boolean contentTypeIsJson = this.contentType == null ? false : this.contentType.toLowerCase().contains("application/json");
            HashMap<String, String> bodyExpansions = this.buildExpansionsForTokens(this.findTokensForExpansion(this.templateBody), !contentTypeIsJson);
            ArrayList<String> nonEncodedParamsList = new ArrayList<String>();
            nonEncodedParamsList.add("{%all_url%}");
            nonEncodedParamsList.add("{%all_json%}");
            HashMap<String, String> nonEncodedURLExpansions = this.buildExpansionsForTokens(nonEncodedParamsList, false);
            bodyExpansions.putAll(nonEncodedURLExpansions);
            expandedBody = StaticMethods.expandTokens(this.templateBody, bodyExpansions);
        }
        return expandedBody;
    }

    protected ThirdPartyQueue getQueue() {
        return ThirdPartyQueue.sharedInstance();
    }

    protected String logPrefix() {
        return ADB_TEMPLATE_CALLBACK_LOG_PREFIX;
    }
}

