/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import com.adobe.mobile.Messages;
import com.adobe.mobile.StaticMethods;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.SecureRandom;

public class MessageNotificationHandler
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        Intent resumeIntent;
        Context sharedContext;
        Activity currentActivity;
        String userInfoStringJSON;
        String deeplink;
        String messageID;
        int otherRequestCode;
        int requestCode;
        String message;
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            StaticMethods.logDebugFormat("Messages - unable to load extras from local notification intent", new Object[0]);
            return;
        }
        try {
            message = bundle.getString("alarm_message");
            requestCode = bundle.getInt("adbMessageCode");
            otherRequestCode = bundle.getInt("requestCode");
            messageID = bundle.getString("adb_m_l_id");
            deeplink = bundle.getString("adb_deeplink");
            userInfoStringJSON = bundle.getString("userData");
        }
        catch (Exception ex) {
            StaticMethods.logDebugFormat("Messages - unable to load message from local notification (%s)", ex.getMessage());
            return;
        }
        if (requestCode != Messages.MESSAGE_LOCAL_IDENTIFIER) {
            return;
        }
        if (message == null) {
            StaticMethods.logDebugFormat("Messages - local notification message was empty ", new Object[0]);
            return;
        }
        try {
            currentActivity = StaticMethods.getCurrentActivity();
        }
        catch (StaticMethods.NullActivityException ex) {
            StaticMethods.logErrorFormat(ex.getMessage(), new Object[0]);
            return;
        }
        try {
            sharedContext = StaticMethods.getSharedContext();
        }
        catch (StaticMethods.NullContextException ex) {
            StaticMethods.logErrorFormat(ex.getMessage(), new Object[0]);
            return;
        }
        Activity notificationActivity = null;
        try {
            notificationActivity = StaticMethods.getCurrentActivity();
        }
        catch (StaticMethods.NullActivityException ex) {
            StaticMethods.logErrorFormat("Messages - unable to find activity for your notification, using default", new Object[0]);
        }
        if (deeplink != null && !deeplink.isEmpty()) {
            resumeIntent = new Intent("android.intent.action.VIEW");
            resumeIntent.setData(Uri.parse((String)deeplink));
        } else {
            resumeIntent = notificationActivity != null ? notificationActivity.getIntent() : intent;
        }
        resumeIntent.setFlags(0x24000000);
        resumeIntent.putExtra("adb_m_l_id", messageID);
        resumeIntent.putExtra("userData", userInfoStringJSON);
        int buildVersion = Build.VERSION.SDK_INT;
        try {
            Object notification;
            PendingIntent sender = PendingIntent.getActivity((Context)sharedContext, (int)otherRequestCode, (Intent)resumeIntent, (int)0x8000000);
            if (sender == null) {
                StaticMethods.logDebugFormat("Messages - could not retrieve sender from broadcast, unable to post notification", new Object[0]);
                return;
            }
            if (buildVersion >= 11) {
                ClassLoader classLoader = BroadcastReceiver.class.getClassLoader();
                Class<?> notificationBuilderClass = classLoader.loadClass("android.app.Notification$Builder");
                Constructor<?> notificationConstructor = notificationBuilderClass.getConstructor(Context.class);
                notificationConstructor.setAccessible(true);
                Object notificationBuilder = notificationConstructor.newInstance(StaticMethods.getSharedContext());
                Method setSmallIcon = notificationBuilderClass.getDeclaredMethod("setSmallIcon", Integer.TYPE);
                setSmallIcon.invoke(notificationBuilder, this.getSmallIcon());
                Bitmap largeIcon = this.getLargeIcon();
                if (largeIcon != null) {
                    Method setLargeIcon = notificationBuilderClass.getDeclaredMethod("setLargeIcon", Bitmap.class);
                    setLargeIcon.invoke(notificationBuilder, largeIcon);
                }
                Method setContentTitle = notificationBuilderClass.getDeclaredMethod("setContentTitle", CharSequence.class);
                setContentTitle.invoke(notificationBuilder, this.getAppName());
                Method setContentText = notificationBuilderClass.getDeclaredMethod("setContentText", CharSequence.class);
                setContentText.invoke(notificationBuilder, message);
                Method setContentIntent = notificationBuilderClass.getDeclaredMethod("setContentIntent", PendingIntent.class);
                setContentIntent.invoke(notificationBuilder, sender);
                Method setAutoCancel = notificationBuilderClass.getDeclaredMethod("setAutoCancel", Boolean.TYPE);
                setAutoCancel.invoke(notificationBuilder, true);
                if (buildVersion >= 16) {
                    Method build = notificationBuilderClass.getDeclaredMethod("build", new Class[0]);
                    notification = build.invoke(notificationBuilder, new Object[0]);
                } else {
                    Method getNotification = notificationBuilderClass.getDeclaredMethod("getNotification", new Class[0]);
                    notification = getNotification.invoke(notificationBuilder, new Object[0]);
                }
                if (notification == null) {
                    return;
                }
            } else {
                Notification tempNotification = new Notification();
                Method __setLatestEventInfo = Notification.class.getDeclaredMethod("setLatestEventInfo", Context.class, String.class, String.class, PendingIntent.class);
                __setLatestEventInfo.invoke((Object)tempNotification, sharedContext, this.getAppName(), message, sender);
                Field __icon = Notification.class.getField("icon");
                __icon.set(tempNotification, this.getSmallIcon());
                tempNotification.flags = 16;
                notification = tempNotification;
            }
            NotificationManager notificationManager = (NotificationManager)currentActivity.getSystemService("notification");
            notificationManager.notify(new SecureRandom().nextInt(), notification);
        }
        catch (ClassNotFoundException ex) {
            StaticMethods.logErrorFormat("Messages - error posting notification, class not found (%s)", ex.getMessage());
        }
        catch (NoSuchMethodException ex) {
            StaticMethods.logErrorFormat("Messages - error posting notification, method not found (%s)", ex.getMessage());
        }
        catch (StaticMethods.NullContextException ex) {
            StaticMethods.logErrorFormat("Messages - error posting notification (%s)", ex.getMessage());
        }
        catch (Exception ex) {
            StaticMethods.logErrorFormat("Messages - unexpected error posting notification (%s)", ex.getMessage());
        }
    }

    private String getAppName() {
        String appName = "";
        try {
            ApplicationInfo applicationInfo;
            PackageManager packageManager = StaticMethods.getSharedContext().getPackageManager();
            if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(StaticMethods.getSharedContext().getPackageName(), 0)) != null) {
                appName = packageManager.getApplicationLabel(applicationInfo) != null ? (String)packageManager.getApplicationLabel(applicationInfo) : "";
            }
        }
        catch (PackageManager.NameNotFoundException ex) {
            StaticMethods.logDebugFormat("Messages - unable to retrieve app name for local notification (%s)", ex.getMessage());
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logDebugFormat("Messages - unable to get app name (%s)", e.getMessage());
        }
        return appName;
    }

    private int getSmallIcon() {
        return Messages.getSmallIconResourceId() != -1 ? Messages.getSmallIconResourceId() : 17301651;
    }

    private Bitmap getLargeIcon() throws ClassNotFoundException, NoSuchMethodException, StaticMethods.NullContextException, IllegalAccessException, InvocationTargetException {
        Drawable iconDrawable = null;
        int largeIconResourceId = Messages.getLargeIconResourceId();
        if (largeIconResourceId != -1) {
            Context ctx = StaticMethods.getSharedContext();
            if (Build.VERSION.SDK_INT > 20) {
                Method __getDrawable = Resources.class.getDeclaredMethod("getDrawable", Integer.TYPE, Resources.Theme.class);
                iconDrawable = (Drawable)__getDrawable.invoke((Object)ctx.getResources(), largeIconResourceId, ctx.getTheme());
            } else {
                Method __getDrawable = Resources.class.getDeclaredMethod("getDrawable", Integer.TYPE);
                iconDrawable = (Drawable)__getDrawable.invoke((Object)ctx.getResources(), largeIconResourceId);
            }
        } else {
            PackageManager packageManager;
            ApplicationInfo applicationInfo = StaticMethods.getSharedContext().getApplicationInfo();
            if (applicationInfo != null && (packageManager = StaticMethods.getSharedContext().getPackageManager()) != null) {
                iconDrawable = packageManager.getApplicationIcon(applicationInfo);
            }
        }
        Bitmap icon = null;
        if (iconDrawable != null) {
            icon = iconDrawable instanceof BitmapDrawable ? ((BitmapDrawable)iconDrawable).getBitmap() : this.getBitmapFromDrawable(iconDrawable);
        }
        return icon;
    }

    private Bitmap getBitmapFromDrawable(Drawable drawable2) {
        Bitmap bmp = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bmp);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bmp;
    }
}

