/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import com.adobe.mobile.AudienceManagerWorker;
import com.adobe.mobile.StaticMethods;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public final class AudienceManager {
    public static HashMap<String, Object> getVisitorProfile() {
        return AudienceManagerWorker.GetVisitorProfile();
    }

    public static String getDpuuid() {
        return AudienceManagerWorker.GetDpuuid();
    }

    public static String getDpid() {
        return AudienceManagerWorker.GetDpid();
    }

    public static String getUuid() {
        FutureTask<String> f = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return AudienceManagerWorker.GetUUID();
            }
        });
        StaticMethods.getAudienceExecutor().execute(f);
        try {
            return f.get();
        }
        catch (Exception e) {
            StaticMethods.logErrorFormat("Audience Manager - Unable to get Uuid (%s)", e.getMessage());
            return "";
        }
    }

    public static void setDpidAndDpuuid(String dpid, String dpuuid) {
        AudienceManagerWorker.SetDpidAndDpuuid(dpid, dpuuid);
    }

    public static void signalWithData(Map<String, Object> data, AudienceManagerCallback<Map<String, Object>> callback) {
        if (StaticMethods.isWearableApp()) {
            StaticMethods.logWarningFormat("Audience Manager - Method signalWithData is not available for Wearable", new Object[0]);
            return;
        }
        AudienceManagerWorker.SubmitSignal(data, callback);
    }

    public static void reset() {
        AudienceManagerWorker.Reset();
    }

    public static interface AudienceManagerCallback<T> {
        public void call(T var1);
    }
}

