/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.content.Context;
import android.content.Intent;
import android.location.Location;
import com.adobe.mobile.AnalyticsTrackAction;
import com.adobe.mobile.AnalyticsTrackBeacon;
import com.adobe.mobile.AnalyticsTrackLifetimeValueIncrease;
import com.adobe.mobile.AnalyticsTrackLocation;
import com.adobe.mobile.AnalyticsTrackState;
import com.adobe.mobile.AnalyticsTrackTimedAction;
import com.adobe.mobile.AnalyticsWorker;
import com.adobe.mobile.ReferrerHandler;
import com.adobe.mobile.StaticMethods;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public final class Analytics {
    private static final String NO_ANALYTICS_MESSAGE = "Analytics - ADBMobile is not configured correctly to use Analytics.";

    public static void trackState(final String state, Map<String, Object> contextData) {
        final HashMap<String, Object> cdata = contextData != null ? new HashMap<String, Object>(contextData) : null;
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                AnalyticsTrackState.trackState(state, cdata);
            }
        });
    }

    public static void trackAction(final String action, Map<String, Object> contextData) {
        final HashMap<String, Object> cdata = contextData != null ? new HashMap<String, Object>(contextData) : null;
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                AnalyticsTrackAction.trackAction(action, cdata);
            }
        });
    }

    public static void trackLocation(final Location location, Map<String, Object> contextData) {
        final HashMap<String, Object> cdata = contextData != null ? new HashMap<String, Object>(contextData) : null;
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                AnalyticsTrackLocation.trackLocation(location, cdata);
            }
        });
    }

    public static void trackBeacon(final String uuid, final String major, final String minor, final BEACON_PROXIMITY proximity, Map<String, Object> contextData) {
        final HashMap<String, Object> cdata = contextData != null ? new HashMap<String, Object>(contextData) : null;
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                AnalyticsTrackBeacon.trackBeacon(uuid, major, minor, proximity, cdata);
            }
        });
    }

    public static void clearBeacon() {
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                AnalyticsTrackBeacon.clearBeacon();
            }
        });
    }

    public static void trackLifetimeValueIncrease(final BigDecimal amount, final HashMap<String, Object> contextData) {
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                AnalyticsTrackLifetimeValueIncrease.trackLifetimeValueIncrease(amount, contextData);
            }
        });
    }

    public static void trackTimedActionStart(final String action, Map<String, Object> contextData) {
        final HashMap<String, Object> cdata = contextData != null ? new HashMap<String, Object>(contextData) : null;
        StaticMethods.getTimedActionsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                AnalyticsTrackTimedAction.sharedInstance().trackTimedActionStart(action, cdata);
            }
        });
    }

    public static void trackTimedActionUpdate(final String action, Map<String, Object> contextData) {
        final HashMap<String, Object> cdata = contextData != null ? new HashMap<String, Object>(contextData) : null;
        StaticMethods.getTimedActionsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                AnalyticsTrackTimedAction.sharedInstance().trackTimedActionUpdate(action, cdata);
            }
        });
    }

    public static void trackTimedActionEnd(final String action, final TimedActionBlock<Boolean> logic) {
        StaticMethods.getTimedActionsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                AnalyticsTrackTimedAction.sharedInstance().trackTimedActionEnd(action, logic);
            }
        });
    }

    public static boolean trackingTimedActionExists(String action) {
        return AnalyticsTrackTimedAction.sharedInstance().trackTimedActionExists(action);
    }

    public static void processReferrer(Context context, final Intent intent) {
        StaticMethods.setSharedContext(context);
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                ReferrerHandler.processIntent(intent);
            }
        });
    }

    public static void processGooglePlayInstallReferrerUrl(final String referrerUrl) {
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                ReferrerHandler.processPlayInstallReferrerUrl(referrerUrl);
            }
        });
    }

    public static String getTrackingIdentifier() {
        FutureTask<String> f = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return StaticMethods.getAID();
            }
        });
        StaticMethods.getAnalyticsExecutor().execute(f);
        try {
            return f.get();
        }
        catch (Exception e) {
            StaticMethods.logErrorFormat("Analytics - Unable to get TrackingIdentifier (%s)", e.getMessage());
            return null;
        }
    }

    public static long getQueueSize() {
        FutureTask<Long> f = new FutureTask<Long>(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return AnalyticsWorker.sharedInstance().getTrackingQueueSize();
            }
        });
        StaticMethods.getAnalyticsExecutor().execute(f);
        try {
            return f.get();
        }
        catch (Exception e) {
            StaticMethods.logErrorFormat("Analytics - Unable to get QueueSize (%s)", e.getMessage());
            return 0L;
        }
    }

    public static void clearQueue() {
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                AnalyticsWorker.sharedInstance().clearTrackingQueue();
            }
        });
    }

    public static void sendQueuedHits() {
        StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                AnalyticsWorker.sharedInstance().forceKick();
            }
        });
    }

    public static interface TimedActionBlock<Boolean> {
        public Boolean call(long var1, long var3, Map<String, Object> var5);
    }

    public static enum BEACON_PROXIMITY {
        PROXIMITY_IMMEDIATE(1),
        PROXIMITY_NEAR(2),
        PROXIMITY_FAR(3),
        PROXIMITY_UNKNOWN(0);

        private final int value;

        private BEACON_PROXIMITY(int value) {
            this.value = value;
        }

        protected int getValue() {
            return this.value;
        }

        public String toString() {
            switch (this) {
                case PROXIMITY_IMMEDIATE: {
                    return "1";
                }
                case PROXIMITY_NEAR: {
                    return "2";
                }
                case PROXIMITY_FAR: {
                    return "3";
                }
            }
            return "0";
        }
    }
}

