/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.analytics.adobeheartbeat;

import android.content.Context;
import com.adobe.mobile.AudienceManager;
import com.adobe.primetime.va.Version;
import com.adobe.primetime.va.simple.MediaHeartbeat;
import com.adobe.primetime.va.simple.MediaHeartbeatConfig;
import com.adobe.primetime.va.simple.MediaObject;
import com.akamai.amp.ads.AdsCount;
import com.akamai.amp.ads.AdsInfo;
import com.akamai.amp.analytics.AnalyticsTracker;
import com.akamai.amp.analytics.AnalyticsTrackerData;
import com.akamai.amp.analytics.adobeheartbeat.AdobeHeartbeat;
import com.akamai.amp.analytics.adobeheartbeat.AmpAdobeHeartbeatAnalyticsTracker;
import com.akamai.amp.config.Config;
import com.akamai.amp.config.data.heartbeat.HeartbeatConfigurationData;
import com.akamai.amp.config.data.heartbeat.HeartbeatData;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.Utils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class AdobeEventsHandler
extends AnalyticsTracker<HeartbeatData>
implements MediaHeartbeat.MediaHeartbeatDelegate,
AmpAdobeHeartbeatAnalyticsTracker {
    private static final String LOG_TAG = "AdobeEventsHandler";
    private MediaHeartbeat heartbeat;
    private boolean isPaused = true;
    private boolean sessionStarted = false;
    private boolean adsStarted = false;
    private boolean trackPlayAfterAdStart = true;
    private boolean trackSessionEndAfterTrackComplete = false;
    private final Object lock = new Object();
    private boolean isBuffering = false;
    private boolean isSeeking = false;
    private int latestAdPlayhead = -1;
    private MediaObject latestAdBreakInfo;
    private MediaObject latestAdInfo;
    private AdsInfo latestAd;
    private AdsCount adsCount = AdsCount.UNKNOWN;
    private boolean adsOnLive = false;
    private boolean isLogicalResumeComing = false;
    private boolean isLogicalPauseComing = false;

    public AdobeEventsHandler(HeartbeatData data) {
        super((AnalyticsTrackerData)data, LOG_TAG, "9.10.6");
    }

    public AdobeEventsHandler(VideoPlayerView videoPlayerView, HeartbeatData data) {
        super(videoPlayerView, (AnalyticsTrackerData)data, LOG_TAG, "9.10.6");
    }

    public MediaObject getQoSObject() {
        long bitrate = -1L;
        double startupTime = -1.0;
        double fps = -1.0;
        long droppedFrames = -1L;
        if (this.mVideoPlayerView != null) {
            bitrate = this.mVideoPlayerView.getCurrentBitrate();
            fps = this.mVideoPlayerView.getFPS();
        }
        MediaObject qoSObject = MediaHeartbeat.createQoSObject((Long)bitrate, (Double)startupTime, (Double)fps, (Long)droppedFrames);
        return qoSObject;
    }

    public Double getCurrentPlaybackTime() {
        if (this.adsStarted) {
            return this.latestAdPlayhead;
        }
        return this.getPlayheadPosition();
    }

    public void setContentLabel(String tag, String value) {
        ((HeartbeatData)this.data).putContentData(tag, value);
    }

    public void setContentLabels(Map<String, String> map) {
        ((HeartbeatData)this.data).setCustomVideoMetadata(map);
    }

    public void setAdLabel(String tag, String value) {
        ((HeartbeatData)this.data).putAdData(tag, value);
    }

    public void setAdLabels(Map<String, String> map) {
        ((HeartbeatData)this.data).setCustomAdMetadata(map);
    }

    @Override
    public List<String> getVideoMetadataKeys() {
        return this.getFieldsNames(MediaHeartbeat.VideoMetadataKeys.class);
    }

    @Override
    public List<String> getAdMetadataKeys() {
        return this.getFieldsNames(MediaHeartbeat.AdMetadataKeys.class);
    }

    @Override
    public List<String> getFieldsNames(Class c) {
        Field[] fields = c.getDeclaredFields();
        ArrayList<String> keyNames = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            String keyName = field.getName();
            keyNames.add(keyName);
        }
        return keyNames;
    }

    public void cleanup() {
        if (this.heartbeat != null) {
            this.doTrackSessionEnd();
            this.heartbeat = null;
        }
        this.resetStateValues();
        LogManager.log((String)LOG_TAG, (String)"AdobeEventsHandler.cleanup()");
    }

    public String getExternalLibVersion() {
        return Version.getVersion();
    }

    public long getPlayheadPositionForLive() {
        return Utils.Time.getSecondsSinceMidnight((TimeZone)AdobeHeartbeat.getTimeZone());
    }

    @Override
    public String getHeartbeatStreamType() {
        if (this.isLive) {
            return "live";
        }
        return "vod";
    }

    public void trackPlayEvent() {
        this.tryTrackPlay("trackPlayEvent()", false, false);
    }

    private void tryTrackPlay(String invokingMethod, boolean comesFromAdStart, boolean isResume) {
        if (!this.sessionStarted) {
            this.doSessionStart(invokingMethod, false);
        }
        if (this.isLogicalResumeComing) {
            this.isLogicalResumeComing = false;
            return;
        }
        boolean shouldTrackPlay = this.shouldTrackPlay(comesFromAdStart, isResume);
        if (shouldTrackPlay) {
            this.doTrackPlay(invokingMethod);
        } else {
            LogManager.log((String)LOG_TAG, (String)(invokingMethod + " did NOT invoke heartbeat.trackPlay()"));
        }
    }

    public void trackPauseEvent() {
        this.tryTrackPause("trackPauseEvent()");
    }

    public void trackResumeEvent() {
        boolean isPaused = this.mVideoPlayerView.isPaused();
        if (!isPaused) {
            this.tryTrackPlay("trackResumeEvent()", false, true);
        }
    }

    public void trackStopPlaying() {
        this.tryTrackPause("trackStopPlaying()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackStartRebuffering() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isBuffering) {
                return;
            }
            this.isBuffering = true;
            if (this.heartbeat == null) {
                return;
            }
            this.heartbeat.trackEvent(MediaHeartbeat.Event.BufferStart, null, null);
            LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackBufferStart()");
            LogManager.log((String)LOG_TAG, (String)"heartbeat.trackEvent(BufferStart)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackStopRebuffering() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isBuffering) {
                return;
            }
            this.isBuffering = false;
            if (this.heartbeat == null) {
                return;
            }
            this.heartbeat.trackEvent(MediaHeartbeat.Event.BufferComplete, null, null);
            LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackBufferComplete()");
            LogManager.log((String)LOG_TAG, (String)"heartbeat.trackEvent(BufferComplete)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackSeekStarted() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isSeeking) {
                return;
            }
            this.isSeeking = true;
            if (this.heartbeat == null) {
                return;
            }
            this.heartbeat.trackEvent(MediaHeartbeat.Event.SeekStart, null, null);
            LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackSeekStart()");
            LogManager.log((String)LOG_TAG, (String)"heartbeat.trackEvent(SeekStart)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackSeekComplete() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isSeeking) {
                return;
            }
            this.isSeeking = false;
            if (this.heartbeat == null) {
                return;
            }
            this.heartbeat.trackEvent(MediaHeartbeat.Event.SeekComplete, null, null);
            LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackSeekComplete()");
            LogManager.log((String)LOG_TAG, (String)"heartbeat.trackEvent(SeekComplete)");
        }
    }

    public void trackFinish() {
        if (this.heartbeat == null) {
            return;
        }
        if (this.trackSessionEndAfterTrackComplete) {
            this.doTrackSessionEnd();
        }
    }

    public void trackSendToBackground() {
        this.doTrackPause("trackSendToBackground()");
    }

    public void trackSendToForeground() {
        this.doTrackPlay("trackSendToForeground()");
    }

    public void trackAdsLoaded(AdsCount param) {
        if (param == null) {
            return;
        }
        this.adsCount = param;
        this.setTrackingPoints();
    }

    public void trackAdsStarted(AdsInfo ad) {
        this.resetLatestAdInfo();
        if (ad == null) {
            LogManager.log((String)LOG_TAG, (String)"onAdsStarted() AdsInfo is NULL (AdBreak)");
        } else {
            if (this.adsStarted) {
                return;
            }
            if (!this.sessionStarted) {
                this.doSessionStart("onAdsStarted ", false);
            }
            LogManager.log((String)LOG_TAG, (String)("onAdsStarted() " + ad));
            this.adsStarted = true;
            if (this.heartbeat == null) {
                return;
            }
            this.latestAdBreakInfo = this.getAdBreakInfo();
            this.heartbeat.trackEvent(MediaHeartbeat.Event.AdBreakStart, this.latestAdBreakInfo, null);
            LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackAdBreakStart()");
            LogManager.log((String)LOG_TAG, (String)"heartbeat.trackEvent(AdBreakStart, latestAdBreakInfo, null)");
            this.latestAd = ad;
            this.latestAdInfo = this.getAdInfo(ad);
            Map adData = ((HeartbeatData)this.data).getAdMetadata();
            this.heartbeat.trackEvent(MediaHeartbeat.Event.AdStart, this.latestAdInfo, adData);
            LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackAdStart()");
            LogManager.log((String)LOG_TAG, (String)("heartbeat.trackEvent(AdStart, latestAdInfo, data.getCustomAdMetadata()) " + adData));
            if (this.isPaused) {
                this.doTrackPlay("onAdsStarted");
            }
        }
    }

    public void trackAdsEnded() {
        if (this.adsStarted) {
            this.adsStarted = false;
            if (this.heartbeat == null) {
                return;
            }
            this.heartbeat.trackEvent(MediaHeartbeat.Event.AdComplete, this.latestAdInfo, null);
            LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackAdComplete()");
            LogManager.log((String)LOG_TAG, (String)"heartbeat.trackEvent(AdComplete, latestAdInfo, null)");
            this.heartbeat.trackEvent(MediaHeartbeat.Event.AdBreakComplete, this.latestAdBreakInfo, null);
            LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackAdBreakComplete()");
            LogManager.log((String)LOG_TAG, (String)"heartbeat.trackEvent(AdBreakComplete, latestAdBreakInfo, null)");
        }
        boolean shouldTrackSessionEnd = !this.trackSessionEndAfterTrackComplete && this.latestAd != null && this.latestAd.isPostroll();
        this.resetLatestAdInfo();
        if (shouldTrackSessionEnd) {
            this.doTrackSessionEnd();
        }
    }

    public void trackAdsError(String error) {
        this.setTrackingPoints();
    }

    public void trackAdsPlayheadUpdate(int seconds) {
        this.latestAdPlayhead = seconds;
    }

    @Override
    public void trackPlayAfterAdStart() {
        this.trackPlayAfterAdStart = true;
    }

    @Override
    public void trackPlayAfterSessionStart() {
        this.trackPlayAfterAdStart = false;
    }

    @Override
    public void trackSessionEndAfterTrackComplete() {
        this.trackSessionEndAfterTrackComplete = true;
    }

    @Override
    public void trackSessionEndAfterPostrolls() {
        this.trackSessionEndAfterTrackComplete = false;
    }

    public void trackLogicalResumeIsComing() {
        this.isLogicalResumeComing = true;
    }

    public void trackLogicalPauseIsComing() {
        this.isLogicalPauseComing = true;
    }

    @Override
    public void adsOnLive(boolean hasAds) {
        this.adsOnLive = hasAds;
    }

    private void resetStateValues() {
        this.isPaused = true;
        this.sessionStarted = false;
        this.adsStarted = false;
    }

    public void init() {
        HeartbeatConfigurationData config = ((HeartbeatData)this.data).getConfig();
        com.adobe.mobile.Config.setContext((Context)this.getOwner());
        com.adobe.mobile.Config.setUserIdentifier((String)config.getAdobeUserId());
        AudienceManager.setDpidAndDpuuid((String)config.getAudienceManagerDpid(), (String)config.getAudienceManagerDpuuid());
        MediaHeartbeatConfig c = this.buildMediaHeartbeatConfig(config);
        c.debugLogging = LogManager.isLogEnabled();
        this.heartbeat = new MediaHeartbeat((MediaHeartbeat.MediaHeartbeatDelegate)this, c);
        LogManager.log((String)LOG_TAG, (String)"AdobeEventsHandler.init()");
    }

    protected HeartbeatData loadDataFromConfig() {
        HeartbeatConfigurationData config = Config.getInstance().heartbeatConfigurationData;
        HeartbeatData data = new HeartbeatData(config);
        return data;
    }

    private MediaHeartbeatConfig buildMediaHeartbeatConfig(HeartbeatConfigurationData data) {
        MediaHeartbeatConfig config = new MediaHeartbeatConfig();
        config.trackingServer = data.getTrackingServer();
        config.channel = data.getChannel();
        config.ovp = data.getOvp();
        this.setSslEnabled(data.getSslEnabled(), config);
        config.debugLogging = LogManager.isLogEnabled();
        String playerName = data.getPlayerName();
        config.playerName = playerName == null ? "Akamai AMP SDK Android" : playerName;
        String appVersion = data.getAppVersion();
        config.appVersion = appVersion == null ? "9.10.6" : appVersion;
        return config;
    }

    private void setSslEnabled(Boolean isSslEnabled, MediaHeartbeatConfig config) {
        if (isSslEnabled == null) {
            return;
        }
        config.ssl = isSslEnabled;
    }

    private void doSessionStart(String logMessage, boolean isResume) {
        if (this.sessionStarted) {
            return;
        }
        if (this.heartbeat == null) {
            return;
        }
        MediaObject mediaInfo = this.getMediaInfo(isResume);
        Map customData = ((HeartbeatData)this.data).getVideoMetadata();
        this.heartbeat.trackSessionStart(mediaInfo, customData);
        LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackSessionStart()");
        LogManager.log((String)LOG_TAG, (String)(logMessage + " invoked heartbeat.trackSessionStart " + customData));
        this.sessionStarted = true;
    }

    private MediaObject getMediaInfo(boolean isResume) {
        if (this.mVideoPlayerView == null) {
            throw new IllegalStateException("VideoPlayerView is null");
        }
        MediaResource mediaResource = this.mVideoPlayerView.getMediaResource();
        if (mediaResource == null) {
            throw new IllegalStateException("MediaResource is null");
        }
        String mediaName = this.getKey(mediaResource, "s:asset:name");
        return this.buildContentMediaInfo(isResume, mediaName);
    }

    private MediaObject buildContentMediaInfo(boolean isResume, String mediaName) {
        Map videoData = ((HeartbeatData)this.data).getVideoMetadata();
        MediaObject mediaInfo = MediaHeartbeat.createMediaObject((String)mediaName, (String)this.getKey(videoData, "video_id"), (Double)this.getDuration(), (String)this.getHeartbeatStreamType());
        videoData.put("live_stream", this.getIsLive());
        mediaInfo.setValue("media_standard_content_metadata", (Object)videoData);
        if (isResume) {
            mediaInfo.setValue("resumed", (Object)true);
        }
        return mediaInfo;
    }

    private String getIsLive() {
        String liveInfo = String.valueOf(this.isLive);
        return liveInfo;
    }

    private double getDuration() {
        double duration = this.isLive ? 86400.0 : (double)this.mVideoPlayerView.getTimelineDuration();
        return duration;
    }

    private String getKey(MediaResource mediaResource, String key) {
        String title = mediaResource.getTitle();
        if (title == null) {
            Map videoMetadata = ((HeartbeatData)this.data).getVideoMetadata();
            String assetName = (String)videoMetadata.get(key);
            if (assetName == null || assetName.isEmpty()) {
                String errorMessage = "<" + key + "> is mandatory and should be unique to the video played, set it on HeartbeatData standardVideoMetadata";
                throw new IllegalStateException(errorMessage);
            }
            return assetName;
        }
        return title;
    }

    private String getKey(Map<String, String> standardVideoMetadata, String key) {
        String videoId;
        if (standardVideoMetadata != null && (videoId = standardVideoMetadata.get(key)) != null && !videoId.isEmpty()) {
            return videoId;
        }
        String errorMessage = "<" + key + "> is mandatory and should be unique to the video played, set it on HeartbeatData standardVideoMetadata";
        throw new IllegalStateException(errorMessage);
    }

    private boolean doTrackPlay(String invokingMethod) {
        if (this.heartbeat == null) {
            return false;
        }
        if (!this.isPaused) {
            return false;
        }
        this.heartbeat.trackPlay();
        LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackPlay()");
        LogManager.log((String)LOG_TAG, (String)(invokingMethod + " invoked heartbeat.trackPlay()"));
        this.isPaused = false;
        return true;
    }

    private boolean shouldTrackPlay(boolean comesFromAdStart, boolean isResume) {
        if (isResume) {
            return true;
        }
        if (this.isLive && !this.adsOnLive) {
            return true;
        }
        if (this.trackPlayAfterAdStart) {
            if (comesFromAdStart) {
                this.trackPlayAfterAdStart = false;
            }
            return comesFromAdStart;
        }
        boolean result = this.isPaused && !this.mVideoPlayerView.isPaused();
        return result;
    }

    private void tryTrackPause(String invokingMethod) {
        if (!this.sessionStarted) {
            String errorMessage = "tryTrackPause() was called from " + invokingMethod + "(), but the session has not been started.";
            LogManager.error((String)"AdobeVideoHeartbeatSDK", (String)errorMessage);
            return;
        }
        if (this.isLogicalPauseComing) {
            this.isLogicalPauseComing = false;
            return;
        }
        if (this.isPaused) {
            LogManager.log((String)LOG_TAG, (String)(invokingMethod + " did NOT invoke heartbeat.trackPause()"));
        } else {
            this.doTrackPause(invokingMethod);
        }
    }

    private boolean doTrackPause(String invokingMethod) {
        if (this.heartbeat == null) {
            return false;
        }
        if (this.isPaused) {
            return false;
        }
        this.heartbeat.trackPause();
        LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackPause()");
        LogManager.log((String)LOG_TAG, (String)(invokingMethod + " invoked heartbeat.trackPause()"));
        this.isPaused = true;
        return true;
    }

    private void doTrackSessionEnd() {
        this.resetStateValues();
        this.doTrackComplete();
        this.heartbeat.trackSessionEnd();
        LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackSessionEnd()");
        LogManager.log((String)LOG_TAG, (String)"heartbeat.trackSessionEnd()");
    }

    private void doTrackComplete() {
        if (this.isLive) {
            return;
        }
        if (this.heartbeat == null) {
            return;
        }
        this.heartbeat.trackComplete();
        LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackComplete()");
        LogManager.log((String)LOG_TAG, (String)"heartbeat.trackComplete()");
    }

    private void setTrackingPoints() {
        if (this.adsCount.hasPrerolls()) {
            LogManager.log((String)LOG_TAG, (String)"setTrackingPoints: adsCount.hasPrerolls(), calling trackPlayAfterAdStart()");
            this.trackPlayAfterAdStart();
        } else {
            LogManager.log((String)LOG_TAG, (String)"setTrackingPoints: NOT adsCount.hasPrerolls(), calling trackPlayAfterSessionStart()");
            this.trackPlayAfterSessionStart();
        }
        if (this.adsCount.hasPostrolls()) {
            LogManager.log((String)LOG_TAG, (String)"setTrackingPoints: adsCount.hasPostrolls(), calling trackSessionEndAfterPostrolls()");
            this.trackSessionEndAfterPostrolls();
        } else {
            LogManager.log((String)LOG_TAG, (String)"setTrackingPoints: NOT adsCount.hasPostrolls(), calling trackSessionEndAfterTrackComplete()");
            this.trackSessionEndAfterTrackComplete();
        }
    }

    private void resetLatestAdInfo() {
        this.latestAdPlayhead = -1;
        this.latestAdBreakInfo = null;
        this.latestAdInfo = null;
        this.latestAd = null;
    }

    private MediaObject getAdBreakInfo() {
        double timePosition = this.mVideoPlayerView.getCurrentTimelinePosition();
        MediaObject adBreakInfo = MediaHeartbeat.createAdBreakObject((String)this.generateUnique("AD_BREAK"), (Long)1L, (Double)timePosition);
        return adBreakInfo;
    }

    private String generateUnique(String base) {
        String result = base + "_" + System.currentTimeMillis();
        return result;
    }

    private MediaObject getAdInfo(AdsInfo adsInfo) {
        String paramAdId = adsInfo.adId;
        String adId = paramAdId == null ? this.generateUnique("AD") : paramAdId;
        MediaObject adData = MediaHeartbeat.createAdObject((String)adsInfo.name, (String)adId, (Long)((long)adsInfo.positionInStream), (Double)Double.valueOf(adsInfo.lengthInSeconds));
        Map customAdMetadata = ((HeartbeatData)this.data).getAdMetadata();
        if (customAdMetadata != null) {
            adData.setValue("media_standard_ad_metadata", (Object)customAdMetadata);
        }
        return adData;
    }
}

