/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.parser.feed;

import com.akamai.amp.media.elements.DRMKey;
import com.akamai.amp.media.elements.Media;
import com.akamai.amp.media.elements.Source;
import com.akamai.amp.media.elements.Track;
import com.akamai.amp.media.exowrapper2.drm.DrmScheme;
import com.akamai.amp.parser.utils.UtilsParser;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class MediaParser {
    public static final String MEDIA_TAG = "media";
    public static final String TITLE_TAG = "title";
    public static final String POSTER_TAG = "poster";
    public static final String SOURCE_TAG = "source";
    public static final String TRACK_TAG = "track";
    public static final String DURATION_TAG = "duration";
    public static final String SRC_TAG = "src";
    public static final String TYPE_TAG = "type";
    public static final String CONTENT_SOURCE_ID = "contentSourceId";
    public static final String VIDEO_ID_TAG = "videoId";
    public static final String ASSET_KEY_TAG = "assetKey";
    public static final String KIND_TAG = "kind";
    public static final String LANGUAGE_TAG = "language";
    public static final String KEYS_TAG = "keys";
    public static final String WIDEVINE_TAG = "com.widevine.alpha";
    public static final String PLAYREADY_TAG = "com.microsoft.playready";
    public static final String DRMLICENSE_TAG = "serverURL";

    public static Media buildMedia(JSONObject mediaObject) {
        Media media = new Media();
        media.setTitle(UtilsParser.getValue(TITLE_TAG, mediaObject));
        media.setPoster(UtilsParser.getValue(POSTER_TAG, mediaObject));
        String duration = UtilsParser.getValue(DURATION_TAG, mediaObject);
        media.setDuration(duration != null ? Integer.valueOf(duration) : 0);
        JSONArray sourceJSONArray = UtilsParser.getJsonArray(SOURCE_TAG, mediaObject);
        JSONArray trackJSONArray = UtilsParser.getJsonArray(TRACK_TAG, mediaObject);
        JSONObject drmKeys = UtilsParser.getObj(KEYS_TAG, mediaObject);
        ArrayList<Track> trackArray = new ArrayList<Track>();
        ArrayList<Source> sourceArray = new ArrayList<Source>();
        ArrayList<DRMKey> drmKeyArray = new ArrayList<DRMKey>();
        String singleSource = UtilsParser.getValue(SRC_TAG, mediaObject);
        if (singleSource != null) {
            Source source = new Source();
            source.setSrc(UtilsParser.getValue(SRC_TAG, mediaObject));
            source.setType(UtilsParser.getValue(TYPE_TAG, mediaObject));
            source.setContentSourceID(UtilsParser.getValue(CONTENT_SOURCE_ID, mediaObject));
            source.setVideoID(UtilsParser.getValue(VIDEO_ID_TAG, mediaObject));
            source.setAssetKey(UtilsParser.getValue(ASSET_KEY_TAG, mediaObject));
            sourceArray.add(source);
        } else if (sourceJSONArray != null) {
            for (int i = 0; i < sourceJSONArray.length(); ++i) {
                JSONObject sourceObject = UtilsParser.getJsonObjectFromArray(sourceJSONArray, i);
                Source source = new Source();
                source.setSrc(UtilsParser.getValue(SRC_TAG, sourceObject));
                source.setType(UtilsParser.getValue(TYPE_TAG, sourceObject));
                source.setContentSourceID(UtilsParser.getValue(CONTENT_SOURCE_ID, sourceObject));
                source.setVideoID(UtilsParser.getValue(VIDEO_ID_TAG, sourceObject));
                source.setAssetKey(UtilsParser.getValue(ASSET_KEY_TAG, sourceObject));
                sourceArray.add(source);
            }
        }
        if (drmKeys != null) {
            JSONObject playreadyObject;
            JSONObject widevineObject = UtilsParser.getObj(WIDEVINE_TAG, drmKeys);
            if (widevineObject != null) {
                DRMKey widevineKey = new DRMKey();
                widevineKey.setDRMScheme(DrmScheme.WIDEVINE);
                widevineKey.setLicenseURL(UtilsParser.getValue(DRMLICENSE_TAG, widevineObject));
                drmKeyArray.add(widevineKey);
            }
            if ((playreadyObject = UtilsParser.getObj(PLAYREADY_TAG, drmKeys)) != null) {
                DRMKey playReadyKey = new DRMKey();
                playReadyKey.setDRMScheme(DrmScheme.PLAYREADY);
                playReadyKey.setLicenseURL(UtilsParser.getValue(DRMLICENSE_TAG, playreadyObject));
                drmKeyArray.add(playReadyKey);
            }
        }
        if (trackJSONArray != null) {
            for (int i = 0; i < trackJSONArray.length(); ++i) {
                JSONObject trackObject = UtilsParser.getJsonObjectFromArray(trackJSONArray, i);
                Track track = new Track();
                track.setType(UtilsParser.getValue(TYPE_TAG, trackObject));
                track.setSrc(UtilsParser.getValue(SRC_TAG, trackObject));
                track.setSrcLanguage(UtilsParser.getValue(LANGUAGE_TAG, trackObject));
                track.setKind(UtilsParser.getValue(KIND_TAG, trackObject));
                trackArray.add(track);
            }
        }
        media.setSource(sourceArray);
        media.setTrack(trackArray);
        media.setDrmKeys(drmKeyArray);
        return media;
    }
}

