/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.trackselection;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.source.TrackGroup;
import com.akamai.amp.exoplayer2.source.chunk.Chunk;
import com.akamai.amp.exoplayer2.source.chunk.MediaChunk;
import com.akamai.amp.exoplayer2.source.chunk.MediaChunkIterator;
import com.akamai.amp.exoplayer2.upstream.BandwidthMeter;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableType;

public interface TrackSelection {
    public void enable();

    public void disable();

    public TrackGroup getTrackGroup();

    public int length();

    public Format getFormat(int var1);

    public int getIndexInTrackGroup(int var1);

    public int indexOf(Format var1);

    public int indexOf(int var1);

    public Format getSelectedFormat();

    public int getSelectedIndexInTrackGroup();

    public int getSelectedIndex();

    public int getSelectionReason();

    @Nullable
    public Object getSelectionData();

    public void onPlaybackSpeed(float var1);

    default public void onDiscontinuity() {
    }

    public void updateSelectedTrack(long var1, long var3, long var5, List<? extends MediaChunk> var7, MediaChunkIterator[] var8);

    public int evaluateQueueSize(long var1, List<? extends MediaChunk> var3);

    default public boolean shouldCancelChunkLoad(long playbackPositionUs, Chunk loadingChunk, List<? extends MediaChunk> queue) {
        return false;
    }

    public boolean blacklist(int var1, long var2);

    public static interface Factory {
        public @NullableType TrackSelection[] createTrackSelections(@NullableType Definition[] var1, BandwidthMeter var2);
    }

    public static final class Definition {
        public final TrackGroup group;
        public final int[] tracks;
        public final int reason;
        @Nullable
        public final Object data;

        public Definition(TrackGroup group, int ... tracks) {
            this(group, tracks, 0, null);
        }

        public Definition(TrackGroup group, int[] tracks, int reason, @Nullable Object data) {
            this.group = group;
            this.tracks = tracks;
            this.reason = reason;
            this.data = data;
        }
    }
}

