/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.analytics.mux.bandwidth;

import com.akamai.amp.analytics.mux.MuxEventBus;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.upstream.DataSpec;
import com.mux.stats.sdk.core.model.BandwidthMetricData;
import java.io.IOException;

class BandwidthMetric {
    private MuxEventBus muxEventBus;

    BandwidthMetric(MuxEventBus muxEventBus) {
        this.muxEventBus = muxEventBus;
    }

    public BandwidthMetricData onLoadError(DataSpec dataSpec, int dataType, IOException e) {
        BandwidthMetricData loadData = new BandwidthMetricData();
        loadData.setRequestError(e.toString());
        if (dataSpec != null && dataSpec.uri != null) {
            loadData.setRequestUrl(dataSpec.uri.toString());
            loadData.setRequestHostName(dataSpec.uri.getHost());
        }
        switch (dataType) {
            case 4: {
                loadData.setRequestType("manifest");
                break;
            }
            case 1: {
                loadData.setRequestType("media");
                break;
            }
            default: {
                return null;
            }
        }
        loadData.setRequestErrorCode(null);
        loadData.setRequestErrorText(e.getMessage());
        return loadData;
    }

    public BandwidthMetricData onLoadCanceled(DataSpec dataSpec) {
        BandwidthMetricData loadData = new BandwidthMetricData();
        loadData.setRequestCancel("genericLoadCanceled");
        if (dataSpec != null && dataSpec.uri != null) {
            loadData.setRequestUrl(dataSpec.uri.toString());
            loadData.setRequestHostName(dataSpec.uri.getHost());
        }
        loadData.setRequestType("media");
        return loadData;
    }

    private BandwidthMetricData onLoad(DataSpec dataSpec, int dataType, Format trackFormat, long mediaStartTimeMs, long mediaEndTimeMs, long elapsedRealtimeMs, long loadDurationMs, long bytesLoaded) {
        BandwidthMetricData loadData = new BandwidthMetricData();
        if (bytesLoaded > 0L) {
            loadData.setRequestBytesLoaded(Long.valueOf(bytesLoaded));
        }
        switch (dataType) {
            case 4: {
                loadData.setRequestType("manifest");
                break;
            }
            case 1: {
                loadData.setRequestType("media");
                break;
            }
            default: {
                return null;
            }
        }
        loadData.setRequestResponseHeaders(null);
        if (dataSpec != null && dataSpec.uri != null) {
            loadData.setRequestHostName(dataSpec.uri.getHost());
        }
        if (dataType == 1) {
            loadData.setRequestMediaDuration(Long.valueOf(mediaEndTimeMs - mediaStartTimeMs));
        }
        if (trackFormat != null) {
            loadData.setRequestCurrentLevel(null);
            if (dataType == 1) {
                loadData.setRequestMediaStartTime(Long.valueOf(mediaStartTimeMs));
            }
            loadData.setRequestVideoWidth(Integer.valueOf(trackFormat.width));
            loadData.setRequestVideoHeight(Integer.valueOf(trackFormat.height));
        }
        loadData.setRequestRenditionLists(this.muxEventBus.renditionList);
        return loadData;
    }

    public BandwidthMetricData onLoadStarted(DataSpec dataSpec, int dataType, Format trackFormat, long mediaStartTimeMs, long mediaEndTimeMs, long elapsedRealtimeMs) {
        BandwidthMetricData loadData = this.onLoad(dataSpec, dataType, trackFormat, mediaStartTimeMs, mediaEndTimeMs, elapsedRealtimeMs, 0L, 0L);
        if (loadData != null) {
            loadData.setRequestResponseStart(Long.valueOf(elapsedRealtimeMs));
        }
        return loadData;
    }

    public BandwidthMetricData onLoadCompleted(DataSpec dataSpec, int dataType, Format trackFormat, long mediaStartTimeMs, long mediaEndTimeMs, long elapsedRealtimeMs, long loadDurationMs, long bytesLoaded) {
        BandwidthMetricData loadData = this.onLoad(dataSpec, dataType, trackFormat, mediaStartTimeMs, mediaEndTimeMs, elapsedRealtimeMs, loadDurationMs, bytesLoaded);
        if (loadData != null) {
            loadData.setRequestResponseStart(Long.valueOf(elapsedRealtimeMs - loadDurationMs));
            loadData.setRequestResponseEnd(Long.valueOf(elapsedRealtimeMs));
        }
        return loadData;
    }
}

