/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.analytics.mux;

import android.net.Uri;
import android.os.AsyncTask;
import com.akamai.amp.analytics.mux.compat.AsyncTaskCompat;
import com.akamai.amp.utils.LogManager;
import com.mux.stats.sdk.muxstats.INetworkRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import org.json.JSONObject;

public class MuxNetworkRequests
implements INetworkRequest {
    private static final String TAG = "MuxNetworkRequests";

    private String getAuthority(String propertykey) {
        if (Pattern.matches("^[a-z0-9]+$", propertykey)) {
            return propertykey + ".litix.io";
        }
        return "img.litix.io";
    }

    public void get(URL url) {
        try {
            AsyncTaskCompat.executeParallel(new NetworkTaskRunner(null), new GetRequest(url));
        }
        catch (Exception e) {
            LogManager.error((String)TAG, (String)e.getMessage(), (Exception)e);
        }
    }

    public void post(URL url, JSONObject body, Hashtable<String, String> headers) {
        try {
            AsyncTaskCompat.executeParallel(new NetworkTaskRunner(null), new PostRequest(url, body.toString(), headers));
        }
        catch (Exception e) {
            LogManager.error((String)TAG, (String)e.getMessage(), (Exception)e);
        }
    }

    public void postWithCompletion(String propertyKey, String body, Hashtable<String, String> headers, INetworkRequest.IMuxNetworkRequestsCompletion callback) {
        try {
            if (propertyKey == null) {
                throw new Exception("propertyKey is null");
            }
            Uri.Builder uriBuilder = new Uri.Builder();
            uriBuilder.scheme("https").authority(this.getAuthority(propertyKey)).path("android");
            AsyncTaskCompat.executeParallel(new NetworkTaskRunner(callback), new PostRequest(new URL(uriBuilder.build().toString()), body, headers));
        }
        catch (Exception e) {
            LogManager.error((String)TAG, (String)e.getMessage(), (Exception)e);
            callback.onComplete(true);
        }
    }

    private static class NetworkTaskRunner
    extends AsyncTask<NetworkRequest, Void, Void> {
        private static final int READ_TIMEOUT_MS = 20000;
        private static final int CONNECT_TIMEOUT_MS = 30000;
        private static final int MAXIMUM_RETRY = 4;
        private static final int BASE_TIME_BETWEEN_BEACONS = 5000;
        private INetworkRequest.IMuxNetworkRequestsCompletion callback;
        private int failureCount = 0;

        NetworkTaskRunner(INetworkRequest.IMuxNetworkRequestsCompletion callback) {
            this.callback = callback;
        }

        private long getNextBeaconTime() {
            if (this.failureCount == 0) {
                return 0L;
            }
            double factor = Math.pow(2.0, this.failureCount - 1);
            return (long)(1.0 + (factor *= Math.random())) * 5000L;
        }

        protected Void doInBackground(NetworkRequest ... params) {
            NetworkRequest request = params[0];
            URL url = request.getUrl();
            String method = request.getMethod();
            Hashtable<String, String> headers = request.getHeaders();
            String body = request.getBody();
            LogManager.log((String)MuxNetworkRequests.TAG, (String)("making " + method + " request to: " + url.toString()));
            boolean successful = false;
            while (!successful && this.failureCount < 4) {
                try {
                    Thread.sleep(this.getNextBeaconTime());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                successful = this.executeHttp(url, method, headers, body);
            }
            if (this.callback != null) {
                this.callback.onComplete(successful);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeHttp(URL url, String method, Hashtable<String, String> headers, String body) {
            HttpURLConnection conn = null;
            InputStream stream = null;
            boolean successful = true;
            try {
                conn = (HttpURLConnection)url.openConnection();
                conn.setReadTimeout(20000);
                conn.setConnectTimeout(30000);
                conn.setRequestMethod(method);
                Enumeration<String> headerKeys = headers.keys();
                boolean shouldGzip = false;
                while (headerKeys.hasMoreElements()) {
                    String key = headerKeys.nextElement();
                    String value = headers.get(key);
                    conn.setRequestProperty(key, value);
                    if (!"Content-Encoding".equalsIgnoreCase(key) || !"gzip".equalsIgnoreCase(value)) continue;
                    shouldGzip = true;
                }
                if (method.equals("POST")) {
                    conn.setRequestProperty("Content-Type", "application/json");
                    byte[] bytes = body.getBytes();
                    if (shouldGzip) {
                        LogManager.log((String)MuxNetworkRequests.TAG, (String)"gzipping");
                        bytes = NetworkTaskRunner.gzip(bytes);
                    }
                    OutputStream outputStream = conn.getOutputStream();
                    outputStream.write(bytes);
                    outputStream.close();
                }
                conn.connect();
                stream = conn.getInputStream();
                LogManager.log((String)MuxNetworkRequests.TAG, (String)("got response: " + conn.getResponseCode()));
            }
            catch (Exception e) {
                LogManager.error((String)MuxNetworkRequests.TAG, (String)e.getMessage(), (Exception)e);
                successful = false;
                ++this.failureCount;
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException ioe) {
                        LogManager.error((String)MuxNetworkRequests.TAG, (String)ioe.getMessage(), (Exception)ioe);
                        successful = false;
                        ++this.failureCount;
                    }
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
            return successful;
        }

        private static byte[] gzip(byte[] input) throws Exception {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gzipOutputStream.write(input);
            gzipOutputStream.flush();
            gzipOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
    }

    private static interface NetworkRequest {
        public URL getUrl();

        public String getMethod();

        public String getBody();

        public Hashtable<String, String> getHeaders();
    }

    private static class GetRequest
    implements NetworkRequest {
        private URL url;
        private Hashtable<String, String> headers;

        GetRequest(URL url) {
            this.url = url;
            this.headers = new Hashtable();
        }

        @Override
        public URL getUrl() {
            return this.url;
        }

        @Override
        public String getMethod() {
            return "GET";
        }

        @Override
        public String getBody() {
            return null;
        }

        @Override
        public Hashtable<String, String> getHeaders() {
            return this.headers;
        }
    }

    private static class PostRequest
    implements NetworkRequest {
        private URL url;
        private String body;
        private Hashtable<String, String> headers;

        PostRequest(URL url, String body, Hashtable<String, String> headers) {
            this.url = url;
            this.body = body == null ? "" : body;
            this.headers = headers == null ? new Hashtable() : headers;
        }

        @Override
        public URL getUrl() {
            return this.url;
        }

        @Override
        public String getMethod() {
            return "POST";
        }

        @Override
        public String getBody() {
            return this.body;
        }

        @Override
        public Hashtable<String, String> getHeaders() {
            return this.headers;
        }
    }
}

