/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.analytics.mux;

import com.akamai.amp.ads.AdsInfo;
import com.akamai.amp.exoplayer2.ExoPlaybackException;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecRenderer;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecUtil;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.PlayerDataPool;
import com.mux.stats.sdk.core.events.EventBus;
import com.mux.stats.sdk.core.events.IEvent;
import com.mux.stats.sdk.core.events.InternalErrorEvent;
import com.mux.stats.sdk.core.events.playback.AdBreakEndEvent;
import com.mux.stats.sdk.core.events.playback.AdBreakStartEvent;
import com.mux.stats.sdk.core.events.playback.AdEndedEvent;
import com.mux.stats.sdk.core.events.playback.AdErrorEvent;
import com.mux.stats.sdk.core.events.playback.AdFirstQuartileEvent;
import com.mux.stats.sdk.core.events.playback.AdMidpointEvent;
import com.mux.stats.sdk.core.events.playback.AdPauseEvent;
import com.mux.stats.sdk.core.events.playback.AdPlayEvent;
import com.mux.stats.sdk.core.events.playback.AdPlayingEvent;
import com.mux.stats.sdk.core.events.playback.AdThirdQuartileEvent;
import com.mux.stats.sdk.core.events.playback.EndedEvent;
import com.mux.stats.sdk.core.events.playback.PauseEvent;
import com.mux.stats.sdk.core.events.playback.PlayEvent;
import com.mux.stats.sdk.core.events.playback.PlaybackEvent;
import com.mux.stats.sdk.core.events.playback.PlayerReadyEvent;
import com.mux.stats.sdk.core.events.playback.PlayingEvent;
import com.mux.stats.sdk.core.events.playback.RenditionChangeEvent;
import com.mux.stats.sdk.core.events.playback.SeekedEvent;
import com.mux.stats.sdk.core.events.playback.SeekingEvent;
import com.mux.stats.sdk.core.events.playback.StalledEvent;
import com.mux.stats.sdk.core.model.BandwidthMetricData;
import com.mux.stats.sdk.core.model.ViewData;
import com.mux.stats.sdk.muxstats.IPlayerListener;
import com.mux.stats.sdk.muxstats.MuxErrorException;
import java.io.IOException;
import java.util.List;

public class MuxEventBus
extends EventBus
implements IPlayerListener {
    private static final String LOG_TAG = MuxEventBus.class.getSimpleName();
    private static final int ERROR_UNKNOWN = -1;
    private static final Integer INVALID_INT = -1;
    private static final Float INVALID_FLOAT = Float.valueOf(-1.0f);
    private static final Long INVALID_LONG = -1L;
    public List<BandwidthMetricData.Rendition> renditionList;
    private AdsInfo latestAdsInfo;
    private Float sourceAdvertisedFramerate = INVALID_FLOAT;
    private String mimeType;
    private String previousEventClassName = "";
    private boolean isPreroll = true;
    private boolean inAdBreak = false;
    private boolean prerollsExpected;
    private boolean adPlayAlreadyTracked;
    private boolean adPlayingAlreadyTracked;
    private boolean playingDispatched;
    private PlayerDataPool playerDataPool;

    MuxEventBus(VideoPlayerView player, boolean prerollsExpected) {
        this.playerDataPool = new PlayerDataPool(player);
        this.prerollsExpected = prerollsExpected;
    }

    public void stopPlayerUpdate() {
        if (this.playerDataPool != null) {
            this.playerDataPool.stopPlayerUpdate();
        }
    }

    public long getCurrentPosition() {
        LogManager.log((String)LOG_TAG, (String)("IPlayerListener.getCurrentPosition() " + this.playerDataPool.currentStreamPositionMS));
        return this.playerDataPool.currentStreamPositionMS;
    }

    public String getMimeType() {
        if (this.mimeType != null) {
            return this.mimeType;
        }
        if (this.playerDataPool.playerInstance == null) {
            return "Unknown";
        }
        return this.playerDataPool.protocol;
    }

    public int getStreamType() {
        return this.playerDataPool.streamType;
    }

    void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public Integer getSourceWidth() {
        if (this.playerDataPool.playerInstance == null) {
            return INVALID_INT;
        }
        return this.playerDataPool.videoWidth;
    }

    public Integer getSourceHeight() {
        if (this.playerDataPool.playerInstance == null) {
            return INVALID_INT;
        }
        return this.playerDataPool.videoHeight;
    }

    public Integer getSourceAdvertisedBitrate() {
        if (this.playerDataPool.playerInstance == null) {
            return INVALID_INT;
        }
        return (int)this.playerDataPool.currentBitrate;
    }

    public Float getSourceAdvertisedFramerate() {
        if (!this.sourceAdvertisedFramerate.equals(INVALID_FLOAT)) {
            return this.sourceAdvertisedFramerate;
        }
        if (this.playerDataPool.playerInstance == null) {
            return INVALID_FLOAT;
        }
        return Float.valueOf(this.playerDataPool.dropFramesCount);
    }

    public Long getSourceDuration() {
        if (this.playerDataPool.playerInstance == null) {
            return INVALID_LONG;
        }
        return this.playerDataPool.streamDuration;
    }

    public boolean isBuffering() {
        if (this.playerDataPool.playerInstance == null) {
            return false;
        }
        return this.playerDataPool.buffering;
    }

    public int getPlayerViewWidth() {
        if (this.playerDataPool.playerInstance == null) {
            return INVALID_INT;
        }
        return this.playerDataPool.width;
    }

    public int getPlayerViewHeight() {
        if (this.playerDataPool.playerInstance == null) {
            return INVALID_INT;
        }
        return this.playerDataPool.height;
    }

    public boolean isPaused() {
        if (this.playerDataPool.playerInstance == null) {
            return false;
        }
        return this.playerDataPool.paused;
    }

    void dispatchPause() {
        if (this.pauseIsPreviousEvent()) {
            return;
        }
        if (this.inAdBreak) {
            return;
        }
        this.dispatch((IEvent)new PauseEvent(null));
        this.playingDispatched = false;
    }

    void dispatchPlay() {
        if (this.inAdBreak) {
            return;
        }
        if (this.playIsPreviousEvent()) {
            return;
        }
        if (this.playingDispatched) {
            return;
        }
        this.dispatch((IEvent)new PlayEvent(null));
    }

    void dispatchPlaying() {
        if (this.inAdBreak) {
            return;
        }
        if (this.playingDispatched) {
            return;
        }
        this.dispatch((IEvent)new PlayingEvent(null));
        this.playingDispatched = true;
    }

    public void forceDispatchPlaying() {
        this.dispatch((IEvent)new PlayingEvent(null));
    }

    void dispatchEnded() {
        this.dispatch((IEvent)new PauseEvent(null));
        this.dispatch((IEvent)new EndedEvent(null));
    }

    void dispatchSeeking() {
        this.dispatch((IEvent)new SeekingEvent(null));
    }

    void dispatchSeeked() {
        this.dispatch((IEvent)new SeekedEvent(null));
    }

    void dispatchStalled() {
        this.dispatch((IEvent)new StalledEvent(null));
    }

    void dispatchInternalError(Exception error) {
        if (error instanceof MuxErrorException) {
            MuxErrorException muxError = (MuxErrorException)error;
            this.dispatch((IEvent)new InternalErrorEvent(muxError.getCode(), muxError.getMessage()));
        } else {
            this.dispatch((IEvent)new InternalErrorEvent(-1, error.getClass().getCanonicalName() + " - " + error.getMessage()));
        }
        this.playingDispatched = false;
    }

    void dispatchRenditionChange(Format format) {
        if (format != null) {
            if (format.frameRate > 0.0f) {
                this.sourceAdvertisedFramerate = Float.valueOf(format.frameRate);
            }
            RenditionChangeEvent event = new RenditionChangeEvent(null);
            this.dispatch((IEvent)event);
        }
    }

    void dispatchPlayerError(ExoPlaybackException e) {
        if (e.type == 1) {
            Exception cause = e.getRendererException();
            if (cause instanceof MediaCodecRenderer.DecoderInitializationException) {
                MediaCodecRenderer.DecoderInitializationException die = (MediaCodecRenderer.DecoderInitializationException)cause;
                if (die.getCause() instanceof MediaCodecUtil.DecoderQueryException) {
                    this.dispatchInternalError((Exception)new MuxErrorException(e.type, "Unable to query device decoders"));
                } else if (die.secureDecoderRequired) {
                    this.dispatchInternalError((Exception)new MuxErrorException(e.type, "No secure decoder for " + die.mimeType));
                } else {
                    this.dispatchInternalError((Exception)new MuxErrorException(e.type, "No decoder for " + die.mimeType));
                }
            }
        } else if (e.type == 0) {
            IOException error = e.getSourceException();
            this.dispatchInternalError((Exception)new MuxErrorException(e.type, error.getClass().getCanonicalName() + " - " + error.getMessage()));
        } else if (e.type == 2) {
            RuntimeException error = e.getUnexpectedException();
            this.dispatchInternalError((Exception)new MuxErrorException(e.type, error.getClass().getCanonicalName() + " - " + error.getMessage()));
        } else {
            this.dispatchInternalError((Exception)e);
        }
    }

    void dispatchAdPlay() {
        if (this.adPlayAlreadyTracked) {
            return;
        }
        if (!this.adBreakStartedIsPreviousEvent()) {
            this.dispatchAdBreakStarted();
        }
        this.dispatchWithAdData((PlaybackEvent)new AdPlayEvent(null));
        this.adPlayAlreadyTracked = true;
    }

    void dispatchAdPlaying(AdsInfo adsInfo) {
        if (this.adPlayingAlreadyTracked) {
            return;
        }
        this.latestAdsInfo = adsInfo;
        this.dispatchWithAdData((PlaybackEvent)new AdPlayingEvent(null));
        this.adPlayingAlreadyTracked = true;
    }

    void dispatchAdPaused() {
        AdPauseEvent event = new AdPauseEvent(null);
        this.dispatchWithAdData((PlaybackEvent)event);
    }

    void dispatchAdEnded() {
        AdEndedEvent event = new AdEndedEvent(null);
        this.dispatchWithAdData((PlaybackEvent)event);
        this.adPlayAlreadyTracked = false;
        this.adPlayingAlreadyTracked = false;
    }

    void dispatchAdErrorEvent() {
        this.inAdBreak = false;
        this.adPlayAlreadyTracked = false;
        AdErrorEvent event = new AdErrorEvent(null);
        this.dispatchWithAdData((PlaybackEvent)event);
        this.latestAdsInfo = null;
    }

    void dispatchAdBreakStarted() {
        if (this.inAdBreak) {
            return;
        }
        this.inAdBreak = true;
        this.adPlayAlreadyTracked = false;
        AdBreakStartEvent event = new AdBreakStartEvent(null);
        this.dispatchWithAdData((PlaybackEvent)event);
    }

    private boolean isPreviousEvent(Class c) {
        boolean result = c.getSimpleName().equals(this.previousEventClassName);
        return result;
    }

    private boolean playIsPreviousEvent() {
        return this.isPreviousEvent(PlayEvent.class);
    }

    private boolean pauseIsPreviousEvent() {
        return this.isPreviousEvent(PauseEvent.class);
    }

    private boolean adBreakStartedIsPreviousEvent() {
        return this.isPreviousEvent(AdBreakStartEvent.class);
    }

    private boolean adErrorIsPreviousEvent() {
        return this.isPreviousEvent(AdErrorEvent.class);
    }

    void dispatchAdBreakEnded() {
        AdBreakEndEvent event = new AdBreakEndEvent(null);
        this.dispatchWithAdData((PlaybackEvent)event);
        this.inAdBreak = false;
        this.adPlayAlreadyTracked = false;
        this.adPlayingAlreadyTracked = false;
    }

    void dispatchAdTrackProgress(int progress) {
        switch (progress) {
            case 0: {
                this.dispatchWithAdData((PlaybackEvent)new AdFirstQuartileEvent(null));
                break;
            }
            case 1: {
                this.dispatchWithAdData((PlaybackEvent)new AdMidpointEvent(null));
                break;
            }
            case 2: {
                this.dispatchWithAdData((PlaybackEvent)new AdThirdQuartileEvent(null));
            }
        }
    }

    public void dispatch(IEvent event) {
        this.previousEventClassName = event.getClass().getSimpleName();
        if (this.prerollsExpected) {
            if (this.adBreakStartedIsPreviousEvent() || this.adErrorIsPreviousEvent()) {
                super.dispatch(event);
                this.prerollsExpected = false;
            }
        } else {
            super.dispatch(event);
        }
    }

    private void dispatchWithAdData(PlaybackEvent event) {
        this.previousEventClassName = event.getClass().getSimpleName();
        if (this.prerollsExpected) {
            if (this.adBreakStartedIsPreviousEvent() || this.adErrorIsPreviousEvent()) {
                this.dispatchWithAdDataInternal(event);
                this.prerollsExpected = false;
            }
        } else {
            this.dispatchWithAdDataInternal(event);
        }
    }

    private void dispatchWithAdDataInternal(PlaybackEvent event) {
        ViewData viewData = this.createViewData();
        event.setViewData(viewData);
        this.dispatch((IEvent)event);
    }

    private ViewData createViewData() {
        ViewData viewData = new ViewData();
        if (this.latestAdsInfo != null) {
            viewData.setViewPrerollAdId(this.latestAdsInfo.adId);
            viewData.setViewAdBreakCount(Integer.valueOf(this.latestAdsInfo.adBreakTotal));
        }
        return viewData;
    }

    void expectPreroll() {
        this.prerollsExpected = true;
    }

    void dispatchPlayerReady() {
        PlayerReadyEvent event = new PlayerReadyEvent(null);
        super.dispatch((IEvent)event);
    }
}

