/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.analytics.mux;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.SystemClock;
import android.provider.Settings;
import com.akamai.amp.analytics.mux.AmpMuxDataAnalyticsTracker;
import com.akamai.amp.utils.LogManager;
import com.mux.stats.sdk.muxstats.IDevice;
import java.lang.ref.WeakReference;

public class MuxDevice
implements IDevice {
    static final String CONNECTION_TYPE_CELLULAR = "cellular";
    static final String CONNECTION_TYPE_WIFI = "wifi";
    static final String CONNECTION_TYPE_ETHERNET = "ethernet";
    static final String CONNECTION_TYPE_OTHER = "other";
    protected WeakReference<Context> contextRef;
    private String deviceId;
    private String appName = "";
    private String appVersion = "";

    @SuppressLint(value={"HardwareIds"})
    MuxDevice(Context ctx) {
        this.deviceId = Settings.Secure.getString((ContentResolver)ctx.getContentResolver(), (String)"android_id");
        this.contextRef = new WeakReference<Context>(ctx);
        try {
            PackageInfo pi = ctx.getPackageManager().getPackageInfo(ctx.getPackageName(), 0);
            this.appName = pi.packageName;
            this.appVersion = pi.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            LogManager.error((String)MuxDevice.class.getSimpleName(), (String)"could not get package info");
        }
    }

    public String getHardwareArchitecture() {
        return Build.HARDWARE;
    }

    public String getOSFamily() {
        return "Android";
    }

    public String getOSVersion() {
        return Build.VERSION.RELEASE + " (" + Build.VERSION.SDK_INT + ")";
    }

    public String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public String getModelName() {
        return Build.MODEL;
    }

    public String getPlayerVersion() {
        return "9.10.6";
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getPluginName() {
        return AmpMuxDataAnalyticsTracker.class.getSimpleName();
    }

    public String getPluginVersion() {
        return "9.10.6";
    }

    public String getPlayerSoftware() {
        return "Akamai AMP SDK Android";
    }

    public String getNetworkConnectionType() {
        Context context = (Context)this.contextRef.get();
        if (context == null) {
            return null;
        }
        ConnectivityManager connectivityMgr = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetwork = null;
        if (connectivityMgr != null) {
            activeNetwork = connectivityMgr.getActiveNetworkInfo();
            if (Build.VERSION.SDK_INT >= 23) {
                NetworkCapabilities nc = connectivityMgr.getNetworkCapabilities(connectivityMgr.getActiveNetwork());
                if (nc.hasTransport(3)) {
                    return CONNECTION_TYPE_ETHERNET;
                }
                if (nc.hasTransport(1)) {
                    return CONNECTION_TYPE_WIFI;
                }
                if (nc.hasTransport(0)) {
                    return CONNECTION_TYPE_CELLULAR;
                }
                return CONNECTION_TYPE_OTHER;
            }
            if (activeNetwork.getType() == 9) {
                return CONNECTION_TYPE_ETHERNET;
            }
            if (activeNetwork.getType() == 1) {
                return CONNECTION_TYPE_WIFI;
            }
            if (activeNetwork.getType() == 0) {
                return CONNECTION_TYPE_CELLULAR;
            }
            return CONNECTION_TYPE_OTHER;
        }
        return null;
    }

    public long getElapsedRealtime() {
        return SystemClock.elapsedRealtime();
    }

    public void outputLog(String tag, String msg) {
        LogManager.log((String)tag, (String)msg);
    }
}

