/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.bidder.aps;

import android.content.Context;
import com.akamai.amp.ads.bidder.AdsBidder;
import com.akamai.amp.ads.bidder.Bid;
import com.akamai.amp.ads.bidder.BidderCallback;
import com.akamai.amp.bidder.aps.AmpBidderManager;
import com.akamai.amp.bidder.aps.ApsContentInfo;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.Utils;
import com.amazon.device.ads.aftv.AdBreakPattern;
import com.amazon.device.ads.aftv.AmazonFireTVAdCallback;
import com.amazon.device.ads.aftv.AmazonFireTVAdRequest;
import com.amazon.device.ads.aftv.AmazonFireTVAdResponse;
import com.amazon.device.ads.aftv.AmazonFireTVAdsKeyValuePair;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ApsBidderHandler
implements AmpBidderManager {
    private static final String TAG = ApsBidderHandler.class.getSimpleName();
    private final BidderCallback callback;
    private final Context context;
    private final String appId;
    private final long timeoutMillis;
    private final boolean testFlag;
    private final AmazonFireTVAdCallback amazonFireTVAdCallback = new AmazonFireTVAdCallback(){

        public void onSuccess(AmazonFireTVAdResponse amazonFireTVAdResponse) {
            List amazonKeyWords = amazonFireTVAdResponse.getAdServerTargetingParams();
            LogManager.log((String)TAG, (String)("onSuccess: " + amazonKeyWords));
            List result = ApsBidderHandler.this.convert(amazonKeyWords);
            ApsBidderHandler.this.callback.onBidsFound(result);
        }

        public void onFailure(AmazonFireTVAdResponse amazonFireTVAdResponse) {
            String reason = amazonFireTVAdResponse.getReasonString();
            LogManager.error((String)TAG, (String)("onFailure: " + reason));
            ApsBidderHandler.this.callback.onBidsNotFound();
        }
    };

    public ApsBidderHandler(BidderCallback callback, Context context, String appId, long timeoutMillis, boolean testFlag) {
        Utils.checkModuleVersion((String)TAG, (String)"9.10.6");
        this.callback = (BidderCallback)Utils.requireNonNull((Object)callback);
        this.context = (Context)Utils.requireNonNull((Object)context);
        this.appId = (String)Utils.requireNonNull((Object)appId);
        this.timeoutMillis = timeoutMillis;
        this.testFlag = testFlag;
        LogManager.log((String)TAG, (String)this.toString());
        this.callback.setBidder((AdsBidder)this);
    }

    @Override
    public void requestBids(MediaResource resource, String adBreakId) {
        Utils.requireNonNull((Object)resource);
        ApsContentInfo contentInfo = this.convert(resource);
        this.requestBids(contentInfo, adBreakId);
    }

    @Override
    public void requestBids(ApsContentInfo data, String adBreakId) {
        Utils.requireNonNull((Object)data);
        Utils.requireNonNull((Object)adBreakId);
        String json = data.toString();
        LogManager.log((String)TAG, (String)String.format("Using JSON: %s", json));
        LogManager.log((String)TAG, (String)String.format("BidderCallback(%s) adBreakId(%s)", this.callback, adBreakId));
        AdBreakPattern adBreakPattern = AdBreakPattern.builder().withId(adBreakId).withJsonString(json).build();
        AmazonFireTVAdRequest adRequest = this.buildRequest(adBreakPattern);
        adRequest.executeRequest();
    }

    @Override
    public String toString() {
        String result = String.format(Locale.getDefault(), "Using AppID(%s) Timeout(%d millis) TestFlag(%b) BidderCallback(%s) Context(%s)", this.appId, this.timeoutMillis, this.testFlag, this.callback, this.context);
        return result;
    }

    private ApsContentInfo convert(MediaResource resource) {
        ApsContentInfo contentInfo = new ApsContentInfo(resource.getGuid(), resource.getRating(), resource.getGenres(), resource.getChannel(), resource.getDuration());
        return contentInfo;
    }

    private AmazonFireTVAdRequest buildRequest(AdBreakPattern adBreakPattern) {
        AmazonFireTVAdRequest adRequest = AmazonFireTVAdRequest.builder().withAppID(this.appId).withContext(this.context).withAdBreakPattern(adBreakPattern).withTimeOut(Long.valueOf(this.timeoutMillis)).withCallback(this.amazonFireTVAdCallback).withTestFlag(this.testFlag).build();
        return adRequest;
    }

    private List<Bid> convert(List<AmazonFireTVAdsKeyValuePair> amazonKeyWords) {
        ArrayList<Bid> result = new ArrayList<Bid>();
        for (AmazonFireTVAdsKeyValuePair amazonPair : amazonKeyWords) {
            Bid bid = this.convert(amazonPair);
            result.add(bid);
        }
        return result;
    }

    private Bid convert(AmazonFireTVAdsKeyValuePair amazonPair) {
        String key = amazonPair.getKey();
        String value = amazonPair.getValue();
        LogManager.log((String)TAG, (String)("AmazonFireTVAdsKeyValuePair found: " + key + ", " + value));
        Bid result = new Bid(key, value);
        return result;
    }
}

