/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.analytics.googleanalytics;

import android.content.Context;
import com.akamai.amp.analytics.AnalyticsTracker;
import com.akamai.amp.analytics.AnalyticsTrackerData;
import com.akamai.amp.analytics.googleanalytics.AmpGoogleAnalyticsTracker;
import com.akamai.amp.config.Config;
import com.akamai.amp.config.data.GoogleAnalyticsData;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.Utils;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class GoogleAnalyticsEventsHandler
extends AnalyticsTracker<GoogleAnalyticsData>
implements AmpGoogleAnalyticsTracker {
    private static final String LOG_TAG = "GoogleAnalyticsEventsHandler";
    public static final String VERSION = "9.10.6";
    public static final String APPLICATION_VERSION = "ak_sdk_app_version";
    public static final String AD_ENABLE = "ak_sdk_ad_enable_preroll";
    public static final String CLIP_TITLE = "ak_sdk_clip_title";
    public static final String CLIP_DURATION = "ak_sdk_clip_duration";
    public static final String CLIP_IS_LIVE = "ak_sdk_clip_type";
    public static final String BUFFER_COUNT = "ak_sdk_rebuffers_count";
    public static final String BUFFER_TIME = "ak_sdk_rebuffers_time";
    public static final String PAUSE_COUNT = "ak_sdk_pause_count";
    public static final String PLAY_TIME = "ak_sdk_play_time";
    public static final String PLAY_CONTROL_EVENT = "ak_sdk_play_event";
    public static final String ERROR_EVENT = "ak_sdk_error_event";
    public static final String SETTINGS_EVENT = "app_captions_display";
    public static final String PRESET_CATEGORY = "ak_sdk_app_captions_preset";
    public static final String FONT_SIZE = "ak_sdk_app_captions_fontsize";
    public static final String FONT_NAME_CHANGED_ROOT_NODE = "ak_sdk_app_captions_fontname";
    public static final String TEXT_STYLE_CHANGED_ROOT_NODE = "ak_sdk_app_captions_textstyle";
    public static final String SCROLLING_ROOT_NODE = "ak_sdk_app_captions_scrolling";
    public static final String TEXT_SCREEN_POSITION_ROOT_NODE = "ak_sdk_app_captions_textposition";
    public static final String TEXT_COLOR = "ak_sdk_app_captions_textcolor";
    public static final String BACKGROUND_COLOR = "ak_sdk_app_captions_backgroundcolor";
    public static final String WINDOW_COLOR = "ak_sdk_app_captions_windowcolor";
    public static final String NEW_ACTIVITY_CATEGORY = "ak_sdk_app_window_opened";
    public static final String PLAY_CONTROL_EVENT_PLAY = "play";
    public static final String PLAY_CONTROL_EVENT_PAUSE = "pause";
    public static final String PLAY_CONTROL_EVENT_END = "end";
    public static final String SETTINGS_EVENT_DISABLED = "disabled";
    public static final String SETTINGS_EVENT_ENABLED = "enabled";
    public static final String PLAY_CONTROL_CATEGORY = "ak_sdk_play_cat";
    public static final String SETTINGS_CATEGORY = "ak_sdk_settings_category";
    private static Tracker mTracker;
    private static Date _lastPlayTime;
    private static Date _lastStartBufferingTime;

    public GoogleAnalyticsEventsHandler(GoogleAnalyticsData data) {
        super((AnalyticsTrackerData)data, LOG_TAG, VERSION);
    }

    public GoogleAnalyticsEventsHandler(VideoPlayerView videoPlayerView, GoogleAnalyticsData data) {
        super(videoPlayerView, (AnalyticsTrackerData)data, LOG_TAG, VERSION);
    }

    public void setContentLabel(String tag, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(tag, value);
        this.send(map);
    }

    public void setContentLabels(Map<String, String> map) {
        this.send(map);
    }

    public void setAdLabel(String tag, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(tag, value);
        this.send(map);
    }

    public void setAdLabels(Map<String, String> map) {
        this.send(map);
    }

    private void send(Map<String, String> m) {
        if (mTracker != null) {
            mTracker.send(m);
        }
    }

    public void init() {
        String gaTrackingId = ((GoogleAnalyticsData)this.data).getTrackingId() == null && Config.getConfig().googleAnalyticsData != null ? Config.getConfig().googleAnalyticsData.getTrackingId() : ((GoogleAnalyticsData)this.data).getTrackingId();
        if (gaTrackingId != null && gaTrackingId.length() > 0) {
            GoogleAnalytics googleAnalytics = GoogleAnalytics.getInstance((Context)this.getOwner());
            mTracker = googleAnalytics.newTracker(gaTrackingId);
            LogManager.log((String)LOG_TAG, (String)("GoogleAnalytics tracking ID: " + gaTrackingId));
        } else {
            mTracker = null;
        }
    }

    protected GoogleAnalyticsData loadDataFromConfig() {
        Config c = Config.getConfig();
        GoogleAnalyticsData configGaData = c.googleAnalyticsData;
        if (configGaData == null) {
            return null;
        }
        String trackingId = configGaData.getTrackingId();
        if (trackingId == null) {
            return null;
        }
        GoogleAnalyticsData gaData = new GoogleAnalyticsData();
        gaData.setTrackingId(trackingId);
        return gaData;
    }

    public void cleanup() {
        mTracker = null;
    }

    public String getExternalLibVersion() {
        String name = Utils.getFieldName((String)"com.google.analytics.tracking.android.AnalyticsConstants", (String)"VERSION");
        if (name == null) {
            return "UNKNOWN_VERSION";
        }
        return name;
    }

    public void trackStartPlaying(int durationValue, boolean isLive, String streamUrl) {
        if (!this.mEnabledReporting) {
            return;
        }
        if (mTracker != null) {
            mTracker.send(new HitBuilders.EventBuilder().setCategory("UX").setAction("click").setLabel("submit").build());
            mTracker.send(((HitBuilders.EventBuilder)new HitBuilders.EventBuilder().set("&cd1", String.valueOf(durationValue))).build());
        }
        _lastPlayTime = new Date();
    }

    public void trackOnStart(String viewName) {
        if (!this.mEnabledReporting) {
            return;
        }
        if (mTracker != null) {
            mTracker.send(((HitBuilders.EventBuilder)new HitBuilders.EventBuilder().set("&cd", viewName)).build());
        }
    }

    public void trackPauseEvent() {
        if (!this.mEnabledReporting) {
            return;
        }
        this.sendHiddenEvent(PLAY_CONTROL_CATEGORY, PLAY_CONTROL_EVENT, PLAY_CONTROL_EVENT_PAUSE);
        if (_lastPlayTime != null) {
            Date pauseDate = new Date();
            this.sendHiddenEvent(PLAY_CONTROL_CATEGORY, PLAY_TIME, Long.toString(pauseDate.getTime() - _lastPlayTime.getTime()));
        }
    }

    public void trackPlayEvent() {
        _lastPlayTime = new Date();
        this.sendHiddenEvent(PLAY_CONTROL_CATEGORY, PLAY_CONTROL_EVENT, PLAY_CONTROL_EVENT_PLAY);
    }

    public void trackStopPlaying() {
        this.trackPauseEvent();
    }

    public void trackFinish() {
        this.sendHiddenEvent(PLAY_CONTROL_CATEGORY, PLAY_CONTROL_EVENT, PLAY_CONTROL_EVENT_END);
    }

    public void trackError(String errorMessage) {
        this.sendHiddenEvent(PLAY_CONTROL_CATEGORY, ERROR_EVENT, errorMessage);
    }

    public void trackStartRebuffering() {
        if (!this.mEnabledReporting) {
            return;
        }
        _lastStartBufferingTime = new Date();
        if (_lastStartBufferingTime != null) {
            _lastStartBufferingTime = null;
        }
    }

    public void trackStopRebuffering() {
        if (!this.mEnabledReporting) {
            return;
        }
        if (_lastStartBufferingTime != null) {
            HashMap<String, String> buffDict = new HashMap<String, String>();
            Date stopDate = new Date();
            long time = stopDate.getTime() - _lastStartBufferingTime.getTime();
            String timeStr = Long.toString(time);
            buffDict.put(BUFFER_TIME, timeStr);
            this.sendHiddenEvent(PLAY_CONTROL_CATEGORY, BUFFER_TIME, timeStr);
            _lastStartBufferingTime = null;
        }
    }

    public void trackSubtitlesDisabled() {
        this.sendHiddenEvent(SETTINGS_CATEGORY, SETTINGS_EVENT, SETTINGS_EVENT_DISABLED);
    }

    public void trackSubtitlesEnabled() {
        this.sendHiddenEvent(SETTINGS_CATEGORY, SETTINGS_EVENT, SETTINGS_EVENT_ENABLED);
    }

    public void trackTextSizeChanged(int newTextSize) {
        this.sendHiddenEvent(SETTINGS_CATEGORY, FONT_SIZE, Integer.toString(newTextSize));
    }

    public void trackScreenPositionChanges(String newScreenPosition) {
        this.sendHiddenEvent(SETTINGS_CATEGORY, TEXT_SCREEN_POSITION_ROOT_NODE, newScreenPosition);
    }

    public void trackTextStyleChanges(String newTextStyle) {
        this.sendHiddenEvent(SETTINGS_CATEGORY, TEXT_STYLE_CHANGED_ROOT_NODE, newTextStyle);
    }

    public void trackFontChanges(String newFontName) {
        if (!this.mEnabledReporting) {
            return;
        }
        this.sendHiddenEvent(SETTINGS_CATEGORY, FONT_NAME_CHANGED_ROOT_NODE, newFontName);
    }

    public void trackScrollingChanges(String newScrollingType) {
        this.sendHiddenEvent(SETTINGS_CATEGORY, SCROLLING_ROOT_NODE, newScrollingType);
    }

    public void trackWindowColorChanges(int newWindowColor) {
        this.sendHiddenEvent(SETTINGS_CATEGORY, WINDOW_COLOR, String.format("#%06X", 0xFFFFFF & newWindowColor));
    }

    public void trackBackgroundColorChanges(int newBackgroundColor) {
        this.sendHiddenEvent(SETTINGS_CATEGORY, BACKGROUND_COLOR, String.format("#%06X", 0xFFFFFF & newBackgroundColor));
    }

    public void trackFontColorChanges(int newFontColor) {
        this.sendHiddenEvent(SETTINGS_CATEGORY, TEXT_COLOR, String.format("#%06X", 0xFFFFFF & newFontColor));
    }

    public void trackPresetChanges(String newPresetType) {
        this.sendHiddenEvent(SETTINGS_CATEGORY, PRESET_CATEGORY, newPresetType);
    }

    private void sendHiddenEvent(String parentCategory, String category, String value) {
        if (!this.mEnabledReporting) {
            return;
        }
        if (mTracker != null) {
            mTracker.send(new HitBuilders.EventBuilder().setCategory(category).setLabel(value).build());
        }
    }

    static {
        _lastPlayTime = null;
        _lastStartBufferingTime = null;
    }
}

