/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.decoder.CryptoInfo;
import com.akamai.amp.exoplayer2.decoder.DecoderInputBuffer;
import com.akamai.amp.exoplayer2.extractor.TrackOutput;
import com.akamai.amp.exoplayer2.source.SampleQueue;
import com.akamai.amp.exoplayer2.upstream.Allocation;
import com.akamai.amp.exoplayer2.upstream.Allocator;
import com.akamai.amp.exoplayer2.upstream.DataReader;
import com.akamai.amp.exoplayer2.util.ParsableByteArray;
import com.akamai.amp.exoplayer2.util.Util;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

class SampleDataQueue {
    private static final int INITIAL_SCRATCH_SIZE = 32;
    private final Allocator allocator;
    private final int allocationLength;
    private final ParsableByteArray scratch;
    private AllocationNode firstAllocationNode;
    private AllocationNode readAllocationNode;
    private AllocationNode writeAllocationNode;
    private long totalBytesWritten;

    public SampleDataQueue(Allocator allocator) {
        this.allocator = allocator;
        this.allocationLength = allocator.getIndividualAllocationLength();
        this.scratch = new ParsableByteArray(32);
        this.readAllocationNode = this.firstAllocationNode = new AllocationNode(0L, this.allocationLength);
        this.writeAllocationNode = this.firstAllocationNode;
    }

    public void reset() {
        this.clearAllocationNodes(this.firstAllocationNode);
        this.readAllocationNode = this.firstAllocationNode = new AllocationNode(0L, this.allocationLength);
        this.writeAllocationNode = this.firstAllocationNode;
        this.totalBytesWritten = 0L;
        this.allocator.trim();
    }

    public void discardUpstreamSampleBytes(long totalBytesWritten) {
        this.totalBytesWritten = totalBytesWritten;
        if (this.totalBytesWritten == 0L || this.totalBytesWritten == this.firstAllocationNode.startPosition) {
            this.clearAllocationNodes(this.firstAllocationNode);
            this.readAllocationNode = this.firstAllocationNode = new AllocationNode(this.totalBytesWritten, this.allocationLength);
            this.writeAllocationNode = this.firstAllocationNode;
        } else {
            AllocationNode lastNodeToKeep = this.firstAllocationNode;
            while (this.totalBytesWritten > lastNodeToKeep.endPosition) {
                lastNodeToKeep = lastNodeToKeep.next;
            }
            AllocationNode firstNodeToDiscard = lastNodeToKeep.next;
            this.clearAllocationNodes(firstNodeToDiscard);
            lastNodeToKeep.next = new AllocationNode(lastNodeToKeep.endPosition, this.allocationLength);
            AllocationNode allocationNode = this.writeAllocationNode = this.totalBytesWritten == lastNodeToKeep.endPosition ? lastNodeToKeep.next : lastNodeToKeep;
            if (this.readAllocationNode == firstNodeToDiscard) {
                this.readAllocationNode = lastNodeToKeep.next;
            }
        }
    }

    public void rewind() {
        this.readAllocationNode = this.firstAllocationNode;
    }

    public void readToBuffer(DecoderInputBuffer buffer, SampleQueue.SampleExtrasHolder extrasHolder) {
        if (buffer.isEncrypted()) {
            this.readEncryptionData(buffer, extrasHolder);
        }
        if (buffer.hasSupplementalData()) {
            this.scratch.reset(4);
            this.readData(extrasHolder.offset, this.scratch.getData(), 4);
            int sampleSize = this.scratch.readUnsignedIntToInt();
            extrasHolder.offset += 4L;
            extrasHolder.size -= 4;
            buffer.ensureSpaceForWrite(sampleSize);
            this.readData(extrasHolder.offset, buffer.data, sampleSize);
            extrasHolder.offset += (long)sampleSize;
            extrasHolder.size -= sampleSize;
            buffer.resetSupplementalData(extrasHolder.size);
            this.readData(extrasHolder.offset, buffer.supplementalData, extrasHolder.size);
        } else {
            buffer.ensureSpaceForWrite(extrasHolder.size);
            this.readData(extrasHolder.offset, buffer.data, extrasHolder.size);
        }
    }

    public void discardDownstreamTo(long absolutePosition) {
        if (absolutePosition == -1L) {
            return;
        }
        while (absolutePosition >= this.firstAllocationNode.endPosition) {
            this.allocator.release(this.firstAllocationNode.allocation);
            this.firstAllocationNode = this.firstAllocationNode.clear();
        }
        if (this.readAllocationNode.startPosition < this.firstAllocationNode.startPosition) {
            this.readAllocationNode = this.firstAllocationNode;
        }
    }

    public long getTotalBytesWritten() {
        return this.totalBytesWritten;
    }

    public int sampleData(DataReader input, int length, boolean allowEndOfInput) throws IOException {
        length = this.preAppend(length);
        int bytesAppended = input.read(this.writeAllocationNode.allocation.data, this.writeAllocationNode.translateOffset(this.totalBytesWritten), length);
        if (bytesAppended == -1) {
            if (allowEndOfInput) {
                return -1;
            }
            throw new EOFException();
        }
        this.postAppend(bytesAppended);
        return bytesAppended;
    }

    public void sampleData(ParsableByteArray buffer, int length) {
        while (length > 0) {
            int bytesAppended = this.preAppend(length);
            buffer.readBytes(this.writeAllocationNode.allocation.data, this.writeAllocationNode.translateOffset(this.totalBytesWritten), bytesAppended);
            length -= bytesAppended;
            this.postAppend(bytesAppended);
        }
    }

    private void readEncryptionData(DecoderInputBuffer buffer, SampleQueue.SampleExtrasHolder extrasHolder) {
        int[] encryptedDataSizes;
        int subsampleCount;
        long offset = extrasHolder.offset;
        this.scratch.reset(1);
        this.readData(offset, this.scratch.getData(), 1);
        ++offset;
        byte signalByte = this.scratch.getData()[0];
        boolean subsampleEncryption = (signalByte & 0x80) != 0;
        int ivSize = signalByte & 0x7F;
        CryptoInfo cryptoInfo = buffer.cryptoInfo;
        if (cryptoInfo.iv == null) {
            cryptoInfo.iv = new byte[16];
        } else {
            Arrays.fill(cryptoInfo.iv, (byte)0);
        }
        this.readData(offset, cryptoInfo.iv, ivSize);
        offset += (long)ivSize;
        if (subsampleEncryption) {
            this.scratch.reset(2);
            this.readData(offset, this.scratch.getData(), 2);
            offset += 2L;
            subsampleCount = this.scratch.readUnsignedShort();
        } else {
            subsampleCount = 1;
        }
        int[] clearDataSizes = cryptoInfo.numBytesOfClearData;
        if (clearDataSizes == null || clearDataSizes.length < subsampleCount) {
            clearDataSizes = new int[subsampleCount];
        }
        if ((encryptedDataSizes = cryptoInfo.numBytesOfEncryptedData) == null || encryptedDataSizes.length < subsampleCount) {
            encryptedDataSizes = new int[subsampleCount];
        }
        if (subsampleEncryption) {
            int subsampleDataLength = 6 * subsampleCount;
            this.scratch.reset(subsampleDataLength);
            this.readData(offset, this.scratch.getData(), subsampleDataLength);
            offset += (long)subsampleDataLength;
            this.scratch.setPosition(0);
            for (int i = 0; i < subsampleCount; ++i) {
                clearDataSizes[i] = this.scratch.readUnsignedShort();
                encryptedDataSizes[i] = this.scratch.readUnsignedIntToInt();
            }
        } else {
            clearDataSizes[0] = 0;
            encryptedDataSizes[0] = extrasHolder.size - (int)(offset - extrasHolder.offset);
        }
        TrackOutput.CryptoData cryptoData = Util.castNonNull(extrasHolder.cryptoData);
        cryptoInfo.set(subsampleCount, clearDataSizes, encryptedDataSizes, cryptoData.encryptionKey, cryptoInfo.iv, cryptoData.cryptoMode, cryptoData.encryptedBlocks, cryptoData.clearBlocks);
        int bytesRead = (int)(offset - extrasHolder.offset);
        extrasHolder.offset += (long)bytesRead;
        extrasHolder.size -= bytesRead;
    }

    private void readData(long absolutePosition, ByteBuffer target, int length) {
        int toCopy;
        this.advanceReadTo(absolutePosition);
        for (int remaining = length; remaining > 0; remaining -= toCopy) {
            toCopy = Math.min(remaining, (int)(this.readAllocationNode.endPosition - absolutePosition));
            Allocation allocation = this.readAllocationNode.allocation;
            target.put(allocation.data, this.readAllocationNode.translateOffset(absolutePosition), toCopy);
            if ((absolutePosition += (long)toCopy) != this.readAllocationNode.endPosition) continue;
            this.readAllocationNode = this.readAllocationNode.next;
        }
    }

    private void readData(long absolutePosition, byte[] target, int length) {
        int toCopy;
        this.advanceReadTo(absolutePosition);
        for (int remaining = length; remaining > 0; remaining -= toCopy) {
            toCopy = Math.min(remaining, (int)(this.readAllocationNode.endPosition - absolutePosition));
            Allocation allocation = this.readAllocationNode.allocation;
            System.arraycopy(allocation.data, this.readAllocationNode.translateOffset(absolutePosition), target, length - remaining, toCopy);
            if ((absolutePosition += (long)toCopy) != this.readAllocationNode.endPosition) continue;
            this.readAllocationNode = this.readAllocationNode.next;
        }
    }

    private void advanceReadTo(long absolutePosition) {
        while (absolutePosition >= this.readAllocationNode.endPosition) {
            this.readAllocationNode = this.readAllocationNode.next;
        }
    }

    private void clearAllocationNodes(AllocationNode fromNode) {
        if (!fromNode.wasInitialized) {
            return;
        }
        int allocationCount = (this.writeAllocationNode.wasInitialized ? 1 : 0) + (int)(this.writeAllocationNode.startPosition - fromNode.startPosition) / this.allocationLength;
        Allocation[] allocationsToRelease = new Allocation[allocationCount];
        AllocationNode currentNode = fromNode;
        for (int i = 0; i < allocationsToRelease.length; ++i) {
            allocationsToRelease[i] = currentNode.allocation;
            currentNode = currentNode.clear();
        }
        this.allocator.release(allocationsToRelease);
    }

    private int preAppend(int length) {
        if (!this.writeAllocationNode.wasInitialized) {
            this.writeAllocationNode.initialize(this.allocator.allocate(), new AllocationNode(this.writeAllocationNode.endPosition, this.allocationLength));
        }
        return Math.min(length, (int)(this.writeAllocationNode.endPosition - this.totalBytesWritten));
    }

    private void postAppend(int length) {
        this.totalBytesWritten += (long)length;
        if (this.totalBytesWritten == this.writeAllocationNode.endPosition) {
            this.writeAllocationNode = this.writeAllocationNode.next;
        }
    }

    private static final class AllocationNode {
        public final long startPosition;
        public final long endPosition;
        public boolean wasInitialized;
        @Nullable
        public Allocation allocation;
        @Nullable
        public AllocationNode next;

        public AllocationNode(long startPosition, int allocationLength) {
            this.startPosition = startPosition;
            this.endPosition = startPosition + (long)allocationLength;
        }

        public void initialize(Allocation allocation, AllocationNode next) {
            this.allocation = allocation;
            this.next = next;
            this.wasInitialized = true;
        }

        public int translateOffset(long absolutePosition) {
            return (int)(absolutePosition - this.startPosition) + this.allocation.offset;
        }

        public AllocationNode clear() {
            this.allocation = null;
            AllocationNode temp = this.next;
            this.next = null;
            return temp;
        }
    }
}

