/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.analytics.comscorestreamsense;

import android.content.Context;
import com.akamai.amp.analytics.comscorestreamsense.AmpComscoreStreamsenseAnalyticsTracker;
import com.akamai.amp.analytics.comscorestreamsense.StreamsenseEventsHandler;
import com.akamai.amp.analytics.comscorestreamsense.UserConsent;
import com.akamai.amp.config.data.streamsense.StreamsenseAppData;
import com.akamai.amp.config.data.streamsense.StreamsenseData;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.utils.LogManager;
import com.comscore.Analytics;
import com.comscore.ClientConfiguration;
import com.comscore.PublisherConfiguration;
import java.util.Map;

public class ComscoreStreamsense {
    private static final String LOG_TAG = "AMPComscoreStreamsense";
    private static long SHORT_LONG_FORM_LIMIT_MILLIS = 900000L;
    static boolean appInitDone = false;

    public static AmpComscoreStreamsenseAnalyticsTracker create(StreamsenseData data) {
        return new StreamsenseEventsHandler(data);
    }

    public static AmpComscoreStreamsenseAnalyticsTracker create(VideoPlayerView videoPlayerView, StreamsenseData data) {
        return new StreamsenseEventsHandler(videoPlayerView, data);
    }

    public static void onApplicationCreate(StreamsenseAppData appData, Context context) {
        ComscoreStreamsense.onApplicationCreate(appData, context, UserConsent.NO_ACTION);
    }

    public static void onApplicationCreate(StreamsenseAppData appData, Context context, UserConsent userConsent) {
        LogManager.log((String)LOG_TAG, (String)"Invoked ComscoreStreamsense.onApplicationCreate()");
        LogManager.log((String)LOG_TAG, (String)("Using StreamsenseAppData " + appData));
        LogManager.log((String)LOG_TAG, (String)("Setting UserConsent " + (Object)((Object)userConsent)));
        Map<String, String> persistentLabels = StreamsenseEventsHandler.buildUserConsentPersistentLabels(userConsent);
        PublisherConfiguration config = ((PublisherConfiguration.Builder)new PublisherConfiguration.Builder().publisherId(appData.getPublisherId()).persistentLabels(persistentLabels)).build();
        Analytics.getConfiguration().addClient((ClientConfiguration)config);
        Analytics.getConfiguration().setApplicationName(appData.getAppName());
        Analytics.getConfiguration().setApplicationVersion(appData.getAppVersion());
        if (LogManager.isLogEnabled()) {
            Analytics.getConfiguration().enableImplementationValidationMode();
        }
        Analytics.start((Context)context);
        appInitDone = true;
        LogManager.log((String)LOG_TAG, (String)("Called com.comscore.Analytics.start() with context " + context));
    }

    public static long getShortLongFormLimitInMillis() {
        return SHORT_LONG_FORM_LIMIT_MILLIS;
    }

    public static void setShortLongFormLimitInMillis(long param) {
        SHORT_LONG_FORM_LIMIT_MILLIS = param;
    }
}

