/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.media.audio;

import android.content.Context;
import android.media.AudioManager;
import com.akamai.amp.utils.LogManager;

public class AudioFocusManager {
    private static final String TAG = "AudioFocusManager";
    private AudioManager audioManager;
    private boolean isAudioFocusGranted = false;
    private boolean isAudioFocusRequested = false;
    private AudioManager.OnAudioFocusChangeListener audioFocusChangeListener;

    public AudioFocusManager(Context ctx) {
        this.audioManager = (AudioManager)ctx.getSystemService("audio");
    }

    public void requestAudioFocus(AudioManager.OnAudioFocusChangeListener audioFocusChangeListener) {
        if (!this.isAudioFocusGranted) {
            this.isAudioFocusRequested = true;
            this.audioFocusChangeListener = audioFocusChangeListener;
            int result = this.audioManager.requestAudioFocus(this.audioFocusChangeListener, 3, 1);
            if (result == 1) {
                this.isAudioFocusGranted = true;
                LogManager.log(TAG, "requestAudioFocus() AUDIOFOCUS_REQUEST_GRANTED");
            } else if (result == 0) {
                this.isAudioFocusGranted = false;
                LogManager.log(TAG, "requestAudioFocus() AUDIOFOCUS_REQUEST_FAILED");
            }
        }
    }

    public void abandonAudioFocus() {
        this.audioManager.abandonAudioFocus(this.audioFocusChangeListener);
        this.audioFocusChangeListener = null;
        this.isAudioFocusGranted = false;
        this.isAudioFocusRequested = false;
        LogManager.log(TAG, "abandonAudioFocus()");
    }

    public boolean isAudioFocusGranted() {
        return this.isAudioFocusGranted;
    }

    public boolean isAudioFocusRequested() {
        return this.isAudioFocusRequested;
    }

    public void setAudioFocusGranted(boolean audioFocusGranted) {
        this.isAudioFocusGranted = audioFocusGranted;
    }
}

