/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.video.spherical;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.BaseRenderer;
import com.akamai.amp.exoplayer2.ExoPlaybackException;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.FormatHolder;
import com.akamai.amp.exoplayer2.RendererCapabilities;
import com.akamai.amp.exoplayer2.decoder.DecoderInputBuffer;
import com.akamai.amp.exoplayer2.util.ParsableByteArray;
import com.akamai.amp.exoplayer2.util.Util;
import com.akamai.amp.exoplayer2.video.spherical.CameraMotionListener;
import java.nio.ByteBuffer;

public final class CameraMotionRenderer
extends BaseRenderer {
    private static final String TAG = "CameraMotionRenderer";
    private static final int SAMPLE_WINDOW_DURATION_US = 100000;
    private final DecoderInputBuffer buffer = new DecoderInputBuffer(1);
    private final ParsableByteArray scratch = new ParsableByteArray();
    private long offsetUs;
    @Nullable
    private CameraMotionListener listener;
    private long lastTimestampUs;

    public CameraMotionRenderer() {
        super(5);
    }

    @Override
    public String getName() {
        return TAG;
    }

    @Override
    public int supportsFormat(Format format) {
        return "application/x-camera-motion".equals(format.sampleMimeType) ? RendererCapabilities.create(4) : RendererCapabilities.create(0);
    }

    @Override
    public void handleMessage(int messageType, @Nullable Object message) throws ExoPlaybackException {
        if (messageType == 7) {
            this.listener = (CameraMotionListener)message;
        } else {
            super.handleMessage(messageType, message);
        }
    }

    @Override
    protected void onStreamChanged(Format[] formats, long startPositionUs, long offsetUs) {
        this.offsetUs = offsetUs;
    }

    @Override
    protected void onPositionReset(long positionUs, boolean joining) {
        this.lastTimestampUs = Long.MIN_VALUE;
        this.resetListener();
    }

    @Override
    protected void onDisabled() {
        this.resetListener();
    }

    @Override
    public void render(long positionUs, long elapsedRealtimeUs) {
        while (!this.hasReadStreamToEnd() && this.lastTimestampUs < positionUs + 100000L) {
            this.buffer.clear();
            FormatHolder formatHolder = this.getFormatHolder();
            int result = this.readSource(formatHolder, this.buffer, false);
            if (result != -4 || this.buffer.isEndOfStream()) {
                return;
            }
            this.lastTimestampUs = this.buffer.timeUs;
            if (this.listener == null || this.buffer.isDecodeOnly()) continue;
            this.buffer.flip();
            float[] rotation = this.parseMetadata(Util.castNonNull(this.buffer.data));
            if (rotation == null) continue;
            Util.castNonNull(this.listener).onCameraMotion(this.lastTimestampUs - this.offsetUs, rotation);
        }
    }

    @Override
    public boolean isEnded() {
        return this.hasReadStreamToEnd();
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Nullable
    private float[] parseMetadata(ByteBuffer data) {
        if (data.remaining() != 16) {
            return null;
        }
        this.scratch.reset(data.array(), data.limit());
        this.scratch.setPosition(data.arrayOffset() + 4);
        float[] result = new float[3];
        for (int i = 0; i < 3; ++i) {
            result[i] = Float.intBitsToFloat(this.scratch.readLittleEndianInt());
        }
        return result;
    }

    private void resetListener() {
        if (this.listener != null) {
            this.listener.onCameraMotionReset();
        }
    }
}

