/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.extractor.mp4;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.extractor.ExtractorInput;
import com.akamai.amp.exoplayer2.extractor.mp4.DefaultSampleValues;
import com.akamai.amp.exoplayer2.extractor.mp4.TrackEncryptionBox;
import com.akamai.amp.exoplayer2.util.ParsableByteArray;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class TrackFragment {
    public @MonotonicNonNull DefaultSampleValues header;
    public long atomPosition;
    public long dataPosition;
    public long auxiliaryDataPosition;
    public int trunCount;
    public int sampleCount;
    public long[] trunDataPosition = new long[0];
    public int[] trunLength = new int[0];
    public int[] sampleSizeTable = new int[0];
    public int[] sampleCompositionTimeOffsetUsTable = new int[0];
    public long[] sampleDecodingTimeUsTable = new long[0];
    public boolean[] sampleIsSyncFrameTable = new boolean[0];
    public boolean definesEncryptionData;
    public boolean[] sampleHasSubsampleEncryptionTable = new boolean[0];
    @Nullable
    public TrackEncryptionBox trackEncryptionBox;
    public final ParsableByteArray sampleEncryptionData = new ParsableByteArray();
    public boolean sampleEncryptionDataNeedsFill;
    public long nextFragmentDecodeTime;
    public boolean nextFragmentDecodeTimeIncludesMoov;

    public void reset() {
        this.trunCount = 0;
        this.nextFragmentDecodeTime = 0L;
        this.nextFragmentDecodeTimeIncludesMoov = false;
        this.definesEncryptionData = false;
        this.sampleEncryptionDataNeedsFill = false;
        this.trackEncryptionBox = null;
    }

    public void initTables(int trunCount, int sampleCount) {
        this.trunCount = trunCount;
        this.sampleCount = sampleCount;
        if (this.trunLength.length < trunCount) {
            this.trunDataPosition = new long[trunCount];
            this.trunLength = new int[trunCount];
        }
        if (this.sampleSizeTable.length < sampleCount) {
            int tableSize = sampleCount * 125 / 100;
            this.sampleSizeTable = new int[tableSize];
            this.sampleCompositionTimeOffsetUsTable = new int[tableSize];
            this.sampleDecodingTimeUsTable = new long[tableSize];
            this.sampleIsSyncFrameTable = new boolean[tableSize];
            this.sampleHasSubsampleEncryptionTable = new boolean[tableSize];
        }
    }

    public void initEncryptionData(int length) {
        this.sampleEncryptionData.reset(length);
        this.definesEncryptionData = true;
        this.sampleEncryptionDataNeedsFill = true;
    }

    public void fillEncryptionData(ExtractorInput input) throws IOException {
        input.readFully(this.sampleEncryptionData.getData(), 0, this.sampleEncryptionData.limit());
        this.sampleEncryptionData.setPosition(0);
        this.sampleEncryptionDataNeedsFill = false;
    }

    public void fillEncryptionData(ParsableByteArray source) {
        source.readBytes(this.sampleEncryptionData.getData(), 0, this.sampleEncryptionData.limit());
        this.sampleEncryptionData.setPosition(0);
        this.sampleEncryptionDataNeedsFill = false;
    }

    public long getSamplePresentationTimeUs(int index) {
        return this.sampleDecodingTimeUsTable[index] + (long)this.sampleCompositionTimeOffsetUsTable[index];
    }

    public boolean sampleHasSubsampleEncryptionTable(int index) {
        return this.definesEncryptionData && this.sampleHasSubsampleEncryptionTable[index];
    }
}

