/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.va.simple;

import com.adobe.primetime.va.plugins.videoplayer.AdBreakInfo;
import com.adobe.primetime.va.plugins.videoplayer.AdInfo;
import com.adobe.primetime.va.plugins.videoplayer.ChapterInfo;
import com.adobe.primetime.va.plugins.videoplayer.QoSInfo;
import com.adobe.primetime.va.plugins.videoplayer.VideoInfo;
import com.adobe.primetime.va.simple.MediaHeartbeat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaObject {
    private static String MEDIAINFO_KEY_NAME = "name";
    private static String MEDIAINFO_KEY_VIDEOID = "videoId";
    private static String MEDIAINFO_KEY_ADID = "adId";
    private static String MEDIAINFO_KEY_LENGTH = "length";
    private static String MEDIAINFO_KEY_PLAYHEAD = "playhead";
    private static String MEDIAINFO_KEY_STREAMTYPE = "streamType";
    private static String MEDIAINFO_KEY_MEDIATYPE = "mediaType";
    private static String MEDIAINFO_KEY_POSITION = "position";
    private static String MEDIAINFO_KEY_STARTTIME = "startTime";
    private static String MEDIAINFO_KEY_BITRATE = "bitrate";
    private static String MEDIAINFO_KEY_FPS = "fps";
    private static String MEDIAINFO_KEY_DROPPEDFRAMES = "droppedFrames";
    private static String MEDIAINFO_KEY_STARTUPTIME = "startupTime";
    private static String MEDIAINFO_KEY_TIMEDMETADATA = "timedMetadata";
    private Map<String, Object> _valueDictionary = new HashMap<String, Object>();
    private static String[] keys = new String[]{MEDIAINFO_KEY_NAME, MEDIAINFO_KEY_VIDEOID, MEDIAINFO_KEY_ADID, MEDIAINFO_KEY_LENGTH, MEDIAINFO_KEY_PLAYHEAD, MEDIAINFO_KEY_STREAMTYPE, MEDIAINFO_KEY_POSITION, MEDIAINFO_KEY_STARTTIME, MEDIAINFO_KEY_BITRATE, MEDIAINFO_KEY_FPS, MEDIAINFO_KEY_DROPPEDFRAMES, MEDIAINFO_KEY_DROPPEDFRAMES, MEDIAINFO_KEY_STARTUPTIME, MEDIAINFO_KEY_TIMEDMETADATA};

    public void setValue(String key, Object value) {
        if (key != null && value != null) {
            this._valueDictionary.put(key, value);
        }
    }

    public Object getValue(String key) {
        return key != null ? this._valueDictionary.get(key) : null;
    }

    public Set<String> allKeys() {
        return this._valueDictionary != null ? this._valueDictionary.keySet() : null;
    }

    static MediaObject mediaInfoForVideo(String name, String mediaId, Double length, String streamType, MediaHeartbeat.MediaType mediaType) {
        MediaObject videoInfo = new MediaObject();
        videoInfo.setValue(MEDIAINFO_KEY_VIDEOID, mediaId);
        videoInfo.setValue(MEDIAINFO_KEY_NAME, name);
        videoInfo.setValue(MEDIAINFO_KEY_LENGTH, length);
        videoInfo.setValue(MEDIAINFO_KEY_PLAYHEAD, 0.0);
        String sType = streamType != null ? streamType : "vod";
        videoInfo.setValue(MEDIAINFO_KEY_STREAMTYPE, sType);
        String mType = mediaType == MediaHeartbeat.MediaType.Audio ? "audio" : "video";
        videoInfo.setValue(MEDIAINFO_KEY_MEDIATYPE, mType);
        return videoInfo;
    }

    static MediaObject mediaInfoForAdBreak(String name, Long position, Double startTime) {
        MediaObject adBreakInfo = new MediaObject();
        adBreakInfo.setValue(MEDIAINFO_KEY_NAME, name);
        adBreakInfo.setValue(MEDIAINFO_KEY_POSITION, position);
        adBreakInfo.setValue(MEDIAINFO_KEY_STARTTIME, startTime);
        return adBreakInfo;
    }

    static MediaObject mediaInfoForAd(String name, String adId, Long position, Double length) {
        MediaObject adInfo = new MediaObject();
        adInfo.setValue(MEDIAINFO_KEY_NAME, name);
        adInfo.setValue(MEDIAINFO_KEY_ADID, adId);
        adInfo.setValue(MEDIAINFO_KEY_POSITION, position);
        adInfo.setValue(MEDIAINFO_KEY_LENGTH, length);
        return adInfo;
    }

    static MediaObject mediaInfoForChapter(String name, Long position, Double length, Double startTime) {
        MediaObject chapterInfo = new MediaObject();
        chapterInfo.setValue(MEDIAINFO_KEY_NAME, name);
        chapterInfo.setValue(MEDIAINFO_KEY_POSITION, position);
        chapterInfo.setValue(MEDIAINFO_KEY_LENGTH, length);
        chapterInfo.setValue(MEDIAINFO_KEY_STARTTIME, startTime);
        return chapterInfo;
    }

    static MediaObject mediaInfoForQoS(Long bitrate, Double startupTime, Double fps, Long droppedFrames) {
        MediaObject qoSInfo = new MediaObject();
        qoSInfo.setValue(MEDIAINFO_KEY_BITRATE, bitrate);
        qoSInfo.setValue(MEDIAINFO_KEY_FPS, fps);
        qoSInfo.setValue(MEDIAINFO_KEY_DROPPEDFRAMES, droppedFrames);
        qoSInfo.setValue(MEDIAINFO_KEY_STARTUPTIME, startupTime);
        return qoSInfo;
    }

    static MediaObject mediaInfoForTimedMetadata(String metadata) {
        MediaObject timedMetadataObject = new MediaObject();
        timedMetadataObject.setValue(MEDIAINFO_KEY_TIMEDMETADATA, metadata);
        return timedMetadataObject;
    }

    VideoInfo createVideoInfo() {
        VideoInfo videoInfo = new VideoInfo();
        videoInfo.id = this.getValue(MEDIAINFO_KEY_VIDEOID) != null ? this.getValue(MEDIAINFO_KEY_VIDEOID).toString() : "";
        videoInfo.name = this.getValue(MEDIAINFO_KEY_NAME) != null ? this.getValue(MEDIAINFO_KEY_NAME).toString() : "";
        videoInfo.length = this.getValue(MEDIAINFO_KEY_LENGTH) != null ? (Double)this.getValue(MEDIAINFO_KEY_LENGTH) : 0.0;
        videoInfo.playhead = this.getValue(MEDIAINFO_KEY_PLAYHEAD) != null ? (Double)this.getValue(MEDIAINFO_KEY_PLAYHEAD) : 0.0;
        videoInfo.streamType = this.getValue(MEDIAINFO_KEY_STREAMTYPE) != null ? this.getValue(MEDIAINFO_KEY_STREAMTYPE).toString() : "";
        videoInfo.mediaType = this.getValue(MEDIAINFO_KEY_MEDIATYPE) != null ? this.getValue(MEDIAINFO_KEY_MEDIATYPE).toString() : "";
        return videoInfo;
    }

    AdBreakInfo createAdBreakInfo() {
        AdBreakInfo adBreakInfo = new AdBreakInfo();
        adBreakInfo.name = this.getValue(MEDIAINFO_KEY_NAME) != null ? this.getValue(MEDIAINFO_KEY_NAME).toString() : "";
        adBreakInfo.position = this.getValue(MEDIAINFO_KEY_POSITION) != null ? (Long)this.getValue(MEDIAINFO_KEY_POSITION) : 0L;
        adBreakInfo.startTime = this.getValue(MEDIAINFO_KEY_STARTTIME) != null ? (Double)this.getValue(MEDIAINFO_KEY_STARTTIME) : 0.0;
        return adBreakInfo;
    }

    AdInfo createAdInfo() {
        AdInfo adInfo = new AdInfo();
        adInfo.id = this.getValue(MEDIAINFO_KEY_ADID) != null ? this.getValue(MEDIAINFO_KEY_ADID).toString() : "";
        adInfo.name = this.getValue(MEDIAINFO_KEY_NAME) != null ? this.getValue(MEDIAINFO_KEY_NAME).toString() : "";
        adInfo.position = this.getValue(MEDIAINFO_KEY_POSITION) != null ? (Long)this.getValue(MEDIAINFO_KEY_POSITION) : 0L;
        adInfo.length = this.getValue(MEDIAINFO_KEY_LENGTH) != null ? (Double)this.getValue(MEDIAINFO_KEY_LENGTH) : 0.0;
        return adInfo;
    }

    ChapterInfo createChapterInfo() {
        ChapterInfo chapterInfo = new ChapterInfo();
        chapterInfo.name = this.getValue(MEDIAINFO_KEY_NAME) != null ? this.getValue(MEDIAINFO_KEY_NAME).toString() : "";
        chapterInfo.position = this.getValue(MEDIAINFO_KEY_POSITION) != null ? (Long)this.getValue(MEDIAINFO_KEY_POSITION) : 0L;
        chapterInfo.length = this.getValue(MEDIAINFO_KEY_LENGTH) != null ? (Double)this.getValue(MEDIAINFO_KEY_LENGTH) : 0.0;
        chapterInfo.startTime = this.getValue(MEDIAINFO_KEY_STARTTIME) != null ? (Double)this.getValue(MEDIAINFO_KEY_STARTTIME) : 0.0;
        return chapterInfo;
    }

    QoSInfo createQoSInfo() {
        QoSInfo qoSInfo = new QoSInfo();
        qoSInfo.bitrate = this.getValue(MEDIAINFO_KEY_BITRATE) != null ? (Long)this.getValue(MEDIAINFO_KEY_BITRATE) : 0L;
        qoSInfo.fps = this.getValue(MEDIAINFO_KEY_FPS) != null ? (Double)this.getValue(MEDIAINFO_KEY_FPS) : 0.0;
        qoSInfo.droppedFrames = this.getValue(MEDIAINFO_KEY_DROPPEDFRAMES) != null ? (Long)this.getValue(MEDIAINFO_KEY_DROPPEDFRAMES) : 0L;
        qoSInfo.startupTime = this.getValue(MEDIAINFO_KEY_STARTUPTIME) != null ? (Double)this.getValue(MEDIAINFO_KEY_STARTUPTIME) : 0.0;
        return qoSInfo;
    }

    String createTimedMetadata() {
        return this.getValue(MEDIAINFO_KEY_TIMEDMETADATA).toString();
    }

    boolean isEqual(MediaObject obj) {
        if (obj == null) {
            return false;
        }
        for (String key : keys) {
            if (this.getValue(key) == obj.getValue(key)) continue;
            return false;
        }
        return true;
    }
}

