/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.va.plugins.videoplayer;

import com.adobe.primetime.core.ICallback;
import com.adobe.primetime.core.Trigger;
import com.adobe.primetime.core.plugin.BasePlugin;
import com.adobe.primetime.core.plugin.IPluginConfig;
import com.adobe.primetime.core.plugin.PluginManager;
import com.adobe.primetime.va.plugins.videoplayer.AdBreakInfo;
import com.adobe.primetime.va.plugins.videoplayer.AdInfo;
import com.adobe.primetime.va.plugins.videoplayer.ChapterInfo;
import com.adobe.primetime.va.plugins.videoplayer.QoSInfo;
import com.adobe.primetime.va.plugins.videoplayer.VideoInfo;
import com.adobe.primetime.va.plugins.videoplayer.VideoPlayerPluginConfig;
import com.adobe.primetime.va.plugins.videoplayer.VideoPlayerPluginDelegate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class VideoPlayerPlugin
extends BasePlugin {
    private static final String NAME = "player";
    private static final String PLAYER_PLUGIN = "adobe-player";
    private static final String ADOBE_HEARTBEAT_PLUGIN = "adobe-heartbeat";
    private static final String ERROR_SOURCE_APPLICATION = "sourceErrorExternal";
    private static final String ERROR_SOURCE_PLAYER = "sourceErrorSDK";
    public static final String VIDEO_LOAD = "video_load";
    public static final String VIDEO_UNLOAD = "video_unload";
    public static final String VIDEO_START = "video_start";
    public static final String VIDEO_RESUME = "video_resume";
    public static final String VIDEO_COMPLETE = "video_complete";
    public static final String VIDEO_SESSION_END = "video_session_end";
    public static final String VIDEO_SKIP = "video_skip";
    public static final String TIMED_METADATA = "timed_metadata";
    public static final String PLAY = "play";
    public static final String PAUSE = "pause";
    public static final String CONTENT_START = "content_start";
    public static final String AD_START = "ad_start";
    public static final String AD_COMPLETE = "ad_complete";
    public static final String AD_SKIP = "ad_skip";
    private static final String ADBREAK_START = "adbreak_start";
    private static final String ADBREAK_COMPLETE = "adbreak_complete";
    public static final String BUFFER_START = "buffer_start";
    public static final String BUFFER_COMPLETE = "buffer_complete";
    public static final String SEEK_START = "seek_start";
    public static final String SEEK_COMPLETE = "seek_complete";
    public static final String CHAPTER_START = "chapter_start";
    public static final String CHAPTER_COMPLETE = "chapter_complete";
    public static final String CHAPTER_SKIP = "chapter_skip";
    public static final String BITRATE_CHANGE = "bitrate_change";
    public static final String TRACK_ERROR = "track_error";
    public static final String VIDEO_IDLE_START = "video_idle_start";
    public static final String VIDEO_IDLE_RESUME = "video_idle_resume";
    private static final String CLOCK_SERVICE = "service.clock";
    private static final String PLAYER_CLOCK_TICK = "adobe-player.tick";
    private static final String KEY_NAME = "name";
    private static final String KEY_INTERVAL = "interval";
    private static final String KEY_RESET = "reset";
    private static final String CMD_CREATE = "create";
    private static final String CMD_RESUME = "resume";
    private static final String KEY_CALLBACK = "callback";
    private static final String KEY_FILTER_REPORT = "filter_report";
    private static final String KEY_SOURCE = "source";
    private static final String KEY_ERROR_ID = "error_id";
    private VideoPlayerPluginDelegate _delegate;
    private boolean _isTrackingSessionActive;
    private boolean _isTrackingSessionStarted;
    private boolean _isTrackingAdBreak;
    private boolean _isTrackingAd;
    private boolean _contentStarted;
    private boolean _isPaused = true;
    private boolean _isSeeking = false;
    private boolean _isBuffering = false;
    private final double PLAYHEAD_INTERVAL = 1.0;
    private final double AD_TRACKING_INTERVAL = 1.0;
    private final int MAX_STALLED_PLAYHEAD_COUNT = 2;
    private double _previousPlayhead;
    private int _stalledPlayheadCount;
    private boolean _playheadStalled;
    private boolean _videoIdle;
    private boolean _playheadTimerRunning;
    private ICallback _cmdVideoIdleStart = new ICallback(){

        public Object call(Object data) {
            VideoPlayerPlugin.this._logger.info(VideoPlayerPlugin.this._logTag, "#_cmdVideoIdleStart()");
            VideoPlayerPlugin.this._videoIdle = true;
            return null;
        }
    };
    private ICallback _cmdVideoIdleResume = new ICallback(){

        public Object call(Object data) {
            VideoPlayerPlugin.this._logger.info(VideoPlayerPlugin.this._logTag, "#_cmdVideoIdleResume()");
            if (VideoPlayerPlugin.this._videoIdle) {
                VideoPlayerPlugin.this._trigger(VideoPlayerPlugin.VIDEO_START, null);
                VideoPlayerPlugin.this._trigger(VideoPlayerPlugin.VIDEO_RESUME, null);
                ArrayList<String> keys = new ArrayList<String>();
                keys.add("ad.isInAd");
                keys.add("ad.isInAdBreak");
                keys.add("chapter.isInChapter");
                HashMap result = (HashMap)VideoPlayerPlugin.this.resolveData(keys);
                if (result.containsKey("ad.isInAdBreak") && ((Boolean)result.get("ad.isInAdBreak")).booleanValue()) {
                    VideoPlayerPlugin.this._trigger(VideoPlayerPlugin.ADBREAK_START, null);
                    VideoPlayerPlugin.this._isTrackingAdBreak = true;
                }
                if (result.containsKey("ad.isInAd") && ((Boolean)result.get("ad.isInAd")).booleanValue()) {
                    VideoPlayerPlugin.this._trigger(VideoPlayerPlugin.AD_START, null);
                    VideoPlayerPlugin.this._isTrackingAd = true;
                }
                if (result.containsKey("chapter.isInChapter") && ((Boolean)result.get("chapter.isInChapter")).booleanValue()) {
                    VideoPlayerPlugin.this._trigger(VideoPlayerPlugin.CHAPTER_START, null);
                }
                if (VideoPlayerPlugin.this._allowPlayerStateChange()) {
                    VideoPlayerPlugin.this._trigger(VideoPlayerPlugin.PLAY, null);
                }
            }
            VideoPlayerPlugin.this._videoIdle = false;
            return null;
        }
    };
    private final ICallback cacheVideoInfo = new ICallback(){

        public Object call(Object param) {
            HashMap map = (HashMap)param;
            if (map.containsKey("video")) {
                return ((HashMap)param).get("video");
            }
            map.put("video", VideoPlayerPlugin.this._delegate.getVideoInfo());
            VideoPlayerPlugin.this._logger.info(VideoPlayerPlugin.this._logTag, "Data from delegate > VideoInfo: " + map.get("video"));
            return map.get("video");
        }
    };
    private final ICallback cacheAdInfo = new ICallback(){

        public Object call(Object param) {
            HashMap map = (HashMap)param;
            if (map.containsKey("ad")) {
                return map.get("ad");
            }
            map.put("ad", VideoPlayerPlugin.this._delegate.getAdInfo());
            VideoPlayerPlugin.this._logger.info(VideoPlayerPlugin.this._logTag, "Data from delegate > AdInfo: " + map.get("ad"));
            return map.get("ad");
        }
    };
    private final ICallback cacheAdBreakInfo = new ICallback(){

        public Object call(Object param) {
            HashMap map = (HashMap)param;
            if (map.containsKey("pod")) {
                return map.get("pod");
            }
            map.put("pod", VideoPlayerPlugin.this._delegate.getAdBreakInfo());
            VideoPlayerPlugin.this._logger.info(VideoPlayerPlugin.this._logTag, "Data from delegate > AdBreakInfo: " + ((HashMap)param).get("pod"));
            return map.get("pod");
        }
    };
    private final ICallback cacheChapterInfo = new ICallback(){

        public Object call(Object param) {
            HashMap map = (HashMap)param;
            if (map.containsKey("chapter")) {
                return map.get("chapter");
            }
            map.put("chapter", VideoPlayerPlugin.this._delegate.getChapterInfo());
            VideoPlayerPlugin.this._logger.info(VideoPlayerPlugin.this._logTag, "Data from delegate > ChapterInfo: " + ((HashMap)param).get("chapter"));
            return map.get("chapter");
        }
    };
    private final ICallback cacheQoSInfo = new ICallback(){

        public Object call(Object param) {
            HashMap map = (HashMap)param;
            if (map.containsKey("qos")) {
                return ((HashMap)param).get("qos");
            }
            map.put("qos", VideoPlayerPlugin.this._delegate.getQoSInfo());
            VideoPlayerPlugin.this._logger.info(VideoPlayerPlugin.this._logTag, "Data from delegate > QoSInfo: " + ((HashMap)param).get("qos"));
            return map.get("qos");
        }
    };
    private ICallback _onTick = new ICallback(){

        public Object call(Object data) {
            double currentPlayhead;
            if (!VideoPlayerPlugin.this._canProcess()) {
                return null;
            }
            ArrayList<String> keys = new ArrayList<String>();
            keys.add("ad.isInAd");
            keys.add("video.playhead");
            HashMap result = (HashMap)VideoPlayerPlugin.this.resolveData(keys);
            double d = currentPlayhead = result.get("video.playhead") != null ? (Double)result.get("video.playhead") : 0.0;
            if (!VideoPlayerPlugin.this._isTrackingAdBreak) {
                if (currentPlayhead != VideoPlayerPlugin.this._previousPlayhead) {
                    VideoPlayerPlugin.this._trackExitStall();
                } else if (currentPlayhead == VideoPlayerPlugin.this._previousPlayhead) {
                    VideoPlayerPlugin.this._stalledPlayheadCount++;
                    if (VideoPlayerPlugin.this._stalledPlayheadCount == 2 && !VideoPlayerPlugin.this._playheadStalled) {
                        VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "#_playheadTimer calling trackPlayheadStall(), previous: " + VideoPlayerPlugin.this._previousPlayhead + ", current: " + currentPlayhead + ", stalledPlayheadCount: " + VideoPlayerPlugin.this._stalledPlayheadCount + ", playheadStalled: " + VideoPlayerPlugin.this._playheadStalled);
                        VideoPlayerPlugin.this._trackPlayheadStall();
                    }
                }
            } else if (VideoPlayerPlugin.this._playheadStalled) {
                VideoPlayerPlugin.this._trackExitStall();
            }
            if (!VideoPlayerPlugin.this._isTrackingAdBreak) {
                double playDuration = currentPlayhead - VideoPlayerPlugin.this._previousPlayhead;
                if (!(!(playDuration > 0.25) || VideoPlayerPlugin.this._contentStarted || VideoPlayerPlugin.this._isPaused || VideoPlayerPlugin.this._isBuffering || VideoPlayerPlugin.this._isSeeking)) {
                    VideoPlayerPlugin.this._logger.info(VideoPlayerPlugin.this._logTag, "#_playheadTimer playhead progress to: " + String.valueOf(currentPlayhead));
                    VideoPlayerPlugin.this._trigger(VideoPlayerPlugin.CONTENT_START, null);
                    VideoPlayerPlugin.this._contentStarted = true;
                }
                VideoPlayerPlugin.this._previousPlayhead = currentPlayhead;
            }
            return null;
        }
    };

    public VideoPlayerPlugin(VideoPlayerPluginDelegate playerDelegate) {
        super(NAME);
        if (playerDelegate == null) {
            throw new Error("PlayerPluginDelegate cannot be NULL");
        }
        this._delegate = playerDelegate;
        this._isTrackingSessionActive = false;
        this._isTrackingSessionStarted = false;
        this._setupDataResolver();
    }

    public void configure(IPluginConfig configData) {
        if (configData == null) {
            throw new Error("Reference tp the configuration data cannot be NULL.");
        }
        if (!(configData instanceof VideoPlayerPluginConfig)) {
            throw new Error("Expected config data to be instance of VideoPlayerPluginConfig.");
        }
        VideoPlayerPluginConfig cfg = (VideoPlayerPluginConfig)configData;
        if (cfg.debugLogging) {
            this._logger.enable();
        } else {
            this._logger.disable();
        }
        this._logger.debug(this._logTag, "configure(debugLogging=" + cfg.debugLogging + ")");
    }

    public void bootstrap(PluginManager pluginManager) {
        super.bootstrap(pluginManager);
        this._registerCommands();
        this._registerBehaviours();
    }

    public void trackSessionStart() {
        this._logger.info(this._logTag, "#trackSessionStart()");
        if (!this._canProcess()) {
            return;
        }
        if (!this._isTrackingSessionActive) {
            this._logger.warn(this._logTag, "#trackSessionStart() > No active tracking session.");
            return;
        }
        if (this._isTrackingSessionStarted) {
            this._logger.info(this._logTag, "#trackSessionStart() > Tracking session already started.");
            return;
        }
        this._isTrackingSessionStarted = true;
        this._trigger(VIDEO_START, null);
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("video.resumed");
        HashMap result = (HashMap)this.resolveData(keys);
        if (result.containsKey("video.resumed") && ((Boolean)result.get("video.resumed")).booleanValue()) {
            this._trigger(VIDEO_RESUME, null);
        }
    }

    public void trackVideoLoad() {
        this._logger.info(this._logTag, "#trackVideoLoad()");
        if (!this._canProcess()) {
            return;
        }
        this._isPaused = true;
        this._isSeeking = false;
        this._isBuffering = false;
        this._isTrackingAd = false;
        this._isTrackingAdBreak = false;
        this._previousPlayhead = 0.0;
        this._stalledPlayheadCount = 0;
        this._playheadStalled = false;
        this._videoIdle = false;
        this._trigger(VIDEO_LOAD, null);
        this._isTrackingSessionActive = true;
        this._isTrackingSessionStarted = false;
        this._contentStarted = false;
        this._setupPlayheadTimer();
    }

    public void trackVideoUnload() {
        this._logger.info(this._logTag, "#trackVideoUnload()");
        if (!this._canProcess()) {
            return;
        }
        if (!this._isTrackingSessionActive) {
            this._logger.warn(this._logTag, "#trackVideoUnload() > No active tracking session.");
            return;
        }
        this._stopPlayheadTimer();
        this._trigger(VIDEO_UNLOAD, null);
        this._isTrackingSessionActive = false;
        this._isTrackingSessionStarted = false;
        this._contentStarted = false;
    }

    public void trackPlay() {
        this._logger.info(this._logTag, "#trackPlay()");
        if (!this._canProcess()) {
            return;
        }
        if (!this._allowPlayerStateChange()) {
            return;
        }
        if (!this._startSessionIfNeeded("trackPlay")) {
            return;
        }
        this._isPaused = false;
        this._trigger(PLAY, null);
        this._startPlayheadTimer();
    }

    public void trackPause() {
        this._logger.info(this._logTag, "#trackPause()");
        if (!this._canProcess()) {
            return;
        }
        if (!this._startSessionIfNeeded("trackPause")) {
            return;
        }
        if (!this._allowPlayerStateChange()) {
            return;
        }
        this._stopPlayheadTimer();
        HashMap<String, Boolean> eventData = new HashMap<String, Boolean>();
        eventData.put(KEY_FILTER_REPORT, false);
        this._isPaused = true;
        this._trigger(PAUSE, eventData);
    }

    public void trackBufferStart() {
        this._logger.info(this._logTag, "#trackBufferStart()");
        if (!this._canProcess()) {
            return;
        }
        this._isBuffering = true;
        if (!this._startSessionIfNeeded("trackBufferStart")) {
            return;
        }
        if (!this._allowPlayerStateChange()) {
            return;
        }
        this._stopPlayheadTimer();
        this._trigger(BUFFER_START, null);
    }

    public void trackBufferComplete() {
        this._logger.info(this._logTag, "#trackBufferComplete()");
        if (!this._canProcess()) {
            return;
        }
        if (!this._startSessionIfNeeded("trackBufferComplete")) {
            return;
        }
        if (!this._allowPlayerStateChange()) {
            return;
        }
        this._isBuffering = false;
        this._trigger(BUFFER_COMPLETE, null);
        this._startPlayheadTimer();
    }

    public void trackSeekStart() {
        this._logger.info(this._logTag, "#trackSeekStart()");
        if (!this._canProcess()) {
            return;
        }
        if (!this._startSessionIfNeeded("trackSeekStart")) {
            return;
        }
        if (!this._allowPlayerStateChange()) {
            return;
        }
        this._stopPlayheadTimer();
        this._isSeeking = true;
        this._trigger(SEEK_START, null);
    }

    public void trackSeekComplete() {
        this._logger.info(this._logTag, "#trackSeekComplete()");
        if (!this._canProcess()) {
            return;
        }
        this._isSeeking = false;
        if (!this._startSessionIfNeeded("trackSeekComplete")) {
            return;
        }
        if (!this._allowPlayerStateChange()) {
            return;
        }
        this._trigger(SEEK_COMPLETE, null);
        this._startPlayheadTimer();
    }

    public void trackComplete(ICallback completeClb) {
        this.trackComplete(completeClb, true);
    }

    public void trackComplete(ICallback completeClb, boolean videoCompleted) {
        this._logger.info(this._logTag, "#trackComplete()");
        if (!this._canProcess()) {
            return;
        }
        if (!this._startSessionIfNeeded("trackComplete")) {
            return;
        }
        this._stopPlayheadTimer();
        if (this._videoIdle) {
            this._logger.info(this._logTag, "#trackComplete() > Video session is already in Idle State.");
            if (completeClb != null) {
                completeClb.call(this);
            }
            return;
        }
        HashMap<String, ICallback> eventData = new HashMap<String, ICallback>();
        eventData.put(KEY_CALLBACK, completeClb);
        if (videoCompleted) {
            this._trigger(VIDEO_COMPLETE, eventData);
        } else {
            this._trigger(VIDEO_SKIP, null);
            this._trigger(VIDEO_SESSION_END, eventData);
        }
    }

    public void trackTimedMetadata(Object metadata) {
        this._logger.info(this._logTag, "#trackTimedMetadata()");
        if (!this._canProcess()) {
            return;
        }
        if (!this._startSessionIfNeeded("trackTimedMetadata")) {
            return;
        }
        this._trigger(TIMED_METADATA, metadata);
    }

    public void trackChapterStart() {
        this._logger.info(this._logTag, "#trackChapterStart()");
        if (!this._canProcess()) {
            return;
        }
        if (!this._startSessionIfNeeded("trackChapterStart")) {
            return;
        }
        this._trigger(CHAPTER_START, null);
    }

    public void trackChapterComplete() {
        this._logger.info(this._logTag, "#trackChapterComplete()");
        if (!this._canProcess()) {
            return;
        }
        if (!this._startSessionIfNeeded("trackChapterComplete")) {
            return;
        }
        this._trigger(CHAPTER_COMPLETE, null);
    }

    public void trackChapterSkip() {
        this._logger.info(this._logTag, "#trackChapterSkip()");
        if (!this._canProcess()) {
            return;
        }
        if (!this._startSessionIfNeeded("trackChapterSkip")) {
            return;
        }
        this._trigger(CHAPTER_SKIP, null);
    }

    public void trackAdStart() {
        this._logger.info(this._logTag, "#trackAdStart()");
        if (!this._canProcess()) {
            return;
        }
        if (!this._startSessionIfNeeded("trackAdStart")) {
            return;
        }
        this._trigger(AD_START, null);
        this._isTrackingAd = true;
    }

    public void trackAdComplete() {
        this._logger.info(this._logTag, "#trackAdComplete()");
        if (!this._canProcess()) {
            return;
        }
        if (!this._startSessionIfNeeded("trackAdComplete")) {
            return;
        }
        this._trigger(AD_COMPLETE, null);
        this._isTrackingAd = false;
    }

    public void trackAdSkip() {
        this._logger.info(this._logTag, "#trackAdSkip()");
        if (!this._canProcess()) {
            return;
        }
        if (!this._startSessionIfNeeded("trackAdSkip")) {
            return;
        }
        this._trigger(AD_SKIP, null);
        this._isTrackingAd = false;
    }

    public void trackAdBreakStart() {
        this._logger.info(this._logTag, "#trackAdBreakStart()");
        if (!this._canProcess()) {
            return;
        }
        if (!this._startSessionIfNeeded("trackAdBreakStart")) {
            return;
        }
        this._trigger(ADBREAK_START, null);
        this._isTrackingAdBreak = true;
    }

    public void trackAdBreakComplete() {
        this._logger.info(this._logTag, "#trackAdBreakComplete()");
        if (!this._canProcess()) {
            return;
        }
        if (!this._startSessionIfNeeded("trackAdBreakComplete")) {
            return;
        }
        this._trigger(ADBREAK_COMPLETE, null);
        this._isTrackingAdBreak = false;
    }

    public void trackBitrateChange() {
        this._logger.info(this._logTag, "#trackBitrateChange()");
        if (!this._canProcess()) {
            return;
        }
        if (!this._startSessionIfNeeded("trackBitrateChange")) {
            return;
        }
        this._trigger(BITRATE_CHANGE, null);
    }

    public void trackVideoPlayerError(String errorId) {
        this._logger.info(this._logTag, "#trackVideoPlayerError(errorId=" + errorId + ")");
        if (!this._startSessionIfNeeded("trackVideoPlayerError")) {
            return;
        }
        HashMap<String, String> eventData = new HashMap<String, String>();
        eventData.put(KEY_SOURCE, ERROR_SOURCE_PLAYER);
        eventData.put(KEY_ERROR_ID, errorId);
        this._trigger(TRACK_ERROR, eventData);
    }

    public void trackApplicationError(String errorId) {
        this._logger.info(this._logTag, "#trackApplicationError(errorId=" + errorId + ")");
        if (!this._startSessionIfNeeded("trackApplicationError")) {
            return;
        }
        HashMap<String, String> eventData = new HashMap<String, String>();
        eventData.put(KEY_SOURCE, ERROR_SOURCE_APPLICATION);
        eventData.put(KEY_ERROR_ID, errorId);
        this._trigger(TRACK_ERROR, eventData);
    }

    private void _registerCommands() {
        this._pluginManager.comply(this, "handleVideoPlayerTimerTick", this._onTick);
        this._pluginManager.comply(this, "handleVideoIdleStart", this._cmdVideoIdleStart);
        this._pluginManager.comply(this, "handleVideoIdleResume", this._cmdVideoIdleResume);
    }

    private void _registerBehaviours() {
        this._pluginManager.registerBehaviour(new Trigger(CLOCK_SERVICE, PLAYER_CLOCK_TICK), this, "handleVideoPlayerTimerTick", null);
        this._pluginManager.registerBehaviour(new Trigger(ADOBE_HEARTBEAT_PLUGIN, VIDEO_IDLE_START), this, "handleVideoIdleStart", null);
        this._pluginManager.registerBehaviour(new Trigger(ADOBE_HEARTBEAT_PLUGIN, VIDEO_IDLE_RESUME), this, "handleVideoIdleResume", null);
    }

    private void _setupDataResolver() {
        final HashMap<String, ICallback> fnMap = new HashMap<String, ICallback>();
        final HashMap cachedData = new HashMap();
        fnMap.put("video.id", new ICallback(){

            public Object call(Object param) {
                VideoInfo videoInfo = (VideoInfo)VideoPlayerPlugin.this.cacheVideoInfo.call(cachedData);
                String retVal = videoInfo != null ? videoInfo.id : null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving video.id: " + retVal);
                return retVal;
            }
        });
        fnMap.put("video.name", new ICallback(){

            public Object call(Object param) {
                VideoInfo videoInfo = (VideoInfo)VideoPlayerPlugin.this.cacheVideoInfo.call(cachedData);
                String retVal = videoInfo != null ? videoInfo.name : null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving video.name: " + retVal);
                return retVal;
            }
        });
        fnMap.put("video.length", new ICallback(){

            public Object call(Object param) {
                VideoInfo videoInfo = (VideoInfo)VideoPlayerPlugin.this.cacheVideoInfo.call(cachedData);
                Double retVal = videoInfo != null ? videoInfo.length : null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving video.length: " + retVal);
                return retVal;
            }
        });
        fnMap.put("video.playerName", new ICallback(){

            public Object call(Object param) {
                VideoInfo videoInfo = (VideoInfo)VideoPlayerPlugin.this.cacheVideoInfo.call(cachedData);
                String retVal = videoInfo != null ? videoInfo.playerName : null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving video.playerName: " + retVal);
                return retVal;
            }
        });
        fnMap.put("video.mediaType", new ICallback(){

            public Object call(Object param) {
                VideoInfo videoInfo = (VideoInfo)VideoPlayerPlugin.this.cacheVideoInfo.call(cachedData);
                String retVal = videoInfo != null ? videoInfo.mediaType : null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving video.mediaType: " + retVal);
                return retVal;
            }
        });
        fnMap.put("video.streamType", new ICallback(){

            public Object call(Object param) {
                VideoInfo videoInfo = (VideoInfo)VideoPlayerPlugin.this.cacheVideoInfo.call(cachedData);
                String retVal = videoInfo != null ? videoInfo.streamType : null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving video.streamType: " + retVal);
                return retVal;
            }
        });
        fnMap.put("video.playhead", new ICallback(){

            public Object call(Object param) {
                VideoInfo videoInfo = (VideoInfo)VideoPlayerPlugin.this.cacheVideoInfo.call(cachedData);
                Double retVal = videoInfo != null ? videoInfo.playhead : 0.0;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving video.playhead: " + retVal);
                return retVal;
            }
        });
        fnMap.put("video.resumed", new ICallback(){

            public Object call(Object param) {
                VideoInfo videoInfo = (VideoInfo)VideoPlayerPlugin.this.cacheVideoInfo.call(cachedData);
                boolean retVal = videoInfo != null ? videoInfo.resumed : false;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving video.resumed: " + retVal);
                return retVal;
            }
        });
        fnMap.put("video.playheadStalled", new ICallback(){

            public Object call(Object param) {
                return VideoPlayerPlugin.this._playheadStalled;
            }
        });
        fnMap.put("pod.name", new ICallback(){

            public Object call(Object param) {
                AdBreakInfo AdBreakInfo2 = (AdBreakInfo)VideoPlayerPlugin.this.cacheAdBreakInfo.call(cachedData);
                String retVal = AdBreakInfo2 != null ? AdBreakInfo2.name : null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving pod.name: " + retVal);
                return retVal;
            }
        });
        fnMap.put("pod.playerName", new ICallback(){

            public Object call(Object param) {
                AdBreakInfo AdBreakInfo2 = (AdBreakInfo)VideoPlayerPlugin.this.cacheAdBreakInfo.call(cachedData);
                String retVal = AdBreakInfo2 != null ? AdBreakInfo2.playerName : null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving pod.playerName: " + retVal);
                return retVal;
            }
        });
        fnMap.put("pod.position", new ICallback(){

            public Object call(Object param) {
                AdBreakInfo AdBreakInfo2 = (AdBreakInfo)VideoPlayerPlugin.this.cacheAdBreakInfo.call(cachedData);
                Long retVal = AdBreakInfo2 != null ? AdBreakInfo2.position : null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving pod.position: " + retVal);
                return retVal;
            }
        });
        fnMap.put("pod.startTime", new ICallback(){

            public Object call(Object param) {
                AdBreakInfo AdBreakInfo2 = (AdBreakInfo)VideoPlayerPlugin.this.cacheAdBreakInfo.call(cachedData);
                Double retVal = AdBreakInfo2 != null ? AdBreakInfo2.startTime : null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving pod.startTime: " + retVal);
                return retVal;
            }
        });
        fnMap.put("ad.isInAdBreak", new ICallback(){

            public Object call(Object param) {
                AdBreakInfo adBreakInfo = (AdBreakInfo)VideoPlayerPlugin.this.cacheAdBreakInfo.call(cachedData);
                boolean retVal = adBreakInfo != null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving ad.isInAdBreak: " + retVal);
                return retVal;
            }
        });
        fnMap.put("ad.isInAd", new ICallback(){

            public Object call(Object param) {
                AdInfo adInfo = (AdInfo)VideoPlayerPlugin.this.cacheAdInfo.call(cachedData);
                boolean retVal = adInfo != null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving ad.isInAd: " + retVal);
                return retVal;
            }
        });
        fnMap.put("ad.id", new ICallback(){

            public Object call(Object param) {
                AdInfo adInfo = (AdInfo)VideoPlayerPlugin.this.cacheAdInfo.call(cachedData);
                String retVal = adInfo != null ? adInfo.id : null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving ad.id: " + retVal);
                return retVal;
            }
        });
        fnMap.put("ad.name", new ICallback(){

            public Object call(Object param) {
                AdInfo adInfo = (AdInfo)VideoPlayerPlugin.this.cacheAdInfo.call(cachedData);
                String retVal = adInfo != null ? adInfo.name : null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving ad.name: " + retVal);
                return retVal;
            }
        });
        fnMap.put("ad.length", new ICallback(){

            public Object call(Object param) {
                AdInfo adInfo = (AdInfo)VideoPlayerPlugin.this.cacheAdInfo.call(cachedData);
                Double retVal = adInfo != null ? adInfo.length : null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving ad.length: " + retVal);
                return retVal;
            }
        });
        fnMap.put("ad.position", new ICallback(){

            public Object call(Object param) {
                AdInfo adInfo = (AdInfo)VideoPlayerPlugin.this.cacheAdInfo.call(cachedData);
                Long retVal = adInfo != null ? adInfo.position : null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving ad.position: " + retVal);
                return retVal;
            }
        });
        fnMap.put("ad.granularTracking", new ICallback(){

            public Object call(Object param) {
                AdInfo adInfo = (AdInfo)VideoPlayerPlugin.this.cacheAdInfo.call(cachedData);
                boolean retVal = adInfo != null ? adInfo.granularTracking : false;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving ad.granularTracking: " + retVal);
                return retVal;
            }
        });
        fnMap.put("ad.trackingInterval", new ICallback(){

            public Object call(Object param) {
                Double retVal = 1.0;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving ad.trackingInterval: " + retVal);
                return retVal;
            }
        });
        fnMap.put("chapter.isInChapter", new ICallback(){

            public Object call(Object param) {
                ChapterInfo chapterInfo = (ChapterInfo)VideoPlayerPlugin.this.cacheChapterInfo.call(cachedData);
                boolean retVal = chapterInfo != null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving chapter.isInChapter: " + retVal);
                return retVal;
            }
        });
        fnMap.put("chapter.name", new ICallback(){

            public Object call(Object param) {
                ChapterInfo chapterInfo = (ChapterInfo)VideoPlayerPlugin.this.cacheChapterInfo.call(cachedData);
                String retVal = chapterInfo != null ? chapterInfo.name : null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving chapter.name: " + retVal);
                return retVal;
            }
        });
        fnMap.put("chapter.length", new ICallback(){

            public Object call(Object param) {
                ChapterInfo chapterInfo = (ChapterInfo)VideoPlayerPlugin.this.cacheChapterInfo.call(cachedData);
                Double retVal = chapterInfo != null ? chapterInfo.length : null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving chapter.length: " + retVal);
                return retVal;
            }
        });
        fnMap.put("chapter.position", new ICallback(){

            public Object call(Object param) {
                ChapterInfo chapterInfo = (ChapterInfo)VideoPlayerPlugin.this.cacheChapterInfo.call(cachedData);
                Long retVal = chapterInfo != null ? chapterInfo.position : 0L;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving chapter.position: " + retVal);
                return retVal;
            }
        });
        fnMap.put("chapter.startTime", new ICallback(){

            public Object call(Object param) {
                ChapterInfo chapterInfo = (ChapterInfo)VideoPlayerPlugin.this.cacheChapterInfo.call(cachedData);
                Double retVal = chapterInfo != null ? chapterInfo.startTime : null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving chapter.startTime: " + retVal);
                return retVal;
            }
        });
        fnMap.put("qos.bitrate", new ICallback(){

            public Object call(Object param) {
                QoSInfo qosInfo = (QoSInfo)VideoPlayerPlugin.this.cacheQoSInfo.call(cachedData);
                Long retVal = qosInfo != null ? qosInfo.bitrate : null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving qos.bitrate: " + retVal);
                return retVal;
            }
        });
        fnMap.put("qos.fps", new ICallback(){

            public Object call(Object param) {
                QoSInfo qosInfo = (QoSInfo)VideoPlayerPlugin.this.cacheQoSInfo.call(cachedData);
                Double retVal = qosInfo != null ? qosInfo.fps : null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving qos.fps: " + retVal);
                return retVal;
            }
        });
        fnMap.put("qos.droppedFrames", new ICallback(){

            public Object call(Object param) {
                QoSInfo qosInfo = (QoSInfo)VideoPlayerPlugin.this.cacheQoSInfo.call(cachedData);
                Long retVal = qosInfo != null ? qosInfo.droppedFrames : null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving qos.droppedFrames: " + retVal);
                return retVal;
            }
        });
        fnMap.put("qos.startupTime", new ICallback(){

            public Object call(Object param) {
                QoSInfo qosInfo = (QoSInfo)VideoPlayerPlugin.this.cacheQoSInfo.call(cachedData);
                Double retVal = qosInfo != null ? Double.valueOf(qosInfo.startupTime * 1000.0) : null;
                VideoPlayerPlugin.this._logger.debug(VideoPlayerPlugin.this._logTag, "Resolving qos.startupTime: " + retVal);
                return retVal;
            }
        });
        this._dataResolver = new ICallback(){

            public Object call(Object param) {
                ArrayList keys = (ArrayList)param;
                if (keys == null || keys.size() == 0) {
                    return null;
                }
                cachedData.clear();
                HashMap<String, Object> _result = new HashMap<String, Object>();
                Iterator iterator = keys.iterator();
                while (iterator.hasNext()) {
                    String key;
                    _result.put(key, fnMap.containsKey(key = (String)iterator.next()) ? ((ICallback)fnMap.get(key)).call(this) : null);
                }
                return _result;
            }
        };
    }

    private boolean _startSessionIfNeeded(String methodName) {
        if (!this._isTrackingSessionActive) {
            this._logger.warn(this._logTag, "#" + methodName + "() > No active tracking session.");
            return false;
        }
        if (!this._isTrackingSessionStarted) {
            this._logger.info(this._logTag, "#" + methodName + "() > Tracking session auto-start.");
            this.trackSessionStart();
        }
        return true;
    }

    private boolean _allowPlayerStateChange() {
        if (this._isTrackingAdBreak && !this._isTrackingAd) {
            this._logger.info(this._logTag, "_allowPlayerStateChange Player plugin does not allow player state changes when in Adbreak and not in Ad.");
            return false;
        }
        return true;
    }

    private void _setupPlayheadTimer() {
        this._previousPlayhead = 0.0;
        this._stalledPlayheadCount = 0;
        this._playheadStalled = false;
        this._playheadTimerRunning = false;
        this._resetTimer();
    }

    private void _resetTimer() {
        this._logger.debug(this._logTag, "_resetTimer().");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(KEY_NAME, PLAYER_PLUGIN);
        params.put(KEY_INTERVAL, 1.0);
        this._pluginManager.command(CLOCK_SERVICE, CMD_CREATE, params);
    }

    private void _resumeTimer() {
        this._logger.debug(this._logTag, "_resumeTimer().");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(KEY_NAME, PLAYER_PLUGIN);
        params.put(KEY_RESET, true);
        this._pluginManager.command(CLOCK_SERVICE, CMD_RESUME, params);
    }

    protected void _teardown() {
        this._pluginManager.off("*", null, null, this);
    }

    private void _trackPlayheadStall() {
        if (!this._canProcess()) {
            return;
        }
        if (!this._playheadStalled) {
            this._logger.debug(this._logTag, "#_trackPlayheadStall(), _playheadStalled: " + this._playheadStalled);
            this._stalledPlayheadCount = 0;
            this._playheadStalled = true;
            this._trigger(PAUSE, null);
        }
    }

    private void _trackExitStall() {
        if (!this._canProcess()) {
            return;
        }
        if (!(this._isPaused || this._isBuffering || this._isSeeking)) {
            this._stalledPlayheadCount = 0;
            if (this._playheadStalled) {
                this._logger.debug(this._logTag, "#_trackExitStall calling explicit Play, previous: " + this._previousPlayhead + ", stalledPlayheadCount: " + this._stalledPlayheadCount + ", playheadStalled: " + this._playheadStalled);
                this._playheadStalled = false;
                this._trigger(PLAY, null);
            }
        }
    }

    private void _startPlayheadTimer() {
        this._logger.debug(this._logTag, "#_startPlayheadTimer(), playheadTimerRunning: " + this._playheadTimerRunning);
        if (this._playheadTimerRunning) {
            return;
        }
        if (!(this._isPaused || this._isBuffering || this._isSeeking)) {
            this._playheadStalled = false;
            this._playheadTimerRunning = true;
            this._resumeTimer();
        }
    }

    private void _stopPlayheadTimer() {
        this._logger.debug(this._logTag, "#_stopPlayheadTimer(), playheadTimerRunning: " + this._playheadTimerRunning);
        if (!this._playheadTimerRunning) {
            return;
        }
        this._resetTimer();
        this._playheadTimerRunning = false;
        this._trackExitStall();
    }
}

