/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.core.radio;

import com.adobe.primetime.core.ICallback;
import com.adobe.primetime.core.radio.Command;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CommandQueue {
    private final long _delay;
    private final ExecutorService _executorService;
    private boolean _isSuspended = false;
    private boolean _drainInProgress = false;
    private List<Command> _queue = new ArrayList<Command>();

    public CommandQueue() {
        this(0L, false);
    }

    public CommandQueue(boolean suspended) {
        this(0L, suspended);
    }

    public CommandQueue(long delay, boolean suspended) {
        this._delay = delay;
        this._isSuspended = suspended;
        this._executorService = Executors.newSingleThreadExecutor();
    }

    public synchronized void addCommand(Command command) {
        this._queue.add(command);
        this._drain();
    }

    public synchronized void cancelAllCommands() {
        this._queue.clear();
    }

    public synchronized boolean isEmpty() {
        return this._queue.isEmpty();
    }

    public synchronized void suspend() {
        this._isSuspended = true;
    }

    public synchronized boolean isSuspended() {
        return this._isSuspended;
    }

    public synchronized void resume() {
        this._isSuspended = false;
        this._drain();
    }

    public synchronized void destroy() {
        this._executorService.shutdownNow();
    }

    private void _drain() {
        if (this._isSuspended) {
            return;
        }
        if (this._drainInProgress) {
            return;
        }
        this._drainInProgress = true;
        this.__drain();
    }

    private void __drain() {
        if (this._queue.size() == 0) {
            this._drainInProgress = false;
        } else {
            Command command = this._queue.get(0);
            this._queue.remove(0);
            this._runCommand(command, new ICallback(){

                public Object call(Object param) {
                    if (CommandQueue.this._isSuspended) {
                        return null;
                    }
                    CommandQueue.this.__drain();
                    return null;
                }
            });
        }
    }

    private synchronized void _runCommand(Command command, ICallback done) {
        if (this._delay != 0L) {
            this._executorService.submit(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(CommandQueue.this._delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
        }
        this._executorService.submit(command);
        if (done != null) {
            done.call(null);
        }
    }
}

