/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.core.plugin;

import com.adobe.primetime.core.Trigger;
import com.adobe.primetime.core.plugin.IPlugin;
import com.adobe.primetime.core.plugin.ParamMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Behaviour {
    private IPlugin _plugin;
    private Trigger _trigger;
    private String _action;
    private Map<String, ParamMapping> _paramMappings;

    public Behaviour(Trigger trigger, IPlugin targetPlugin, String targetAction, ArrayList<ParamMapping> params) {
        this._trigger = trigger;
        this._action = targetAction;
        this._paramMappings = new HashMap<String, ParamMapping>();
        this._plugin = targetPlugin;
        this.mergeParams(params);
    }

    public Trigger getTrigger() {
        return this._trigger;
    }

    public String getAction() {
        return this._action;
    }

    public IPlugin getPlugin() {
        return this._plugin;
    }

    public void mergeParams(ArrayList<ParamMapping> params) {
        if (params == null) {
            return;
        }
        for (ParamMapping paramMapping : params) {
            this._paramMappings.put(paramMapping.getKeyName(), paramMapping);
        }
    }

    public ArrayList<ParamMapping> getParams() {
        ArrayList<ParamMapping> retVal = new ArrayList<ParamMapping>(this._paramMappings.values());
        for (ParamMapping param : this._paramMappings.values()) {
            retVal.add(param);
        }
        return retVal;
    }

    public void addParam(ParamMapping paramMapping) {
        if (paramMapping != null) {
            this._paramMappings.put(paramMapping.getKeyName(), paramMapping);
        }
    }

    public void removeParam(String pluginName, String key) {
        ParamMapping paramMapping = new ParamMapping(pluginName, key, null);
        if (this._paramMappings.containsKey(paramMapping.getKeyName())) {
            this._paramMappings.remove(paramMapping.getKeyName());
        }
    }
}

