/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.core.plugin;

import com.adobe.primetime.core.Event;
import com.adobe.primetime.core.ICallback;
import com.adobe.primetime.core.ILogger;
import com.adobe.primetime.core.Logger;
import com.adobe.primetime.core.Trigger;
import com.adobe.primetime.core.plugin.IPlugin;
import com.adobe.primetime.core.plugin.IPluginConfig;
import com.adobe.primetime.core.plugin.PluginManager;
import com.adobe.primetime.va.ErrorInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasePlugin
implements IPlugin {
    public static final String STATE_PLUGIN = "state";
    public static final String ERROR_INFO = "error_info";
    protected static final String INITIALIZED = "initialized";
    protected String _logTag;
    protected ILogger _logger;
    protected String _name;
    protected Object _dataResolver;
    protected PluginManager _pluginManager;
    protected boolean _isDestroyed;
    protected boolean _isEnabled;
    protected boolean _isInitialized;

    public BasePlugin(String name) {
        this._name = name;
        this._isInitialized = false;
        this._isDestroyed = false;
        this._isEnabled = true;
        this._dataResolver = new HashMap();
        this._logTag = this.getClass().getSimpleName();
        this._logger = new Logger();
    }

    @Override
    public void configure(IPluginConfig pluginConfig) {
    }

    @Override
    public void bootstrap(PluginManager pluginManager) {
        this._pluginManager = pluginManager;
        if (this._isDestroyed) {
            this._pluginManager.raise(new ErrorInfo("Invalid State.", "Plugin already destroyed."));
        }
    }

    @Override
    public void setup() {
        this._isInitialized = true;
        this._trigger(INITIALIZED, null);
    }

    @Override
    public void destroy() {
        if (this._isDestroyed) {
            return;
        }
        this._isDestroyed = true;
        this._teardown();
    }

    @Override
    public void enable() {
        this._isEnabled = true;
        this._enabled();
    }

    @Override
    public void disable() {
        this._isEnabled = false;
        this._disabled();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public boolean isInitialized() {
        return this._isInitialized;
    }

    @Override
    public Object resolveData(ArrayList<String> keys) {
        Iterator<String> iterator;
        if (!this._isEnabled || !this._isInitialized) {
            this._logger.warn(this._logTag, "Unable to retrieve plugin data.. Plugin: " + this._name + ". Enabled: " + this._isEnabled + ". Initialized: " + this._isInitialized + ".");
            return null;
        }
        if (this._dataResolver == null) {
            return null;
        }
        if (this._dataResolver instanceof ICallback) {
            return ((ICallback)this._dataResolver).call(keys);
        }
        HashMap<String, Object> result = null;
        if (this._dataResolver instanceof HashMap && (iterator = keys.iterator()).hasNext()) {
            String key = iterator.next();
            Object resolver = ((HashMap)this._dataResolver).get(key);
            result = new HashMap<String, Object>();
            if (resolver instanceof ICallback) {
                return result.put(key, ((ICallback)resolver).call(key));
            }
            HashMap map = (HashMap)this._dataResolver;
            return result.put(key, map.get(key));
        }
        return result;
    }

    public String toString() {
        return "<plugin: " + this._name + ">";
    }

    public Logger getLogger() {
        return (Logger)this._logger;
    }

    protected void _enabled() {
    }

    protected void _disabled() {
    }

    protected void _teardown() {
    }

    protected boolean _canProcess() {
        if (!this._isEnabled) {
            this._logger.error(this._logTag, "#_canProcess() > Plugin disabled.");
            return false;
        }
        if (this._isDestroyed) {
            this._logger.error(this._logTag, "#_canProcess() > Plugin destroyed.");
            return false;
        }
        return true;
    }

    protected void _trigger(String eventName, Object info) {
        Event event = Event.createFromTrigger(new Trigger(this._name, eventName));
        event.setData(info);
        this._pluginManager.trigger(event);
    }
}

