/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.core;

import com.adobe.primetime.core.ILogger;
import com.adobe.primetime.core.Logger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class TLSSocketFactory
extends SSLSocketFactory {
    private static volatile SSLSocketFactory _singleton;
    private static final Object _sslMutex;
    private static volatile boolean _failed;
    private static ILogger _logger;
    private static String _logTag;
    private SSLSocketFactory _delegate;

    private TLSSocketFactory() throws KeyManagementException, NoSuchAlgorithmException {
        _logger = new Logger();
        _logTag = this.getClass().getSimpleName();
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, null, null);
        this._delegate = context.getSocketFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SSLSocketFactory getInstance() {
        if (_singleton == null && !_failed) {
            Object object = _sslMutex;
            synchronized (object) {
                if (_singleton == null) {
                    try {
                        _singleton = new TLSSocketFactory();
                    }
                    catch (Exception e) {
                        _failed = true;
                        _logger.warn(_logTag, "Failed to generate TLSSocketFactory");
                    }
                }
            }
        }
        return _singleton;
    }

    public String[] getDefaultCipherSuites() {
        return this._delegate.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this._delegate.getSupportedCipherSuites();
    }

    public Socket createSocket() throws IOException {
        return this.enableTLSOnSocket(this._delegate.createSocket());
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.enableTLSOnSocket(this._delegate.createSocket(s, host, port, autoClose));
    }

    public Socket createSocket(String host, int port) throws IOException {
        return this.enableTLSOnSocket(this._delegate.createSocket(host, port));
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.enableTLSOnSocket(this._delegate.createSocket(host, port, localHost, localPort));
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.enableTLSOnSocket(this._delegate.createSocket(host, port));
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.enableTLSOnSocket(this._delegate.createSocket(address, port, localAddress, localPort));
    }

    private Socket enableTLSOnSocket(Socket socket) {
        if (socket instanceof SSLSocket) {
            ((SSLSocket)socket).setEnabledProtocols(new String[]{"TLSv1.1", "TLSv1.2"});
        }
        return socket;
    }

    static {
        _sslMutex = new Object();
        _failed = false;
    }
}

