/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.extractor.mkv;

import com.akamai.amp.exoplayer2.extractor.ExtractorInput;
import com.akamai.amp.exoplayer2.util.ParsableByteArray;
import java.io.IOException;

final class Sniffer {
    private static final int SEARCH_LENGTH = 1024;
    private static final int ID_EBML = 440786851;
    private final ParsableByteArray scratch = new ParsableByteArray(8);
    private int peekLength;

    public boolean sniff(ExtractorInput input) throws IOException {
        long inputLength = input.getLength();
        int bytesToSearch = (int)(inputLength == -1L || inputLength > 1024L ? 1024L : inputLength);
        input.peekFully(this.scratch.getData(), 0, 4);
        this.peekLength = 4;
        for (long tag = this.scratch.readUnsignedInt(); tag != 440786851L; tag |= (long)(this.scratch.getData()[0] & 0xFF)) {
            if (++this.peekLength == bytesToSearch) {
                return false;
            }
            input.peekFully(this.scratch.getData(), 0, 1);
            tag = tag << 8 & 0xFFFFFFFFFFFFFF00L;
        }
        long headerSize = this.readUint(input);
        long headerStart = this.peekLength;
        if (headerSize == Long.MIN_VALUE || inputLength != -1L && headerStart + headerSize >= inputLength) {
            return false;
        }
        while ((long)this.peekLength < headerStart + headerSize) {
            long id2 = this.readUint(input);
            if (id2 == Long.MIN_VALUE) {
                return false;
            }
            long size = this.readUint(input);
            if (size < 0L || size > Integer.MAX_VALUE) {
                return false;
            }
            if (size == 0L) continue;
            int sizeInt = (int)size;
            input.advancePeekPosition(sizeInt);
            this.peekLength += sizeInt;
        }
        return (long)this.peekLength == headerStart + headerSize;
    }

    private long readUint(ExtractorInput input) throws IOException {
        input.peekFully(this.scratch.getData(), 0, 1);
        int value = this.scratch.getData()[0] & 0xFF;
        if (value == 0) {
            return Long.MIN_VALUE;
        }
        int mask = 128;
        int length = 0;
        while ((value & mask) == 0) {
            mask >>= 1;
            ++length;
        }
        value &= ~mask;
        input.peekFully(this.scratch.getData(), 1, length);
        for (int i = 0; i < length; ++i) {
            value <<= 8;
            value += this.scratch.getData()[i + 1] & 0xFF;
        }
        this.peekLength += length + 1;
        return value;
    }
}

