/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.core.util;

import com.mux.stats.sdk.core.events.DebugEvent;
import com.mux.stats.sdk.core.events.IEvent;
import com.mux.stats.sdk.core.events.IEventListener;
import com.mux.stats.sdk.muxstats.IDevice;
import com.mux.stats.sdk.muxstats.MuxStats;

public class MuxLogger {
    public static final int LOG_LEVEL_NORMAL = 0;
    public static final int LOG_LEVEL_VERBOSE = 1;
    private static String debug;
    private static IEventListener dispatcher;
    private static Boolean allowLogcat;
    private static int logLevel;

    public static void enable(String debug, IEventListener dispatcher) {
        MuxLogger.debug = debug;
        MuxLogger.dispatcher = dispatcher;
    }

    private static boolean anyEnabled() {
        return debug != null && dispatcher != null;
    }

    private static boolean allLoggingEnabled() {
        return MuxLogger.anyEnabled() && debug.indexOf("all") >= 0;
    }

    private static boolean debugContains(String str) {
        return MuxLogger.anyEnabled() && debug.indexOf(str) >= 0;
    }

    public static void event(String name) {
        if (MuxLogger.allLoggingEnabled() || MuxLogger.debugContains("event")) {
            dispatcher.handle(new DebugEvent("type=event " + name));
        }
    }

    public static void printEvent(String tag, IEvent evnt) {
        if (evnt.getType().equalsIgnoreCase("internalheartbeat") || evnt.getType().equalsIgnoreCase("timeupdate")) {
            return;
        }
        switch (logLevel) {
            case 0: {
                MuxLogger.d(tag, "Sending event: " + evnt.getType());
                break;
            }
            case 1: {
                MuxLogger.d(tag, "Sending event: " + evnt.getType() + "\n" + evnt.getDebugString());
                break;
            }
            default: {
                MuxLogger.d(tag, "Unknown log level: " + logLevel);
            }
        }
    }

    public static void info(String info) {
        if (MuxLogger.allLoggingEnabled() || MuxLogger.debugContains("info")) {
            dispatcher.handle(new DebugEvent("type=info " + info));
        }
    }

    public static void d(String tag, String msg) {
        IDevice device = MuxStats.getHostDevice();
        if (allowLogcat.booleanValue() && device != null) {
            device.outputLog(tag, msg);
        }
    }

    public static void setAllowLogcat(boolean allow) {
        allowLogcat = allow;
    }

    static {
        allowLogcat = false;
        logLevel = 0;
    }
}

