/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.core.trackers;

import com.mux.stats.sdk.core.events.IEventDispatcher;
import com.mux.stats.sdk.core.events.ViewMetricEvent;
import com.mux.stats.sdk.core.events.playback.PlaybackEvent;
import com.mux.stats.sdk.core.model.PlayerData;
import com.mux.stats.sdk.core.model.VideoData;
import com.mux.stats.sdk.core.model.ViewData;
import com.mux.stats.sdk.core.trackers.BaseAdTracker;
import java.util.HashSet;

public class ScalingTracker
extends BaseAdTracker {
    private Long lastPlayheadPosition;
    private Integer lastPlayerWidth;
    private Integer lastPlayerHeight;
    private Integer lastSourceWidth;
    private Integer lastSourceHeight;
    private HashSet<String> calculationEvents = new HashSet();
    private HashSet<String> preparationEvents;
    private long viewTotalContentPlaybackTime = 0L;
    private double viewMaxUpscaling = 0.0;
    private double viewMaxDownscaling = 0.0;
    private double viewTotalUpscaling = 0.0;
    private double viewTotalDownscaling = 0.0;

    public ScalingTracker(IEventDispatcher dispatcher) {
        super(dispatcher);
        this.calculationEvents.add("pause");
        this.calculationEvents.add("rebufferstart");
        this.calculationEvents.add("seeking");
        this.calculationEvents.add("adbreakstart");
        this.calculationEvents.add("timeupdate");
        this.calculationEvents.add("viewend");
        this.calculationEvents.add("error");
        this.preparationEvents = new HashSet();
        this.preparationEvents.add("playing");
        this.preparationEvents.add("timeupdate");
    }

    private void calculate(long playheadTime) {
        if (this.isAdBreak || this.lastPlayheadPosition == null || this.lastPlayerWidth == null || this.lastPlayerHeight == null || this.lastSourceWidth == null || this.lastSourceHeight == null || this.lastPlayerWidth <= 0 || this.lastPlayerHeight <= 0 || this.lastSourceWidth <= 0 || this.lastSourceHeight <= 0) {
            this.lastPlayheadPosition = null;
            return;
        }
        long timeDiff = playheadTime - this.lastPlayheadPosition;
        if (timeDiff < 0L) {
            this.lastPlayheadPosition = null;
            return;
        }
        double widthScaling = (double)this.lastPlayerWidth.intValue() / (double)this.lastSourceWidth.intValue();
        double heightScaling = (double)this.lastPlayerHeight.intValue() / (double)this.lastSourceHeight.intValue();
        double scale = Math.min(widthScaling, heightScaling);
        double upscale = Math.max(0.0, scale - 1.0);
        double downscale = Math.max(0.0, 1.0 - scale);
        this.viewMaxUpscaling = Math.max(this.viewMaxUpscaling, upscale);
        this.viewMaxDownscaling = Math.max(this.viewMaxDownscaling, downscale);
        this.viewTotalContentPlaybackTime += timeDiff;
        this.viewTotalUpscaling += upscale * (double)timeDiff;
        this.viewTotalDownscaling += downscale * (double)timeDiff;
        ViewData viewData = new ViewData();
        viewData.setViewMaxUpscalePercentage(this.viewMaxUpscaling);
        viewData.setViewMaxDownscalePercentage(this.viewMaxDownscaling);
        viewData.setViewTotalContentPlaybackTime(this.viewTotalContentPlaybackTime);
        viewData.setViewTotalUpscaling(this.viewTotalUpscaling);
        viewData.setViewTotalDownscaling(this.viewTotalDownscaling);
        this.dispatch(new ViewMetricEvent(viewData));
        this.lastPlayheadPosition = null;
    }

    private void prepare(PlaybackEvent event) {
        PlayerData playerData = event.getPlayerData();
        this.lastPlayheadPosition = playerData.getPlayerPlayheadTime();
        this.lastPlayerWidth = playerData.getPlayerWidth();
        this.lastPlayerHeight = playerData.getPlayerHeight();
        VideoData videoData = event.getVideoData();
        this.lastSourceWidth = videoData.getVideoSourceWidth();
        this.lastSourceHeight = videoData.getVideoSourceHeight();
    }

    @Override
    protected void handlePlaybackEvent(PlaybackEvent event) {
        PlayerData playerData;
        Long playerPlayheadTime;
        super.handlePlaybackEvent(event);
        if (this.calculationEvents.contains(event.getType()) && (playerPlayheadTime = (playerData = event.getPlayerData()).getPlayerPlayheadTime()) != null) {
            this.calculate(playerPlayheadTime);
        }
        if (this.preparationEvents.contains(event.getType())) {
            this.prepare(event);
        }
    }
}

