/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.core.trackers;

import com.mux.stats.sdk.core.events.IEventDispatcher;
import com.mux.stats.sdk.core.events.ViewMetricEvent;
import com.mux.stats.sdk.core.events.playback.PlaybackEvent;
import com.mux.stats.sdk.core.model.ViewData;
import com.mux.stats.sdk.core.trackers.BaseTracker;
import com.mux.stats.sdk.core.util.MuxLogger;

public class PlaybackTimeTracker
extends BaseTracker {
    private static final String TAG = "PlaybackTimeTracker";
    private static final long MAX_PLAYHEAD_JUMP = 1000L;
    private long lastPlayheadPosition = -1L;
    private long contentPlaybackTime = 0L;

    public PlaybackTimeTracker(IEventDispatcher dispatcher) {
        super(dispatcher);
    }

    private void updatePlaybackTime(long playheadPosition) {
        if (this.lastPlayheadPosition >= 0L && playheadPosition > this.lastPlayheadPosition) {
            long diff = playheadPosition - this.lastPlayheadPosition;
            if (diff <= 1000L) {
                this.contentPlaybackTime += diff;
                ViewData viewData = new ViewData();
                viewData.setViewContentPlaybackTime(this.contentPlaybackTime);
                this.dispatch(new ViewMetricEvent(viewData));
            } else {
                MuxLogger.d(TAG, "Playhead position jump of over 1 seconds detected.");
            }
        }
        this.lastPlayheadPosition = playheadPosition;
    }

    private void clearPlaybackTimeState(long playheadPosition) {
        this.updatePlaybackTime(playheadPosition);
        this.lastPlayheadPosition = -1L;
    }

    @Override
    protected void handlePlaybackEvent(PlaybackEvent event) {
        String eventType = event.getType();
        Long playerPlayheadTime = event.getPlayerData().getPlayerPlayheadTime();
        if (playerPlayheadTime == null) {
            return;
        }
        if (eventType == "internalheartbeat") {
            this.updatePlaybackTime(playerPlayheadTime);
        } else if (eventType == "internalheartbeatend" || eventType == "seeking") {
            this.clearPlaybackTimeState(playerPlayheadTime);
        } else if (eventType == "seeked") {
            this.lastPlayheadPosition = playerPlayheadTime;
        }
    }
}

