/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.core.trackers;

import com.mux.stats.sdk.core.events.IEventDispatcher;
import com.mux.stats.sdk.core.events.playback.InternalHeartbeatEndEvent;
import com.mux.stats.sdk.core.events.playback.InternalHeartbeatEvent;
import com.mux.stats.sdk.core.events.playback.PlaybackEvent;
import com.mux.stats.sdk.core.model.PlayerData;
import com.mux.stats.sdk.core.model.ViewData;
import com.mux.stats.sdk.core.trackers.BaseTracker;

public class InternalHeartbeatTracker
extends BaseTracker {
    private boolean playing = false;

    public InternalHeartbeatTracker(IEventDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void handlePlaybackEvent(PlaybackEvent event) {
        switch (event.getType()) {
            case "timeupdate": {
                if (!this.playing) break;
                this.dispatchInternalHearbeatEvent(event.getPlayerData(), event.getViewData());
                break;
            }
            case "playing": 
            case "adplaying": {
                this.playing = true;
                this.dispatchInternalHearbeatEvent(event.getPlayerData(), event.getViewData());
                break;
            }
            case "play": 
            case "adbreakstart": 
            case "adplay": 
            case "seeking": {
                this.startHeartbeat(event.getPlayerData(), event.getViewData());
                break;
            }
            case "pause": 
            case "ended": 
            case "viewend": 
            case "error": 
            case "adpause": 
            case "adended": 
            case "adbreakend": {
                this.endHeartbeat(event.getPlayerData(), event.getViewData());
                break;
            }
            case "seeked": {
                if (!event.getPlayerData().getPlayerIsPaused().booleanValue()) break;
                this.endHeartbeat(event.getPlayerData(), event.getViewData());
            }
        }
    }

    private void endHeartbeat(PlayerData playerData, ViewData viewData) {
        if (this.playing) {
            this.playing = false;
            InternalHeartbeatEndEvent hbe = new InternalHeartbeatEndEvent(playerData);
            hbe.setViewData(viewData);
            this.dispatch(hbe);
        }
    }

    private void startHeartbeat(PlayerData playerData, ViewData viewData) {
        if (!this.playing) {
            this.playing = true;
            this.dispatchInternalHearbeatEvent(playerData, viewData);
        }
    }

    private void dispatchInternalHearbeatEvent(PlayerData playerData, ViewData viewData) {
        InternalHeartbeatEvent hbe = new InternalHeartbeatEvent(playerData);
        hbe.setViewData(viewData);
        this.dispatch(hbe);
    }
}

