/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.core.events;

import com.mux.stats.sdk.core.events.BaseEvent;
import com.mux.stats.sdk.core.model.BandwidthMetricData;
import com.mux.stats.sdk.core.model.BaseQueryData;
import com.mux.stats.sdk.core.model.CustomerPlayerData;
import com.mux.stats.sdk.core.model.CustomerVideoData;
import com.mux.stats.sdk.core.model.EnvironmentData;
import com.mux.stats.sdk.core.model.PlayerData;
import com.mux.stats.sdk.core.model.VideoData;
import com.mux.stats.sdk.core.model.ViewData;
import com.mux.stats.sdk.core.model.ViewerData;

public class TrackableEvent
extends BaseEvent {
    public static final String TYPE = "TrackableEvent";
    private static final String VIEW_SEQUENCE_NUMBER = "xsqno";
    private String eventType;
    private BaseQueryData query;
    private ViewData viewData;
    private VideoData videoData;
    private CustomerVideoData customerVideoData;
    private PlayerData playerData;
    private CustomerPlayerData customerPlayerData;
    private EnvironmentData environmentData;
    private ViewerData viewerData;
    private BandwidthMetricData bandwidthMetricData;

    @Override
    public String getType() {
        return TYPE;
    }

    public TrackableEvent(String eventType) {
        this.eventType = eventType;
        this.query = new BaseQueryData();
    }

    @Override
    public boolean isTrackable() {
        return true;
    }

    public String getEventType() {
        return this.eventType;
    }

    public BaseQueryData getQuery() {
        return this.query;
    }

    public Integer getViewSequenceNumber() {
        String value = this.query.get(VIEW_SEQUENCE_NUMBER);
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    private void updateQuery(BaseQueryData query) {
        this.query.update(query);
    }

    public ViewData getViewData() {
        return this.viewData;
    }

    public void setViewData(ViewData viewData) {
        this.updateQuery(viewData);
        this.viewData = viewData;
    }

    public VideoData getVideoData() {
        return this.videoData;
    }

    public void setVideoData(VideoData videoData) {
        this.updateQuery(videoData);
        this.videoData = videoData;
    }

    public PlayerData getPlayerData() {
        return this.playerData;
    }

    public void setPlayerData(PlayerData playerData) {
        this.updateQuery(playerData);
        this.playerData = playerData;
    }

    public EnvironmentData getEnvironmentData() {
        return this.environmentData;
    }

    public void setEnvironmentData(EnvironmentData environmentData) {
        this.updateQuery(environmentData);
        this.environmentData = environmentData;
    }

    public ViewerData getViewerData() {
        return this.viewerData;
    }

    public void setViewerData(ViewerData viewerData) {
        this.updateQuery(viewerData);
        this.viewerData = viewerData;
    }

    public String toString() {
        return "TrackableEvent<" + this.eventType + ", " + this.query.toString() + ">";
    }

    public CustomerVideoData getCustomerVideoData() {
        return this.customerVideoData;
    }

    public void setCustomerVideoData(CustomerVideoData customerVideoData) {
        this.updateQuery(customerVideoData);
        this.customerVideoData = customerVideoData;
    }

    public CustomerPlayerData getCustomerPlayerData() {
        return this.customerPlayerData;
    }

    public void setCustomerPlayerData(CustomerPlayerData customerPlayerData) {
        this.updateQuery(customerPlayerData);
        this.customerPlayerData = customerPlayerData;
    }

    public BandwidthMetricData getBandwidthMetricData() {
        return this.bandwidthMetricData;
    }

    public void setBandwidthMetricData(BandwidthMetricData bandwidthMetricData) {
        this.updateQuery(bandwidthMetricData);
        this.bandwidthMetricData = bandwidthMetricData;
    }

    @Override
    public String getDebugString() {
        return "TrackableEvent: " + (this.query != null ? "\n  " + this.query.getDebugString() : "") + (this.viewData != null ? "\n  " + this.viewData.getDebugString() : "") + (this.videoData != null ? "\n  " + this.videoData.getDebugString() : "") + (this.customerVideoData != null ? "\n  " + this.customerVideoData.getDebugString() : "") + (this.playerData != null ? "\n  " + this.playerData.getDebugString() : "") + (this.customerPlayerData != null ? "\n  " + this.customerPlayerData.getDebugString() : "") + (this.environmentData != null ? "\n  " + this.environmentData.getDebugString() : "") + (this.bandwidthMetricData != null ? "\n  " + this.bandwidthMetricData.getDebugString() : "");
    }
}

