/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.core;

import com.mux.stats.sdk.core.model.EnvironmentData;
import com.mux.stats.sdk.core.util.CurrentTime;
import com.mux.stats.sdk.core.util.UUID;

public class Session {
    private static final long TWENTY_FIVE_MINUTES_IN_MS = 1500000L;
    private String id;
    private long start;
    private long expires;
    private CurrentTime currentTime = new CurrentTime();

    public void startSession() {
        this.startSession(this.now());
    }

    private void startSession(long time) {
        this.id = UUID.generateUUID();
        this.start = time;
        this.expires = this.start + 1500000L;
    }

    public void setCurrentTime(CurrentTime currentTime) {
        this.currentTime = currentTime;
    }

    public long now() {
        return this.currentTime.now();
    }

    public void updateEnvironmentData(EnvironmentData environmentData) {
        long time = this.now();
        if (time > this.expires) {
            this.startSession(this.now());
        } else {
            this.expires = time + 1500000L;
        }
        environmentData.setSessionStart(this.start);
        environmentData.setSessionExpires(this.expires);
        environmentData.setSessionId(this.id);
    }
}

