/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.media.hls.httpdownloaders;

import android.os.Build;
import android.util.Log;
import com.akamai.amp.exoplayer2.ampcustom.AMPPreSettings;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.hls.httpdownloaders.Inputs;
import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.Utils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class HttpDownloader<T> {
    private static final String TAG = "HttpDownloader";
    public static Exception latestException;
    HttpURLConnection mConnection = null;
    BufferedInputStream mInputStream = null;
    private long mExpiration = 0L;
    private int mBandwidth = 0;
    private int mLastHttpResponseCode = 0;
    protected boolean mCancel = false;
    private Hashtable<String, String> mCookies = null;
    protected static final int STORE_BUFFER_SIZE = 0x200000;
    protected static final int READ_BUFFER_SIZE = 4096;
    private String mReferer = "";
    private String mProcessedURL = null;
    private boolean mOutOfMemoryRaised = false;

    public abstract T readInputStream(BufferedInputStream var1) throws IOException;

    abstract int getLengthInBytes(T var1);

    abstract String getTag();

    public T loadFile(String path, String rangeHeader, boolean getCookies) {
        latestException = null;
        Inputs inputs = this.checkInputs(path);
        if (inputs == null) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        T result = this.read(inputs, rangeHeader, getCookies, startTime);
        return result;
    }

    private Inputs checkInputs(String path) {
        URL url;
        latestException = null;
        if (path == null || path.length() == 0) {
            Log.e((String)this.getTag(), (String)"URL to download is null or empty");
            return null;
        }
        Log.d((String)this.getTag(), (String)("Downloading file: " + path.substring(path.lastIndexOf(47) + 1)));
        path = this.cleanPath(path);
        String hostHeader = null;
        try {
            url = new URL(path);
            if (Utils.isNonStandardHost(url.getHost())) {
                hostHeader = url.getHost();
                url = Utils.setIPasHost(url);
            }
        }
        catch (Exception e) {
            Log.e((String)this.getTag(), (String)(path + " " + e.getMessage()));
            latestException = e;
            return null;
        }
        return new Inputs(path, url, hostHeader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T read(Inputs input, String rangeHeader, boolean getCookies, long startTime) {
        try {
            latestException = null;
            boolean preRead = this.preProcess(input, rangeHeader);
            if (!preRead) {
                T t = null;
                return t;
            }
            this.mInputStream = new BufferedInputStream(this.mConnection.getInputStream(), 4096);
            T result = this.readInputStream(this.mInputStream);
            if (this.mInputStream != null) {
                this.mInputStream.close();
            }
            if (result == null) {
                T t = null;
                return t;
            }
            long ellapsedTimeMillis = System.currentTimeMillis() - startTime;
            this.postRead(input.getPath(), getCookies, ellapsedTimeMillis, result);
            T t = result;
            return t;
        }
        catch (UnknownHostException e) {
            latestException = e;
            URL url = this.mConnection.getURL();
            if (Utils.isNonStandardHost(url.getHost())) {
                T t = this.loadFile(url.toString(), rangeHeader, getCookies);
                return t;
            }
        }
        catch (IOException e) {
            latestException = e;
            try {
                this.mLastHttpResponseCode = this.mConnection.getResponseCode();
            }
            catch (Exception e1) {
                latestException = e1;
                this.reportException(e1, input.getPath());
            }
            this.reportException(e, input.getPath());
        }
        catch (OutOfMemoryError e) {
            latestException = new RuntimeException(e);
            this.mOutOfMemoryRaised = true;
            this.reportException(e, input.getPath());
        }
        catch (Exception e) {
            latestException = e;
            this.reportException(e, input.getPath());
        }
        finally {
            if (this.mConnection != null && !this.mCancel) {
                this.mConnection.disconnect();
            }
        }
        return null;
    }

    private void reportException(Throwable t, String path) {
        Log.e((String)this.getTag(), (String)(t.getClass().getCanonicalName() + ": " + t));
        Log.e((String)this.getTag(), (String)("Url: " + path));
        t.printStackTrace();
    }

    private void postRead(String path, boolean getCookies, long ellapsedTimeMillis, T baf) {
        this.reportBandwidth(path, ellapsedTimeMillis, baf);
        if (getCookies) {
            this.readCookies(this.mConnection, false, true);
        }
        this.mProcessedURL = this.getProcessedUrl();
        Log.i((String)this.getTag(), (String)("mProcessedURL: " + this.mProcessedURL));
    }

    private String getProcessedUrl() {
        String location;
        if (this.isRedirect(this.mLastHttpResponseCode) && this.hasContent(location = this.mConnection.getHeaderField("Location"))) {
            return location;
        }
        URL url = this.mConnection.getURL();
        return url.toString();
    }

    private boolean hasContent(String s) {
        return s != null && s.trim().length() > 0;
    }

    private boolean isRedirect(int httpResponseCode) {
        return httpResponseCode >= 300 && httpResponseCode < 400;
    }

    private void reportBandwidth(String path, long ellapsedTimeMillis, T object) {
        if (object == null) {
            return;
        }
        int lengthInBytes = this.getLengthInBytes(object);
        if (lengthInBytes <= 0) {
            return;
        }
        this.mBandwidth = this.calculateBandwidth(lengthInBytes, ellapsedTimeMillis);
        String fileName = path.substring(path.lastIndexOf(47) + 1);
        String fileSize = this.prettyPrintFileSize(lengthInBytes);
        Log.d((String)this.getTag(), (String)("Downlad complete. File: " + fileName + ". Size: " + fileSize + ", Bandwidth: " + this.mBandwidth + "KB/s"));
    }

    private String prettyPrintFileSize(int lengthInBytes) {
        if (lengthInBytes > 1024) {
            int fileSize = lengthInBytes / 1024;
            return fileSize + "KB";
        }
        return lengthInBytes + "bytes";
    }

    private int calculateBandwidth(int lengthInBytes, long ellapsedTimeMillis) {
        int lengthInBits = lengthInBytes * 8;
        long bandwidthLong = (long)lengthInBits / ellapsedTimeMillis;
        return (int)bandwidthLong;
    }

    private boolean preProcess(Inputs input, String rangeHeader) throws IOException {
        String userAgent;
        this.mLastHttpResponseCode = 0;
        this.mConnection = (HttpURLConnection)input.getUrl().openConnection();
        Log.d((String)this.getTag(), (String)Utils.getDefaultUserAgent());
        if (input.getHostHeader() != null) {
            this.mConnection.setRequestProperty("Host", input.getHostHeader());
        }
        if (null == (userAgent = AMPPreSettings.getPreSettingsInstance().getUserAgent())) {
            userAgent = Utils.getDefaultUserAgent();
        }
        this.mConnection.setRequestProperty("User-Agent", userAgent);
        if (this.mReferer.length() > 0) {
            this.mConnection.setRequestProperty("Referer", this.mReferer);
        }
        if (rangeHeader != null) {
            this.mConnection.addRequestProperty("Range", rangeHeader);
        }
        if (this.mCookies != null) {
            this.writeCookies(this.mConnection, this.mCookies);
        }
        this.mExpiration = this.mConnection.getExpiration();
        this.mLastHttpResponseCode = this.mConnection.getResponseCode();
        if (this.isError(this.mLastHttpResponseCode)) {
            int index = input.getPath().lastIndexOf(47);
            String path = input.getPath().substring(index + 1);
            Log.e((String)this.getTag(), (String)("Aborting download [HTTP response code " + this.mLastHttpResponseCode + "] for " + path));
            return false;
        }
        return true;
    }

    private boolean isError(int httpResponseCode) {
        return httpResponseCode >= 400 && httpResponseCode < 600;
    }

    private String cleanPath(String path) {
        StringBuilder temp = new StringBuilder(path);
        if (temp.charAt(0) == '\"') {
            temp.deleteCharAt(0);
        }
        if (temp.charAt(temp.length() - 1) == '\"') {
            temp.deleteCharAt(temp.length() - 1);
        }
        path = temp.toString();
        return path;
    }

    public Hashtable<String, String> getCookies() {
        if (!this.mCookies.isEmpty()) {
            return this.mCookies;
        }
        return null;
    }

    public void setCookies(Hashtable<String, String> cookies) {
        this.mCookies = cookies;
    }

    public void writeCookies(HttpURLConnection urlConn, Hashtable<String, String> cookies) {
        String cookieString = "";
        Enumeration<String> keys = cookies.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            cookieString = cookieString + key + "=" + cookies.get(key);
            if (!keys.hasMoreElements()) continue;
            cookieString = cookieString + "; ";
        }
        urlConn.setRequestProperty("Cookie", cookieString);
    }

    public void readCookies(HttpURLConnection urlConn, boolean printCookies, boolean reset) {
        String hdrKey;
        if (this.mCookies == null) {
            this.mCookies = new Hashtable();
        }
        if (reset) {
            this.mCookies.clear();
        }
        int i = 1;
        while ((hdrKey = urlConn.getHeaderFieldKey(i)) != null) {
            if (hdrKey.equals("Set-Cookie")) {
                String aCookie;
                int j;
                String hdrString = urlConn.getHeaderField(i);
                int colonPos = hdrString.indexOf(";");
                if (hdrString != null && colonPos > 0 && (j = (aCookie = hdrString.substring(0, colonPos)).indexOf("=")) != -1 && !this.mCookies.containsKey(aCookie.substring(0, j))) {
                    this.mCookies.put(aCookie.substring(0, j), aCookie.substring(j + 1));
                    if (printCookies) {
                        System.out.println("Reading Key: " + aCookie.substring(0, j));
                        System.out.println("        Val: " + aCookie.substring(j + 1));
                    }
                }
            }
            ++i;
        }
    }

    public boolean getDownloadCanceled() {
        return this.mCancel;
    }

    public void cancelDownload() {
        Log.d((String)this.getTag(), (String)"Cancel download requested");
        this.mCancel = true;
        if (Build.VERSION.SDK_INT <= 20 && this.mInputStream != null) {
            latestException = null;
            try {
                this.mInputStream.close();
                this.mInputStream.notify();
            }
            catch (IOException e) {
                latestException = e;
            }
            catch (Exception e) {
                latestException = e;
            }
            try {
                if (this.mConnection != null) {
                    this.mConnection.disconnect();
                    this.mConnection = null;
                }
            }
            catch (Exception e) {
                latestException = e;
            }
        }
    }

    public void resetCancelDownload() {
        this.mCancel = false;
    }

    public int getLastHttpResponseCode() {
        return this.mLastHttpResponseCode;
    }

    public int getBandwidth() {
        return this.mBandwidth;
    }

    public long getExpiration() {
        return this.mExpiration;
    }

    public void setReferer(String value) {
        this.mReferer = value;
    }

    public String getProcessedURL() {
        return this.mProcessedURL;
    }

    public boolean isOutOfMemoryRaised() {
        return this.mOutOfMemoryRaised;
    }

    public boolean resolveMimeType(MediaResource resource) {
        boolean bRes = true;
        latestException = null;
        try {
            for (int tries = 0; tries < 5; ++tries) {
                String resourceUrl = resource.getResourceUrl();
                HttpURLConnection conn = this.createConnection(resourceUrl);
                if (conn == null) {
                    bRes = false;
                } else {
                    conn.setInstanceFollowRedirects(false);
                    int httpResponseCode = conn.getResponseCode();
                    LogManager.log(TAG, "resolveMimeType conn.getResponseCode() = " + httpResponseCode);
                    if (httpResponseCode / 100 == 3) {
                        String newLocation = conn.getHeaderField("Location");
                        if (newLocation != null && newLocation.length() > 0) {
                            resource.setRedirectedUrl(newLocation);
                            continue;
                        }
                        bRes = false;
                    } else {
                        String contentType = conn.getContentType();
                        resource.setMimeType(contentType);
                        LogManager.log(TAG, "resolveMimeType " + contentType);
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            latestException = e;
        }
        return bRes;
    }

    private HttpURLConnection createConnection(String path) throws IOException {
        String userAgent;
        URL url;
        HttpURLConnection res = null;
        if (path == null || path.length() == 0) {
            Log.e((String)TAG, (String)"URL to download is null or empty");
            return null;
        }
        Log.d((String)TAG, (String)("Downloading file: " + path.substring(path.lastIndexOf(47) + 1)));
        String hostHeader = null;
        StringBuilder temp = new StringBuilder(path);
        if (temp.charAt(0) == '\"') {
            temp.deleteCharAt(0);
        }
        if (temp.charAt(temp.length() - 1) == '\"') {
            temp.deleteCharAt(temp.length() - 1);
        }
        path = temp.toString();
        try {
            url = new URL(path);
            if (Utils.isNonStandardHost(url.getHost())) {
                hostHeader = url.getHost();
                url = Utils.setIPasHost(url);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)(path + " " + e.getMessage()));
            latestException = e;
            return null;
        }
        this.mLastHttpResponseCode = 0;
        this.mConnection = (HttpURLConnection)url.openConnection();
        if (hostHeader != null) {
            this.mConnection.setRequestProperty("Host", hostHeader);
        }
        if (null == (userAgent = AMPPreSettings.getPreSettingsInstance().getUserAgent())) {
            userAgent = Utils.getDefaultUserAgent();
        }
        this.mConnection.setRequestProperty("User-Agent", userAgent);
        if (this.mReferer.length() > 0) {
            this.mConnection.setRequestProperty("Referer", this.mReferer);
        }
        res = this.mConnection;
        return res;
    }

    public static Exception fetchLatestExceptionAndNullify() {
        if (latestException != null) {
            Exception result = latestException;
            latestException = null;
            return result;
        }
        return null;
    }
}

