/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.text.cea;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.decoder.OutputBuffer;
import com.akamai.amp.exoplayer2.text.Subtitle;
import com.akamai.amp.exoplayer2.text.SubtitleDecoder;
import com.akamai.amp.exoplayer2.text.SubtitleDecoderException;
import com.akamai.amp.exoplayer2.text.SubtitleInputBuffer;
import com.akamai.amp.exoplayer2.text.SubtitleOutputBuffer;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;
import java.util.ArrayDeque;
import java.util.PriorityQueue;

abstract class CeaDecoder
implements SubtitleDecoder {
    private static final int NUM_INPUT_BUFFERS = 10;
    private static final int NUM_OUTPUT_BUFFERS = 2;
    private final ArrayDeque<CeaInputBuffer> availableInputBuffers = new ArrayDeque();
    private final ArrayDeque<SubtitleOutputBuffer> availableOutputBuffers;
    private final PriorityQueue<CeaInputBuffer> queuedInputBuffers;
    @Nullable
    private CeaInputBuffer dequeuedInputBuffer;
    private long playbackPositionUs;
    private long queuedInputBufferCount;

    public CeaDecoder() {
        int i;
        for (i = 0; i < 10; ++i) {
            this.availableInputBuffers.add(new CeaInputBuffer());
        }
        this.availableOutputBuffers = new ArrayDeque();
        for (i = 0; i < 2; ++i) {
            this.availableOutputBuffers.add(new CeaOutputBuffer(this::releaseOutputBuffer));
        }
        this.queuedInputBuffers = new PriorityQueue();
    }

    @Override
    public abstract String getName();

    @Override
    public void setPositionUs(long positionUs) {
        this.playbackPositionUs = positionUs;
    }

    @Override
    @Nullable
    public SubtitleInputBuffer dequeueInputBuffer() throws SubtitleDecoderException {
        Assertions.checkState(this.dequeuedInputBuffer == null);
        if (this.availableInputBuffers.isEmpty()) {
            return null;
        }
        this.dequeuedInputBuffer = this.availableInputBuffers.pollFirst();
        return this.dequeuedInputBuffer;
    }

    @Override
    public void queueInputBuffer(SubtitleInputBuffer inputBuffer) throws SubtitleDecoderException {
        Assertions.checkArgument(inputBuffer == this.dequeuedInputBuffer);
        CeaInputBuffer ceaInputBuffer = (CeaInputBuffer)inputBuffer;
        if (ceaInputBuffer.isDecodeOnly()) {
            this.releaseInputBuffer(ceaInputBuffer);
        } else {
            ceaInputBuffer.queuedInputBufferCount = this.queuedInputBufferCount++;
            this.queuedInputBuffers.add(ceaInputBuffer);
        }
        this.dequeuedInputBuffer = null;
    }

    @Override
    @Nullable
    public SubtitleOutputBuffer dequeueOutputBuffer() throws SubtitleDecoderException {
        if (this.availableOutputBuffers.isEmpty()) {
            return null;
        }
        while (!this.queuedInputBuffers.isEmpty() && Util.castNonNull(this.queuedInputBuffers.peek()).timeUs <= this.playbackPositionUs) {
            CeaInputBuffer inputBuffer = Util.castNonNull(this.queuedInputBuffers.poll());
            if (inputBuffer.isEndOfStream()) {
                SubtitleOutputBuffer outputBuffer = Util.castNonNull(this.availableOutputBuffers.pollFirst());
                outputBuffer.addFlag(4);
                this.releaseInputBuffer(inputBuffer);
                return outputBuffer;
            }
            this.decode(inputBuffer);
            if (this.isNewSubtitleDataAvailable()) {
                Subtitle subtitle = this.createSubtitle();
                SubtitleOutputBuffer outputBuffer = Util.castNonNull(this.availableOutputBuffers.pollFirst());
                outputBuffer.setContent(inputBuffer.timeUs, subtitle, Long.MAX_VALUE);
                this.releaseInputBuffer(inputBuffer);
                return outputBuffer;
            }
            this.releaseInputBuffer(inputBuffer);
        }
        return null;
    }

    private void releaseInputBuffer(CeaInputBuffer inputBuffer) {
        inputBuffer.clear();
        this.availableInputBuffers.add(inputBuffer);
    }

    protected void releaseOutputBuffer(SubtitleOutputBuffer outputBuffer) {
        outputBuffer.clear();
        this.availableOutputBuffers.add(outputBuffer);
    }

    @Override
    public void flush() {
        this.queuedInputBufferCount = 0L;
        this.playbackPositionUs = 0L;
        while (!this.queuedInputBuffers.isEmpty()) {
            this.releaseInputBuffer(Util.castNonNull(this.queuedInputBuffers.poll()));
        }
        if (this.dequeuedInputBuffer != null) {
            this.releaseInputBuffer(this.dequeuedInputBuffer);
            this.dequeuedInputBuffer = null;
        }
    }

    @Override
    public void release() {
    }

    protected abstract boolean isNewSubtitleDataAvailable();

    protected abstract Subtitle createSubtitle();

    protected abstract void decode(SubtitleInputBuffer var1);

    @Nullable
    protected final SubtitleOutputBuffer getAvailableOutputBuffer() {
        return this.availableOutputBuffers.pollFirst();
    }

    protected final long getPositionUs() {
        return this.playbackPositionUs;
    }

    private static final class CeaInputBuffer
    extends SubtitleInputBuffer
    implements Comparable<CeaInputBuffer> {
        private long queuedInputBufferCount;

        private CeaInputBuffer() {
        }

        @Override
        public int compareTo(CeaInputBuffer other) {
            if (this.isEndOfStream() != other.isEndOfStream()) {
                return this.isEndOfStream() ? 1 : -1;
            }
            long delta = this.timeUs - other.timeUs;
            if (delta == 0L && (delta = this.queuedInputBufferCount - other.queuedInputBufferCount) == 0L) {
                return 0;
            }
            return delta > 0L ? 1 : -1;
        }
    }

    private static final class CeaOutputBuffer
    extends SubtitleOutputBuffer {
        private OutputBuffer.Owner<CeaOutputBuffer> owner;

        public CeaOutputBuffer(OutputBuffer.Owner<CeaOutputBuffer> owner) {
            this.owner = owner;
        }

        @Override
        public final void release() {
            this.owner.releaseOutputBuffer(this);
        }
    }
}

