/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source.chunk;

import com.akamai.amp.exoplayer2.extractor.DummyTrackOutput;
import com.akamai.amp.exoplayer2.extractor.TrackOutput;
import com.akamai.amp.exoplayer2.source.SampleQueue;
import com.akamai.amp.exoplayer2.source.chunk.ChunkExtractor;
import com.akamai.amp.exoplayer2.util.Log;

public final class BaseMediaChunkOutput
implements ChunkExtractor.TrackOutputProvider {
    private static final String TAG = "BaseMediaChunkOutput";
    private final int[] trackTypes;
    private final SampleQueue[] sampleQueues;

    public BaseMediaChunkOutput(int[] trackTypes, SampleQueue[] sampleQueues) {
        this.trackTypes = trackTypes;
        this.sampleQueues = sampleQueues;
    }

    @Override
    public TrackOutput track(int id, int type) {
        for (int i = 0; i < this.trackTypes.length; ++i) {
            if (type != this.trackTypes[i]) continue;
            return this.sampleQueues[i];
        }
        Log.e(TAG, "Unmatched track of type: " + type);
        return new DummyTrackOutput();
    }

    public int[] getWriteIndices() {
        int[] writeIndices = new int[this.sampleQueues.length];
        for (int i = 0; i < this.sampleQueues.length; ++i) {
            writeIndices[i] = this.sampleQueues[i].getWriteIndex();
        }
        return writeIndices;
    }

    public void setSampleOffsetUs(long sampleOffsetUs) {
        for (SampleQueue sampleQueue : this.sampleQueues) {
            sampleQueue.setSampleOffsetUs(sampleOffsetUs);
        }
    }
}

