/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.drm;

import android.os.Looper;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.drm.DrmSession;
import com.akamai.amp.exoplayer2.drm.DrmSessionEventListener;
import com.akamai.amp.exoplayer2.drm.ErrorStateDrmSession;
import com.akamai.amp.exoplayer2.drm.ExoMediaCrypto;
import com.akamai.amp.exoplayer2.drm.UnsupportedDrmException;
import com.akamai.amp.exoplayer2.drm.UnsupportedMediaCrypto;

public interface DrmSessionManager {
    public static final DrmSessionManager DUMMY = new DrmSessionManager(){

        @Override
        @Nullable
        public DrmSession acquireSession(Looper playbackLooper, @Nullable DrmSessionEventListener.EventDispatcher eventDispatcher, Format format) {
            if (format.drmInitData == null) {
                return null;
            }
            return new ErrorStateDrmSession(new DrmSession.DrmSessionException(new UnsupportedDrmException(1)));
        }

        @Nullable
        public Class<UnsupportedMediaCrypto> getExoMediaCryptoType(Format format) {
            return format.drmInitData != null ? UnsupportedMediaCrypto.class : null;
        }
    };

    public static DrmSessionManager getDummyDrmSessionManager() {
        return DUMMY;
    }

    default public void prepare() {
    }

    default public void release() {
    }

    @Nullable
    public DrmSession acquireSession(Looper var1, @Nullable DrmSessionEventListener.EventDispatcher var2, Format var3);

    @Nullable
    public Class<? extends ExoMediaCrypto> getExoMediaCryptoType(Format var1);
}

