/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.analytics.comscorestreamsense;

import com.akamai.amp.ads.AdPosition;
import com.akamai.amp.ads.AdsInfo;
import com.akamai.amp.analytics.AnalyticsTracker;
import com.akamai.amp.analytics.AnalyticsTrackerData;
import com.akamai.amp.analytics.comscorestreamsense.AmpComscoreStreamsenseAnalyticsTracker;
import com.akamai.amp.analytics.comscorestreamsense.ComscoreStreamsense;
import com.akamai.amp.analytics.comscorestreamsense.UserConsent;
import com.akamai.amp.config.Config;
import com.akamai.amp.config.data.streamsense.StreamsenseData;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.utils.LogManager;
import com.comscore.Analytics;
import com.comscore.streaming.AdvertisementMetadata;
import com.comscore.streaming.AssetMetadata;
import com.comscore.streaming.ContentMetadata;
import com.comscore.streaming.StreamingAnalytics;
import java.util.HashMap;
import java.util.Map;

public class StreamsenseEventsHandler
extends AnalyticsTracker<StreamsenseData>
implements AmpComscoreStreamsenseAnalyticsTracker {
    private static final String LOG_TAG = "StreamsenseEventsHandler";
    private static final String VERSION = "9.10.6";
    private static final String USER_CONSENT_LABEL = "cs_ucfr";
    private static final Map<AdPosition, Integer> ampToComscoreAdType = new HashMap<AdPosition, Integer>(){
        {
            this.put(AdPosition.PREROLL, 211);
            this.put(AdPosition.MIDROLL, 212);
            this.put(AdPosition.POSTROLL, 213);
        }
    };
    private static StreamingAnalytics streamingAnalytics;
    private boolean sessionStarted = false;
    private boolean latestPlayIsAd = false;
    private AdsInfo latestAd;
    private boolean adsPaused = false;
    private int segmentNumber = 1;
    private ContentMetadata contentMetadata;
    private AdvertisementMetadata adMetadata;
    private static UserConsent userConsent;
    private boolean logicalResumeIsComing = false;
    private boolean logicalPauseIsComing = false;
    private boolean prerollExpected = false;

    StreamsenseEventsHandler(StreamsenseData param) {
        super((AnalyticsTrackerData)param, LOG_TAG, VERSION);
    }

    StreamsenseEventsHandler(VideoPlayerView videoPlayerView, StreamsenseData param) {
        super(videoPlayerView, (AnalyticsTrackerData)param, LOG_TAG, VERSION);
    }

    public void init() {
        LogManager.log((String)LOG_TAG, (String)"init()");
        if (!ComscoreStreamsense.appInitDone) {
            throw new IllegalStateException("StreamsenseEventsHandler.onApplicationCreate() must be called from your Application's onCreate() method");
        }
        Analytics.setLogLevel((int)(LogManager.isLogEnabled() ? 30004 : 30000));
        streamingAnalytics = new StreamingAnalytics();
        streamingAnalytics.setMediaPlayerName("Akamai AMP SDK Android");
        streamingAnalytics.setMediaPlayerVersion(VERSION);
        LogManager.log((String)LOG_TAG, (String)("Created new StreamingAnalytics(), using version " + this.getExternalLibVersion()));
        Map persistentLabels = ((StreamsenseData)this.data).getPersistentLabels();
        Analytics.getConfiguration().addPersistentLabels(persistentLabels);
        LogManager.log((String)LOG_TAG, (String)("Analytics.getConfiguration().addPersistentLabels() " + persistentLabels));
    }

    public void setContentLabel(String tag, String value) {
        throw new IllegalStateException("Don't call this method for Comscore Streamsense");
    }

    public void setContentLabels(Map<String, String> map) {
        throw new IllegalStateException("Don't call this method for Comscore Streamsense");
    }

    public void setAdLabel(String tag, String value) {
        throw new IllegalStateException("Don't call this method for Comscore Streamsense");
    }

    public void setAdLabels(Map<String, String> map) {
        throw new IllegalStateException("Don't call this method for Comscore Streamsense");
    }

    protected StreamsenseData loadDataFromConfig() {
        return Config.getConfig().streamsenseData;
    }

    public void cleanup() {
        LogManager.log((String)LOG_TAG, (String)"cleanup()");
        if (this.sessionStarted) {
            this.trackFinish();
        }
        Analytics.notifyExitForeground();
        Analytics.notifyUxInactive();
        streamingAnalytics = null;
    }

    public String getExternalLibVersion() {
        return Analytics.getVersion();
    }

    public void trackSendToBackground() {
        LogManager.log((String)LOG_TAG, (String)"trackSendToBackground()");
        int millis = this.latestReportedPositionSeconds * 1000;
        this.doPause(millis);
        Analytics.notifyExitForeground();
        Analytics.notifyUxInactive();
    }

    public void trackSendToForeground() {
        if (!this.sessionStarted) {
            LogManager.log((String)LOG_TAG, (String)"trackSendToForeground() !sessionStarted");
            return;
        }
        LogManager.log((String)LOG_TAG, (String)"trackSendToForeground()");
        this.doPlayEvent("trackSendToForeground");
        Analytics.notifyEnterForeground();
        Analytics.notifyUxActive();
    }

    public void trackPlayEvent() {
        this.doTrackPlayEvent(this.latestPlayIsAd);
    }

    public void trackResumeEvent() {
        if (streamingAnalytics == null) {
            LogManager.error((String)LOG_TAG, (String)"NULL StreamingAnalytics on trackResumeEvent()");
            return;
        }
        if (!this.sessionStarted) {
            LogManager.log((String)LOG_TAG, (String)"trackResumeEvent() !sessionStarted");
            return;
        }
        if (!this.mVideoPlayerView.isPaused()) {
            if (this.logicalResumeIsComing) {
                this.logicalResumeIsComing = false;
                LogManager.log((String)LOG_TAG, (String)"trackResumeEvent avoiding notifyPlay() due to logicalResumeIsComing");
                return;
            }
            this.doPlayEvent("trackResumeEvent");
        }
    }

    private void doPlayEvent(String callingMethod) {
        if (this.prerollExpected) {
            return;
        }
        this.currentTimeInMillis = this.getCurrentPositionInMillis();
        streamingAnalytics.startFromPosition((long)this.currentTimeInMillis);
        streamingAnalytics.notifyPlay();
        LogManager.log((String)LOG_TAG, (String)(callingMethod + "() streamingAnalytics.notifyPlay() " + this.currentTimeInMillis));
    }

    public void trackLogicalResumeIsComing() {
        this.logicalResumeIsComing = true;
        LogManager.log((String)LOG_TAG, (String)"trackLogicalResumeIsComing");
    }

    public void trackPauseEvent() {
        this.currentTimeInMillis = this.getCurrentPositionInMillis();
        this.doPause(this.currentTimeInMillis);
    }

    private void doPause(int positionMillis) {
        if (streamingAnalytics == null) {
            LogManager.error((String)LOG_TAG, (String)"NULL StreamingAnalytics on doPause()");
            return;
        }
        if (this.logicalPauseIsComing) {
            this.logicalPauseIsComing = false;
            LogManager.log((String)LOG_TAG, (String)"doPause() avoiding notifyPause() due to logicalPauseIsComing");
            return;
        }
        if (!this.sessionStarted) {
            LogManager.log((String)LOG_TAG, (String)"doPause() avoiding notifyPause() due to !sessionStarted");
            return;
        }
        if (this.prerollExpected) {
            LogManager.log((String)LOG_TAG, (String)"doPause() avoiding notifyPause() due to !sessionStarted");
            return;
        }
        streamingAnalytics.notifyPause();
        LogManager.log((String)LOG_TAG, (String)("doPause() streamingAnalytics.notifyPause() " + positionMillis));
    }

    public void trackLogicalPauseIsComing() {
        this.logicalPauseIsComing = true;
        LogManager.log((String)LOG_TAG, (String)"trackLogicalPauseIsComing");
    }

    public void trackStopPlaying() {
        this.trackPauseEvent();
    }

    public void trackStartRebuffering() {
        if (streamingAnalytics == null) {
            LogManager.error((String)LOG_TAG, (String)"NULL StreamingAnalytics on trackStartRebuffering()");
            return;
        }
        this.currentTimeInMillis = this.getCurrentPositionInMillis();
        streamingAnalytics.startFromPosition((long)this.currentTimeInMillis);
        streamingAnalytics.notifyBufferStart();
        LogManager.log((String)LOG_TAG, (String)("streamingAnalytics.notifyBufferStart() " + this.currentTimeInMillis));
    }

    public void trackStopRebuffering() {
        if (streamingAnalytics == null) {
            LogManager.error((String)LOG_TAG, (String)"NULL StreamingAnalytics on trackStopRebuffering()");
            return;
        }
        this.currentTimeInMillis = this.getCurrentPositionInMillis();
        streamingAnalytics.startFromPosition((long)this.currentTimeInMillis);
        streamingAnalytics.notifyBufferStop();
        LogManager.log((String)LOG_TAG, (String)("streamingAnalytics.notifyBufferStop() " + this.currentTimeInMillis));
    }

    public void trackFinish() {
        this.sessionStarted = false;
        if (streamingAnalytics == null) {
            return;
        }
        streamingAnalytics.notifyEnd();
        LogManager.log((String)LOG_TAG, (String)"trackFinish streamingAnalytics.notifyEnd()");
    }

    public void trackError(String errorMsg) {
        this.sessionStarted = false;
        this.currentTimeInMillis = this.getCurrentPositionInMillis();
        LogManager.log((String)LOG_TAG, (String)("trackError pos: " + this.currentTimeInMillis + ", error: " + errorMsg));
    }

    public void trackSeekStarted() {
        if (streamingAnalytics == null) {
            return;
        }
        this.currentTimeInMillis = this.getCurrentPositionInMillis();
        streamingAnalytics.startFromPosition((long)this.currentTimeInMillis);
        streamingAnalytics.notifySeekStart();
        LogManager.log((String)LOG_TAG, (String)("streamingAnalytics.notifySeekStart " + this.currentTimeInMillis));
    }

    public void trackSeekComplete() {
        boolean isPaused;
        if (streamingAnalytics == null) {
            return;
        }
        boolean bl = isPaused = this.mVideoPlayerView.isPaused() || this.latestPlayIsAd && this.adsPaused;
        if (isPaused) {
            LogManager.log((String)LOG_TAG, (String)"trackSeekComplete() while paused, not invoking any streamsense methods");
            return;
        }
        this.doPlayEvent("trackSeekComplete");
    }

    public void trackVideoLoad() {
        this.segmentNumber = 1;
    }

    public void trackAdsStarted(AdsInfo ad) {
        if (ad == null) {
            return;
        }
        this.latestPlayIsAd = true;
        this.latestAd = ad;
        this.adsPaused = false;
        this.prerollExpected = false;
        if (streamingAnalytics == null) {
            return;
        }
        this.adMetadata = this.convertAd(this.latestAd);
        this.setMetadata(true);
        streamingAnalytics.notifyPlay();
        LogManager.log((String)LOG_TAG, (String)("onAdsStarted streamingAnalytics.notifyPlay() " + this.adMetadata));
        if (ad.isMidroll()) {
            ++this.segmentNumber;
        }
    }

    private AdvertisementMetadata convertAd(AdsInfo latestAd) {
        int comscoreAdType = this.getAdType(latestAd.adPosition);
        int lengthInMillis = latestAd.lengthInSeconds * 1000;
        AdvertisementMetadata adMetadata = new AdvertisementMetadata.Builder().mediaType(comscoreAdType).relatedContentMetadata(this.contentMetadata).length((long)lengthInMillis).totalInBreak(latestAd.adBreakTotal).numberInBreak(latestAd.positionInAdBreak).build();
        return adMetadata;
    }

    private Integer getAdType(AdPosition adPosition) {
        Integer comscoreAdType = ampToComscoreAdType.get(adPosition);
        if (comscoreAdType == null) {
            comscoreAdType = 200;
        }
        return comscoreAdType;
    }

    public void trackAdsError(String reason) {
        this.latestPlayIsAd = false;
        this.adsPaused = false;
        this.prerollExpected = false;
        LogManager.log((String)LOG_TAG, (String)("trackAdsError() " + reason));
    }

    public void trackAdsPaused() {
        this.adsPaused = true;
        if (streamingAnalytics == null) {
            return;
        }
        this.currentTimeInMillis = this.getCurrentPositionInMillis();
        streamingAnalytics.notifyPause();
        LogManager.log((String)LOG_TAG, (String)("onAdsPaused streamingAnalytics.notifyPause() " + this.currentTimeInMillis));
    }

    public void trackAdsEnded() {
        this.latestPlayIsAd = false;
        this.adsPaused = false;
        if (streamingAnalytics == null) {
            return;
        }
        this.currentTimeInMillis = this.getCurrentPositionInMillis();
        streamingAnalytics.notifyEnd();
        LogManager.log((String)LOG_TAG, (String)("onAdsEnded streamingAnalytics.notifyEnd() " + this.currentTimeInMillis));
    }

    public void trackAdBreakEnd() {
        this.resumeContent();
    }

    private void resumeContent() {
        if (this.latestAd == null) {
            return;
        }
        if (this.latestAd.isPostroll()) {
            return;
        }
        LogManager.log((String)LOG_TAG, (String)(this.latestAd.adPosition + " resumeContent() onAdsEnded(); resuming content playback"));
        this.doTrackPlayEvent(false);
    }

    private void doTrackPlayEvent(boolean useAdsInfo) {
        if (this.isLive) {
            long dvrLength = this.mVideoPlayerView.getDVRLength() * 1000L;
            streamingAnalytics.setDvrWindowLength(dvrLength);
            LogManager.log((String)LOG_TAG, (String)("streamingAnalytics.setDvrWindowLength() " + dvrLength));
        }
        Analytics.notifyUxActive();
        if (!this.sessionStarted) {
            this.sessionStarted = true;
            if (streamingAnalytics == null) {
                return;
            }
            streamingAnalytics.createPlaybackSession();
            LogManager.log((String)LOG_TAG, (String)"doTrackPlayEvent() streamingAnalytics.createPlaybackSession()");
        }
        if (streamingAnalytics == null) {
            return;
        }
        if (this.prerollExpected) {
            return;
        }
        AssetMetadata assetMetadata = this.setMetadata(useAdsInfo);
        streamingAnalytics.notifyPlay();
        LogManager.log((String)LOG_TAG, (String)("doTrackPlayEvent() streamingAnalytics.notifyPlay() " + assetMetadata));
    }

    private AssetMetadata setMetadata(boolean useAdsInfo) {
        if (streamingAnalytics == null) {
            return null;
        }
        if (useAdsInfo) {
            streamingAnalytics.setMetadata((AssetMetadata)this.adMetadata);
            LogManager.log((String)LOG_TAG, (String)("streamingAnalytics.setMetadata() AD " + this.adMetadata));
            return this.adMetadata;
        }
        streamingAnalytics.setMetadata((AssetMetadata)this.contentMetadata);
        LogManager.log((String)LOG_TAG, (String)("streamingAnalytics.setMetadata() CONTENT " + this.contentMetadata));
        return this.contentMetadata;
    }

    @Override
    public void notifyHiddenEvent() {
        Analytics.notifyHiddenEvent();
        LogManager.log((String)LOG_TAG, (String)"Analytics.notifyHiddenEvent()");
    }

    @Override
    public void notifyHiddenEvent(Map<String, String> params) {
        Analytics.notifyHiddenEvent(params);
        LogManager.log((String)LOG_TAG, (String)("Analytics.notifyHiddenEvent(Map): " + params));
    }

    @Override
    public void notifyViewEvent() {
        Analytics.notifyViewEvent();
        LogManager.log((String)LOG_TAG, (String)"Analytics.notifyViewEvent()");
    }

    @Override
    public void notifyViewEvent(Map<String, String> params) {
        Analytics.notifyViewEvent(params);
        LogManager.log((String)LOG_TAG, (String)("Analytics.notifyViewEvent(Map): " + params));
    }

    @Override
    public UserConsent getUserConsent() {
        return userConsent;
    }

    @Override
    public void setUserConsent(UserConsent param) {
        userConsent = param;
        String consentValue = userConsent.getValue();
        this.notifyLabelChange(USER_CONSENT_LABEL, consentValue);
        LogManager.log((String)LOG_TAG, (String)("Analytics.setUserConsent() " + (Object)((Object)param)));
    }

    static Map<String, String> buildUserConsentPersistentLabels(UserConsent userConsentParam) {
        userConsent = userConsentParam;
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put(USER_CONSENT_LABEL, userConsent.getValue());
        return labels;
    }

    @Override
    public void notifyLabelChange(String key, String value) {
        String publisherId = ((StreamsenseData)this.data).getStreamsenseData().getPublisherId();
        Analytics.getConfiguration().getPublisherConfiguration(publisherId).setPersistentLabel(key, value);
        Analytics.notifyHiddenEvent();
        LogManager.log((String)LOG_TAG, (String)("Analytics.setPersistentLabel() and notifyHiddenEvent() " + key + " -> " + value));
    }

    @Override
    public void setContentMetadata(ContentMetadata contentMetadata) {
        this.contentMetadata = contentMetadata;
        this.setMetadata(false);
    }

    @Override
    public void expectPreroll() {
        this.prerollExpected = true;
    }

    static {
        userConsent = UserConsent.NO_ACTION;
    }
}

