/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.analytics.adobeexperienceplatform;

import com.adobe.marketing.mobile.Media;
import com.adobe.marketing.mobile.MediaTracker;
import com.akamai.amp.ads.AdsCount;
import com.akamai.amp.ads.AdsInfo;
import com.akamai.amp.analytics.AnalyticsTracker;
import com.akamai.amp.analytics.AnalyticsTrackerData;
import com.akamai.amp.analytics.adobeexperienceplatform.AdobeExperience;
import com.akamai.amp.analytics.adobeexperienceplatform.AmpAdobeExperienceAnalyticsTracker;
import com.akamai.amp.config.data.experienceplatform.ExperiencePlatformData;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.mute.MuteHelper;
import com.akamai.amp.media.mute.MuteListener;
import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.ReflectionUtils;
import com.akamai.amp.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class AdobeExperienceEventsHandler
extends AnalyticsTracker<ExperiencePlatformData>
implements AmpAdobeExperienceAnalyticsTracker,
MuteListener {
    private static final String LOG_TAG = AdobeExperienceEventsHandler.class.getSimpleName();
    private MediaTracker _tracker;
    private boolean isPaused = true;
    private boolean sessionStarted = false;
    private boolean adsStarted = false;
    private boolean trackPlayAfterAdStart = true;
    private boolean trackSessionEndAfterTrackComplete = false;
    private final Object lock = new Object();
    private boolean isBuffering = false;
    private boolean isSeeking = false;
    private Map<String, Object> latestAdBreakInfo;
    private Map<String, Object> latestAdInfo;
    private AdsInfo latestAd;
    private AdsCount adsCount = AdsCount.UNKNOWN;
    private boolean adsOnLive = false;
    private boolean isLogicalResumeComing = false;
    private boolean isLogicalPauseComing = false;

    public AdobeExperienceEventsHandler(ExperiencePlatformData data) {
        super((AnalyticsTrackerData)data, LOG_TAG, "9.10.6");
    }

    public AdobeExperienceEventsHandler(VideoPlayerView videoPlayerView, ExperiencePlatformData data) {
        super(videoPlayerView, (AnalyticsTrackerData)data, LOG_TAG, "9.10.6");
    }

    public String getExternalLibVersion() {
        String version = ReflectionUtils.tryToReadDeclaredField(Media.class, (String)"EXTENSION_VERSION");
        return version;
    }

    public void init() {
        LogManager.log((String)LOG_TAG, (String)("init() " + LOG_TAG + " with external version " + this.getExternalLibVersion()));
        this.initTracker();
        MuteHelper.addListener((MuteListener)this);
    }

    private void initTracker() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("config.channel", ((ExperiencePlatformData)this.data).getChannel());
        this._tracker = Media.createTracker(config);
        if (this._tracker == null) {
            throw new IllegalStateException("Don't forget to call " + AdobeExperience.class.getCanonicalName() + ".onApplicationCreate() on your Application's onCreate()");
        }
    }

    public void cleanup() {
        if (this._tracker != null) {
            this.doTrackSessionEnd();
            this._tracker = null;
        }
        this.resetStateValues();
        LogManager.log((String)LOG_TAG, (String)"AdobeEventsHandler.cleanup()");
    }

    public void trackPositionUpdate(long playheadPosition) {
        if (this._tracker == null) {
            return;
        }
        this._tracker.updateCurrentPlayhead((double)playheadPosition);
        LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)("trackPositionUpdate() " + playheadPosition));
        LogManager.log((String)LOG_TAG, (String)("trackPositionUpdate() " + playheadPosition));
    }

    public long getPlayheadPositionForLive() {
        return Utils.Time.getSecondsSinceMidnight((TimeZone)AdobeExperience.getTimeZone());
    }

    public void trackPlayEvent() {
        this.tryTrackPlay("trackPlayEvent()", false, false);
    }

    private void tryTrackPlay(String invokingMethod, boolean comesFromAdStart, boolean isResume) {
        if (!this.sessionStarted) {
            this.doSessionStart(invokingMethod, false);
        }
        if (this.isLogicalResumeComing) {
            this.isLogicalResumeComing = false;
            return;
        }
        boolean shouldTrackPlay = this.shouldTrackPlay(comesFromAdStart, isResume);
        if (shouldTrackPlay) {
            this.doTrackPlay(invokingMethod);
        } else {
            LogManager.log((String)LOG_TAG, (String)(invokingMethod + " did NOT invoke heartbeat.trackPlay()"));
        }
    }

    private void doSessionStart(String logMessage, boolean isResume) {
        if (this.sessionStarted) {
            return;
        }
        if (this._tracker == null) {
            return;
        }
        Map<String, Object> mediaInfo = this.getMediaInfo(isResume);
        Map videoMetadata = ((ExperiencePlatformData)this.data).getMetadata();
        this._tracker.trackSessionStart(mediaInfo, videoMetadata);
        LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackSessionStart()");
        LogManager.log((String)LOG_TAG, (String)(logMessage + " invoked heartbeat.trackSessionStart " + videoMetadata));
        this.sessionStarted = true;
    }

    private Map<String, Object> getMediaInfo(boolean isResume) {
        if (this.mVideoPlayerView == null) {
            throw new IllegalStateException("VideoPlayerView is null");
        }
        MediaResource mediaResource = this.mVideoPlayerView.getMediaResource();
        if (mediaResource == null) {
            throw new IllegalStateException("MediaResource is null");
        }
        Map<String, Object> mediaInfo = this.buildContentMediaInfo(isResume);
        return mediaInfo;
    }

    private Map<String, Object> buildContentMediaInfo(boolean isResume) {
        HashMap mediaInfo = Media.createMediaObject((String)((ExperiencePlatformData)this.data).getVideoName(), (String)((ExperiencePlatformData)this.data).getVideoID(), (double)this.getDuration(), (String)(this.isLive ? "live" : "vod"), (Media.MediaType)(this.getIsAudioOnly() ? Media.MediaType.Audio : Media.MediaType.Video));
        if (isResume) {
            mediaInfo.put("media.resumed", true);
        }
        return mediaInfo;
    }

    private double getDuration() {
        if (this.isLive) {
            return 86400.0;
        }
        if (this.mVideoPlayerView == null) {
            return -100.0;
        }
        double duration = this.mVideoPlayerView.getStreamDuration();
        return duration;
    }

    private boolean getIsAudioOnly() {
        if (this.mVideoPlayerView == null) {
            return false;
        }
        boolean audioOnly = this.mVideoPlayerView.isAudioOnly();
        return audioOnly;
    }

    private Map<String, String> create(Map<String, String> metadata) {
        if (metadata == null) {
            return new HashMap<String, String>();
        }
        return new HashMap<String, String>(metadata);
    }

    public void trackPauseEvent() {
        this.tryTrackPause("trackPauseEvent()");
    }

    public void trackResumeEvent() {
        boolean isPaused = this.mVideoPlayerView.isPaused();
        if (!isPaused) {
            this.tryTrackPlay("trackResumeEvent()", false, true);
        }
    }

    public void trackStopPlaying() {
        this.tryTrackPause("trackStopPlaying()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackStartRebuffering() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isBuffering) {
                return;
            }
            this.isBuffering = true;
            if (this._tracker == null) {
                return;
            }
            this._tracker.trackEvent(Media.Event.BufferStart, null, null);
            LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackBufferStart()");
            LogManager.log((String)LOG_TAG, (String)"heartbeat.trackEvent(BufferStart)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackStopRebuffering() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isBuffering) {
                return;
            }
            this.isBuffering = false;
            if (this._tracker == null) {
                return;
            }
            this._tracker.trackEvent(Media.Event.BufferComplete, null, null);
            LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackBufferComplete()");
            LogManager.log((String)LOG_TAG, (String)"heartbeat.trackEvent(BufferComplete)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackSeekStarted() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isSeeking) {
                return;
            }
            this.isSeeking = true;
            if (this._tracker == null) {
                return;
            }
            this._tracker.trackEvent(Media.Event.SeekStart, null, null);
            LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackSeekStart()");
            LogManager.log((String)LOG_TAG, (String)"heartbeat.trackEvent(SeekStart)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackSeekComplete() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isSeeking) {
                return;
            }
            this.isSeeking = false;
            if (this._tracker == null) {
                return;
            }
            this._tracker.trackEvent(Media.Event.SeekComplete, null, null);
            LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackSeekComplete()");
            LogManager.log((String)LOG_TAG, (String)"heartbeat.trackEvent(SeekComplete)");
        }
    }

    public void trackFinish() {
        if (this._tracker == null) {
            return;
        }
        if (this.trackSessionEndAfterTrackComplete) {
            this.doTrackSessionEnd();
        }
    }

    public void trackSendToBackground() {
        this.doTrackPause("trackSendToBackground()");
    }

    public void trackSendToForeground() {
        this.doTrackPlay("trackSendToForeground()");
    }

    public void trackAdsLoaded(AdsCount param) {
        if (param == null) {
            return;
        }
        this.adsCount = param;
        this.setTrackingPoints();
    }

    public void trackAdsStarted(AdsInfo ad) {
        this.resetLatestAdInfo();
        if (ad == null) {
            LogManager.log((String)LOG_TAG, (String)"onAdsStarted() AdsInfo is NULL (AdBreak)");
        } else {
            if (this.adsStarted) {
                return;
            }
            if (!this.sessionStarted) {
                this.doSessionStart("onAdsStarted ", false);
            }
            LogManager.log((String)LOG_TAG, (String)("onAdsStarted() " + ad));
            this.adsStarted = true;
            if (this._tracker == null) {
                return;
            }
            this.latestAdBreakInfo = this.getAdBreakInfo();
            this._tracker.trackEvent(Media.Event.AdBreakStart, this.latestAdBreakInfo, null);
            LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackAdBreakStart()");
            LogManager.log((String)LOG_TAG, (String)"heartbeat.trackEvent(AdBreakStart, latestAdBreakInfo, null)");
            this.latestAd = ad;
            this.latestAdInfo = this.getAdInfo(ad);
            Map adData = ((ExperiencePlatformData)this.data).getAdMetadata();
            this._tracker.trackEvent(Media.Event.AdStart, this.latestAdInfo, adData);
            LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackAdStart()");
            LogManager.log((String)LOG_TAG, (String)("heartbeat.trackEvent(AdStart, latestAdInfo, data.getAdMetadata()) " + adData));
            if (this.isPaused) {
                this.doTrackPlay("onAdsStarted");
            }
        }
    }

    public void trackAdsEnded() {
        if (this.adsStarted) {
            this.adsStarted = false;
            if (this._tracker == null) {
                return;
            }
            this._tracker.trackEvent(Media.Event.AdComplete, null, null);
            LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackAdComplete()");
            LogManager.log((String)LOG_TAG, (String)"heartbeat.trackEvent(AdComplete, latestAdInfo, null)");
            this._tracker.trackEvent(Media.Event.AdBreakComplete, null, null);
            LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackAdBreakComplete()");
            LogManager.log((String)LOG_TAG, (String)"heartbeat.trackEvent(AdBreakComplete, latestAdBreakInfo, null)");
        }
        boolean shouldTrackSessionEnd = !this.trackSessionEndAfterTrackComplete && this.latestAd != null && this.latestAd.isPostroll();
        this.resetLatestAdInfo();
        if (shouldTrackSessionEnd) {
            this.doTrackSessionEnd();
        }
    }

    public void trackAdsError(String error) {
        this.setTrackingPoints();
    }

    @Override
    public void trackPlayAfterAdStart() {
        this.trackPlayAfterAdStart = true;
    }

    @Override
    public void trackPlayAfterSessionStart() {
        this.trackPlayAfterAdStart = false;
    }

    @Override
    public void trackSessionEndAfterTrackComplete() {
        this.trackSessionEndAfterTrackComplete = true;
    }

    @Override
    public void trackSessionEndAfterPostrolls() {
        this.trackSessionEndAfterTrackComplete = false;
    }

    public void trackLogicalResumeIsComing() {
        this.isLogicalResumeComing = true;
    }

    public void trackLogicalPauseIsComing() {
        this.isLogicalPauseComing = true;
    }

    @Override
    public void adsOnLive(boolean hasAds) {
        this.adsOnLive = hasAds;
    }

    private void resetStateValues() {
        this.isPaused = true;
        this.sessionStarted = false;
        this.adsStarted = false;
    }

    private void doTrackPlay(String invokingMethod) {
        if (this._tracker == null) {
            return;
        }
        if (!this.isPaused) {
            return;
        }
        this._tracker.trackPlay();
        LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackPlay()");
        LogManager.log((String)LOG_TAG, (String)(invokingMethod + " invoked heartbeat.trackPlay()"));
        this.isPaused = false;
    }

    private boolean shouldTrackPlay(boolean comesFromAdStart, boolean isResume) {
        if (isResume) {
            return true;
        }
        if (this.isLive && !this.adsOnLive) {
            return true;
        }
        if (this.trackPlayAfterAdStart) {
            if (comesFromAdStart) {
                this.trackPlayAfterAdStart = false;
            }
            return comesFromAdStart;
        }
        boolean result = this.isPaused && !this.mVideoPlayerView.isPaused();
        return result;
    }

    private void tryTrackPause(String invokingMethod) {
        if (!this.sessionStarted) {
            String errorMessage = "tryTrackPause() was called from " + invokingMethod + "(), but the session has not been started.";
            LogManager.error((String)"AdobeVideoHeartbeatSDK", (String)errorMessage);
            return;
        }
        if (this.isLogicalPauseComing) {
            this.isLogicalPauseComing = false;
            return;
        }
        if (this.isPaused) {
            LogManager.log((String)LOG_TAG, (String)(invokingMethod + " did NOT invoke heartbeat.trackPause()"));
        } else {
            this.doTrackPause(invokingMethod);
        }
    }

    private void doTrackPause(String invokingMethod) {
        if (this._tracker == null) {
            return;
        }
        if (this.isPaused) {
            return;
        }
        this._tracker.trackPause();
        LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackPause()");
        LogManager.log((String)LOG_TAG, (String)(invokingMethod + " invoked heartbeat.trackPause()"));
        this.isPaused = true;
    }

    private void doTrackSessionEnd() {
        this.resetStateValues();
        this.doTrackComplete();
        this._tracker.trackSessionEnd();
        LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackSessionEnd()");
        LogManager.log((String)LOG_TAG, (String)"heartbeat.trackSessionEnd()");
    }

    private void doTrackComplete() {
        if (this.isLive) {
            return;
        }
        if (this._tracker == null) {
            return;
        }
        this._tracker.trackComplete();
        LogManager.log((String)"AdobeVideoHeartbeatSDK", (String)"trackComplete()");
        LogManager.log((String)LOG_TAG, (String)"heartbeat.trackComplete()");
    }

    private void setTrackingPoints() {
        if (this.adsCount.hasPrerolls()) {
            LogManager.log((String)LOG_TAG, (String)"setTrackingPoints: adsCount.hasPrerolls(), calling trackPlayAfterAdStart()");
            this.trackPlayAfterAdStart();
        } else {
            LogManager.log((String)LOG_TAG, (String)"setTrackingPoints: NOT adsCount.hasPrerolls(), calling trackPlayAfterSessionStart()");
            this.trackPlayAfterSessionStart();
        }
        if (this.adsCount.hasPostrolls()) {
            LogManager.log((String)LOG_TAG, (String)"setTrackingPoints: adsCount.hasPostrolls(), calling trackSessionEndAfterPostrolls()");
            this.trackSessionEndAfterPostrolls();
        } else {
            LogManager.log((String)LOG_TAG, (String)"setTrackingPoints: NOT adsCount.hasPostrolls(), calling trackSessionEndAfterTrackComplete()");
            this.trackSessionEndAfterTrackComplete();
        }
    }

    private void resetLatestAdInfo() {
        this.latestAdBreakInfo = null;
        this.latestAdInfo = null;
        this.latestAd = null;
    }

    private Map<String, Object> getAdBreakInfo() {
        double timePosition = this.mVideoPlayerView.getCurrentTimelinePosition();
        HashMap adBreakInfo = Media.createAdBreakObject((String)this.generateUnique("AD_BREAK"), (long)1L, (double)timePosition);
        return adBreakInfo;
    }

    private String generateUnique(String base) {
        String result = base + "_" + System.currentTimeMillis();
        return result;
    }

    private Map<String, Object> getAdInfo(AdsInfo ad) {
        HashMap adInfo = Media.createAdObject((String)ad.name, (String)ad.adId, (long)ad.positionInAdBreak, (double)ad.lengthInSeconds);
        return adInfo;
    }

    public void onMuted() {
        if (this._tracker == null) {
            return;
        }
        LogManager.log((String)LOG_TAG, (String)"MuteListener.onMuted()");
        HashMap stateInfo = Media.createStateObject((String)"mute");
        this._tracker.trackEvent(Media.Event.StateStart, (Map)stateInfo, null);
    }

    public void onUnmuted() {
        if (this._tracker == null) {
            return;
        }
        LogManager.log((String)LOG_TAG, (String)"MuteListener.onUnmuted()");
        HashMap stateInfo = Media.createStateObject((String)"mute");
        this._tracker.trackEvent(Media.Event.StateEnd, (Map)stateInfo, null);
    }

    public void onVolumeChanged(float volume) {
    }
}

