/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.va.plugins.ah.engine.network;

import com.adobe.primetime.core.ILogger;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SettingsParser {
    private static final String KEY_REPORTING_INTERVAL = "reporting_interval";
    private static final String KEY_CHECK_STATUS_INTERVAL = "check_status_interval";
    private static final String KEY_TRACK_EXTERNAL_ERRORS = "track_external_errors";
    private static final String KEY_CHECK_NIELSEN_ENABLED = "nielsen_enabled";
    private static final String KEY_CHECK_TRACKING_DISABLED = "tracking_disabled";
    private final String _data;
    private ILogger _logger;
    private String _logTag;

    public SettingsParser(String data, ILogger logger) {
        if (data == null) {
            throw new Error("Reference to the data object cannot be NULL.");
        }
        this._data = data;
        if (logger == null) {
            throw new Error("Reference to logger object cannot be NULL.");
        }
        this._logger = logger;
        this._logTag = SettingsParser.class.getSimpleName();
    }

    public Map<String, Object> parse() {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new StringReader(this._data));
            Document document = documentBuilder.parse(inputSource);
            document.getDocumentElement().normalize();
            Double trackingInterval = null;
            Double checkStatusInterval = null;
            Boolean trackExternalErrors = null;
            Boolean trackingDisabled = null;
            Node node = document.getElementsByTagName("trackingInterval").item(0);
            if (node != null) {
                trackingInterval = Double.parseDouble(node.getFirstChild().getNodeValue());
            }
            if ((node = document.getElementsByTagName("setupCheckInterval").item(0)) != null) {
                checkStatusInterval = Double.parseDouble(node.getFirstChild().getNodeValue());
            }
            if ((node = document.getElementsByTagName("trackExternalErrors").item(0)) != null) {
                trackExternalErrors = Double.parseDouble(node.getFirstChild().getNodeValue()) == 1.0;
            }
            if ((node = document.getElementsByTagName("trackingDisabled").item(0)) != null && node.getFirstChild() != null && node.getFirstChild().getNodeValue() != null) {
                trackingDisabled = Double.parseDouble(node.getFirstChild().getNodeValue()) == 1.0;
            }
            if (trackingInterval != null && checkStatusInterval != null && trackExternalErrors != null) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put(KEY_REPORTING_INTERVAL, trackingInterval);
                result.put(KEY_CHECK_STATUS_INTERVAL, checkStatusInterval);
                result.put(KEY_TRACK_EXTERNAL_ERRORS, trackExternalErrors);
                if (trackingDisabled != null) {
                    result.put(KEY_CHECK_TRACKING_DISABLED, trackingDisabled);
                }
                return result;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.warn(this._logTag, "#parse() - Failed to parse configuration settings: " + e.getMessage());
        }
        return null;
    }
}

