/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.va.plugins.ah.engine.network;

import android.os.Build;
import com.adobe.primetime.core.Event;
import com.adobe.primetime.core.ICallback;
import com.adobe.primetime.core.ILogger;
import com.adobe.primetime.core.URLLoader;
import com.adobe.primetime.core.radio.Channel;
import com.adobe.primetime.core.radio.Command;
import com.adobe.primetime.core.radio.CommandQueue;
import com.adobe.primetime.va.plugins.ah.engine.model.report.Report;
import com.adobe.primetime.va.plugins.ah.engine.model.serialization.QueryStringSerializer;
import com.adobe.primetime.va.plugins.ah.engine.network.SettingsParser;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Network {
    private static final String KEY_PUBLISHER = "publisher";
    private static final String KEY_TRACKING_SERVER = "tracking_server";
    private static final String KEY_CHECK_STATUS_SERVER = "check_status_server";
    private static final String KEY_QUIET_MODE = "quiet_mode";
    private static final String KEY_SSL = "ssl";
    private static final String KEY_REPORT = "report";
    private static final String EVENT_API_CONFIG = "api:config";
    private static final String EVENT_FILTER_REPORT_AVAILABLE = "filter:data_available";
    private static final String EVENT_CLOCK_CHECK_STATUS_TICK = "clock:check_status.tick";
    private static final String EVENT_NET_CHECK_STATUS_COMPLETE = "net:check_status_complete";
    private ILogger _logger;
    private String _logTag;
    private String _publisher = null;
    private String _trackingServer = null;
    private String _checkStatusServer = null;
    private boolean _quietMode = false;
    private boolean _optOut = false;
    private boolean _isConfigured = false;
    private boolean _isDestroyed = false;
    private final Channel _channel;
    private final QueryStringSerializer _serializer;
    private Report _prevReportSent = null;
    private CommandQueue _networkQueue;
    private boolean _disableKeepAlive = false;
    private static final int ANDROID_KITKAT_VERSION_CODE = 19;
    private final ICallback _onApiConfig = new ICallback(){

        public Object call(Object param) {
            Event e = (Event)param;
            Map info = (Map)e.getData();
            Network.this._logger.debug(Network.this._logTag, "#_onApiConfig(sb_server=" + info.get(Network.KEY_TRACKING_SERVER) + ", check_status_server=" + info.get(Network.KEY_CHECK_STATUS_SERVER) + ", publisher=" + info.get(Network.KEY_PUBLISHER) + ", quiet_mode=" + info.get(Network.KEY_QUIET_MODE) + ", ssl=" + info.get(Network.KEY_SSL) + ")");
            Network.this._trackingServer = Network._updateRequestProtocol((String)info.get(Network.KEY_TRACKING_SERVER), (Boolean)info.get(Network.KEY_SSL));
            Network.this._checkStatusServer = Network._updateRequestProtocol((String)info.get(Network.KEY_CHECK_STATUS_SERVER), (Boolean)info.get(Network.KEY_SSL));
            Network.this._publisher = (String)info.get(Network.KEY_PUBLISHER);
            Network.this._quietMode = (Boolean)info.get(Network.KEY_QUIET_MODE);
            Network.this._isConfigured = true;
            return null;
        }
    };
    private final ICallback _onFilterReportAvailable = new ICallback(){

        public Object call(Object data) {
            Network.this._logger.debug(Network.this._logTag, "#_onFilterReportAvailable()");
            if (!Network.this._isConfigured) {
                Network.this._logger.warn(Network.this._logTag, "#_onFilterReportAvailable() > Unable to send request: not configured.");
                return null;
            }
            Network.this._networkQueue.addCommand(new Command(Network.this._processFilterReport, data));
            return null;
        }
    };
    private final ICallback _onClockCheckStatusTick = new ICallback(){

        public Object call(Object param) {
            if (!Network.this._isConfigured) {
                Network.this._logger.warn(Network.this._logTag, "#_onClockCheckStatusTick() - Unable to send request: not configured.");
                return null;
            }
            if (Network.this._publisher == null) {
                Network.this._logger.warn(Network.this._logTag, "#_onClockCheckStatusTick() > Publisher is NULL.");
                return null;
            }
            ICallback onSuccess = new ICallback(){

                public Object call(Object param) {
                    Event e = (Event)param;
                    Map info = (Map)e.getData();
                    String serverResponse = (String)info.get("server_response");
                    if (serverResponse != null && !serverResponse.equals("")) {
                        SettingsParser parser = new SettingsParser(serverResponse, Network.this._logger);
                        Map<String, Object> parseResult = parser.parse();
                        if (parseResult != null) {
                            Network.this._channel.trigger(new Event(Network.EVENT_NET_CHECK_STATUS_COMPLETE, parseResult));
                        } else {
                            Network.this._logger.warn(Network.this._logTag, "#_onClockCheckStatusTick() > Failed to parse the config. settings.");
                        }
                    } else {
                        Network.this._logger.warn(Network.this._logTag, "#_onClockCheckStatusTick() > Null or empty config. settings..");
                    }
                    return null;
                }
            };
            ICallback onError = new ICallback(){

                public Object call(Object param) {
                    Network.this._logger.warn(Network.this._logTag, "#_onClockCheckStatusTick() - Failed to obtain the config. settings.");
                    return null;
                }
            };
            String sanitizedPublisher = Network.this._publisher.replaceAll("[^a-zA-Z0-9]+", "-").toLowerCase();
            String url = Network.this._checkStatusServer + sanitizedPublisher + ".xml?r=" + new Date().getTime();
            URLLoader.URLRequest req = new URLLoader.URLRequest(url, URLLoader.HttpMethod.GET);
            URLLoader loader = new URLLoader(Network.this._logger);
            loader.on("success", onSuccess);
            loader.on("error", onError);
            Network.this._logger.debug(Network.this._logTag, "#_onClockCheckStatusTick() - Get new settings from: " + url);
            loader.load(req, Network.this._disableKeepAlive);
            return null;
        }
    };
    private final ICallback _processFilterReport = new ICallback(){

        public Object call(Object param) {
            Event e = (Event)param;
            Map info = (Map)e.getData();
            Report report = (Report)info.get(Network.KEY_REPORT);
            if (Network.this._prevReportSent != null && Network.this._prevReportSent.getEventData() != null && report.getEventData() != null && Network.this._prevReportSent.getEventData().getPlayhead() == report.getEventData().getPlayhead() && Network.this._prevReportSent.getEventData().getType().equals(report.getEventData().getType()) && Network.this._prevReportSent.getEventData().getTs() == report.getEventData().getTs() && Network.this._prevReportSent.getEventData().getPrevTs() == report.getEventData().getPrevTs()) {
                Map payload = Network.this._serializer.serializeReport(report);
                Network.this._logger.warn(Network.this._logTag, "#_onFilterReportAvailable() > Duplicate heartbeat report not sent: \n" + ((HashMap)payload).get("serializedOutput"));
                return null;
            }
            if (report.getEventData().getType().equals("complete") && report.getAssetData().getType().equals("main")) {
                Network.this._prevReportSent = null;
            } else {
                Network.this._prevReportSent = report;
            }
            Map payload = Network.this._serializer.serializeReport(report);
            ICallback onError = new ICallback((HashMap)payload){
                final /* synthetic */ HashMap val$payload;
                {
                    this.val$payload = hashMap;
                }

                public Object call(Object param) {
                    Network.this._logger.warn(Network.this._logTag, "#_onFilterReportAvailable() > Failed to send heartbeat report.");
                    if (this.val$payload != null && this.val$payload.get("callback") != null) {
                        ((ICallback)this.val$payload.get("callback")).call(null);
                    }
                    return null;
                }
            };
            ICallback onSuccess = new ICallback((HashMap)payload){
                final /* synthetic */ HashMap val$payload;
                {
                    this.val$payload = hashMap;
                }

                public Object call(Object param) {
                    if (this.val$payload != null && this.val$payload.get("callback") != null) {
                        ((ICallback)this.val$payload.get("callback")).call(null);
                    }
                    return null;
                }
            };
            String url = Network.this._trackingServer + "/?" + ((HashMap)payload).get("serializedOutput");
            URLLoader.URLRequest req = new URLLoader.URLRequest(url, URLLoader.HttpMethod.GET);
            Network.this._logger.info(Network.this._logTag, "_onFilterReportAvailable() > " + url);
            if (!Network.this._quietMode && !Network.this._optOut) {
                URLLoader loader = new URLLoader(Network.this._logger);
                loader.on("success", onSuccess);
                loader.on("error", onError);
                loader.load(req, Network.this._disableKeepAlive);
            }
            return null;
        }
    };

    public Network(Channel channel, ILogger logger) {
        if (channel == null) {
            throw new Error("Reference to the channel object cannot be NULL");
        }
        this._channel = channel;
        this._networkQueue = new CommandQueue();
        if (logger == null) {
            throw new Error("Reference to the logger object cannot be NULL");
        }
        this._logger = logger;
        this._logTag = Network.class.getSimpleName();
        this._serializer = new QueryStringSerializer(this._logger);
        this._installEventListeners();
        if (Build.VERSION.SDK_INT < 19) {
            this._logger.debug(this._logTag, "Setting \"Connection\" property to \"close\" for this device with Android API Level " + Build.VERSION.SDK_INT + " (< 19)");
            this._disableKeepAlive = true;
        }
    }

    public void destroy() {
        if (this._isDestroyed) {
            return;
        }
        this._logger.debug(this._logTag, "#destroy()");
        this._uninstallEventListeners();
        this._networkQueue.destroy();
        this._isDestroyed = true;
    }

    public void setOptOut(boolean optOut) {
        this._optOut = optOut;
    }

    private static String _updateRequestProtocol(String url, boolean useSsl) {
        String stripped = url;
        if (stripped.indexOf("http://") == 0) {
            stripped = stripped.substring(7);
        } else if (stripped.indexOf("https://") == 0) {
            stripped = stripped.substring(8);
        }
        return useSsl ? "https://" + stripped : "http://" + stripped;
    }

    private void _installEventListeners() {
        this._channel.on(EVENT_API_CONFIG, this._onApiConfig, this);
        this._channel.on(EVENT_FILTER_REPORT_AVAILABLE, this._onFilterReportAvailable, this);
        this._channel.on(EVENT_CLOCK_CHECK_STATUS_TICK, this._onClockCheckStatusTick, this);
    }

    private void _uninstallEventListeners() {
        this._channel.off(null, null, this);
    }
}

