/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.va.plugins.ah.engine.clock;

import com.adobe.primetime.core.Event;
import com.adobe.primetime.core.ICallback;
import com.adobe.primetime.core.ILogger;
import com.adobe.primetime.core.plugin.PluginManager;
import com.adobe.primetime.core.radio.Channel;
import com.adobe.primetime.va.plugins.ah.engine.clock.Timer;
import java.util.Map;

public final class ReportingTimer
extends Timer {
    private static final String NAME = "reporting";
    private static final double DEFAULT_REPORT_INTERVAL = 10.0;
    private static final String KEY_DO_NOT_OVERRIDE_INTERVAL = "do_not_override_interval";
    private static final String KEY_REPORTING_INTERVAL = "reporting_interval";
    private static final String EVENT_NET_CHECK_STATUS_COMPLETE = "net:check_status_complete";
    private static final String EVENT_UPDATE_REPORTING_INTERVAL = "update_reporting_interval";
    private boolean _doNotOverrideInterval;
    private final ICallback _onCheckStatusComplete = new ICallback(){

        public Object call(Object param) {
            if (!ReportingTimer.this._doNotOverrideInterval) {
                Map eventData = (Map)((Event)param).getData();
                Double newTimerInterval = (Double)eventData.get(ReportingTimer.KEY_REPORTING_INTERVAL);
                ReportingTimer.this._logger.debug(ReportingTimer.this._logTag, "#_onCheckStatusComplete(interval=" + newTimerInterval + "). Ignoring reporting timer interval.");
            }
            return null;
        }
    };
    private final ICallback _updateReportingInterval = new ICallback(){

        public Object call(Object param) {
            Map eventData = param != null && param instanceof Event && ((Event)param).getData() != null && ((Event)param).getData() instanceof Map ? (Map)((Event)param).getData() : null;
            Double newTimerInterval = eventData != null && eventData.get(ReportingTimer.KEY_REPORTING_INTERVAL) != null ? (double)((Double)eventData.get(ReportingTimer.KEY_REPORTING_INTERVAL)).longValue() : 10.0;
            ReportingTimer.this._doNotOverrideInterval = eventData != null && eventData.get(ReportingTimer.KEY_DO_NOT_OVERRIDE_INTERVAL) != null ? (Boolean)eventData.get(ReportingTimer.KEY_DO_NOT_OVERRIDE_INTERVAL) : false;
            ReportingTimer.this._logger.debug(ReportingTimer.this._logTag, "#_updateReportingInterval(interval=" + newTimerInterval + ")");
            if (newTimerInterval != null) {
                if (newTimerInterval.equals(ReportingTimer.this._interval)) {
                    ReportingTimer.this._logger.debug(ReportingTimer.this._logTag, "#_updateReportingInterval() - Interval remains same as previous.");
                    return null;
                }
                ReportingTimer.this._logger.debug(ReportingTimer.this._logTag, "#_updateReportingInterval() > Interval changed to: " + newTimerInterval);
                ReportingTimer.this.setInterval(newTimerInterval);
            } else {
                ReportingTimer.this._logger.warn(ReportingTimer.this._logTag, "#_onCheckStatusComplete() - Invalid interval value.");
                ReportingTimer.this.setInterval(10.0);
            }
            return null;
        }
    };

    public ReportingTimer(PluginManager pluginManager, Channel channel, ILogger logger) {
        super(pluginManager, channel, NAME, 10.0, logger);
        this.installHandlers();
        this._doNotOverrideInterval = false;
    }

    private void installHandlers() {
        this._channel.on(EVENT_NET_CHECK_STATUS_COMPLETE, this._onCheckStatusComplete, this);
        this._channel.on(EVENT_UPDATE_REPORTING_INTERVAL, this._updateReportingInterval, this);
        this._channel.reply(KEY_REPORTING_INTERVAL, new ICallback(){

            public Object call(Object param) {
                return ReportingTimer.this._interval;
            }
        });
    }
}

