/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.core.radio;

import com.adobe.primetime.core.Event;
import com.adobe.primetime.core.ICallback;
import com.adobe.primetime.core.ILogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Channel {
    public static final String WILDCARD = "*";
    public static final String SEPARATOR = ":";
    private String _logTag;
    private ILogger _logger;
    private String _name;
    private Map<String, List<EventHandler>> _listeners;
    private Map<String, ICallback> _requests;
    private Map<String, ICallback> _commands;
    private boolean _isShutDown;

    public Channel(String name, ILogger logger) {
        this._name = name;
        this._listeners = new HashMap<String, List<EventHandler>>();
        this._requests = new HashMap<String, ICallback>();
        this._commands = new HashMap<String, ICallback>();
        this._isShutDown = false;
        if (logger == null) {
            throw new Error("Reference to the logger object cannot be NULL");
        }
        this._logTag = Channel.class.getSimpleName();
        this._logger = logger;
    }

    public String toString() {
        return "<channel: " + this._name + ">";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Channel channel = this;
        synchronized (channel) {
            if (this._isShutDown) {
                return;
            }
            this._logger.debug(this._logTag, " #shutdown > Shutting down");
            this.off(null, null, null);
            this._requests.clear();
            this._commands.clear();
            this._isShutDown = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void on(String eventName, ICallback listener, Object context) {
        Channel channel = this;
        synchronized (channel) {
            if (this._isShutDown) {
                return;
            }
            if (!this._listeners.containsKey(eventName)) {
                this._listeners.put(eventName, new ArrayList());
            }
            this._listeners.get(eventName).add(new EventHandler(listener, context));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void off(String eventName, ICallback listener, Object context) {
        Channel channel = this;
        synchronized (channel) {
            if (this._isShutDown) {
                return;
            }
            if (eventName == null && listener == null && context == null) {
                this._listeners.clear();
                return;
            }
            if (eventName == null) {
                for (String _eventName : this._listeners.keySet()) {
                    this._removeListener(_eventName, listener, context);
                }
                Iterator<String> it = this._listeners.keySet().iterator();
                while (it.hasNext()) {
                    String _eventName;
                    _eventName = it.next();
                    if (this._listeners.get(_eventName).size() != 0) continue;
                    it.remove();
                }
            } else {
                this._removeListener(eventName, listener, context);
            }
        }
    }

    public void off() {
        this.off(null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger(Event event) {
        Channel channel = this;
        synchronized (channel) {
            if (this._isShutDown) {
                return;
            }
            for (Map.Entry<String, List<EventHandler>> entry : this._listeners.entrySet()) {
                String eventType = entry.getKey();
                List<EventHandler> handlers = entry.getValue();
                if (!Channel._matchWildcard(eventType, event.getName())) continue;
                for (EventHandler handler : handlers) {
                    handler.getCallback().call(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void comply(String name, ICallback handler) {
        Channel channel = this;
        synchronized (channel) {
            if (this._isShutDown) {
                return;
            }
            this._commands.put(name, handler);
        }
    }

    public void command(String name, Object param) {
        if (this._isShutDown) {
            return;
        }
        ICallback handler = this._commands.get(name);
        if (handler == null) {
            this._logger.warn(this._logTag, "#command > No command handler for: " + name);
            return;
        }
        handler.call(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reply(String what, ICallback response) {
        Channel channel = this;
        synchronized (channel) {
            if (this._isShutDown) {
                return;
            }
            this._requests.put(what, response);
        }
    }

    public Object request(String what) {
        return this.request(what, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object request(String what, Object param) {
        Channel channel = this;
        synchronized (channel) {
            if (this._isShutDown) {
                return null;
            }
            ICallback response = this._requests.get(what);
            if (response == null) {
                this._logger.warn(this._logTag, "#request > No request handler for: " + what);
                return null;
            }
            return response.call(param);
        }
    }

    private static boolean _matchWildcard(String wildcard, String test) {
        String[] testParts;
        wildcard = wildcard == null ? "" : wildcard;
        String string = test = test == null ? "" : test;
        if (wildcard.equals(test)) {
            return true;
        }
        String[] parts = wildcard.split(SEPARATOR);
        if (parts.length != (testParts = test.split(SEPARATOR)).length) {
            return false;
        }
        boolean match = true;
        for (int i = 0; i < parts.length; ++i) {
            match = match && (parts[i].equals(WILDCARD) || parts[i].equals(testParts[i]));
        }
        return match;
    }

    private void _removeListener(String eventType, ICallback listener, Object context) {
        List<EventHandler> handlers = this._listeners.get(eventType);
        if (handlers == null) {
            return;
        }
        Iterator<EventHandler> it = handlers.iterator();
        while (it.hasNext()) {
            EventHandler handler = it.next();
            if (listener != null && listener != handler.getCallback() || context != null && context != handler.getContext()) continue;
            it.remove();
        }
    }

    private static class EventHandler {
        private final ICallback _callback;
        private final Object _context;

        EventHandler(ICallback callback, Object context) {
            if (callback == null) {
                throw new Error("Event handler callback cannot be null");
            }
            this._callback = callback;
            if (context == null) {
                throw new Error("Event handler context cannot be null");
            }
            this._context = context;
        }

        public ICallback getCallback() {
            return this._callback;
        }

        public Object getContext() {
            return this._context;
        }
    }
}

