/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.core;

import android.util.Log;
import com.adobe.primetime.core.ILogger;
import java.util.Date;

public class Logger
implements ILogger {
    private Boolean _enabled = true;
    private final String SDK_NAMESPACE = "ADB";

    public boolean enabled() {
        return this._enabled;
    }

    public void enable() {
        this._enabled = true;
    }

    public void disable() {
        this._enabled = false;
    }

    public void debug(String tag, String message) {
        if (this._enabled.booleanValue()) {
            Log.d((String)this._computeTag(tag), (String)message);
        }
    }

    public void info(String tag, String message) {
        if (this._enabled.booleanValue()) {
            Log.i((String)this._computeTag(tag), (String)message);
        }
    }

    public void warn(String tag, String message) {
        if (this._enabled.booleanValue()) {
            Log.w((String)this._computeTag(tag), (String)message);
        }
    }

    public void error(String tag, String message) {
        Log.e((String)this._computeTag(tag), (String)message);
    }

    private String _computeTag(String className) {
        Date date = new Date();
        String line = "[" + date.getTime() + "]";
        line = line + "[ADB" + className + "]";
        return line;
    }
}

