/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.license.decryption;

import com.akamai.amp.license.decryption.AES256JNCryptor;
import com.akamai.amp.license.decryption.CryptorException;
import com.akamai.amp.license.decryption.StreamIntegrityException;
import com.akamai.amp.license.decryption.StreamUtils;
import com.akamai.amp.license.decryption.TrailerInputStream;
import com.akamai.amp.license.decryption.Validate;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class AES256JNCryptorInputStream
extends InputStream {
    private static final int END_OF_STREAM = -1;
    private final boolean isPasswordEncrypted;
    private final InputStream in;
    private char[] password;
    private SecretKey decryptionKey;
    private SecretKey hmacKey;
    private boolean endOfStreamHandled = false;
    private PushbackInputStream pushbackInputStream;
    private TrailerInputStream trailerIn;
    private Mac mac;

    public AES256JNCryptorInputStream(InputStream in, char[] password) {
        this.isPasswordEncrypted = true;
        this.password = password;
        this.in = in;
    }

    public AES256JNCryptorInputStream(InputStream in, SecretKey decryptionKey, SecretKey hmacKey) {
        this.isPasswordEncrypted = false;
        this.decryptionKey = decryptionKey;
        this.hmacKey = hmacKey;
        this.in = in;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private void initializeStream() throws IOException {
        int headerDataSize = this.isPasswordEncrypted ? 34 : 18;
        byte[] headerData = new byte[headerDataSize];
        StreamUtils.readAllBytesOrFail(this.in, headerData);
        int offset = 0;
        byte version = headerData[offset++];
        if (version != 3) {
            throw new IOException(String.format("Expected version %d but found %d.", 3, version));
        }
        byte options = headerData[offset++];
        if (this.isPasswordEncrypted) {
            if (options != 1) {
                throw new IOException("Expected password flag missing.");
            }
            byte[] decryptionSalt = new byte[8];
            System.arraycopy(headerData, offset, decryptionSalt, 0, decryptionSalt.length);
            byte[] hmacSalt = new byte[8];
            System.arraycopy(headerData, offset += decryptionSalt.length, hmacSalt, 0, hmacSalt.length);
            offset += hmacSalt.length;
            AES256JNCryptor cryptor = new AES256JNCryptor();
            try {
                this.decryptionKey = cryptor.keyForPassword(this.password, decryptionSalt);
                this.hmacKey = cryptor.keyForPassword(this.password, hmacSalt);
            }
            catch (CryptorException e) {
                throw new IOException("Failed to derive keys from password.", e);
            }
        } else if (options != 0) {
            throw new IOException("Expected options byte to be zero.");
        }
        byte[] iv = new byte[16];
        System.arraycopy(headerData, offset, iv, 0, iv.length);
        this.trailerIn = new TrailerInputStream(this.in, 32);
        try {
            Cipher decryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            decryptCipher.init(2, (Key)this.decryptionKey, new IvParameterSpec(iv));
            this.mac = Mac.getInstance("HmacSHA256");
            this.mac.init(this.hmacKey);
            this.mac.update(headerData);
            this.pushbackInputStream = new PushbackInputStream(new CipherInputStream(new MacUpdateInputStream(this.trailerIn, this.mac), decryptCipher), 1);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Failed to initiate cipher.", e);
        }
    }

    @Override
    public int read() throws IOException, StreamIntegrityException {
        if (this.trailerIn == null) {
            this.initializeStream();
        }
        int result = this.pushbackInputStream.read();
        return this.completeRead(result);
    }

    @Override
    public int read(byte[] b) throws IOException, StreamIntegrityException {
        Validate.notNull(b, "Array cannot be null.", new Object[0]);
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Validate.notNull(b, "Byte array cannot be null.", new Object[0]);
        Validate.isTrue(off >= 0, "Offset cannot be negative.", new Object[0]);
        Validate.isTrue(len >= 0, "Length cannot be negative.", new Object[0]);
        Validate.isTrue(len + off <= b.length, "Length plus offset cannot be longer than byte array.", new Object[0]);
        if (len == 0) {
            return 0;
        }
        if (this.trailerIn == null) {
            this.initializeStream();
        }
        int result = this.pushbackInputStream.read(b, off, len);
        return this.completeRead(result);
    }

    private int completeRead(int b) throws IOException, StreamIntegrityException {
        if (b == -1) {
            this.handleEndOfStream();
        } else {
            int c = this.pushbackInputStream.read();
            if (c == -1) {
                this.handleEndOfStream();
            } else {
                this.pushbackInputStream.unread(c);
            }
        }
        return b;
    }

    private void handleEndOfStream() throws StreamIntegrityException {
        byte[] calculateHMAC;
        if (this.endOfStreamHandled) {
            return;
        }
        this.endOfStreamHandled = true;
        byte[] originalHMAC = this.trailerIn.getTrailer();
        if (!AES256JNCryptor.arraysEqual(originalHMAC, calculateHMAC = this.mac.doFinal())) {
            throw new StreamIntegrityException("MAC validation failed.");
        }
    }

    @Override
    public void close() throws IOException {
        try {
            AES256JNCryptorInputStream.closeIfNotNull(this.pushbackInputStream);
        }
        finally {
            AES256JNCryptorInputStream.closeIfNotNull(this.trailerIn);
        }
    }

    private static void closeIfNotNull(InputStream in) throws IOException {
        if (in != null) {
            in.close();
        }
    }

    private static class MacUpdateInputStream
    extends FilterInputStream {
        Mac mac;

        private MacUpdateInputStream(InputStream in, Mac mac) {
            super(in);
            this.mac = mac;
        }

        @Override
        public int read() throws IOException {
            int b = super.read();
            if (b >= 0) {
                this.mac.update((byte)b);
            }
            return b;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n = super.read(b, off, len);
            if (n > 0) {
                this.mac.update(b, off, n);
            }
            return n;
        }
    }
}

